/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.portal.datalog.service.IDataCollectService;
import kd.bos.portal.service.dto.DataCollectDTO;
import org.apache.commons.lang3.ObjectUtils;

public class PortalDataCollectServiceImpl
implements IDataCollectService {
    private static Map<String, DataCollectDTO> tableMap = PortalDataCollectServiceImpl.getDataCollectDTO();

    public Map<String, Object> collectData() {
        return null;
    }

    public List<Map<String, Object>> collectBatchData() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        tableMap.forEach((key, value) -> list.add(PortalDataCollectServiceImpl.getData(value.getTableName(), value.getBusinessScene())));
        return list;
    }

    private static Map<String, Object> getData(String tableName, String businessScene) {
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("table_name", tableName);
        data.put("department", "svc");
        data.put("business_scene", businessScene);
        data.put("statisticNumExt1", PortalDataCollectServiceImpl.getCountData(tableName));
        return data;
    }

    private static long getCountData(String tableName) {
        String algoKey = PortalDataCollectServiceImpl.class.getName() + ".query";
        long num = 0L;
        String sql = "select count(1) from %s ";
        sql = String.format(sql, tableName);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql, null);){
            Row row;
            if (ds.hasNext() && ObjectUtils.isNotEmpty((Object)(row = ds.next()).get(0))) {
                num = Long.parseLong(String.valueOf(row.get(0)));
            }
        }
        return num;
    }

    private static Map<String, DataCollectDTO> getDataCollectDTO() {
        HashMap<String, DataCollectDTO> map = new HashMap<String, DataCollectDTO>(8);
        map.put("qywx_light_app", new DataCollectDTO("t_bas_wxqyh", "qywx_light_app"));
        map.put("wxgzh_light_app", new DataCollectDTO("t_bas_wxgzh", "wxgzh_light_app"));
        map.put("dingding_light_app", new DataCollectDTO("t_bas_dingding", "dingding_light_app"));
        map.put("fly_book_light_app", new DataCollectDTO("t_bas_fly_book", "fly_book_light_app"));
        map.put("welink_light_app", new DataCollectDTO("t_bas_welink", "welink_light_app"));
        map.put("perm_pswstrategy", new DataCollectDTO("t_perm_pswstrategy", "perm_pswstrategy"));
        map.put("perm_weakpsw_num", new DataCollectDTO("t_perm_weakpsw", "perm_weakpsw_num"));
        map.put("secondauthscheme_num", new DataCollectDTO("t_bd_secondauthscheme", "secondauthscheme_num"));
        map.put("ec_contractsubject_num", new DataCollectDTO("t_ec_contractsubject", "ec_contractsubject_num"));
        map.put("ec_companyauth_num", new DataCollectDTO("t_ec_companyauth", "ec_companyauth_num"));
        map.put("perm_privacystmttpl_num", new DataCollectDTO("t_perm_privacystmttpl", "perm_privacystmttpl_num"));
        map.put("perm_privacystmt_num", new DataCollectDTO("t_perm_privacystmt", "perm_privacystmt_num"));
        map.put("perm_userprivacystmt_num", new DataCollectDTO("t_perm_userprivacystmt", "perm_userprivacystmt_num"));
        map.put("msg_notice_num", new DataCollectDTO("t_msg_notice", "msg_notice_num"));
        map.put("perm_appblacklist_num", new DataCollectDTO("t_perm_appblacklist", "perm_appblacklist_num"));
        map.put("bas_proverbs_num", new DataCollectDTO(" t_bas_proverbs", "bas_proverbs_num"));
        map.put("bas_mainpagelayout_num", new DataCollectDTO(" t_bas_mainpagelayout", "bas_mainpagelayout_num"));
        map.put("bas_schemegroup_num", new DataCollectDTO(" t_bas_schemegroup", "bas_schemegroup_num"));
        map.put("bas_custom_help_num", new DataCollectDTO(" t_bas_custom_help", "bas_custom_help_num"));
        return map;
    }
}

