/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.IPortalParamService;
import kd.bos.portal.util.ImageUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.shortcut.ShortcutsServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PortalParamServiceImpl
implements IPortalParamService {
    private static final String NAME = "name";
    private static final String EID = "eid";
    private static final String ID = "id";
    private static final String USERNAME = "username";
    private static final String PICTUREFIELD = "picturefield";
    private static Log log = LogFactory.getLog(PortalParamServiceImpl.class);
    private static Map<String, String> systemEnvKV = new HashMap<String, String>(8);

    @Override
    public JSONObject getPortalUserInfo() {
        try {
            OrmLocaleValue nameLocalVal;
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(RequestContext.get().getCurrUserId());
            List userInfoList = UserServiceHelper.get(userIds, (String[])new String[]{ID, EID, USERNAME, PICTUREFIELD, NAME}, null);
            if (ObjectUtils.isEmpty((Object)userInfoList)) {
                return null;
            }
            Map user = (Map)userInfoList.get(0);
            HashMap<String, String> result = new HashMap<String, String>(8);
            Object name = user.get(NAME);
            if (name != null && (nameLocalVal = (OrmLocaleValue)name) != null) {
                result.put(NAME, nameLocalVal.get((Object)"zh_CN"));
            }
            String imageUrl = ImageUtil.getCurrentUserAvatarPath(true);
            result.put("photoUrl", imageUrl);
            String portalUser = SerializationUtils.toJsonString(result);
            return JSONObject.parseObject((String)portalUser);
        }
        catch (Exception e) {
            log.info("PortalParamServiceImpl#getPortalUserInfo error ", (Object)e);
            return null;
        }
    }

    @Override
    public JSONObject loadShortcutsBasedata() {
        try {
            DynamicObject[] dyObjects;
            JSONObject btnSettingJsonObj = new JSONObject();
            JSONArray objects = new JSONArray();
            String selectProperties = "operationnum,shortcut,keycode";
            for (DynamicObject dyObject : dyObjects = BusinessDataServiceHelper.load((String)"bd_shortcuts", (String)selectProperties, null, (String)"createdate")) {
                JSONObject btnSettingJsonBtn = new JSONObject();
                JSONObject btnSettingJsonshortCut = new JSONObject();
                btnSettingJsonBtn.put("opk", dyObject.get("operationnum"));
                btnSettingJsonshortCut.put(NAME, dyObject.get("shortcut"));
                btnSettingJsonshortCut.put("info", (Object)JSONObject.parseObject((String)dyObject.get("keycode").toString()));
                btnSettingJsonBtn.put("shortCut", (Object)btnSettingJsonshortCut);
                objects.add((Object)btnSettingJsonBtn);
            }
            btnSettingJsonObj.put("btnSetting", (Object)objects);
            String selectPropertiesAd = "nextfield,nextfieldentry,autotonext,autoaddentry";
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_advancesetting", (String)selectPropertiesAd, (QFilter[])new QFilter[]{new QFilter("user.id", "=", (Object)RequestContext.get().getCurrUserId())});
            btnSettingJsonObj.put("advanceSetting", (Object)ShortcutsServiceHelper.getShortcutsAdvanceSetting(dynamicObjects));
            return btnSettingJsonObj;
        }
        catch (KDException e) {
            log.info(e.getMessage());
            return null;
        }
    }

    @Override
    public String getSysModeType() {
        String modeType = "";
        try {
            modeType = String.valueOf(LicenseServiceHelper.getModeType());
        }
        catch (Exception e) {
            log.info("getSysModeType", (Object)e);
        }
        return modeType;
    }

    @Override
    public Map<String, Object> getSystemEnvInfo() {
        JSONObject data = new JSONObject();
        String systemEnvForDef = "cosmic";
        data.put("systemEnv", (Object)systemEnvForDef);
        try {
            List productInfos = LicenseServiceHelper.getProductInfos();
            if (ObjectUtils.isEmpty((Object)productInfos)) {
                return data;
            }
            for (Map productInfo : productInfos) {
                String prodid = (String)productInfo.get("prodid");
                if (!StringUtils.isNotBlank((CharSequence)prodid) || systemEnvKV.get(prodid) == null || "cosmic".equals(systemEnvKV.get(prodid))) continue;
                data.put("systemEnv", (Object)systemEnvKV.get(prodid));
                return data;
            }
        }
        catch (Exception e) {
            log.info("PortalParamServiceImpl#getSystemEnvInfo error ", (Object)e);
        }
        return data;
    }

    static {
        systemEnvKV.put("1I6CUBKTC4GY", "constellation");
        systemEnvKV.put("1I6COPY94UBO", "cosmic");
        systemEnvKV.put("2D3=SA5XL/92", "galaxy_pro");
        systemEnvKV.put("2D3=SA5XL/93", "galaxy_pro");
    }
}

