/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service.impl;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.user.PrivacyPolicyService;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.model.LegalPrivacyPolicyDto;
import kd.bos.portal.service.IPrivacyPolicyService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PrivacyPolicyServiceImpl
implements IPrivacyPolicyService {
    private static final String STATUS = "status";
    private static final String MODIFYDATE = "modifydate";
    private static final String TYPE = "type";
    private static final String VERSION = "version";
    private static final String STRING_0 = "0";
    private static final String STRING_1 = "1";
    public static final String STRING_2 = "2";
    private static Log log = LogFactory.getLog(PrivacyPolicyServiceImpl.class);
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"synToResourceCloud_portal", (int)0, (int)2);

    @Override
    public DynamicObject[] getUserPrivacyPolicy(String type) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("privacypolicyid.type", "=", (Object)type));
        qFilterList.add(new QFilter("userid.id", "=", (Object)RequestContext.get().getCurrUserId()));
        DynamicObject[] privacyPolicyArray = BusinessDataServiceHelper.load((String)"bos_user_privacy_record", (String)"id,userid,privacypolicyid,optime,clienttype,country,localeid,opdesc,opflag", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"optime desc");
        return privacyPolicyArray;
    }

    @Override
    public void backOut(String userPolicyid) {
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(userPolicyid), (String)"bos_user_privacy_record");
        data.set("opflag", (Object)STRING_0);
        SaveServiceHelper.update((DynamicObject)data);
        if (data == null || data.get("privacypolicyid") == null) {
            return;
        }
        ArrayList<Map<String, Object>> synList = new ArrayList<Map<String, Object>>(2);
        Map<String, Object> privacyData = this.wrapPrivacyData(data.getDynamicObject("privacypolicyid"));
        privacyData.put("opFlag", STRING_0);
        privacyData.put("userId", String.valueOf(RequestContext.get().getCurrUserId()));
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        String name = user.getString("name");
        String trueName = "";
        if (!ObjectUtils.isEmpty((Object)name)) {
            trueName = name.toString();
        }
        privacyData.put("trueName", PrivacyPolicyServiceImpl.getSHA256Hash(trueName));
        privacyData.put("signature", PrivacyPolicyServiceImpl.getSHA256Hash(String.valueOf(RequestContext.get().getCurrUserId()) + "mewikuytreolkghdjyo986358ngjei"));
        synList.add(privacyData);
        this.synToResourceCloud(synList);
    }

    @Override
    public List<Long> getPrivacyPolicyList() {
        ArrayList<Long> list = new ArrayList<Long>(8);
        try {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
            qFilterList.add(new QFilter(STATUS, "=", (Object)STRING_1));
            DynamicObject[] privacyPolicyArray = this.getPrivacyPolicyData(qFilterList);
            Long privacyPolicyId = null;
            for (DynamicObject privacyPolicy : privacyPolicyArray) {
                privacyPolicyId = privacyPolicy.getLong("id");
                list.add(privacyPolicyId);
            }
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        return list;
    }

    public static boolean enablePrivacy() {
        return PrivacyPolicyService.enablePrivacy();
    }

    @Override
    @Deprecated
    public void savePrivacyPolicy(String privacyAgreement, String userAgreement) {
    }

    private DynamicObject[] getPrivacyPolicyData(List<QFilter> qFilterList) {
        DynamicObject[] privacyPolicyArray = null;
        try {
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>(8);
            }
            privacyPolicyArray = BusinessDataServiceHelper.load((String)"bos_privacy_policy", (String)"id,version,type,status,modifydate,locale.number,country.number,content_tag,createdate,modifydate", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        }
        catch (Exception e) {
            log.info(e.toString());
        }
        return privacyPolicyArray;
    }

    private DynamicObject getWrapData(LegalPrivacyPolicyDto privacyPolicy, String type) {
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"bos_privacy_policy");
        try {
            DynamicObject[] locale;
            data.set(STATUS, (Object)STRING_1);
            data.set(TYPE, (Object)type);
            data.set(VERSION, (Object)privacyPolicy.getVersion());
            data.set("content_tag", (Object)privacyPolicy.getContent());
            data.set("createdate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(privacyPolicy.getCreatetime()));
            if (StringUtils.isNotBlank((CharSequence)privacyPolicy.getModifytime())) {
                data.set(MODIFYDATE, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(privacyPolicy.getModifytime()));
            }
            if ((locale = BusinessDataServiceHelper.load((String)"inte_language", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)privacyPolicy.getLanguage())})) != null && locale.length > 0) {
                data.set("locale", locale[0].get("id"));
            }
            if (StringUtils.isNotBlank((CharSequence)privacyPolicy.getCountry())) {
                data.set("country", (Object)privacyPolicy.getCountry());
            }
        }
        catch (Exception e) {
            log.info("kd.bos.portal.service.impl.PrivacyPolicyServiceImpl.getWrapData#error", (Object)e);
        }
        return data;
    }

    @Override
    public void savePrivacyPolicy(List<LegalPrivacyPolicyDto> list, String type) {
        ArrayList<DynamicObject> insertData = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(8);
        try {
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
            qFilterList.add(new QFilter(STATUS, "=", (Object)STRING_1));
            qFilterList.add(new QFilter(TYPE, "=", (Object)type));
            DynamicObject[] privacyPolicyArray = this.getPrivacyPolicyData(qFilterList);
            block13: for (LegalPrivacyPolicyDto legalPrivacyPolicyDto : list) {
                if (privacyPolicyArray == null || privacyPolicyArray.length == 0) {
                    insertData.add(this.getWrapData(legalPrivacyPolicyDto, type));
                    continue;
                }
                String key = legalPrivacyPolicyDto.getLanguage() + legalPrivacyPolicyDto.getCountry();
                for (int i = 0; i < privacyPolicyArray.length; ++i) {
                    DynamicObject dynamicObject = privacyPolicyArray[i];
                    String val = dynamicObject.getString("locale.number") + dynamicObject.getString("country.number");
                    if (key.equals(val)) {
                        if (!dynamicObject.getString(VERSION).equals(legalPrivacyPolicyDto.getVersion())) {
                            insertData.add(this.getWrapData(legalPrivacyPolicyDto, type));
                            dynamicObject.set(STATUS, (Object)STRING_0);
                            dynamicObject.set(MODIFYDATE, (Object)new Date());
                            updateData.add(dynamicObject);
                        }
                        String modifyDate = legalPrivacyPolicyDto.getModifytime();
                        if (!dynamicObject.getString(VERSION).equals(legalPrivacyPolicyDto.getVersion()) || !this.isNeedUpdate(modifyDate, dynamicObject.getDate(MODIFYDATE))) continue block13;
                        if (StringUtils.isNotBlank((CharSequence)legalPrivacyPolicyDto.getModifytime())) {
                            dynamicObject.set(MODIFYDATE, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(legalPrivacyPolicyDto.getModifytime()));
                        }
                        dynamicObject.set("content_tag", (Object)legalPrivacyPolicyDto.getContent());
                        updateData.add(dynamicObject);
                        continue block13;
                    }
                    if (i != privacyPolicyArray.length - 1) continue;
                    insertData.add(this.getWrapData(legalPrivacyPolicyDto, type));
                }
            }
        }
        catch (Exception e) {
            log.info("kd.bos.portal.service.impl.PrivacyPolicyServiceImpl.savePrivacyPolicy#error", (Object)e);
        }
        try (TXHandle h = TX.required((String)"privacy_policy_save");){
            try {
                if (insertData.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])insertData.toArray(new DynamicObject[0]));
                }
                if (updateData.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[0]));
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void synToResourceCloud(final List<Map<String, Object>> synList) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Map result;
                    String url = DefaultParameterService.getDefaultValueByKey((String)"privacy_policy_url") + "/kapi/v2/kdec/kdec_legal_center/legalPrivacyPolicy/savePrivacyPolicyRecord";
                    HashMap header = new HashMap(2);
                    Map body = PrivacyPolicyServiceImpl.this.wrapBodyData((Map)synList.get(0));
                    String data = HttpClientUtils.postAppJson((String)url, header, (Map)body);
                    if (StringUtils.isNotBlank((CharSequence)data) && (result = (Map)JSONUtils.cast((String)data, HashMap.class)) != null && !"true".equals(String.valueOf(result.get(PrivacyPolicyServiceImpl.STATUS)))) {
                        log.info(data);
                    }
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                }
            }
        }, RequestContext.get());
    }

    private Map<String, Object> wrapBodyData(Map<String, Object> map) throws IOException {
        HashMap<String, Object> body = new HashMap<String, Object>(2);
        map.put("tenantId", RequestContext.get().getTenantId());
        map.put("productVersion", "7.0.1");
        body.put("privacyPolicyRecordDto", map);
        return body;
    }

    private Map<String, Object> wrapPrivacyData(DynamicObject privacyPolicy) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(TYPE, privacyPolicy.getString(TYPE));
        result.put(VERSION, privacyPolicy.getString(VERSION));
        String localeNumber = privacyPolicy.getString("locale.number");
        result.put("language", localeNumber);
        String countryNumber = privacyPolicy.getString("country.number");
        result.put("country", countryNumber);
        return result;
    }

    private boolean isNeedUpdate(String modifyDate, Date nowDate) throws ParseException {
        return StringUtils.isNotBlank((CharSequence)modifyDate) && nowDate != null && new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(modifyDate).compareTo(nowDate) > 0;
    }

    private static String getSHA256Hash(String data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] messageDigest = md.digest(data.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                hexString.append(String.format("%02X", b));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            DisCardUtil.discard();
            return "";
        }
    }
}

