/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.privacystatement.DefaultCountrySourcePluginImpl;
import kd.bos.portal.service.IPrivacyStatementService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class PrivacyStatementServiceImpl
implements IPrivacyStatementService {
    private static final Log logger = LogFactory.getLog(PrivacyStatementServiceImpl.class);

    @Override
    public JSONObject getPrivacyStatement() {
        JSONObject data = new JSONObject();
        try {
            Long userId = RequestContext.get().getCurrUserId();
            Lang lang = RequestContext.get().getLang();
            Long privacystmtId = this.getPrivacyStatementExt(userId, lang, "");
            if (null == privacystmtId) {
                privacystmtId = this.getLastPrivacyStatementId(userId, lang, "1");
            }
            if (privacystmtId == null || !this.checkIsNeedSignPrivacyStatement(userId, privacystmtId)) {
                return data;
            }
            String title = ResManager.loadKDString((String)"\u9690\u79c1\u58f0\u660e", (String)"PrivacyStatementServiceImpl_0", (String)"bos-portal-plugin", (Object[])new Object[0]);
            String str = "{\"loadPageAfterShowPCForm\": [{\"formId\": \"privacystmtsignpage\",\"direction\":\"middle\",\"width\":880,\"title\":\"%s\",\"loadDataParams\":{\"privacystmtId\":\"%d\"}}],\"loadPageAfterShowMobileForm\": [{\"formId\": \"privacystmtpage_mobile\",\"direction\":\"middle\",\"width\":350,\"title\":\"%s\",\"loadDataParams\":{\"privacystmtId\":\"%d\"}}]}";
            data = JSONObject.parseObject((String)String.format(str, title, privacystmtId, title, privacystmtId));
        }
        catch (Exception e) {
            logger.info("kd.bos.portal.service.impl.PrivacyStatementServiceImpl.getPrivacyStatement", (Object)e);
        }
        return data;
    }

    @Override
    public Long getPrivacyStatementExt(Long userId, Lang lang, String source) {
        Long id = (Long)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IExtLoginConfigService", (String)"getPrivacyStatement", (Object[])new Object[]{userId, lang, source});
        return id;
    }

    private boolean checkIsNeedSignPrivacyStatement(Long userId, Long privacystmtId) {
        if (userId <= 0L) {
            return false;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("privacystmt.id", "=", (Object)privacystmtId));
        filters.add(new QFilter("isagree", "=", (Object)"1"));
        filters.add(new QFilter("user.id", "=", (Object)userId));
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"userprivacystmt", (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"privacystmt.version desc");
        if (data != null && data.length > 0) {
            return false;
        }
        data = BusinessDataServiceHelper.load((String)"userprivacystmthistory", (String)"id, isagree, modifytime", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"modifytime desc");
        return data == null || data.length <= 0 || !"1".equals(String.valueOf(data[0].get("isagree")));
    }

    private Long getLastPrivacyStatementId(Long userId, Lang lang, String useScope) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        Optional<Boolean> countrySwitchOp = this.isCountrySwitchOpen();
        if (countrySwitchOp.isPresent() && countrySwitchOp.get().booleanValue()) {
            DefaultCountrySourcePluginImpl countrySourcePlugin = new DefaultCountrySourcePluginImpl();
            filters.add(new QFilter("country.id", "=", (Object)countrySourcePlugin.getCountryId()));
        }
        filters.add(new QFilter("locale.number", "=", (Object)lang.name()));
        filters.add(new QFilter("usescope", "=", (Object)useScope));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] data = this.getPrivacyStatement(filters);
        if (data != null && data.length > 0) {
            return Long.parseLong(String.valueOf(data[0].get("id")));
        }
        return null;
    }

    private DynamicObject getPrivacyStatement(Lang lang, String useScope) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("locale.number", "=", (Object)lang.name()));
        filters.add(new QFilter("usescope", "=", (Object)useScope));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] data = this.getPrivacyStatement(filters);
        if (data != null && data.length > 0) {
            return data[0];
        }
        return null;
    }

    @Override
    public DynamicObject[] getPrivacyStatement(List<QFilter> filters) {
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"privacystatement", (String)"id,content,content_tag", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"version desc");
        return data;
    }

    @Override
    public Optional<Boolean> isCountrySwitchOpen() {
        Boolean countrySwitch = (Boolean)SystemParamServiceHelper.loadPublicParameterFromCache((String)"privacy_country_switch");
        return Optional.ofNullable(countrySwitch);
    }
}

