/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.coderule.api.CoderuleFile;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.DBVersion;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.portal.model.PortalSchemeFile;
import kd.bos.portal.util.DevportalUtil;
import kd.bos.portal.util.DocumentParseUtil;
import kd.bos.servicehelper.ControlSchemaServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.billtype.entity.BillTypeFile;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.util.DisCardUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AppPackageUtil {
    public static final String UTF_8 = "UTF-8";
    public static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    public static final String CREATE_NEW_FILE_FLAG_S = "createNewFileFlag:%s";
    public static final String FOUR = "\n    ";
    public static final String STRING = "string";
    public static final String SEPARATOR = "Separator";
    public static final String DBKEY = "dbkey";
    public static final String SQL_SCRIPT = "SqlScript";
    public static final String COSMIC_CUS = "cosmic_cus_";
    public static final String KDPKG = "kdpkg";
    public static final String SOURCE_PATH = "sourcePath";
    public static final String STATIC_RESOURCE = "staticResource";
    public static final String STR = ";\t\n";
    public static final String KSQLEXP_PLUGIN_ERROR_S = "KSQLExpPlugin error:%s.";
    private static Log logger = LogFactory.getLog(AppPackageUtil.class);
    private static final String SOURCE_NAME = "name";
    private static final String SOURCE_ID = "id";
    private static final String SOURCE_NUMBER = "number";
    private static final String APP_ID = "appmeta#firmenu";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String APP_NUM = "appnum";
    private static final String PAGE_ID = "pagemeta#firmenu";
    private static final String PAGE_NUM = "pagenum";
    private static final String SCRIPT_ID = "scriptmeta#firmenu";
    private static final String SCRIPT_NUM = "scriptnum";
    private static final String BILLTYPE_ID = "billtypemeta#firmenu";
    private static final String BILLTYPE_NUM = "billtypenum";
    private static final String CODERULE_ID = "coderulemeta#firmenu";
    private static final String CODERULE_NUM = "coderulenum";
    private static final String CLOUD_ID = "cloudmeta#firmenu";
    private static final String CLOUD_NUM = "cloudnum";
    private static final String SCHEMA_ID = "schemameta#firmenu";
    private static final String SCHEMA_NUM = "schemanum";
    private static final String WORKBENCH_ID = "workbench#firmenu";
    private static final String WORKBENCH_NUM = "workbenchnum";
    private static final String URL_NAME = "urlname";
    private static final String URL = "url";
    private static final String DATABASE = "databasetype";
    private static final String BIZAPPID = "bizappid";
    private static final String DATAMODEL = "datamodel";
    private static final String PREINSDATA = "preinsdata";

    private static String getAppName() {
        return ResManager.loadKDString((String)"\u5e94\u7528\u4fe1\u606f(\u5305\u62ec\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4)", (String)"AppPackageUtil_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getPageName() {
        return ResManager.loadKDString((String)"\u9875\u9762", (String)"AppPackageUtil_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getScriptName() {
        return ResManager.loadKDString((String)"\u811a\u672c", (String)"AppPackageUtil_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getBilltypeName() {
        return ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AppPackageUtil_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getCoderuleName() {
        return ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219", (String)"AppPackageUtil_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getCloudName() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"AppPackageUtil_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getSchemaName() {
        return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u63a7\u4ef6\u65b9\u6848", (String)"AppPackageUtil_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getWorkbenchName() {
        return ResManager.loadKDString((String)"\u5e94\u7528\u5de5\u4f5c\u53f0", (String)"AppPackageUtil_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static String getProductName() {
        return ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79(\u4e8c\u5f00)", (String)"AppPackageUtil_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    public static void zipDMFile(String zipPath, String appPackageName) {
        String checkzipPath;
        File dmFile;
        JSONArray files = new JSONArray();
        File file = new File(SecurityUtils.normalize((String)zipPath));
        if (file.exists()) {
            files.add((Object)zipPath);
        }
        if (!(dmFile = new File(SecurityUtils.normalize((String)((checkzipPath = DevportalUtil.checkFilePath(zipPath)) + File.separator + "dm")))).exists()) {
            dmFile.mkdirs();
        }
        File zipFile = new File(SecurityUtils.normalize((String)(checkzipPath + File.separator + "dm" + File.separator + appPackageName + ".zip")));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            DevportalUtil.zipFile(files, out, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void exportCustomSchemaSql(String schemaId, String appPath) {
        File schemaFile;
        String insertSql = ControlSchemaServiceHelper.getInsertSql((String)schemaId);
        String prePath = File.separator + PREINSDATA;
        String schemaFilePath = File.separator + schemaId + ".sql";
        String checkPrePath = DevportalUtil.checkFilePath(prePath);
        String checschemaFilePath = DevportalUtil.checkFilePath(schemaFilePath);
        File preFile = new File(SecurityUtils.normalize((String)checkPrePath));
        if (!preFile.exists()) {
            preFile.mkdirs();
        }
        if (!(schemaFile = new File(SecurityUtils.normalize((String)checschemaFilePath))).exists()) {
            OutputStreamWriter outputSteramWriter = null;
            FileOutputStream fileOutputStream = null;
            try {
                boolean createNewFileFlag = schemaFile.createNewFile();
                if (createNewFileFlag) {
                    DisCardUtil.discard();
                }
                fileOutputStream = new FileOutputStream(schemaFile);
                outputSteramWriter = new OutputStreamWriter((OutputStream)fileOutputStream, UTF_8);
                outputSteramWriter.write(insertSql);
            }
            catch (IOException e) {
                throw new KDBizException(e.getMessage());
            }
            finally {
                if (outputSteramWriter != null) {
                    try {
                        outputSteramWriter.close();
                    }
                    catch (Exception exception) {
                        DisCardUtil.discard();
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        DisCardUtil.discard();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportSource(String appPath, Object objectFile) {
        String fileName = "";
        List dataList = Collections.emptyList();
        if (objectFile instanceof CoderuleFile) {
            fileName = ((CoderuleFile)objectFile).getFileName();
            dataList = ((CoderuleFile)objectFile).getFileContent();
        } else if (objectFile instanceof BillTypeFile) {
            fileName = ((BillTypeFile)objectFile).getFileName();
            dataList = ((BillTypeFile)objectFile).getFileContent();
        }
        String filePath = File.separator + PREINSDATA + File.separator + fileName + ".sql";
        String checkFilePath = DevportalUtil.checkFilePath(filePath);
        File file = new File(SecurityUtils.normalize((String)checkFilePath));
        File coderuleAboveFile = file.getParentFile();
        if (!coderuleAboveFile.exists()) {
            coderuleAboveFile.mkdirs();
        }
        if (!file.exists()) {
            OutputStreamWriter writer = null;
            FileOutputStream fileOutputStream = null;
            try {
                boolean createNewFileFlag = file.createNewFile();
                if (createNewFileFlag) {
                    DisCardUtil.discard();
                }
                fileOutputStream = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)fileOutputStream, UTF_8);
                for (String data : dataList) {
                    writer.write(data + System.lineSeparator());
                }
            }
            catch (Exception ex) {
                logger.info("exportSource error", (Object)ex);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioException) {
                        logger.info("exportCodeRuleSource", (Object)ioException);
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        DisCardUtil.discard();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createLogInfo(String zipPath, String detailErrorInfo, String packagePath) {
        File packageFile = new File(SecurityUtils.normalize((String)packagePath));
        FileOutputStream fos = null;
        try {
            boolean createNewFileFlag;
            boolean deleteFlag;
            if (packageFile.exists() && (deleteFlag = packageFile.delete())) {
                DisCardUtil.discard();
            }
            if (createNewFileFlag = packageFile.createNewFile()) {
                DisCardUtil.discard();
            }
            fos = new FileOutputStream(packageFile);
            fos.write(detailErrorInfo.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            logger.info("createLogInfo", (Object)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    logger.info("createLogInfo close", (Object)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAppInfo(String zipPath, List<String> appNumbers, String packagePath) {
        File appInfoFile = new File(SecurityUtils.normalize((String)packagePath));
        OutputFormat format = OutputFormat.createPrettyPrint();
        FileOutputStream fileOutputStream = null;
        try {
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("AppDataModel");
            int i = 1;
            for (String appNumber : appNumbers) {
                Element oneChildElement = root.addElement("AppSeq").addAttribute(SOURCE_ID, appNumber).addAttribute("seq", String.valueOf(i));
                ++i;
            }
            fileOutputStream = new FileOutputStream(appInfoFile);
            XMLWriter writer = new XMLWriter((OutputStream)fileOutputStream, format);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            logger.info("createAppInfo error", (Object)e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    DisCardUtil.discard();
                }
            }
        }
    }

    public static void createAppXML(String bizAppId, String bizAppNum, String appPath, JSONArray dbschemaArr, JSONArray preinsdataArr, List<String> sqlNameList, boolean hasXmlFlag) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String dbRoute = "999";
        String appXMLPath = appPath + File.separator + bizAppNum + ".xml";
        File appXMLFile = new File(SecurityUtils.normalize((String)appXMLPath));
        if (!appXMLFile.exists()) {
            try {
                boolean createNewFileFlag = appXMLFile.createNewFile();
                if (createNewFileFlag) {
                    DisCardUtil.discard();
                }
            }
            catch (IOException exception) {
                logger.info(exception.getMessage());
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(appXMLFile);){
            AttributesImpl attrImple;
            String dataBaseType;
            int i;
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(fileOutputStream);
            String four = FOUR;
            AttributesImpl coderuleImple = new AttributesImpl();
            AttributesImpl rootImple = new AttributesImpl();
            transformerHandle.startDocument();
            transformerHandle.characters(four.toCharArray(), 0, 1);
            rootImple.addAttribute("", "", "dympath", STRING, "metadata");
            if (hasXmlFlag) {
                rootImple.addAttribute("", "", "xmlpath", STRING, "preinsdata/xml");
            }
            transformerHandle.startElement("", "", "DataModel", rootImple);
            coderuleImple.addAttribute("", "", "Type", STRING, "KSQL");
            coderuleImple.addAttribute("", "", SEPARATOR, STRING, ";");
            coderuleImple.addAttribute("", "", DBKEY, STRING, "basedata");
            if (dbschemaArr != null && dbschemaArr.size() > 0) {
                for (i = 0; i < dbschemaArr.size(); ++i) {
                    JSONObject dbschemaObj = (JSONObject)dbschemaArr.get(i);
                    String dbschema = dbschemaObj.getString(URL_NAME);
                    dataBaseType = dbschemaObj.getString(DATABASE);
                    attrImple = new AttributesImpl();
                    attrImple.addAttribute("", "", "Type", STRING, dataBaseType);
                    attrImple.addAttribute("", "", SEPARATOR, STRING, ";");
                    attrImple.addAttribute("", "", DBKEY, STRING, dbRoute);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, attrImple, four, "dbschema/" + dbschema, SQL_SCRIPT);
                }
            }
            if (preinsdataArr != null && preinsdataArr.size() > 0) {
                for (i = 0; i < preinsdataArr.size(); ++i) {
                    JSONObject preinsdataObj = (JSONObject)preinsdataArr.get(i);
                    String preinsdata = preinsdataObj.getString(URL_NAME);
                    dataBaseType = preinsdataObj.getString(DATABASE);
                    attrImple = new AttributesImpl();
                    attrImple.addAttribute("", "", "Type", STRING, dataBaseType);
                    attrImple.addAttribute("", "", SEPARATOR, STRING, ";");
                    attrImple.addAttribute("", "", DBKEY, STRING, dbRoute);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, attrImple, four, "preinsdata/" + preinsdata, SQL_SCRIPT);
                }
            }
            for (String sqlName : sqlNameList) {
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, coderuleImple, four, "preinsdata/" + sqlName, SQL_SCRIPT);
            }
            transformerHandle.endElement("", "", "DataModel");
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void exportSchOrPreSource(String appPath, String urlName, String url, String sourceType) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (TXHandle tx = TX.required((String)"mdl_BizAppDeployTreePlugin_exportSchOrPreSource");){
            String checkDbOrPreFullPath;
            File uploadFile;
            String dbOrPrePath = "";
            String dbOrPreFullPath = "";
            if (sourceType.equals("dbschema")) {
                dbOrPrePath = File.separator + "dbschema";
                dbOrPreFullPath = dbOrPrePath + File.separator + urlName;
            } else if (sourceType.equals(PREINSDATA)) {
                dbOrPrePath = File.separator + PREINSDATA;
                dbOrPreFullPath = dbOrPrePath + File.separator + urlName;
            }
            String checkDbOrPrePath = DevportalUtil.checkFilePath(dbOrPrePath);
            File dbOrPreFile = new File(SecurityUtils.normalize((String)checkDbOrPrePath));
            if (!dbOrPreFile.exists()) {
                dbOrPreFile.mkdirs();
            }
            if (!(uploadFile = new File(SecurityUtils.normalize((String)(checkDbOrPreFullPath = DevportalUtil.checkFilePath(dbOrPreFullPath))))).exists()) {
                try {
                    boolean createNewFileFlag = uploadFile.createNewFile();
                    if (createNewFileFlag) {
                        DisCardUtil.discard();
                    }
                }
                catch (IOException exception) {
                    DisCardUtil.discard();
                }
            }
            Path customZipPath = Paths.get(dbOrPreFullPath, new String[0]);
            try (InputStream inputStream = cache.getInputStream(url);
                 BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8));){
                String line = null;
                while ((line = in.readLine()) != null) {
                    bw.write(line);
                    bw.newLine();
                    bw.flush();
                }
            }
            catch (Exception exception) {
                logger.info(exception.getMessage(), (Object)exception);
            }
        }
    }

    public static void exportJarOrStaticSource(String zipPath, String urlName, String url, String relativePath) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (TXHandle tx = TX.required((String)"mdl_BizAppDeployTreePlugin_exportSchOrPreSource");){
            String jarPath;
            String checkJarPath;
            File jarFile;
            String libPath = File.separator + relativePath;
            String checkLibPath = DevportalUtil.checkFilePath(libPath);
            File libFile = new File(SecurityUtils.normalize((String)checkLibPath));
            if (!libFile.exists()) {
                libFile.mkdirs();
            }
            if (!(jarFile = new File(SecurityUtils.normalize((String)(checkJarPath = DevportalUtil.checkFilePath(jarPath = File.separator + urlName))))).exists()) {
                try {
                    boolean createNewFileFlag = jarFile.createNewFile();
                    if (createNewFileFlag) {
                        DisCardUtil.discard();
                    }
                }
                catch (IOException exception) {
                    DisCardUtil.discard();
                }
            }
            try (InputStream inputStream = cache.getInputStream(url);
                 FileOutputStream bos = new FileOutputStream(jarFile);){
                int readLength = 0;
                byte[] buf = new byte[0x100000];
                while ((readLength = inputStream.read(buf)) != -1) {
                    ((OutputStream)bos).write(buf, 0, readLength);
                }
                ((OutputStream)bos).close();
            }
            catch (Exception exception) {
                logger.info(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportCustomResource(String sourceUrl, String schemaPath, String zipPath, String schemaId) throws IOException {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        FileOutputStream outPutStream = null;
        try (InputStream inputStream = fileService.getInputStream(sourceUrl);){
            String checkSchemaPath = DevportalUtil.checkFilePath(schemaPath);
            File customFile = new File(SecurityUtils.normalize((String)checkSchemaPath));
            customFile.mkdirs();
            try (ZipInputStream zipIn = new ZipInputStream(inputStream);){
                ZipEntry entry = null;
                while ((entry = zipIn.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        String name = entry.getName();
                        name = name.substring(0, name.length() - 1);
                        File entryFile = new File(SecurityUtils.normalize((String)checkSchemaPath));
                        entryFile.mkdirs();
                        continue;
                    }
                    String checkSchemaPathEntity = DevportalUtil.checkFilePath(schemaPath + File.separator + entry.getName());
                    File child = new File(SecurityUtils.normalize((String)checkSchemaPathEntity));
                    String childPath = child.getAbsolutePath();
                    if (childPath.contains("\\")) {
                        childPath = childPath.replace("\\", "/");
                        String checkChilPath = DevportalUtil.checkFilePath(childPath);
                        child = new File(SecurityUtils.normalize((String)checkChilPath));
                    }
                    if (!child.getParentFile().exists()) {
                        child.getParentFile().mkdirs();
                    }
                    outPutStream = new FileOutputStream(child);
                    int len = 0;
                    byte[] buf = new byte[1024];
                    while ((len = zipIn.read(buf)) != -1) {
                        ((OutputStream)outPutStream).write(buf, 0, len);
                    }
                }
                String jsonPath = zipPath + File.separator + "schemasource" + File.separator + schemaId;
                ArrayList<String> fileList = new ArrayList<String>();
                List<String> schemaList = DevportalUtil.recursiveFiles(schemaPath, fileList);
                HashMap agencyMap = new HashMap();
                ArrayList<String> jsonStr = new ArrayList<String>(10);
                for (String schemaFileName : schemaList) {
                    String replaceSchema = schemaFileName.replace(File.separator, "/");
                    String schemaFile = replaceSchema.substring(replaceSchema.indexOf("webapp"));
                    jsonStr.add(schemaFile);
                }
                agencyMap.put("modify", jsonStr);
                String keyListValue = SerializationUtils.toJsonString(agencyMap);
                DevportalUtil.createJsonFile(keyListValue, jsonPath, "webapp");
            }
            catch (Exception exception) {
                logger.info(exception.getMessage(), (Object)exception);
            }
        }
        catch (Exception exception) {
            logger.info(exception.getMessage(), (Object)exception);
        }
        finally {
            AppPackageUtil.safeClose(outPutStream);
        }
    }

    public static void safeClose(OutputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
    }

    public static void getJarAndStaticResource(JSONArray jarMsg, JSONArray staticSourceMsg, IDataModel dataModel) {
        int sourceRowCount = dataModel.getEntryRowCount("sourceentryentity");
        for (int i = 0; i < sourceRowCount; ++i) {
            JSONObject sourceObject = new JSONObject();
            String sourceType = (String)dataModel.getValue("sourcetype", i);
            String sourceName = (String)dataModel.getValue("sourcename", i);
            String sourcePath = (String)dataModel.getValue("sourceurl", i);
            String sourceAppId = (String)dataModel.getValue("sourceappid", i);
            sourceObject.put(URL_NAME, (Object)sourceName);
            sourceObject.put(URL, (Object)sourcePath);
            sourceObject.put("sourceappid", (Object)sourceAppId);
            if (ResManager.loadKDString((String)"\u9759\u6001\u8d44\u6e90", (String)"AppPackageUtil_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]).equals(sourceType)) {
                staticSourceMsg.add((Object)sourceObject);
                continue;
            }
            if (!ResManager.loadKDString((String)"JAR\u5305", (String)"AppPackageUtil_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]).equals(sourceType)) continue;
            jarMsg.add((Object)sourceObject);
        }
    }

    public static void putSqlIntoApp(int sqlRowCount, String selectAppId, JSONArray dbschemaMsg, JSONArray preinsdataMsg, IDataModel dataModel) {
        for (int i = 0; i < sqlRowCount; ++i) {
            JSONObject sqlObject = new JSONObject();
            String sqlAppId = (String)dataModel.getValue("sqlappid", i);
            String sqlType = (String)dataModel.getValue("sqltype", i);
            String sqlName = (String)dataModel.getValue("sqlname", i);
            String sqlPath = (String)dataModel.getValue("urlpath", i);
            String dataBaseType = (String)dataModel.getValue(DATABASE, i);
            if (!sqlAppId.equals(selectAppId)) continue;
            sqlObject.put(URL_NAME, (Object)sqlName);
            sqlObject.put(URL, (Object)sqlPath);
            sqlObject.put(DATABASE, (Object)dataBaseType);
            if (ResManager.loadKDString((String)"\u5efa\u8868SQL", (String)"AppPackageUtil_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]).equals(sqlType)) {
                dbschemaMsg.add((Object)sqlObject);
                continue;
            }
            if (!ResManager.loadKDString((String)"\u9884\u7f6eSQL", (String)"AppPackageUtil_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]).equals(sqlType)) continue;
            preinsdataMsg.add((Object)sqlObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportPageScheme(List<Long> wkBenchList, String mainPath, List<String> sqlNameList) {
        Map<Long, PortalSchemeFile> pageSchemeMap = AppPackageUtil.exportAppPageScheme(wkBenchList);
        boolean hasXml = false;
        for (Map.Entry<Long, PortalSchemeFile> entry : pageSchemeMap.entrySet()) {
            Map<String, StringWriter> xmlMap;
            PortalSchemeFile portalSchemeFile = entry.getValue();
            String portalSchemeSqlName = portalSchemeFile.getFileName();
            sqlNameList.add(portalSchemeSqlName);
            String portalSchemeSqlContent = portalSchemeFile.getSql();
            String checkMainPath = DevportalUtil.checkFilePath(mainPath);
            String pageSchemeFilePath = checkMainPath + File.separator + PREINSDATA + File.separator + portalSchemeSqlName;
            String pageSchemeXmlPath = checkMainPath + File.separator + PREINSDATA + File.separator + "xml";
            String checkPageSchemeFilePath = DevportalUtil.checkFilePath(pageSchemeFilePath);
            File pageSchemeFile = new File(SecurityUtils.normalize((String)checkPageSchemeFilePath));
            File pageSchemeParentFile = pageSchemeFile.getParentFile();
            if (!pageSchemeParentFile.exists()) {
                pageSchemeParentFile.mkdirs();
            }
            if (!pageSchemeFile.exists()) {
                OutputStreamWriter writer = null;
                FileOutputStream fileOutputStream = null;
                try {
                    boolean createNewFileFlag = pageSchemeFile.createNewFile();
                    if (createNewFileFlag) {
                        DisCardUtil.discard();
                    }
                    fileOutputStream = new FileOutputStream(pageSchemeFile);
                    writer = new OutputStreamWriter((OutputStream)fileOutputStream, UTF_8);
                    writer.write(portalSchemeSqlContent);
                }
                catch (Exception e) {
                    logger.info("io error", (Object)e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioException) {
                            logger.info("exportCodeRuleSource", (Object)ioException);
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {
                            DisCardUtil.discard();
                        }
                    }
                }
            }
            if ((xmlMap = portalSchemeFile.getXmlMap()) != null && !xmlMap.isEmpty()) {
                hasXml = true;
            }
            if (Objects.isNull(xmlMap)) {
                return false;
            }
            for (Map.Entry<String, StringWriter> portalSchemeEntry : xmlMap.entrySet()) {
                String xmlName = portalSchemeEntry.getKey();
                StringWriter xmlContent = portalSchemeEntry.getValue();
                String xmlFilePath = pageSchemeXmlPath + File.separator + xmlName;
                XMLWriter writer = null;
                FileOutputStream fileOutputStream = null;
                try {
                    boolean createNewFileFlag;
                    String checkXmlFilePath;
                    File xmlFile;
                    Document document = DocumentParseUtil.parseText(xmlContent.toString());
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setEncoding("utf-8");
                    format.setTrimText(false);
                    String checkPageSchemeXmlPath = DevportalUtil.checkFilePath(pageSchemeXmlPath);
                    File xmlPathFile = new File(SecurityUtils.normalize((String)checkPageSchemeXmlPath));
                    if (!xmlPathFile.exists()) {
                        xmlPathFile.mkdirs();
                    }
                    if (!(xmlFile = new File(SecurityUtils.normalize((String)(checkXmlFilePath = DevportalUtil.checkFilePath(xmlFilePath))))).exists() && (createNewFileFlag = xmlFile.createNewFile())) {
                        DisCardUtil.discard();
                    }
                    fileOutputStream = new FileOutputStream(xmlFile);
                    writer = new XMLWriter((OutputStream)fileOutputStream, format);
                    writer.write(document);
                }
                catch (Exception e) {
                    logger.info("io error", (Object)e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException ioException) {
                            DisCardUtil.discard();
                        }
                    }
                    if (fileOutputStream == null) continue;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        DisCardUtil.discard();
                    }
                }
            }
        }
        return hasXml;
    }

    public static void createDataModelXML(String bizAppId, String selectAppNum, String bizCloudNum, String appVersion, String zipPath) {
        String dataModelPath = zipPath + File.separator + DATAMODEL + File.separator + "datamodel.xml";
        File dataModelFile = new File(SecurityUtils.normalize((String)dataModelPath));
        if (!dataModelFile.exists()) {
            try {
                boolean createNewFileFlag = dataModelFile.createNewFile();
                if (createNewFileFlag) {
                    DisCardUtil.discard();
                }
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
        try (FileOutputStream out = new FileOutputStream(dataModelFile);){
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(out);
            String four = FOUR;
            String eight = "\n        ";
            AttributesImpl attrImple = new AttributesImpl();
            AttributesImpl rootImple = new AttributesImpl();
            transformerHandle.startDocument();
            transformerHandle.characters(four.toCharArray(), 0, 1);
            if (bizCloudNum.equalsIgnoreCase("dev") || bizCloudNum.equalsIgnoreCase("sys") || bizCloudNum.equalsIgnoreCase("wfs")) {
                bizCloudNum = "bos";
            }
            rootImple.addAttribute("", "", SOURCE_NAME, STRING, bizCloudNum);
            transformerHandle.startElement("", "", "Package", rootImple);
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, four, appVersion, "ver");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.startElement("", "", "app", attrImple);
            attrImple.addAttribute("", "", SOURCE_ID, STRING, selectAppNum);
            attrImple.addAttribute("", "", SOURCE_NAME, STRING, selectAppNum);
            attrImple.addAttribute("", "", "pkname", STRING, bizCloudNum + "-" + selectAppNum);
            attrImple.addAttribute("", "", "path", STRING, "main/" + selectAppNum);
            transformerHandle.characters(eight.toCharArray(), 0, eight.length());
            transformerHandle.startElement("", "", "item", attrImple);
            transformerHandle.endElement("", "", "item");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.endElement("", "", "app");
            transformerHandle.endElement("", "", "Package");
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void createKdpkgsXML(List<String> appPackageNames, Map<String, String> dmMD5Vals, String zipPath, Map<String, String> jarMsg, Map<String, String> staticSourceMsg, List<String> customList, IFormView formView, IPageCache pageCache, IDataModel dataModel, Control descriptionControl, Control nameControl) {
        String packagePath = zipPath + File.separator + "kdpkgs.xml";
        String checkPackagePath = DevportalUtil.checkFilePath(packagePath);
        File packageFile = new File(SecurityUtils.normalize((String)checkPackagePath));
        if (!packageFile.exists()) {
            try {
                boolean createNewFileFlag = packageFile.createNewFile();
                if (createNewFileFlag) {
                    DisCardUtil.discard();
                }
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(packageFile);){
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(fileOutputStream);
            String four = FOUR;
            String eight = "\n        ";
            String twelve = "\n            ";
            AttributesImpl rootImple = new AttributesImpl();
            AttributesImpl productImple = new AttributesImpl();
            AttributesImpl staticResImple = new AttributesImpl();
            transformerHandle.startDocument();
            String isvString = ISVService.getISVInfo().getId();
            transformerHandle.characters(four.toCharArray(), 0, 1);
            rootImple.addAttribute("", "", "isv", STRING, isvString);
            transformerHandle.startElement("", "", "kdpkgs", rootImple);
            AppPackageUtil.createElementWithAttribute(transformerHandle, four, "", "format", "ver", STRING, "1.1");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.startElement("", "", "description", null);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dataFormat = sdf.format(new Date());
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, dataFormat, "time");
            String description = "";
            if (descriptionControl != null) {
                OrmLocaleValue localeValue = (OrmLocaleValue)dataModel.getValue("pacckdescription");
                description = localeValue.getLocaleValue();
            }
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, description, "content");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.endElement("", "", "description");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            String packageVersion = (String)dataModel.getValue("pkversion");
            ArrayList<String> productSqlList = new ArrayList<String>();
            String delProductSql = String.format("delete from T_META_PKPRODUCTVERSION where FISV = '%s' and FPRODUCTNUMBER = '%s';", isvString, COSMIC_CUS + isvString);
            ArrayList<kd.bos.dataentity.SqlParameter[]> productSqlParameters = new ArrayList<kd.bos.dataentity.SqlParameter[]>();
            String insertProductSql = "insert into T_META_PKPRODUCTVERSION (FID,FISV,FPRODUCTNUMBER,FPRODUCTNAME,FUPGRADETIME,FVERSION) values (?,?,?,?,?,?)";
            productSqlParameters.add(new kd.bos.dataentity.SqlParameter[]{new kd.bos.dataentity.SqlParameter(":FID", -5, (Object)DB.genLongId((String)"T_META_PKPRODUCTVERSION")), new kd.bos.dataentity.SqlParameter(":FISV", 12, (Object)isvString), new kd.bos.dataentity.SqlParameter(":FPRODUCTNUMBER", 12, (Object)(COSMIC_CUS + isvString)), new kd.bos.dataentity.SqlParameter(":FPRODUCTNAME", 12, (Object)AppPackageUtil.getProductName()), new kd.bos.dataentity.SqlParameter(":FUPGRADETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new kd.bos.dataentity.SqlParameter(":FVERSION", 12, (Object)packageVersion)});
            productSqlList.add(delProductSql);
            DevportalUtil.insertDevVersion(productSqlList);
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertProductSql, productSqlParameters);
            String bizAppId = (String)formView.getFormShowParameter().getCustomParam(BIZAPPID);
            AppMetadata appmeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            String appIsv = appmeta.getIsv();
            productImple.addAttribute("", "", SOURCE_NAME, "", COSMIC_CUS + appIsv);
            productImple.addAttribute("", "", "nameCN", "", AppPackageUtil.getProductName());
            productImple.addAttribute("", "", "ver", "", packageVersion);
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.startElement("", "", "product", productImple);
            HashMap<String, String> appMap = new HashMap<String, String>(20);
            for (String string : appPackageNames) {
                String string2 = string.split("-")[1];
                ArrayList<String> sqlList = new ArrayList<String>();
                String delSql = String.format("delete from T_META_PACKAGEAPPVERSION where FAPPID = '%s';", string2);
                ArrayList<Object[]> appSqlParameters = new ArrayList<Object[]>();
                String insertAppSql = "insert into T_META_PACKAGEAPPVERSION (FID,FAPPID,FUPGRADETIME,FDBVERSION) values (?,?,?,?)";
                appSqlParameters.add(new kd.bos.dataentity.SqlParameter[]{new kd.bos.dataentity.SqlParameter(":FID", -5, AppPackageUtil.getLongId()), new kd.bos.dataentity.SqlParameter(":FAPPID", 12, (Object)string2), new kd.bos.dataentity.SqlParameter(":FUPGRADETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new kd.bos.dataentity.SqlParameter(":FDBVERSION", 12, (Object)packageVersion)});
                AppPackageUtil.executeBatchMethod(insertAppSql, appSqlParameters);
                sqlList.add(delSql);
                DevportalUtil.insertDevVersion(sqlList);
                transformerHandle.characters(eight.toCharArray(), 0, eight.length());
                transformerHandle.startElement("", "", "app", null);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, twelve, string2, SOURCE_NAME);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, twelve, packageVersion, "ver");
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, twelve, string2, "appids");
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, twelve, "", "dependon");
                String appUUID2 = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                StringBuilder dmUUID = new StringBuilder();
                dmUUID.append(appUUID2);
                appMap.put(string, appUUID2);
                if (!jarMsg.isEmpty()) {
                    for (Map.Entry<String, String> jarEntry : jarMsg.entrySet()) {
                        String jarKey = jarEntry.getKey();
                        String jarVal = jarEntry.getValue();
                        String jarAppNum = jarVal.split("-")[0];
                        if (!string2.equals(jarAppNum)) continue;
                        String jarUUID = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                        dmUUID.append(",").append(jarUUID);
                        jarMsg.put(jarKey, jarVal + "-" + jarUUID);
                    }
                }
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, twelve, dmUUID.toString(), "resource");
                transformerHandle.characters(eight.toCharArray(), 0, eight.length());
                transformerHandle.endElement("", "", "app");
            }
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.endElement("", "", "product");
            if (!appMap.isEmpty()) {
                appMap.forEach((appPackageName, appUUID) -> {
                    try {
                        transformerHandle.characters(four.toCharArray(), 0, four.length());
                        transformerHandle.startElement("", "", KDPKG, null);
                        String dmName = appPackageName + ".zip";
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, appUUID, "ID");
                        if (dmMD5Vals.containsKey(appPackageName)) {
                            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, (String)dmMD5Vals.get(appPackageName), "md5");
                        }
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, dmName, SOURCE_NAME);
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, "dm", "type");
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, "dm/", SOURCE_PATH);
                        transformerHandle.characters(four.toCharArray(), 0, four.length());
                        transformerHandle.endElement("", "", KDPKG);
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                });
            }
            if (jarMsg != null && jarMsg.size() > 0) {
                for (Map.Entry entry : jarMsg.entrySet()) {
                    String string = (String)entry.getKey();
                    String jarVal = (String)entry.getValue();
                    transformerHandle.characters(four.toCharArray(), 0, four.length());
                    transformerHandle.startElement("", "", KDPKG, null);
                    String[] jarStrArr = jarVal.split("-");
                    String jarMD5Value = jarStrArr[1];
                    String jarUUID = jarStrArr[2];
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, jarUUID, "ID");
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, jarMD5Value, "md5");
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, string, SOURCE_NAME);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, "jar", "type");
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, "jar/", SOURCE_PATH);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, "cus", "outputPath");
                    transformerHandle.characters(four.toCharArray(), 0, four.length());
                    transformerHandle.endElement("", "", KDPKG);
                }
            }
            StringBuilder staticResource = new StringBuilder();
            if (staticSourceMsg != null && staticSourceMsg.size() > 0) {
                for (Map.Entry<String, String> entry : staticSourceMsg.entrySet()) {
                    String staticSourceName = entry.getKey();
                    String staticSourceMD5Value = entry.getValue();
                    String staticSourceUUID = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                    if (StringUtils.isNotBlank((CharSequence)staticResource)) {
                        staticResource.append(",").append(staticSourceUUID);
                    } else {
                        staticResource.append(staticSourceUUID);
                    }
                    transformerHandle.characters(four.toCharArray(), 0, four.length());
                    transformerHandle.startElement("", "", KDPKG, null);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, staticSourceUUID, "ID");
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, staticSourceMD5Value, "md5");
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, staticSourceName, SOURCE_NAME);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, STATIC_RESOURCE, "type");
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, "resource/uploadsource", SOURCE_PATH);
                    transformerHandle.characters(four.toCharArray(), 0, four.length());
                    transformerHandle.endElement("", "", KDPKG);
                }
            }
            for (String string : customList) {
                String customSourceUUID = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                if (StringUtils.isNotBlank((CharSequence)staticResource)) {
                    staticResource.append(",").append(customSourceUUID);
                } else {
                    staticResource.append(customSourceUUID);
                }
                transformerHandle.characters(four.toCharArray(), 0, four.length());
                transformerHandle.startElement("", "", KDPKG, null);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, customSourceUUID, "ID");
                String customSourceMD5Value = pageCache.get(string);
                pageCache.remove(string);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, customSourceMD5Value, "md5");
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, string, SOURCE_NAME);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, STATIC_RESOURCE, "type");
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, "resource/custom", SOURCE_PATH);
                transformerHandle.characters(four.toCharArray(), 0, four.length());
                transformerHandle.endElement("", "", KDPKG);
            }
            staticResImple.addAttribute("", "", "ver", "", packageVersion);
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.startElement("", "", STATIC_RESOURCE, staticResImple);
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, eight, staticResource.toString(), "resource");
            transformerHandle.characters(four.toCharArray(), 0, four.length());
            transformerHandle.endElement("", "", STATIC_RESOURCE);
            transformerHandle.endElement("", "", "kdpkgs");
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static Object getLongId() {
        return DB.genLongId((String)"T_META_PACKAGEAPPVERSION");
    }

    private static void executeBatchMethod(String insertAppSql, List<Object[]> appSqlParameters) {
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertAppSql, appSqlParameters);
    }

    public static TransformerHandler getTransformerHandler(FileOutputStream fileOutputStream) throws TransformerConfigurationException {
        StreamResult reultXml = new StreamResult(fileOutputStream);
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = factory.newTransformer();
        TransformerHandler transformerHandle = factory.newTransformerHandler();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", UTF_8);
        transformerHandle.setResult(reultXml);
        return transformerHandle;
    }

    public static void createElementWithoutAttribute(TransformerHandler transformerHandle, AttributesImpl attributesImple, String blankLength, String endLength, String elementName) throws SAXException {
        AttributesImpl attriImple = null;
        attriImple = StringUtils.isBlank((Object)attributesImple) ? new AttributesImpl() : attributesImple;
        transformerHandle.characters(blankLength.toCharArray(), 0, blankLength.length());
        transformerHandle.startElement("", "", elementName, attriImple);
        if (StringUtils.isNotBlank((CharSequence)endLength)) {
            transformerHandle.characters(endLength.toCharArray(), 0, endLength.length());
        }
        transformerHandle.endElement("", "", elementName);
    }

    public static void createElementWithAttribute(TransformerHandler transformerHandle, String blankLength, String endLength, String elementName, String attributeName, String attributeType, String attributeValue) throws SAXException {
        AttributesImpl attriImple = new AttributesImpl();
        transformerHandle.characters(blankLength.toCharArray(), 0, blankLength.length());
        attriImple.addAttribute("", "", attributeName, attributeType, attributeValue);
        transformerHandle.startElement("", "", elementName, attriImple);
        if (StringUtils.isNotBlank((CharSequence)endLength)) {
            transformerHandle.characters(endLength.toCharArray(), 0, endLength.length());
        }
        transformerHandle.endElement("", "", elementName);
    }

    public static String getDevPorductVersion() {
        int tempSysProductionIterVal;
        String productNum;
        String dbVersion = DBVersion.getVer();
        String sysProductSql = "select FVERSION from t_bas_industry_version where FISV = ? and FPRODUCTNUMBER = ?";
        String isv = ISVService.getISVInfo().getId();
        kd.bos.dataentity.SqlParameter[] sysProductParams = new kd.bos.dataentity.SqlParameter[]{new kd.bos.dataentity.SqlParameter(":FISV", 12, (Object)isv), new kd.bos.dataentity.SqlParameter(":FPRODUCTNUMBER", 12, (Object)(productNum = COSMIC_CUS + isv))};
        String sysProductVersion = DevportalUtil.selectSourceVersion(sysProductSql, (SqlParameter[])sysProductParams, "");
        if (StringUtils.isBlank((CharSequence)sysProductVersion)) {
            sysProductVersion = dbVersion;
        }
        String[] sysProductInfo = sysProductVersion.split("\\.");
        String sysProductBig = sysProductInfo[0] + "." + sysProductInfo[1];
        Integer sysProductBigVal = Integer.valueOf(sysProductInfo[0] + sysProductInfo[1]);
        String sysProductIter = sysProductInfo[sysProductInfo.length - 1];
        String devProductSql = "select FVERSION from t_meta_pkproductversion where FISV = ? and FPRODUCTNUMBER = ?";
        String devProductVersion = DevportalUtil.selectSourceVersion(devProductSql, (SqlParameter[])sysProductParams, "");
        if (StringUtils.isBlank((CharSequence)devProductVersion)) {
            devProductVersion = sysProductVersion;
        }
        String[] devProductInfo = devProductVersion.split("\\.");
        Integer devProductBigVal = Integer.valueOf(devProductInfo[0] + devProductInfo[1]);
        String devProductIter = devProductInfo[devProductInfo.length - 1];
        if (sysProductBigVal > devProductBigVal) {
            tempSysProductionIterVal = Integer.parseInt(sysProductIter);
            devProductIter = String.valueOf(++tempSysProductionIterVal);
        } else if (StringUtils.isNotBlank((CharSequence)devProductIter) && Integer.parseInt(devProductIter) >= Integer.parseInt(sysProductIter)) {
            int tempdevProductIterVal = Integer.parseInt(devProductIter);
            devProductIter = String.valueOf(++tempdevProductIterVal);
        } else {
            tempSysProductionIterVal = Integer.parseInt(sysProductIter);
            devProductIter = String.valueOf(++tempSysProductionIterVal);
        }
        String newPKIterVersion = "";
        newPKIterVersion = devProductIter.length() == 1 ? "00" + devProductIter : (devProductIter.length() == 2 ? "0" + devProductIter : devProductIter);
        String newPkProductionVersion = sysProductBig + "." + newPKIterVersion;
        return newPkProductionVersion;
    }

    public static JSONArray getFirNodes() {
        JSONArray jsonArray = new JSONArray();
        String[][] source = new String[][]{{AppPackageUtil.getCloudName(), CLOUD_ID, CLOUD_NUM}, {AppPackageUtil.getAppName(), APP_ID, APP_NUM}, {AppPackageUtil.getPageName(), PAGE_ID, PAGE_NUM}, {AppPackageUtil.getScriptName(), SCRIPT_ID, SCRIPT_NUM}, {AppPackageUtil.getBilltypeName(), BILLTYPE_ID, BILLTYPE_NUM}, {AppPackageUtil.getCoderuleName(), CODERULE_ID, CODERULE_NUM}, {AppPackageUtil.getSchemaName(), SCHEMA_ID, SCHEMA_NUM}, {AppPackageUtil.getWorkbenchName(), WORKBENCH_ID, WORKBENCH_NUM}};
        for (int i = 0; i < source.length; ++i) {
            String sourceName = source[i][0];
            String sourceId = source[i][1];
            String sourceNum = source[i][2];
            JSONObject sourceObject = AppPackageUtil.putObjToArr(sourceName, sourceId, sourceNum);
            jsonArray.add((Object)sourceObject);
        }
        return jsonArray;
    }

    public static JSONObject putObjToArr(String name, String id, String num) {
        JSONObject homeObject = new JSONObject();
        homeObject.put(SOURCE_NAME, (Object)name);
        homeObject.put(SOURCE_ID, (Object)id);
        homeObject.put(SOURCE_NUMBER, (Object)num);
        return homeObject;
    }

    public static void pushSourceToCollection(List<Map<String, Object>> sourceList, Map<String, Object> selectNodeMap, String bizParent, List<String> selectAppIdList, int num) {
        sourceList.add(selectNodeMap);
        String bizAppId = bizParent.split("#")[num];
        if (!selectAppIdList.contains(bizAppId)) {
            selectAppIdList.add(bizAppId);
        }
    }

    public static void getTreeNodeChildren(TreeNode treeNode, List<String> treeNodeList) {
        String treeNodeId = treeNode.getId();
        treeNodeList.add(treeNodeId);
        List childTreeNodeList = treeNode.getChildren();
        if (childTreeNodeList != null) {
            for (TreeNode childTreeNode : childTreeNodeList) {
                AppPackageUtil.getTreeNodeChildren(childTreeNode, treeNodeList);
            }
        }
    }

    public static Map<Long, PortalSchemeFile> exportAppPageScheme(List<Long> mainPageIds) {
        HashMap<Long, PortalSchemeFile> portalSchemeFileMap = new HashMap<Long, PortalSchemeFile>(20);
        for (long mainPageId : mainPageIds) {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("DELETE FROM T_BAS_CARDCONFIG_L WHERE FID IN (SELECT FID FROM T_BAS_CARDCONFIG WHERE FMAINPAGEID = ").append(String.valueOf(mainPageId)).append(");\t\n");
            sqlBuilder.append("DELETE FROM T_BAS_CARDCONFIG WHERE FMAINPAGEID = ").append(String.valueOf(mainPageId)).append(STR);
            sqlBuilder.append("DELETE FROM T_BAS_MAINPAGELAYOUT_L WHERE FID = ").append(String.valueOf(mainPageId)).append(STR);
            sqlBuilder.append("DELETE FROM T_BAS_MAINPAGELAYOUT WHERE FID = ").append(String.valueOf(mainPageId)).append(STR);
            PortalSchemeFile portalSchemeFile = new PortalSchemeFile();
            portalSchemeFile.setFileName("wb_portal_scheme_" + mainPageId + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".sql");
            PreInsDataScriptBuilder builder3 = new PreInsDataScriptBuilder();
            HashMap map3 = new HashMap();
            String selectField3 = "FPKID, FID, FLOCALEID, FCARDTITLE, FCUSTOMNAME  ";
            StringBuilder whereField3 = new StringBuilder();
            whereField3.append("fid in (select fid from t_bas_cardconfig where fmainpageid = ").append(mainPageId).append(")");
            try {
                map3.putAll(builder3.genInsertSQLScript(DBRoute.basedata, "t_bas_cardconfig_l", selectField3, whereField3.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map3.get("sql")))) {
                    sqlBuilder.append((String)map3.get("sql"));
                }
                if (map3.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map3.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            PreInsDataScriptBuilder builder2 = new PreInsDataScriptBuilder();
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            String selectField2 = "FID, FUSERID, FTYPE, FCONFIG, FMAINPAGEID, FCARDID ";
            StringBuilder whereField2 = new StringBuilder();
            whereField2.append("FMAINPAGEID = ").append(mainPageId);
            try {
                map2.putAll(builder2.genInsertSQLScript(DBRoute.basedata, "t_bas_cardconfig", selectField2, whereField2.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map2.get("sql")))) {
                    AppPackageUtil.processExportCardConfig(map2);
                    sqlBuilder.append((String)map2.get("sql"));
                }
                if (map2.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map2.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            PreInsDataScriptBuilder builder1 = new PreInsDataScriptBuilder();
            HashMap map1 = new HashMap();
            String selectField1 = "FPKID, FID, FLOCALEID, FNAME ";
            StringBuilder whereField1 = new StringBuilder();
            whereField1.append("FID = ").append(mainPageId);
            try {
                map1.putAll(builder1.genInsertSQLScript(DBRoute.basedata, "t_bas_mainpagelayout_l", selectField1, whereField1.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map1.get("sql")))) {
                    sqlBuilder.append((String)map1.get("sql"));
                }
                if (map1.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map1.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
            HashMap map = new HashMap();
            String tableName = "t_bas_mainpagelayout";
            String selectField = "FID, FUSERID, FTYPE, FBIZAPPID, FLAYOUT, FNUMBER, FENABLE, FCUSTOMABLE, FISMULTIORG, FISPRESET, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FDISABLERID, FDISABLETIME, FSCHEMETYPE,FFORMNUM ";
            StringBuilder whereField = new StringBuilder();
            whereField.append("FID = ").append(mainPageId);
            try {
                map.putAll(builder.genInsertSQLScript(DBRoute.basedata, tableName, selectField, whereField.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map.get("sql")))) {
                    sqlBuilder.append((String)map.get("sql"));
                }
                if (map.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map.get("xml"));
                }
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXP_PLUGIN_ERROR_S, e.getMessage())});
            }
            portalSchemeFile.setSql(sqlBuilder.toString());
            portalSchemeFileMap.put(mainPageId, portalSchemeFile);
        }
        return portalSchemeFileMap;
    }

    private static void processExportCardConfig(Map<String, Object> exportCardConfigSqlInfo) {
        AppPackageUtil.processExportQingCardConfig(exportCardConfigSqlInfo);
    }

    private static void processExportQingCardConfig(Map<String, Object> exportCardConfigSqlInfo) {
        String[] sqlArr;
        String allSql = (String)exportCardConfigSqlInfo.get("sql");
        if (StringUtils.isBlank((CharSequence)allSql)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String curSql : sqlArr = allSql.split(";")) {
            if (StringUtils.isBlank((CharSequence)curSql)) {
                sb.append("\r\n");
                continue;
            }
            StringBuilder curSqlSb = new StringBuilder(curSql);
            if (curSql.contains("INSERT INTO t_bas_cardconfig") && curSql.contains("'bos_card_qing'")) {
                int startIndex = curSql.indexOf("'{");
                int endIndex = curSql.lastIndexOf("}'");
                String configJsonStr = curSql.substring(startIndex + 1, endIndex + 1);
                String resultStr = AppPackageUtil.invokeBOSService(configJsonStr);
                curSqlSb.replace(startIndex + 1, endIndex + 1, resultStr);
            }
            sb.append((CharSequence)curSqlSb).append(";");
        }
        exportCardConfigSqlInfo.put("sql", sb.toString());
    }

    private static String invokeBOSService(String configJsonStr) {
        return (String)DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"switchHomepageCardIdToPath", (Object[])new Object[]{configJsonStr});
    }
}

