/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONArray;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.SummaryResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.list.ListQueryParameter;
import kd.bos.mservice.list.ListServiceResult;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.portal.model.CardCountType;
import kd.bos.portal.model.CountErrorCode;
import kd.bos.portal.model.CountRst;
import kd.bos.portal.model.CountStatusEnum;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.util.CacheUtil;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BillCountCardUtils {
    private static Log log = LogFactory.getLog(BillCountCardUtils.class);
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String FILTERSCHEMA = "filterschema";
    public static final String ENTITYID = "entityid";
    public static final String FORM_SERVICE = "FormService";
    private IFormView iFormView = null;
    private IPageCache iPageCache = null;
    private IDataModel iDataModel = null;
    private Log logger = null;

    public BillCountCardUtils(IFormView pFormView, IPageCache pPageCache, IDataModel pDataModel, Log plogger) {
        this.iFormView = pFormView;
        this.iPageCache = pPageCache;
        this.iDataModel = pDataModel;
        this.logger = plogger;
    }

    public CountRst getBillCountWithCache(Map<String, String> cardMap, Boolean isRefresh, CardCountType cardCountType) {
        CountRst countRst;
        if (this.iFormView == null || this.iPageCache == null || this.iDataModel == null || this.logger == null) {
            return null;
        }
        Boolean isUseCache = Boolean.TRUE;
        try {
            Object object = SystemParamServiceHelper.loadPublicParameterFromCache((String)"card_use_cache_enable");
            if (object != null) {
                isUseCache = Boolean.parseBoolean(object.toString());
            }
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u9996\u9875\u5361\u7247\u4f7f\u7528\u7f13\u5b58\u5f00\u5173\u65f6\u95f4\u5f02\u5e38\uff1a", (Object)e);
        }
        String key = this.getKey(cardMap, cardCountType);
        if (!isRefresh.booleanValue() && isUseCache.booleanValue() && (countRst = this.getCountRstFromCache(key)) != null) {
            return countRst;
        }
        try {
            countRst = this.getBillCount(cardMap, cardCountType);
        }
        catch (Exception e) {
            this.logger.info("card count error: ", (Object)e);
            countRst = new CountRst("ERR", Instant.now().toEpochMilli() + "", CountStatusEnum.ERROR.name());
        }
        if (isUseCache.booleanValue()) {
            CacheUtil.putCardCountCache(key, countRst.getCount(), countRst.getTimeStamp(), 30, TimeUnit.DAYS);
        }
        return countRst;
    }

    private CountRst checkBillCount(Map<String, String> cardMap) {
        String filterSchemeId;
        CountRst countRst = new CountRst();
        countRst.setTimeStamp(Instant.now().toEpochMilli() + "");
        Long userId = RequestContext.get().getCurrUserId();
        String appNum = cardMap.get("appnum");
        if (appNum != null) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNum);
            String appId = appInfo.getId();
            Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            if (disabledAppIds != null && disabledAppIds.contains(appId)) {
                countRst.setStatus(CountStatusEnum.ERROR.name());
                countRst.setCount("0");
                return countRst;
            }
            try {
                Map noPermMenuMap = (Map)this.iFormView.getFormShowParameter().getCustomParam("noPermMenuMap");
                Object noPermMenuIdsObj = noPermMenuMap.get(appId);
                JSONArray noPermMenuIds = (JSONArray)noPermMenuIdsObj;
                String menuid = cardMap.get("menuid");
                if (noPermMenuIds.contains((Object)menuid)) {
                    countRst.setStatus(CountStatusEnum.ERROR.name());
                    countRst.setCount("0");
                    return countRst;
                }
            }
            catch (Exception e) {
                this.logger.info("checkBillCount permission error", (Object)e);
            }
        }
        if (StringUtils.isNotEmpty((String)(filterSchemeId = cardMap.get(FILTERSCHEMA)))) {
            if (!BillCountCardUtils.isHaveSchemeRecord(filterSchemeId)) {
                this.logger.debug(filterSchemeId + "\u5217\u8868\u8fc7\u6ee4\u65b9\u6848\u5df2\u7ecf\u88ab\u5220\u9664");
                countRst.setStatus(CountStatusEnum.ERROR.name());
                countRst.setCount(ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u5220\u9664", (String)"CardUtils_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                countRst.setErrorCode(CountErrorCode.SCHEMEDELETE.name());
                return countRst;
            }
            if (!OpenPageUtils.isHaveSchemeAuth(filterSchemeId, userId)) {
                this.logger.debug(filterSchemeId + "\u6ca1\u6709\u5217\u8868\u8fc7\u6ee4\u65b9\u6848\u6743\u9650");
                countRst.setStatus(CountStatusEnum.ERROR.name());
                countRst.setCount("0");
                return countRst;
            }
        }
        try {
            String formNum = cardMap.get(ENTITYID);
            String entityNum = CardUtils.getEntityNumByFormNum(formNum);
            String sumField = cardMap.get("sumfield");
            boolean hasFieldPerm = this.checkFieldPerm(appNum, entityNum, sumField);
            if (!hasFieldPerm) {
                countRst.setStatus(CountStatusEnum.ERROR.name());
                countRst.setCount("***");
                return countRst;
            }
        }
        catch (Exception e) {
            this.logger.info("checkFieldPerm fail", (Object)e);
        }
        return null;
    }

    private boolean checkFieldPerm(String appNum, String entityNum, String field) {
        if (StringUtils.isEmpty((String)field)) {
            return true;
        }
        FieldControlRules fieldControlRules = PermissionServiceHelper.getFieldControlRules((long)RequestContext.get().getCurrUserId(), (String)appNum, (String)entityNum);
        List fieldControlRuleDtos = fieldControlRules.getFieldControlRuleDtos();
        if (CollectionUtils.isEmpty((Collection)fieldControlRuleDtos)) {
            return true;
        }
        String column = field;
        String[] split = field.split("\\.");
        int length = split.length;
        if (length > 0) {
            column = split[length - 1];
        }
        for (FieldControlRuleDto data : fieldControlRuleDtos) {
            boolean contains;
            FieldControlRule fieldControlRule = data.getFieldControlRule();
            Set canNotReadFields = fieldControlRule.getCanNotReadFields();
            if (CollectionUtils.isEmpty((Collection)canNotReadFields) || !(contains = canNotReadFields.contains(column))) continue;
            return false;
        }
        return true;
    }

    private CountRst getBillCount(Map<String, String> cardMap, CardCountType cardCountType) {
        ListServiceResult result;
        String filterSchemeId;
        AppMenuInfo ami;
        CountRst countRst = this.checkBillCount(cardMap);
        if (countRst != null) {
            return countRst;
        }
        String formNum = cardMap.get(ENTITYID);
        String entityNum = CardUtils.getEntityNumByFormNum(formNum);
        String appNum = cardMap.get("appnum");
        if (StringUtils.isEmpty((String)appNum)) {
            appNum = this.iFormView.getFormShowParameter().getAppId();
            this.logger.debug("\u672a\u83b7\u53d6\u5230\u5355\u636e\u7edf\u8ba1\u5361\u7247\u8868\u5355\u6240\u5728\u7684\u5e94\u7528\uff0c\u8868\u5355\uff1a" + entityNum);
        }
        String menuId = cardMap.get("menuid");
        String sumField = cardMap.get("sumfield");
        boolean isolationOrg = CardUtils.getIsolationOrg(appNum, menuId);
        String params = null;
        if (StringUtils.isNotEmpty((String)menuId) && (ami = AppMetadataCache.getAppMenuInfo((String)appNum, (String)menuId)) != null) {
            params = ami.getParams();
        }
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formNum);
        ListQueryParameter lqp = new ListQueryParameter();
        try {
            String appHomeFormId = AppMetadataCache.getAppInfo((String)appNum).getHomeNum();
            lqp.setParentFormId(appHomeFormId);
        }
        catch (Exception e) {
            this.logger.info(String.format("getAppInfo error, appNum:%s", appNum), (Object)e);
        }
        lqp.setBillFormId(formNum);
        lqp.setFormId(formConfig.getListFormId());
        lqp.setHasRight(true);
        lqp.setIsolationOrg(isolationOrg);
        if (!StringUtils.isEmpty((String)params)) {
            lqp.setCustomParams((Map)SerializationUtils.fromJsonString((String)params, Map.class));
        }
        if (StringUtils.isNotEmpty((String)(filterSchemeId = cardMap.get(FILTERSCHEMA)))) {
            lqp.setFilterSchemeId(filterSchemeId);
        }
        lqp.setAppId(appNum);
        String serviceAppId = FormMetadataCache.getFormConfig((String)entityNum).getAppId();
        if (CardCountType.SUM.name().equals(cardCountType.name())) {
            String[] sumFields = new String[]{sumField};
            result = (ListServiceResult)DispatchServiceHelper.invokeBOSService((String)serviceAppId, (String)"ListService", (String)"getListSummaryResult", (Object[])new Object[]{lqp, sumFields});
        } else {
            result = (ListServiceResult)DispatchServiceHelper.invokeBOSService((String)serviceAppId, (String)"ListService", (String)"getBillDataCount", (Object[])new Object[]{lqp});
        }
        this.logger.debug("getBillCount result:" + SerializationUtils.toJsonString((Object)result));
        String time = Instant.now().toEpochMilli() + "";
        if (result != null && result.getSuccess().booleanValue() && result.getData() != null) {
            Object data = result.getData();
            String countStr = data instanceof List ? this.parseData((List)data) : result.getData().toString();
            return new CountRst(countStr, time, CountStatusEnum.SUCCESS.name());
        }
        return new CountRst("0", time, CountStatusEnum.ERROR.name());
    }

    private String parseData(List list) {
        if (list == null || list.size() == 0) {
            this.logger.debug("data is empty");
            return "0";
        }
        Object data = list.get(0);
        try {
            if (data instanceof SummaryResult) {
                SummaryResult sumData = (SummaryResult)data;
                return sumData.getNumberPrecision().getResult().toString();
            }
            this.logger.debug("BillCountCardUtils--parseData:" + SerializationUtils.toJsonString(data));
            return data.toString();
        }
        catch (Exception e) {
            this.logger.info("BillCountCardUtils--parseData error", (Object)e);
            return "0";
        }
    }

    private CountRst getCountRstFromCache(String key) {
        Map<String, String> rstCache = CacheUtil.getCardCountCacheVal(key);
        if (rstCache != null && rstCache.size() > 0) {
            String value = rstCache.get("value");
            String timeStamp = rstCache.get("timeStamp");
            if (StringUtils.isNotEmpty((String)value) && StringUtils.isNotEmpty((String)timeStamp)) {
                CountRst countRst = new CountRst();
                countRst.setStatus(CountStatusEnum.SUCCESS.name());
                countRst.setCount(value);
                countRst.setTimeStamp(timeStamp);
                return countRst;
            }
        }
        return null;
    }

    private String getKey(Map<String, String> cardMap, CardCountType cardCountType) {
        String formNum = cardMap.get(ENTITYID);
        String appNum = cardMap.get("appnum");
        if (StringUtils.isEmpty((String)appNum)) {
            appNum = this.iFormView.getFormShowParameter().getAppId();
        }
        String menuId = cardMap.get("menuid");
        String filterSchemeId = cardMap.get(FILTERSCHEMA);
        String sumField = cardMap.get("sumfield");
        return CacheUtil.getCardCountKey(RequestContext.get().getUserId(), appNum, menuId, formNum, filterSchemeId, sumField, cardCountType);
    }

    public static boolean isHaveSchemeRecord(String schemeId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)schemeId)};
        String sql = "SELECT COUNT(1) FROM T_BAS_FILTERSCHEME T1 WHERE T1.FSCHEMEID =?";
        ResultSetHandler action = rs -> {
            if (rs.next() && rs.getInt(1) > 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        };
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)action);
    }
}

