/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.portal.model.CardCountType;
import kd.sdk.annotation.SdkInternal;

public class CacheUtil {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("bos_portal_plugin", new DistributeCacheHAPolicy(true, true));

    @SdkInternal
    public static void putCardCountCache(String key, String value, String timeStamp, int timeOut, TimeUnit timeUnit) {
        HashMap<String, String> valMap = new HashMap<String, String>();
        valMap.put("value", value);
        valMap.put("timeStamp", timeStamp);
        cache.put(key, valMap, timeOut, timeUnit);
    }

    @SdkInternal
    public static String getCardCountKey(String userId, String appId, String menuId, String formNum, String filterSchemeId, String field, CardCountType cardCountType) {
        StringBuilder key = new StringBuilder();
        key.append("card_count_");
        key.append(RequestContext.get().getAccountId());
        key.append(userId);
        key.append(appId);
        key.append(menuId);
        key.append(formNum);
        key.append(filterSchemeId);
        if (StringUtils.isNotEmpty((CharSequence)field)) {
            key.append(field);
        }
        key.append(cardCountType.getValue());
        return key.toString();
    }

    @Deprecated
    public static String getCardCountKey(String userId, String appId, String menuId, String formNum, String filterSchemeId, CardCountType cardCountType) {
        return CacheUtil.getCardCountKey(userId, appId, menuId, formNum, filterSchemeId, "", cardCountType);
    }

    @SdkInternal
    public static Map<String, String> getCardCountCacheVal(String key) {
        return cache.getAll(key);
    }

    public static void removeCardCountCache(String key) {
        cache.remove(key);
    }

    public static String getMyCurrentAppKey() {
        StringBuilder key = new StringBuilder();
        key.append("my_current_use_app_");
        key.append(RequestContext.get().getAccountId());
        key.append('_');
        key.append(RequestContext.get().getCurrUserId());
        return key.toString();
    }

    public static void putMyCurrentAppCache(String myCurrentApp) {
        cache.put(CacheUtil.getMyCurrentAppKey(), (Object)myCurrentApp, 100, TimeUnit.DAYS);
    }

    public static String getMyCurrentAppCache() {
        return (String)cache.get(CacheUtil.getMyCurrentAppKey());
    }
}

