/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class CloudLadderSkipUtils {
    private static Log logger = LogFactory.getLog(CloudLadderSkipUtils.class);
    private static final String BASEURL = "https://ops.kdcloud.com/";
    private static final String OPSAPPID = "cosmiccloud";
    private static final String CLOUD_LADDER_TYPE = "cosmic";
    private static final String UID = "80099833";
    private static final String PRODINSTCODE = "15626374296d4dcf4615cdb868adcd6d";

    public static Map<String, Object> cloudLadderAuth() {
        String appId = CloudLadderSkipUtils.getOPSAppID();
        String secret = CloudLadderSkipUtils.getOPSAppSecret();
        String type = CloudLadderSkipUtils.getOPSType();
        String phone = CloudLadderSkipUtils.getOPSPhone();
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)secret)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)phone)) {
            return null;
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        String uid = CloudLadderSkipUtils.getOPSUid();
        String prodInstCode = CloudLadderSkipUtils.getProdInstCode();
        String sign = CloudLadderSkipUtils.getSign(appId, type, timestamp, phone, prodInstCode, secret);
        StringBuilder authUrl = new StringBuilder(CloudLadderSkipUtils.getOPSUrl());
        authUrl.append("boss/open/auth");
        HashMap<String, String> authBody = new HashMap<String, String>();
        authBody.put("appId", appId);
        authBody.put("type", type);
        authBody.put("nonce", timestamp);
        authBody.put("phone", phone);
        authBody.put("code", prodInstCode);
        authBody.put("sign", sign);
        String cloudLadderRespStr = "";
        Map resp = null;
        try {
            cloudLadderRespStr = HttpClientUtils.post((String)authUrl.toString(), null, authBody);
            logger.debug(String.format("cloudLadderAuth.response.cloudLadderRespStr:%s", cloudLadderRespStr));
        }
        catch (Exception e) {
            logger.info("cloudLadderAuth.response.error", (Object)e);
            return resp;
        }
        resp = (Map)JSON.parseObject((String)cloudLadderRespStr, Map.class);
        return resp;
    }

    private static String getSign(String appId, String type, String nonce, String phone, String code, String secret) {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("appId", appId);
        param.put("type", type);
        param.put("nonce", nonce);
        param.put("phone", phone);
        param.put("code", code);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry map : param.entrySet()) {
            sb.append("&").append((String)map.getKey()).append("=").append((String)map.getValue());
        }
        String temp = sb.substring(1) + "&secret=" + secret;
        param.put("sign", DigestUtils.md5Hex((String)temp.toUpperCase()));
        String sign = DigestUtils.md5Hex((String)temp.toUpperCase());
        return sign;
    }

    private static String getOPSAppID() {
        String opsAppID = System.getProperty("opsAppID");
        if (StringUtils.isEmpty((CharSequence)opsAppID)) {
            opsAppID = OPSAPPID;
        }
        return opsAppID;
    }

    private static String getOPSAppSecret() {
        String opsAppSecret = System.getProperty("opsAppSecret");
        if (StringUtils.isNotEmpty((CharSequence)opsAppSecret)) {
            opsAppSecret = Encrypters.decode((String)opsAppSecret);
        }
        if (StringUtils.isEmpty((CharSequence)opsAppSecret)) {
            opsAppSecret = DefaultParameterService.getDefaultValueByKey((String)"opsapp_param");
        }
        return opsAppSecret;
    }

    private static String getOPSType() {
        String opsType = System.getProperty("opsType");
        if (StringUtils.isEmpty((CharSequence)opsType)) {
            opsType = CLOUD_LADDER_TYPE;
        }
        return opsType;
    }

    public static String getOPSUid() {
        RequestContext requestContext = RequestContext.get();
        String uid = requestContext.getUid();
        if (StringUtils.isEmpty((CharSequence)uid)) {
            uid = UID;
        }
        return uid;
    }

    public static String getOPSPhone() {
        String phone = null;
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        if (StringUtils.isNumeric((CharSequence)userId)) {
            String selectFields = "id, name, phone";
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(userId));
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
            phone = userObj.getString("phone");
        }
        return phone;
    }

    public static String getProdInstCode() {
        Map productInfoMap;
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        String prodInstCode = null;
        if (paramMap != null) {
            prodInstCode = (String)paramMap.get("prodinstcode");
            logger.debug(String.format("BaseAppParameterServiceHelper--getProductInfo:%s", prodInstCode));
        }
        if (StringUtils.isEmpty(prodInstCode) && !CollectionUtils.isEmpty((Map)(productInfoMap = LicenseServiceHelper.getProductInfo()))) {
            prodInstCode = (String)productInfoMap.get("prodInstCode");
            logger.debug(String.format("LicenseServiceHelper--getProductInfo:%s", prodInstCode));
        }
        if (StringUtils.isEmpty((CharSequence)prodInstCode)) {
            prodInstCode = PRODINSTCODE;
        }
        return prodInstCode;
    }

    public static String getOPSUrl() {
        String opsUrl = System.getProperty("opsUrl");
        if (StringUtils.isEmpty((CharSequence)opsUrl)) {
            opsUrl = BASEURL;
        } else if (!opsUrl.endsWith("/")) {
            opsUrl = opsUrl + '/';
        }
        return opsUrl;
    }
}

