/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CollectAppAndMenuUtil
implements Runnable {
    public static final String BOS_SMC_APPUSEDDETAILS = "bos_smc_appuseddetails";
    public static final String SUMTIMES = "sumtimes";
    private Log logger = LogFactory.getLog(CollectAppAndMenuUtil.class);
    private RequestContext requestContext = null;
    private JSONObject operateInfo = null;

    public CollectAppAndMenuUtil(RequestContext requestContext, JSONObject operateInfo) {
        this.requestContext = requestContext;
        this.operateInfo = operateInfo;
    }

    @Override
    public void run() {
        if (this.operateInfo != null) {
            this.manageUserOperate();
        }
    }

    private void manageUserOperate() {
        String type = this.operateInfo.getString("type");
        if (type != null && "app".equals(type)) {
            this.recordAppUsedDetails();
        }
    }

    private void recordAppUsedDetails() {
        String appId = this.operateInfo.getString("id");
        String appName = this.operateInfo.getString("name");
        String selectFields = "id, bizappid, bizappname, sumtimes, lastdate, usefrequency";
        QFilter[] filter = new QFilter[]{new QFilter("bizappid", "=", (Object)appId)};
        Object[] appDetailsObjects = BusinessDataServiceHelper.load((String)BOS_SMC_APPUSEDDETAILS, (String)selectFields, (QFilter[])filter);
        if (appDetailsObjects != null && appDetailsObjects.length != 0) {
            DynamicObject adObject = appDetailsObjects[0];
            int sumTimes = adObject.getInt(SUMTIMES);
            adObject.set("lastdate", (Object)new Date());
            adObject.set(SUMTIMES, (Object)(sumTimes + 1));
            adObject.set("usefrequency", (Object)Float.valueOf(this.getUseFrequency(sumTimes + 1)));
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)BOS_SMC_APPUSEDDETAILS);
            BusinessDataServiceHelper.save((IDataEntityType)met, (Object[])appDetailsObjects);
        } else {
            DynamicObject adObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_SMC_APPUSEDDETAILS);
            adObject.set("bizappid", (Object)appId);
            adObject.set("bizappname", (Object)appName);
            adObject.set(SUMTIMES, (Object)1);
            adObject.set("lastdate", (Object)new Date());
            adObject.set("usefrequency", (Object)Float.valueOf(this.getUseFrequency(1)));
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)BOS_SMC_APPUSEDDETAILS);
            BusinessDataServiceHelper.save((IDataEntityType)met, (Object[])new DynamicObject[]{adObject});
        }
    }

    private float getUseFrequency(int clickCount) {
        float frequency = 0.0f;
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)BOS_SMC_APPUSEDDETAILS, (String)"id, sumtimes", null);
        int allClick = 0;
        int weight = 1;
        if (objects != null && objects.length != 0) {
            for (DynamicObject object : objects) {
                allClick += weight * object.getInt(SUMTIMES);
            }
        }
        frequency = ((float)clickCount + 0.0f) / (float)(allClick += weight * 1);
        return frequency;
    }
}

