/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.DBVersion;
import kd.bos.entity.tree.TreeMenuNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.sdk.annotation.SdkInternal;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DevportalUtil {
    public static final String KDPKGS_XML = "kdpkgs.xml";
    public static final String ERROR_INFO_TXT = "errorInfo.txt";
    public static final String APP_INFO_XML = "appInfo.xml";
    public static final String RESOURCE = "resource";
    public static final String CUSTOM = "custom";
    public static final String UPLOADSOURCE = "uploadsource";
    public static final String JSON = ".json";
    private static Log logger = LogFactory.getLog(DevportalUtil.class);
    public static final String ERROR = "ERROR";
    private static final String SPACE = "   ";

    public static JSONArray readXML(String xmlFileName) {
        SAXReader reader = new SAXReader();
        URL xmlUrl = DevportalUtil.class.getResource(xmlFileName);
        JSONArray jsonArray = new JSONArray();
        try {
            Document doc = reader.read(xmlUrl);
            Element rootElement = doc.getRootElement();
            jsonArray = DevportalUtil.getChildElements(rootElement);
        }
        catch (DocumentException arg) {
            throw new OrmException("Deserialize.DocumentException", arg.getMessage());
        }
        return jsonArray;
    }

    private static JSONArray getChildElements(Element parentElement) {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < parentElement.nodeCount(); ++i) {
            JSONObject map = new JSONObject();
            if (!(parentElement.getXPathResult(i) instanceof Element)) continue;
            Element element = (Element)parentElement.getXPathResult(i);
            for (int j = 0; j < element.nodeCount(); ++j) {
                if (!(element.getXPathResult(j) instanceof Element)) continue;
                Element childElement = (Element)element.getXPathResult(j);
                if (childElement.nodeCount() > 1) {
                    JSONArray childElements = DevportalUtil.getChildElements(childElement);
                    map.put(childElement.getName(), (Object)childElements);
                    continue;
                }
                map.put(childElement.getName(), (Object)childElement.getStringValue());
            }
            jsonArray.add((Object)map);
        }
        return jsonArray;
    }

    public static boolean checkAppPermission(String appId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Boolean isHasPermission = false;
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        String bizAppId = null;
        boolean isAllUserApp = false;
        if (app != null) {
            isAllUserApp = app.isAllUserApp();
            bizAppId = app.getId();
        }
        isHasPermission = isAllUserApp ? Boolean.valueOf(true) : PermissionServiceHelper.checkUserBizApp((Long)userId, (String)bizAppId);
        return isHasPermission;
    }

    @SdkInternal
    public static TreeMenuNode buildNode(TreeMenuNode pnode, List<TreeMenuNode> childNode) {
        HashMap<String, TreeMenuNode> leafNodeMap = new HashMap<String, TreeMenuNode>();
        DevportalUtil.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeMenuNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            if (!leafNodeMap.containsKey(parentID)) continue;
            TreeMenuNode parNode = (TreeMenuNode)leafNodeMap.get(parentID);
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        return pnode;
    }

    public static void getLeafNodes(Map<String, TreeMenuNode> map, TreeMenuNode node) {
        if (node.getChildren() != null) {
            for (TreeMenuNode childNode : node.getChildren()) {
                DevportalUtil.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
            return;
        }
    }

    public static List<String> recursiveFiles(String path, List<String> fileList) {
        String checkPath = DevportalUtil.checkFilePath(path);
        File file = new File(checkPath);
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        for (File f : files) {
            if (f.isDirectory()) {
                DevportalUtil.recursiveFiles(f.getAbsolutePath(), fileList);
                continue;
            }
            if (!f.isFile()) continue;
            fileList.add(f.getAbsolutePath());
        }
        return fileList;
    }

    public static void zipFiles(List<String> zipNames, String zipPath, String defaultAppPackageName) {
        String staticResourcePath;
        File staticResourceFile;
        String customResourcePath;
        File customResourceFile;
        String appInfo;
        File appInfoFile;
        String errorLog;
        File errorLogFile;
        JSONArray files = new JSONArray();
        String packageXML = zipPath + File.separator + KDPKGS_XML;
        File packageXMLFile = new File(SecurityUtils.normalize((String)packageXML));
        if (packageXMLFile.exists()) {
            files.add((Object)packageXML);
        }
        if ((errorLogFile = new File(SecurityUtils.normalize((String)(errorLog = zipPath + File.separator + ERROR_INFO_TXT)))).exists()) {
            files.add((Object)errorLog);
        }
        if ((appInfoFile = new File(SecurityUtils.normalize((String)(appInfo = zipPath + File.separator + APP_INFO_XML)))).exists()) {
            files.add((Object)appInfo);
        }
        for (String zipName : zipNames) {
            String zipAppPath = zipPath + File.separator + "dm" + File.separator + zipName + ".zip";
            File zipAppFile = new File(SecurityUtils.normalize((String)zipAppPath));
            if (!zipAppFile.exists()) continue;
            files.add((Object)zipAppPath);
        }
        String libPath = zipPath + File.separator + "jar";
        File libFile = new File(SecurityUtils.normalize((String)libPath));
        if (libFile.exists()) {
            files.add((Object)libPath);
        }
        if ((customResourceFile = new File(SecurityUtils.normalize((String)(customResourcePath = zipPath + File.separator + RESOURCE + File.separator + CUSTOM)))).exists()) {
            files.add((Object)customResourcePath);
        }
        if ((staticResourceFile = new File(SecurityUtils.normalize((String)(staticResourcePath = zipPath + File.separator + RESOURCE + File.separator + UPLOADSOURCE)))).exists()) {
            files.add((Object)staticResourcePath);
        }
        File zipFile = new File(SecurityUtils.normalize((String)(zipPath + File.separator + defaultAppPackageName + ".zip")));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            DevportalUtil.zipPatchFile(files, out, zipNames);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void zipFiles(String zipName, String localPath, List<File> fileList) {
        JSONArray files = new JSONArray();
        String MetadataPath = localPath + File.separator + "metadata";
        String checkMetadataPath = DevportalUtil.checkFilePath(MetadataPath);
        File MetadataFile = new File(checkMetadataPath);
        if (MetadataFile.exists()) {
            files.add((Object)MetadataPath);
        }
        if (fileList != null && fileList.size() > 0) {
            for (File file : fileList) {
                files.add((Object)file.getAbsolutePath());
            }
        }
        String checkLocalPathZip = DevportalUtil.checkFilePath(localPath + File.separator + zipName + ".zip");
        File zipFile = new File(checkLocalPathZip);
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            DevportalUtil.zipFile(files, out, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void zipFile(JSONArray files, ZipOutputStream out, String pathSign) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File(DevportalUtil.checkFilePath((String)files.get(i)));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    tempFiles.add((Object)tempFile.getAbsolutePath());
                }
                DevportalUtil.zipFile(tempFiles, out, pathSign);
                continue;
            }
            String path = file.getAbsolutePath();
            String fileName = file.getName();
            int t = -1;
            if (path.contains("datamodel")) {
                t = path.indexOf("datamodel");
            }
            if (path.contains("jar") && path.endsWith(".zip") && !fileName.contains("jar")) {
                t = path.indexOf("jar");
            }
            if (StringUtils.isNotBlank((CharSequence)pathSign)) {
                if (path.contains(pathSign) && !path.contains(JSON)) {
                    t = path.indexOf("webapp");
                } else if (path.contains(JSON)) {
                    t = path.indexOf(pathSign);
                }
            } else if ((path.contains(CUSTOM) || path.contains(UPLOADSOURCE)) && path.endsWith(".zip") && !fileName.contains(CUSTOM) && !fileName.contains(UPLOADSOURCE)) {
                t = path.indexOf(RESOURCE);
            }
            if (t == -1) continue;
            if ((path = path.endsWith(JSON) ? path.substring(t + pathSign.length() + 1, path.length()) : path.substring(t, path.length())).contains("\\")) {
                path = path.replace("\\", "/");
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private static void zipPatchFile(JSONArray files, ZipOutputStream out, List<String> zipNames) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File(DevportalUtil.checkFilePath((String)files.get(i)));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    tempFiles.add((Object)tempFile.getAbsolutePath());
                }
                DevportalUtil.zipFile(tempFiles, out, "");
                continue;
            }
            String path = file.getAbsolutePath();
            int t = -1;
            if (path.contains(KDPKGS_XML)) {
                t = path.indexOf(KDPKGS_XML);
            }
            if (path.contains(ERROR_INFO_TXT)) {
                t = path.indexOf(ERROR_INFO_TXT);
            }
            if (path.contains(APP_INFO_XML)) {
                t = path.indexOf(APP_INFO_XML);
            }
            if (path.endsWith(".zip")) {
                for (String zipName : zipNames) {
                    if (!path.endsWith(zipName + ".zip")) continue;
                    t = path.indexOf(zipName + ".zip");
                }
            }
            if (t == -1) continue;
            path = path.endsWith(".zip") ? path.substring(t - 3, path.length()) : path.substring(t, path.length());
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    public static String getAppVerion(String appNum) {
        String version = DBVersion.getVer();
        if (StringUtils.isNotBlank((CharSequence)appNum)) {
            String appVer;
            QFilter filter = new QFilter("number", "=", (Object)appNum);
            if (QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{filter})) {
                version = "";
            }
            if (StringUtils.isNotBlank((CharSequence)(appVer = DBVersion.getAppVer((String)appNum)))) {
                version = appVer;
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createJsonFile(String jsonString, String filePath, String fileName) {
        boolean flag = true;
        String fullPath = filePath + File.separator + fileName + JSON;
        OutputStreamWriter write = null;
        try {
            boolean createNewFileFlag;
            boolean deleteFlag;
            File file = new File(DevportalUtil.checkFilePath(fullPath));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists() && (deleteFlag = file.delete())) {
                DisCardUtil.discard();
            }
            if (createNewFileFlag = file.createNewFile()) {
                DisCardUtil.discard();
            }
            jsonString = DevportalUtil.formatJson(jsonString);
            write = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            write.write(jsonString);
            write.flush();
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            if (write != null) {
                DisCardUtil.discard();
                try {
                    write.close();
                }
                catch (Exception ex) {
                    DisCardUtil.discard();
                }
            }
        }
        return flag;
    }

    public static String formatJson(String json) {
        StringBuilder result = new StringBuilder();
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if (key == '[' || key == '{') {
                if (i - 1 > 0 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(DevportalUtil.indent(number));
                }
                result.append(key);
                result.append('\n');
                result.append(DevportalUtil.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append('\n');
                result.append(DevportalUtil.indent(--number));
                result.append(key);
                if (i + 1 >= length || json.charAt(i + 1) == ',') continue;
                result.append('\n');
                continue;
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            result.append(SPACE);
        }
        return result.toString();
    }

    public static void insertDevVersion(List<String> sqlList) {
        ArrayList list = new ArrayList();
        sqlList.forEach(sql -> list.add(new SqlObject(sql, null)));
        if (list.size() > 0) {
            for (SqlObject sqlObject : list) {
                DevportalUtil.executeSQL(sqlObject);
            }
        }
    }

    private static void executeSQL(SqlObject sqlObject) {
        DB.execute((DBRoute)DBRoute.basedata, (String)sqlObject.getSql(), null);
    }

    public static String selectSourceVersion(String sql, SqlParameter[] params, final String defaultVal) {
        return (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return defaultVal;
            }
        });
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }
}

