/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentParseUtil {
    public static Document parse(InputStream is) throws Exception {
        SAXReader reader = DocumentParseUtil.getInstance();
        reader.setEncoding("utf-8");
        return reader.read(is);
    }

    public static Document parseUrl(URL url) throws Exception {
        SAXReader reader = DocumentParseUtil.getInstance();
        reader.setEncoding("utf-8");
        return reader.read(url);
    }

    public static Document parseText(String text) throws Exception {
        SAXReader reader = DocumentParseUtil.getInstance();
        String encoding = DocumentParseUtil.getEncoding(text);
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(encoding);
        Document result = reader.read(source);
        if (result.getXMLEncoding() == null) {
            result.setXMLEncoding(encoding);
        }
        return result;
    }

    private static SAXReader getInstance() throws SAXException {
        SAXReader reader = SAXReader.createDefault();
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return reader;
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }
}

