/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import kd.sdk.annotation.SdkInternal;

public class ImageUtil {
    private static List<String> staticImage = new ArrayList<String>();

    @SdkInternal
    public static String removeVersion(String imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        String newUrl = imageUrl;
        if (imageUrl.indexOf("?v=") > 0) {
            newUrl = imageUrl.substring(0, imageUrl.indexOf("?v="));
        }
        if (imageUrl.indexOf("&v=") > 0) {
            newUrl = imageUrl.substring(0, imageUrl.indexOf("&v="));
        }
        return newUrl;
    }

    @SdkInternal
    public static String getFullImageUrl(String avatarPath) {
        if (!avatarPath.toLowerCase(Locale.ENGLISH).startsWith("http") && !staticImage.contains(avatarPath)) {
            avatarPath = UrlService.getCheckAuthImageUrl((String)avatarPath);
        }
        return avatarPath;
    }

    public static String getStaticResourceFullImageUrl(String avatarPath) {
        if (staticImage.contains(avatarPath)) {
            String domainUrl = UrlService.getDomainContextUrl();
            avatarPath = RevProxyUtil.removeSlash((String)domainUrl) + avatarPath;
        }
        return avatarPath;
    }

    @SdkInternal
    public static String getCurrentUserAvatarPath(boolean isGetFullPath) {
        long userId = RequestContext.get().getCurrUserId();
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)isGetFullPath);
        if (!CollectionUtils.isEmpty((Map)userAvatarPathMap)) {
            String imgURL = (String)userAvatarPathMap.get(userId);
            return StringUtils.isBlank((CharSequence)imgURL) ? "/images/pc/emotion/default_person_82_82.png" : imgURL;
        }
        return "/images/pc/emotion/default_person_82_82.png";
    }

    static {
        staticImage.add("/images/pc/emotion/default_person_82_82.png");
        staticImage.add("/icons/pc/other/superAdministrators_38_38.png");
        staticImage.add("/private/universe_ad.png");
        staticImage.add("/private/super_ad.png");
        staticImage.add("/private/audit_ad.png");
        staticImage.add("/private/safe_ad.png");
    }
}

