/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.HashMap;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.portal.model.BasLoginConfigParam;
import kd.bos.portal.service.IBasLoginConfigService;
import kd.bos.portal.util.LoginMCServiceUtil;
import kd.bos.portal.util.PortalLogUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class LoginConfigUtils {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";

    public static String getLoginConfigValue(IBasLoginConfigService basLoginConfigService, String mcKey) {
        String configData = null;
        if (LoginConfigUtils.isEnableLoginConfig()) {
            BasLoginConfigParam basLoginConfigParam = new BasLoginConfigParam();
            basLoginConfigParam.setLocaleid("zh_CN");
            basLoginConfigParam.setKey(mcKey);
            basLoginConfigParam.setIsSynCommon("0");
            BasLoginConfigParam configParam = basLoginConfigService.get(basLoginConfigParam);
            if (configParam != null && configParam.getId() != null) {
                configData = configParam.getValue();
            }
        }
        if (StringUtils.isEmpty(configData)) {
            configData = LoginMCServiceUtil.getMcData(mcKey);
        }
        return configData;
    }

    @SdkInternal
    public static boolean isEnableLoginConfig() {
        boolean isEnableLoginConfig = false;
        if ("true".equals(SystemPropertyUtils.getProptyByTenant((String)"enable_dataCenter_loginPage", (String)RequestContext.get().getTenantId()))) {
            isEnableLoginConfig = true;
        }
        return isEnableLoginConfig;
    }

    public static LocalMemoryCache getCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(21600);
        info.setMaxItemSize(5000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("bos_portal_localcache", "custLoginConfig", info);
    }

    public static void loginOut(IFormView view) {
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>(0);
        mpURL.put("url", "auth/logout.do");
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
        PortalLogUtils.addLog("bos_user", "83bfebc8000037ac", "logout", new MultiLangEnumBridge("\u9000\u51fa", "PrivacyStatementOperationPlugin_2", BOS_PORTAL_PLUGIN), new MultiLangEnumBridge("\u9000\u51fa\u6210\u529f", "PrivacyStatementOperationPlugin_3", BOS_PORTAL_PLUGIN), new String[0]);
    }
}

