/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.Map;
import java.util.Objects;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.IMainPageFacadeService;
import kd.bos.login.utils.FrameCommonUtls;
import kd.bos.login.utils.ModeTypeUtils;
import kd.bos.portal.service.impl.BasLoginConfigServiceImpl;
import kd.bos.portal.util.LoginConfigUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.util.StringUtils;

public class LogoUtils {
    private static Log logger = LogFactory.getLog(LogoUtils.class);
    private static final String URL_CACHE_KEY = "_custom_logo_url_";

    public static String getDefaultLogo() {
        Lang lang = RequestContext.get().getLang();
        boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
        if (oemEnv) {
            String logoImage = !Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? "/images/pc/other/logo_cc_en_378_72.png" : "/images/pc/other/logo_cc_cn_246_72.png";
            return logoImage;
        }
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        String logoImage = modelType == 1 ? "/images/pc/other/logo_single_357_64.png" : (modelType == 2 || modelType == 4 ? (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? "/images/pc/other/logo_qjb_en_398_64.png" : "/images/pc/other/logo_qjb_cn_310_64.png") : (ModeTypeUtils.isEducation() ? "/images/pc/other/logo_1280_288.png" : (!Lang.zh_CN.equals((Object)lang) && !Lang.zh_TW.equals((Object)lang) ? "/images/pc/other/logo_ccs_abbr_278_72.png" : "/images/pc/other/logo_ccs_cn_242_72.png")));
        return logoImage;
    }

    public static String getCustomLogo() {
        String url = null;
        IMainPageFacadeService service = FrameCommonUtls.getFacadeService((String)RequestContext.get().getTenantId());
        if (service != null) {
            url = service.getLogoUrl();
        }
        return url;
    }

    public static String getLoginConfigLogo() {
        String urlFromLocalCache;
        String cacheKey = URL_CACHE_KEY + RequestContext.get().getTenantId();
        if (LoginConfigUtils.isEnableLoginConfig()) {
            cacheKey = URL_CACHE_KEY + RequestContext.get().getAccountId();
        }
        if (null != (urlFromLocalCache = StringUtils.getStringValue((Object)LoginConfigUtils.getCache().get(cacheKey)))) {
            logger.debug("get from local cache data:" + urlFromLocalCache);
            return urlFromLocalCache;
        }
        String url = null;
        try {
            BasLoginConfigServiceImpl basLoginConfigService = new BasLoginConfigServiceImpl();
            String urlFromMC = LoginConfigUtils.getLoginConfigValue(basLoginConfigService, "_tenant_login_config_values_");
            logger.debug("get from mc data:" + urlFromMC);
            if (StringUtils.isNotEmpty((String)urlFromMC)) {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)urlFromMC, Map.class);
                if (Objects.isNull(dataMap)) {
                    return null;
                }
                url = (String)dataMap.get("lefttoplogoimg");
            }
            LogoUtils.updateCacheValue(cacheKey, url);
        }
        catch (Exception e) {
            logger.info("getLoginConfigLogo error", (Object)e);
        }
        return url;
    }

    private static void updateCacheValue(String key, String url) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        LocalMemoryCache cache = LoginConfigUtils.getCache();
        if (Objects.isNull(cache)) {
            return;
        }
        cache.remove(new String[]{key});
        cache.put(key, (Object)(url == null ? "" : url));
    }
}

