/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.pushservice.WebSocketIdReader;

public class MessagePushUtils {
    public static final String USER_ID = "userId";
    public static final String MESSAGE = "message";
    public static final String SESSION_ID = "sessionId";
    public static final String SHOW_FORM = "showForm";

    public static void sendMessage(String message, String formId) {
        List userIds = MsgSessionUtil.getOnLineUserIds();
        String accountId = RequestContext.get().getAccountId();
        for (Long id : userIds) {
            String[] sessionIds = WebSocketIdReader.getWSSessionIdByUser((String)accountId, (String)id.toString());
            if (sessionIds == null || sessionIds.length <= 0) continue;
            String sessionId = sessionIds[0];
            FormShowParameter fsp2 = new FormShowParameter();
            fsp2.setFormId(formId);
            fsp2.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(MESSAGE, message);
            fsp2.setCustomParams(map);
            fsp2.setSessionId(sessionId);
            fsp2.setShowTitle(false);
            Map config = FormConfigFactory.createConfig((FormShowParameter)fsp2);
            config.put(SESSION_ID, sessionId);
            String msg = MessagePushUtils.buildWebSocketAction(SHOW_FORM, config);
            PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)msg);
            PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
        }
    }

    public static void sendMessage(String message, String formId, String tittle) {
        List userIds = MsgSessionUtil.getOnLineUserIds();
        String accountId = RequestContext.get().getAccountId();
        for (Long id : userIds) {
            String[] sessionIds = WebSocketIdReader.getWSSessionIdByUser((String)accountId, (String)id.toString());
            if (sessionIds == null || sessionIds.length <= 0) continue;
            String sessionId = sessionIds[0];
            FormShowParameter fsp2 = new FormShowParameter();
            fsp2.setFormId(formId);
            fsp2.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(MESSAGE, message);
            map.put("title", tittle);
            fsp2.setCustomParams(map);
            fsp2.setSessionId(sessionId);
            fsp2.setShowTitle(false);
            Map config = FormConfigFactory.createConfig((FormShowParameter)fsp2);
            config.put(SESSION_ID, sessionId);
            String msg = MessagePushUtils.buildWebSocketAction(SHOW_FORM, config);
            PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)msg);
            PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
        }
    }

    public static void sendMessageOne(String message, String formId) {
        FormShowParameter fsp2 = new FormShowParameter();
        fsp2.setFormId(formId);
        fsp2.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MESSAGE, message);
        fsp2.setCustomParams(map);
        String accountId = RequestContext.get().getAccountId();
        String userId = RequestContext.get().getUserId();
        String[] sessionIds = WebSocketIdReader.getWSSessionIdByUser((String)accountId, (String)userId);
        if (sessionIds != null && sessionIds.length > 0) {
            String sessionId = sessionIds[0];
            fsp2.setSessionId(sessionId);
            Map config = FormConfigFactory.createConfig((FormShowParameter)fsp2);
            config.put(SESSION_ID, sessionId);
            String msg = MessagePushUtils.buildWebSocketAction(SHOW_FORM, config);
            PushMessage pushMessage = new PushMessage(PushMessageRange.Session, sessionId, (Object)msg);
            PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
        }
    }

    private static String buildWebSocketAction(String actionName, Object param) {
        ArrayList acts = new ArrayList();
        HashMap<String, Object> action = new HashMap<String, Object>();
        action.put("a", actionName);
        ArrayList<Object> paras = new ArrayList<Object>();
        action.put("p", paras);
        if (param instanceof List) {
            List p = (List)param;
            for (int i = 0; i < p.size(); ++i) {
                paras.add(p.get(i));
            }
        } else {
            paras.add(param);
        }
        acts.add(action);
        return SerializationUtils.toJsonString(acts);
    }
}

