/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.PortalMenuService;
import kd.bos.portal.service.factory.PortalMenuServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang.StringUtils;

public class MyCurrentAppUtil {
    private static PortalMenuService menuService = PortalMenuServiceFactory.createPortalMenuService();
    private static final Log logger = LogFactory.getLog(MyCurrentAppUtil.class);

    public static List<String> getMyCurrentAppCache() {
        DynamicObject dynamicObject = MyCurrentAppUtil.loadCurrentApp(RequestContext.get().getCurrUserId());
        if (dynamicObject == null) {
            return null;
        }
        String currentApp = dynamicObject.getString("currentapp");
        if (StringUtils.isEmpty((String)currentApp)) {
            return null;
        }
        List<String> currentAppList = Stream.of(currentApp.split(";")).collect(Collectors.toList());
        return currentAppList;
    }

    @SdkInternal
    public static void putMyCurrentAppCache(String appId) {
        menuService.addCurrentUseApp(appId);
    }

    public static void putMyCurrentUseAppMenu(String appId, String menuId) {
        menuService.addCurrentUseAppMenu(appId, menuId);
    }

    private static DynamicObject loadCurrentApp(long userID) {
        QFilter userFilter = new QFilter("user", "=", (Object)userID);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObject currentApp = BusinessDataServiceHelper.loadSingle((String)"bos_portal_current_app", (String)"currentapp", (QFilter[])filters);
        return currentApp;
    }
}

