/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.HashMap;
import kd.bos.base.parameter.ParameterService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.NewPortalService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;

public class NewPortalUtils {
    private static final Log logger = LogFactory.getLog(NewPortalUtils.class);

    public static void refreshPortal(IFormView formView, boolean isSupportNewPortal) {
        NewPortalUtils.saveCommonSetting("usenewportal", isSupportNewPortal);
        IClientViewProxy proxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>(2);
        RequestContext context = RequestContext.get();
        String url = context.getClientFullContextPath();
        url = isSupportNewPortal ? url + "?formId=home_page" : url + "?formId=pc_main_console";
        mpURL.put("url", url);
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    private static void removeCache() {
        RequestContext rc = RequestContext.get();
        Long userId = rc.getCurrUserId();
        ParameterService.removeNewPortalSetting((String)rc.getAccountId(), (String)"newportal", (String)(userId + ""));
        NewPortalService.removeNewPortalSetting((String)rc.getAccountId(), (String)"newportalconfig", (String)(userId + ""));
        MessageCenterServiceHelper.clearMsgPersonalTopIdsCache((Long)userId);
    }

    public static void saveCommonSetting(String propertyName, Object value) {
        RequestContext rc = RequestContext.get();
        Long userId = rc.getCurrUserId();
        String entityId = "bos_user_params_config";
        QFilter filter = new QFilter("userid", "=", (Object)userId);
        DynamicObject userConfig = BusinessDataServiceHelper.loadSingle((String)entityId, (String)propertyName, (QFilter[])new QFilter[]{filter});
        if (userConfig == null) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
            userConfig = new DynamicObject((DynamicObjectType)dt);
            userConfig.set("userid", (Object)userId);
            userConfig.set(propertyName, value);
        } else {
            userConfig.set(propertyName, value);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userConfig});
            if ("usenewportal".equals(propertyName)) {
                NewPortalUtils.removeCache();
            }
        }
        catch (Exception e) {
            logger.info("NewPortalUtils--saveUserConfig--error", (Object)e);
        }
    }
}

