/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.AICommandParameter;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.bean.LicenseGrayNotice;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.NewPortalService;
import kd.bos.login.utils.BeanUtils;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.req.CheckPermissionReq;
import kd.bos.permission.model.perm.req.user.CheckUserBizAppReq;
import kd.bos.portal.model.BrandUpEnum;
import kd.bos.portal.plugin.trace.MenuTraceService;
import kd.bos.portal.plugin.yzj.enums.YzjAppEnum;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.service.factory.MenuModeFactory;
import kd.bos.portal.util.CollectAppAndMenuUtil;
import kd.bos.portal.util.MyCurrentAppUtil;
import kd.bos.portal.util.PortalMessageUtils;
import kd.bos.portal.util.PortalUsableFuncUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseGrayServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class OpenPageUtils {
    public static final String TABAP = "tabap";
    public static final String FILTER_SCHEME_ID = "filterSchemeId";
    public static final String HOMEPAGE_TABAP_COUNT = "homepage_tabap_count";
    public static final String APPNAME = "appname";
    public static final String APPMAINNUMBER = "appmainnumber";
    public static final String APPIMAGEURL = "appImageUrl";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String FORMNUMBER = "formnumber";
    public static final String PARAMETER = "parameter";
    public static final String WFTASK = "wftask";
    public static final String PARAMETERTYPE = "parametertype";
    public static final String APPID = "appid";
    public static final String YYY_MM_DD_HH_MM_SS = "yyy-MM-dd hh:mm:ss";
    public static final String TIME = "---time:";
    public static final String MESSAGE_ID = "messageId";
    public static final String TAB_TYPE = "tabType";
    public static final String OPEN_PAGE = "openPage";
    public static final String BILL_FORM_ID = "billFormId";
    private static final String SPLIT_STR = "@";
    private static Log logger = LogFactory.getLog(OpenPageUtils.class);
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"trace_user_menu", (int)0, (int)3);
    private static final String CUSTOMPARAMETERS = "customparameters";
    private static final String ENTITY_ADMINSCHEME = "perm_adminscheme";
    private static final String PROP_ISALLOWBIZOPERATE = "isallowbizoperate";

    private static String getFormMsg() {
        return ResManager.loadKDString((String)"\u83dc\u5355ID\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u68c0\u67e5\u5e94\u7528\u83dc\u5355\u914d\u7f6e\u3002", (String)"OpenPageUtils_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    private static IFormView getMainPageView(IFormView myappView) {
        String rootPageId;
        IFormView mainPageView = myappView.getMainView();
        if (mainPageView == null && (mainPageView = myappView.getView(rootPageId = myappView.getFormShowParameter().getRootPageId())) == null) {
            throw new KDException(new ErrorCode("mainView is null", "mainView is null"), new Object[0]);
        }
        return mainPageView;
    }

    public static boolean isAllowAdminBizOperate() {
        boolean result = false;
        DynamicObject enableScheme = BusinessDataServiceHelper.loadSingle((String)ENTITY_ADMINSCHEME, (String)PROP_ISALLOWBIZOPERATE, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        if (enableScheme != null) {
            result = enableScheme.getBoolean(PROP_ISALLOWBIZOPERATE);
        }
        return result;
    }

    public static void openApp(String appId, String menuId, Map<String, Object> map, IFormView myappView) {
        boolean isRediret = OpenPageUtils.rediretAppOrPage(appId, menuId, map, myappView);
        if (isRediret) {
            return;
        }
        try {
            OpenPageUtils.openApp(appId, menuId, map, myappView, "");
        }
        catch (Exception e) {
            String message = e.getMessage();
            if ("LicenseGrayNotice EXPIRED".equals(message)) {
                logger.debug(message);
            }
            throw e;
        }
    }

    private static boolean rediretAppOrPage(String appId, String menuId, Map<String, Object> map, IFormView myappView) {
        JSONObject paramRediret;
        JSONObject params;
        AppMenuInfo menu = null;
        try {
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)menuId)) {
                menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
            }
        }
        catch (Exception e) {
            logger.info("checkAppMenuPermission", (Object)e);
        }
        if (menu != null && (params = JSONArray.parseObject((String)menu.getParams())) != null && params.size() > 0 && (paramRediret = params.getJSONObject("kdRedirect")) != null) {
            String rediretAppId = paramRediret.getString("appId");
            String rediretMenuId = paramRediret.getString("menuId");
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)rediretAppId)) {
                AppInfo app = AppMetadataCache.getAppInfo((String)rediretAppId);
                if (app == null) {
                    OpenPageUtils.getMainPageView(myappView).showMessage(ResManager.loadKDString((String)"\u914d\u7f6e\u4e86\u8df3\u8f6c\u5e94\u7528\uff0c\u4f46\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"OpenPageUtils_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return true;
                }
                map.put(APPNAME, app.getName().getLocaleValue());
                map.put(APPMAINNUMBER, app.getHomeNum());
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)rediretMenuId)) {
                    OpenPageUtils.openApp(rediretAppId, rediretMenuId, map, myappView, "");
                    return true;
                }
                OpenPageUtils.openApp(rediretAppId, null, null, myappView, app.getName().getLocaleValue());
                return true;
            }
        }
        return false;
    }

    public static void openAppAndPage(String appId, String pageId, Map<String, Object> map, IFormView myappView) {
        map.put("newWindosPageId", pageId);
        OpenPageUtils.openApp(appId, null, map, myappView, "");
    }

    public static void openApp(String appNumber, String menuId, Map<String, Object> map, IFormView myappView, String selfAppName) {
        if (MenuModeFactory.getBaseParam("tile_menu_mode_enable") != null) {
            MenuModeFactory.createMenuModeService(myappView).openApp(appNumber, menuId, map, myappView, selfAppName);
            return;
        }
        try {
            Object isFixedApp;
            AppMenuInfo menu;
            String appName;
            AppInfo app = AppMetadataCache.getAppInfo((String)appNumber);
            if (app == null || myappView == null) {
                return;
            }
            String showMessage = (String)myappView.getFormShowParameter().getCustomParam("showMessage");
            String appMainNumber = app.getHomeNum();
            IFormView mainPageView = OpenPageUtils.getMainPageView(myappView);
            String mainPageId = mainPageView.getPageId();
            if (!"false".equals(showMessage)) {
                PortalMessageUtils.showActivityMessageAsync(mainPageId, appNumber);
            }
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)selfAppName)) {
                selfAppName = OpenPageUtils.getAppSelfName(myappView, appNumber);
            }
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)(appName = kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)selfAppName) ? selfAppName : app.getName().getLocaleValue()))) {
                appName = app.getNumber();
            }
            if (map == null) {
                map = new HashMap<String, Object>();
                map.put("view", myappView);
                map.put(APPMAINNUMBER, appMainNumber);
            }
            map.put(APPNAME, appName);
            map.put(APPIMAGEURL, app.getImage());
            PermResult permResult = OpenPageUtils.checkAppMenuPermission(appNumber, appName, menuId, map, isSuperAdmin);
            if (!permResult.isOk()) {
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)menuId)) {
                    if (map.containsKey("openUserFixedApp")) {
                        DeleteServiceHelper.delete((String)"bos_portal_userfixedapp", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("bizapp", "=", (Object)appNumber)});
                    } else {
                        myappView.showMessage(permResult.getMsg());
                    }
                } else {
                    myappView.showMessage(permResult.getMsg());
                }
                return;
            }
            Object para = map.get(PARAMETER);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)para)) {
                Map parameter = (Map)SerializationUtils.fromJsonString((String)para.toString(), Map.class);
                String filterSchemeId = null;
                if (parameter != null) {
                    filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
                }
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty(filterSchemeId)) {
                    if (!CardUtils.isHaveSchemeRecord(filterSchemeId)) {
                        myappView.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"OpenPageUtils_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                    if (!OpenPageUtils.isHaveSchemeAuth(filterSchemeId, userId)) {
                        myappView.showMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u65b9\u6848\u6743\u9650\u3002", (String)"OpenPageUtils_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                        return;
                    }
                }
            }
            String menuType = "page";
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)menuId) && (menu = AppMetadataCache.getAppMenuInfo((String)appNumber, (String)menuId)) != null) {
                menuType = menu.getMenuType();
            }
            boolean isAppHome = false;
            String formNumber = (String)map.get(FORMNUMBER);
            if ("page".equals(menuType)) {
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)formNumber)) {
                    formNumber = appMainNumber;
                    isAppHome = true;
                } else if (formNumber.equals(appMainNumber)) {
                    isAppHome = true;
                }
            }
            if (!"true".equals(isFixedApp = map.get("openUserFixedApp"))) {
                try {
                    boolean result = OpenPageUtils.checkLicenseGray(myappView, app.getHomeNum(), app.getNumber(), app.getCloudNum());
                    if (!result) {
                        mainPageView.getPageCache().put("Portal_LicenseGrayNotice_" + app.getAppId(), "true");
                    }
                }
                catch (Exception e) {
                    logger.info("checkLicenseGray error", (Object)e);
                    return;
                }
            }
            if ("1".equals(app.getOpenType())) {
                if ("devportal".equals(appNumber) || "devnew".equals(appNumber)) {
                    myappView.openUrl("?formId=" + formNumber);
                } else {
                    FormShowParameter fsp = new FormShowParameter();
                    fsp.setFormId(formNumber);
                    fsp.setAppId(appNumber);
                    fsp.getOpenStyle().setShowType(ShowType.NewWindow);
                    myappView.showForm(fsp);
                }
            } else if ("2".equals(app.getOpenType())) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(formNumber);
                fsp.setAppId(appNumber);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                myappView.showForm(fsp);
            } else {
                Tab tab = (Tab)mainPageView.getControl(TABAP);
                for (Control ctrl : tab.getItems()) {
                    if (!ctrl.getKey().equals(appNumber)) continue;
                    tab.activeTab(appNumber);
                    myappView.sendFormAction(mainPageView);
                    return;
                }
                String appPageId = appNumber + mainPageId;
                IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
                if (appPageView != null) {
                    OpenPageUtils.activatePage(appPageId, myappView, map);
                    if (menuId != null && !isAppHome) {
                        String menuPageId;
                        String markId = menuId;
                        Object parameterStr = map.get(PARAMETER);
                        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)parameterStr)) {
                            Map parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
                            String filterSchemeId = null;
                            if (parameter != null) {
                                filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
                            }
                            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty(filterSchemeId)) {
                                markId = menuId + SPLIT_STR + filterSchemeId;
                            }
                        }
                        if (mainPageView.getViewNoPlugin(menuPageId = markId + mainPageId) != null) {
                            OpenPageUtils.activatePage(menuPageId, myappView, map);
                        } else {
                            OpenPageUtils.openMenuPage(appNumber, menuId, map);
                        }
                    }
                } else {
                    int count;
                    IPageCache homepagePageCache = (IPageCache)mainPageView.getService(IPageCache.class);
                    String homepage_tabap_count = homepagePageCache.get(HOMEPAGE_TABAP_COUNT);
                    int n = count = homepage_tabap_count == null ? 3 : Integer.parseInt(homepage_tabap_count);
                    if (count >= 13) {
                        mainPageView.showMessage(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u540c\u65f6\u6253\u5f0010\u4e2a\u5e94\u7528\u3002", (String)"OpenPageUtils_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                        myappView.sendFormAction(mainPageView);
                        return;
                    }
                    OpenPageUtils.openAppPage(appNumber, map);
                    Object newWindowPageId = map.get("newWindosPageId");
                    if (newWindowPageId != null) {
                        IFormView formView;
                        appPageView = mainPageView.getViewNoPlugin(appPageId);
                        if (appPageView != null && (formView = SessionManager.getCurrent().getView(newWindowPageId.toString())) != null) {
                            FormShowParameter formShowParameter = formView.getFormShowParameter();
                            formShowParameter.setRootPageId(mainPageId);
                            formShowParameter.setParentPageId(appPageId);
                            formShowParameter.setPageId(formShowParameter.getPageId() + kd.bos.util.StringUtils.randomNumber((int)16));
                            appPageView.showForm(formShowParameter);
                            myappView.sendFormAction(appPageView);
                        }
                    } else if (menuId != null && !isAppHome) {
                        OpenPageUtils.openMenuPage(appNumber, menuId, map);
                    }
                    if ((appPageView = mainPageView.getViewNoPlugin(appPageId)) != null) {
                        homepagePageCache.put(HOMEPAGE_TABAP_COUNT, ++count + "");
                    }
                }
            }
            mainPageView.getPageCache().remove("Portal_LicenseGrayNotice_" + app.getAppId());
            MyCurrentAppUtil.putMyCurrentUseAppMenu(app.getId(), menuId);
        }
        catch (Exception e) {
            logger.info("openApp error", (Object)e);
            myappView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u9875\u9762\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u9875\u9762\u63d2\u4ef6\u6216\u670d\u52a1\uff0c\u8be6\u7ec6\u9519\u8bef\uff1a%s", (String)"MenuModeServiceAbstract_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static String getAppSelfName(IFormView myappView, String appNum) {
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(myappView);
        return portalUtil.getAppSelfName(appNum);
    }

    private static boolean checkLicenseGray(IFormView view, String formNum, String appNum, String cloudNum) {
        if (StringUtils.isBlank((CharSequence)formNum)) {
            return true;
        }
        IFormView mainView = view.getMainView();
        LicenseGrayNotice notice = LicenseGrayServiceHelper.getExpiringGrayFeatureNotice((Long)RequestContext.get().getCurrUserId(), (String)formNum, (String)appNum, (String)cloudNum);
        LicenseGrayNotice.NoticeType noticeType = notice.getNoticeType();
        if (noticeType == LicenseGrayNotice.NoticeType.UNEXPIRED || noticeType == LicenseGrayNotice.NoticeType.EXPIRED) {
            String message = notice.getNoticeMessage();
            if (StringUtils.isNotBlank((CharSequence)message)) {
                mainView.showForm(PortalMessageUtils.createFormShowParameter(notice.getTitle(), message));
                view.sendFormAction(mainView);
            }
            if (noticeType == LicenseGrayNotice.NoticeType.EXPIRED) {
                throw new KDException(new ErrorCode("LicenseGrayNotice EXPIRED", "LicenseGrayNotice EXPIRED"), new Object[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean checkIsDisableApp(String appId) {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        return disabledAppIds != null && disabledAppIds.contains(appId);
    }

    private static boolean openUrlWhenTypeIsUrl(AppMenuInfo menu, IFormView curView) {
        if (menu == null) {
            return false;
        }
        String linkUrl = menu.getLinkUrl();
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)linkUrl)) {
            curView.showMessage(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u83dc\u5355\u9875\u9762\uff0c\u8bf7\u68c0\u67e5\u83dc\u5355\u914d\u7f6e\u3002", (String)"OpenPageUtils_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        FormShowParameter fsp = new FormShowParameter();
        IFormView mainPageView = OpenPageUtils.getMainPageView(curView);
        String pageId = menu.getId() + mainPageView.getPageId();
        fsp.setCaption(menu.getName().getLocaleValue());
        fsp.setPageId(pageId);
        fsp.setCustomParam("linkUrl", (Object)linkUrl);
        fsp.setFormId("bos_open_url");
        fsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        fsp.getOpenStyle().setTargetKey("_submaintab_");
        String appPageID = menu.getAppId() + mainPageView.getPageId();
        IFormView appPageView = mainPageView.getViewNoPlugin(appPageID);
        if (curView.getPageId().equals(appPageView.getPageId())) {
            curView.showForm(fsp);
        } else {
            appPageView.showForm(fsp);
            curView.sendFormAction(appPageView);
        }
        return true;
    }

    public static void openAppForCardCount(String appNum, String menuId, Map<String, Object> map, IFormView view) {
        OpenPageUtils.openAppForCardCount(appNum, menuId, map, view, "");
    }

    public static void openAppForCardCount(String appNum, String menuId, Map<String, Object> map, IFormView view, String selfAppName) {
        AppInfo appInfo;
        Object noPermMenuIdsObj;
        JSONArray noPermMenuIds;
        Map noPermMenuMap = (Map)view.getFormShowParameter().getCustomParam("noPermMenuMap");
        if (noPermMenuMap != null && (noPermMenuIds = (JSONArray)(noPermMenuIdsObj = noPermMenuMap.get((appInfo = AppMetadataCache.getAppInfo((String)appNum)).getId()))) != null && noPermMenuIds.contains((Object)menuId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\u3002", (String)"OpenPageUtils_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        OpenPageUtils.openApp(appNum, menuId, map, view, selfAppName);
    }

    public static boolean isHaveSchemeAuth(String schemeId, Long userId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)schemeId), new SqlParameter(":FUSERID", -5, (Object)userId), new SqlParameter(":FBASEDATAID", -5, (Object)userId)};
        String sql = "SELECT COUNT(1) FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_SHAREFILTERSCHEME T3 ON T1.FSCHEMEID = T3.FSCHEMEID LEFT JOIN T_BAS_SCHEMESHAREUSERS T4 ON T3.FID = T4.FID WHERE T1.FSCHEMEID = ? AND (T1.FISFIXED = '1' OR T1.FUSERID = ? OR T4.FBASEDATAID = ?)";
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next() && rs.getInt(1) > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        Boolean isHaveSchemeAuth = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)action);
        return isHaveSchemeAuth;
    }

    private static PermResult checkAppMenuPermission(String appId, String appName, String menuId, Map<String, Object> map, boolean isSuperAdmin) {
        long userId;
        PermResult permResult;
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5931\u8d25\u3002", (String)"GETAPPINFO_FAIL", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        boolean isDisableApp = OpenPageUtils.checkIsDisableApp(app.getId());
        if (isDisableApp) {
            return PermResult.fail((String)ResManager.loadKDString((String)"\u5e94\u7528\u5df2\u7981\u7528\uff0c\u65e0\u6743\u8bbf\u95ee\u3002", (String)"OpenPageUtils_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        String formNumber = (String)map.get(FORMNUMBER);
        boolean isAllUserApp = app.isAllUserApp();
        if (isAllUserApp) {
            if (appId.equals(WFTASK)) {
                return PermResult.ok();
            }
            if (isSuperAdmin && !OpenPageUtils.isAllowAdminBizOperate()) {
                return PermResult.fail((String)ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u505a\u4e1a\u52a1\u64cd\u4f5c\u3002", (String)"ADMIN_CANNOT_DOBUSI", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            Set appBlackSet = PermissionServiceHelper.getAppBlackSet((Long)RequestContext.get().getCurrUserId());
            if (appBlackSet.contains(app.getId())) {
                return PermResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5b58\u5728\u4e8e\u5168\u5458\u5e94\u7528\u9ed1\u540d\u5355\u4e2d\u3002", (String)"CURAPP_IS_ALLUSERAPPBLACK", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            Map checkPermAllUserAppEntMap = PermissionServiceHelper.getCheckPermAllUserAppEntMap();
            List entNums = (List)checkPermAllUserAppEntMap.get(app.getId());
            if (entNums == null || !entNums.contains(formNumber)) {
                return PermResult.ok();
            }
        }
        if (!(permResult = PermissionServiceHelper.checkUserBizApp((CheckUserBizAppReq)new CheckUserBizAppReq(Long.valueOf(userId = RequestContext.get().getCurrUserId()), app.getId()))).isOk()) {
            return permResult;
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)menuId)) {
            Object permItem;
            boolean isNotSpecialMenu = true;
            AppMenuInfo menu = null;
            try {
                menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
            }
            catch (Exception e) {
                logger.info("checkAppMenuPermission", (Object)e);
            }
            if (menu != null && (permItem = map.get("permItem")) == null) {
                map.put("permItem", menu.getPermission());
            }
            IFormView view = (IFormView)map.get("view");
            if (menu != null && view != null) {
                if ("link".equals(menu.getMenuType())) {
                    return PermResult.ok();
                }
                Short menuSeq = menu.getSeq();
                if (menuSeq == -1) {
                    isNotSpecialMenu = false;
                }
                if (isNotSpecialMenu) {
                    if (formNumber != null) {
                        String parameterType = "";
                        if (map.get(PARAMETERTYPE) != null) {
                            parameterType = (String)map.get(PARAMETERTYPE);
                        }
                        String permItem2 = map.get("permItem") == null ? null : map.get("permItem").toString();
                        boolean isOnlyCheckView = false;
                        String formId = view.getFormShowParameter().getFormId();
                        if (formId.equals("bos_card_numstatisticcard") || formId.equals("bos_card_sumstatisticcard")) {
                            isOnlyCheckView = true;
                        }
                        permResult = isOnlyCheckView ? PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(userId), null, app.getId(), formNumber, "47150e89000000ac")) : (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)permItem2) ? ("ListShowParameter".equalsIgnoreCase(parameterType) || "ReportShowParameter".equalsIgnoreCase(parameterType) || "FormShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(userId), null, app.getId(), formNumber, "47150e89000000ac")) : ("BillShowParameter".equalsIgnoreCase(parameterType) || "BaseShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(userId), null, app.getId(), formNumber, "47156aff000000ac")) : PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(userId), null, app.getId(), formNumber, "47150e89000000ac")))) : PermissionServiceHelper.checkPermission((CheckPermissionReq)new CheckPermissionReq(Long.valueOf(userId), null, app.getId(), formNumber, permItem2)));
                    } else {
                        String openPageUtils_6 = ResManager.loadKDString((String)"\u5f53\u524d\u83dc\u5355\u672a\u7ed1\u5b9a\u5355\u636e\uff0c\u8bf7\u524d\u5f80\u201c\u5f00\u53d1\u5e73\u53f0\u201d\u91cd\u65b0\u914d\u7f6e\u3002", (String)"OpenPageUtils_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                        view.showTipNotification(openPageUtils_6);
                        permResult = PermResult.fail((String)openPageUtils_6);
                    }
                }
            }
        }
        logger.debug("checkAppMenuPermission end..., permResult:{}", (Object)permResult);
        return permResult;
    }

    @Deprecated
    public static void openAppTab(String appID, String markID, Map<String, Object> map, IFormView myappView) {
        String appNum = AppMetadataCache.getAppNumberById((String)appID);
        OpenPageUtils.openApp(appNum, markID, map, myappView);
    }

    public static void openMenu(IFormView view, AICommandParameter command) {
        String menuItemId = (String)command.getParameter("menuId");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)menuItemId)) {
            view.showTipNotification(OpenPageUtils.getFormMsg());
            return;
        }
        String appId = view.getFormShowParameter().getAppId();
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355\u3002", (String)"OpenPageUtils_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        OpenPageUtils.openMenu(view, menuItemId, app.getId(), command.getPara());
    }

    public static void openMenu(IFormView view, String menuItemId, String bizAppId) {
        OpenPageUtils.openMenu(view, menuItemId, bizAppId, null);
    }

    public static void openMenu(IFormView view, String menuItemId, String bizAppId, Map<String, Object> customParameters) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)menuItemId)) {
            view.showTipNotification(OpenPageUtils.getFormMsg());
            return;
        }
        String appId = AppMetadataCache.getAppNumberById((String)bizAppId);
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528\u3002", (String)"OpenPageUtils_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuItemId);
        if (menu == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355\u3002", (String)"OpenPageUtils_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String appHomeNum = app.getHomeNum();
        String menuFormId = menu.getFormId();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)appHomeNum) || "page".equals(menu.getMenuType()) && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)menuFormId)) {
            view.showTipNotification(OpenPageUtils.getFormMsg());
            return;
        }
        String appName = app.getName().getLocaleValue();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", view);
        map.put(APPNAME, appName);
        map.put(APPMAINNUMBER, appHomeNum);
        map.put(FORMNUMBER, menuFormId);
        map.put(PARAMETERTYPE, menu.getParamType());
        map.put(PARAMETER, menu.getParams());
        map.put("menuname", menu.getName().getLocaleValue());
        map.put(CUSTOMPARAMETERS, customParameters);
        OpenPageUtils.openApp(app.getNumber(), menuItemId, map, view);
    }

    public static void closeMenu(IFormView view, String menuItemId, String appId) {
        String menuPageID;
        IFormView menuView;
        String appPageID;
        IFormView appPageView;
        IFormView mainPageView = OpenPageUtils.getMainPageView(view);
        if (mainPageView != null && (appPageView = mainPageView.getViewNoPlugin(appPageID = appId + mainPageView.getPageId())) != null && (menuView = view.getViewNoPlugin(menuPageID = menuItemId + mainPageView.getPageId())) != null) {
            menuView.close();
            view.sendFormAction(menuView);
        }
    }

    private static void openAppPage(String appID, Map<String, Object> map) {
        Map params;
        if (map.get(APPNAME) == null || map.get(APPMAINNUMBER) == null || map.get("view") == null) {
            logger.debug("OpenPageUtils----openAppPage----appmainnumber or view in map is null [105]");
            return;
        }
        IFormView view = (IFormView)map.get("view");
        IFormView mainPageView = OpenPageUtils.getMainPageView(view);
        String mainPageID = mainPageView.getPageId();
        String appName = map.get(APPNAME).toString();
        String appMainNumber = map.get(APPMAINNUMBER).toString();
        HashMap<String, String> customMap = new HashMap<String, String>();
        customMap.put(APPID, appID);
        customMap.put(APPNAME, appName);
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)map.get(APPIMAGEURL))) {
            customMap.put(APPIMAGEURL, OpenPageUtils.getAppImgUrl(map.get(APPIMAGEURL).toString()));
        }
        if ((params = (Map)map.get(CUSTOMPARAMETERS)) != null) {
            customMap.putAll(params);
        }
        String appPageID = appID + mainPageID;
        FormShowParameter para = new FormShowParameter();
        para.setAppId(appID);
        para.setCustomParams(customMap);
        para.getOpenStyle().setTargetKey(TABAP);
        para.getOpenStyle().setShowType(ShowType.NewTabPage);
        para.setFormId(appMainNumber);
        para.setCaption(appName);
        para.setPageId(appPageID);
        para.setHasRight(true);
        para.setInvokeTimeout(300);
        if ("true".equals(map.get("noSwitchFocus"))) {
            para.getOpenStyle().setNoSwitchFocus(true);
        }
        OpenPageUtils.setBrandUpApp(view);
        if (mainPageView.getPageId().equals(view.getPageId())) {
            view.showForm(para);
        } else {
            mainPageView.showForm(para);
            view.sendFormAction(mainPageView);
        }
        String userId = RequestContext.get().getUserId();
        String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
        String debugInfo = "the ending of click APP debug info is: ---userID:" + userId + TIME + time + "---appID:" + appID + "---appName:" + appName + "---appPageID:" + appPageID;
        logger.debug(debugInfo);
    }

    private static String getAppImgUrl(String url) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)url)) {
            return "icons/pc/entrance/default_48_48.png";
        }
        if (url.startsWith("/") && url.length() > 1) {
            url = url.substring(1);
        }
        return url;
    }

    private static void setBrandUpApp(IFormView view) {
        String appNumber;
        if (view != null && kd.bos.util.StringUtils.isNotEmpty((String)(appNumber = (String)view.getFormShowParameter().getCustomParam("appNumber"))) && BrandUpEnum.getAppNumbers(appNumber) != null) {
            view.getFormShowParameter().setCustomParam("isHideHomeTab", (Object)false);
        }
    }

    private static void openMenuPage(String appID, String menuid, Map<String, Object> map) {
        String appPageID;
        IFormView appPageView;
        if (Objects.isNull(map)) {
            return;
        }
        IFormView view = (IFormView)map.get("view");
        IFormView mainPageView = OpenPageUtils.getMainPageView(view);
        String data = mainPageView.getPageCache().get("Portal_LicenseGrayNotice_" + appID);
        if (!"true".equals(data)) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)appID);
            OpenPageUtils.checkLicenseGray(view, (String)map.get(FORMNUMBER), appInfo.getNumber(), appInfo.getCloudNum());
        }
        if (appID == null || map.get("view") == null) {
            logger.debug("OpenPageUtils----openMenuPage----appID or parameter in map is error [143]");
            return;
        }
        String parameterType = "";
        Object objParamType = map.get(PARAMETERTYPE);
        parameterType = objParamType == null ? "FormShowParameter" : objParamType.toString();
        Map<String, Object> parameter = new HashMap();
        Object parameterStr = map.get(PARAMETER);
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((Object)parameterStr)) {
            parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
        }
        if ((appPageView = mainPageView.getViewNoPlugin(appPageID = appID + mainPageView.getPageId())) != null) {
            Boolean isAIVoiceRequest;
            HashMap<String, String> customMap;
            AppMenuInfo appMenuInfo;
            if (appPageView.getPageId().equalsIgnoreCase(view.getPageId())) {
                appPageView = view;
            }
            String filterSchemeId = null;
            if (parameter != null) {
                filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
            }
            String markId = null;
            markId = kd.bos.dataentity.utils.StringUtils.isNotEmpty(filterSchemeId) ? menuid + SPLIT_STR + filterSchemeId : menuid;
            String menuPageID = markId + mainPageView.getPageId();
            boolean existView = mainPageView.existView(menuPageID);
            if (existView) {
                menuPageID = menuPageID + "_" + kd.bos.login.utils.StringUtils.randomNumber((int)16);
            }
            if (Objects.nonNull(appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appID, (String)menuid)) && "link".equals(appMenuInfo.getMenuType())) {
                OpenPageUtils.openUrlWhenTypeIsUrl(appMenuInfo, view);
                return;
            }
            if (map.get(FORMNUMBER) == null) {
                logger.debug("OpenPageUtils----openMenuPage----form number is null [144]");
                return;
            }
            String formNumber = map.get(FORMNUMBER).toString();
            FormShowParameter fsp = OpenPageUtils.showFormParameter(formNumber, parameterType, parameter, map);
            fsp.setHasRight(true);
            fsp.setAppId(appID);
            Map params = (Map)map.get(CUSTOMPARAMETERS);
            if (params != null) {
                fsp.setCustomParams(params);
            }
            if ((customMap = fsp.getCustomParams()) == null) {
                customMap = new HashMap<String, String>();
            }
            if ((isAIVoiceRequest = (Boolean)customMap.get("isAIVoiceRequest")) != null && isAIVoiceRequest.booleanValue()) {
                Map<String, String> openStyleCustParam = fsp.getOpenStyle().getCustParam() != null ? fsp.getOpenStyle().getCustParam() : new HashMap();
                openStyleCustParam.put("isFullScreen", "true");
                fsp.getOpenStyle().setCustParam(openStyleCustParam);
            }
            if (appMenuInfo != null && "Modal".equals(appMenuInfo.getOpenType())) {
                fsp.getOpenStyle().setShowType(ShowType.Modal);
            }
            customMap.put(APPID, appID);
            fsp.setCustomParams(customMap);
            fsp.setPageId(menuPageID);
            List pluginList = ((FormViewPluginProxy)appPageView.getService(FormViewPluginProxy.class)).getPlugIns();
            if (pluginList != null && pluginList.size() > 0) {
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)pluginList.get(0), "close_menupage"));
            }
            if (view.getPageId().equals(appPageView.getPageId())) {
                view.showForm(fsp);
            } else {
                appPageView.showForm(fsp);
                view.sendFormAction(appPageView);
            }
            OpenPageUtils.traceMenu(appID, menuid, formNumber);
            String userId = RequestContext.get().getUserId();
            String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
            String debugInfo = "the ending of click MENU debug info is: ---userID:" + userId + TIME + time + "---menuID:" + menuid + "---menuPageID:" + menuPageID;
            logger.debug(debugInfo);
            JSONObject menuInfo = new JSONObject();
            menuInfo.put("type", (Object)"menu");
            menuInfo.put("id", (Object)menuid);
            menuInfo.put("name", map.get("menuname"));
            menuInfo.put(APPID, (Object)appID);
            menuInfo.put(APPNAME, (Object)appPageView.getFormShowParameter().getCaption());
            CollectAppAndMenuUtil menuThread = new CollectAppAndMenuUtil(RequestContext.get(), menuInfo);
            ThreadPools.executeOnceIncludeRequestContext((String)"manageMenuInfo", (Runnable)menuThread);
        } else {
            OpenPageUtils.showPageTips(view);
        }
    }

    private static void showPageTips(IFormView view) {
        List acts = view.getActionResult();
        if (acts != null && !acts.isEmpty()) {
            HashMap<String, Object> arg = new HashMap<String, Object>(2);
            arg.put("pageId", view.getPageId());
            arg.put("actions", acts);
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("sendDynamicFormAction", arg);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u91cd\u65b0\u767b\u5f55\u3002", (String)"OpenPageUtils_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private static void traceMenu(final String appID, final String menuid, final String formNumber) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AppInfo app = AppMetadataCache.getAppInfo((String)appID);
                    MenuTraceService menuTraceService = (MenuTraceService)BeanUtils.getBean((String)"kd.bos.ais.core.sync.AisMenuTraceServiceImpl");
                    menuTraceService.traceMenu(app.getCloudId(), appID, formNumber, menuid, true, null, null);
                }
                catch (Exception e) {
                    logger.info("traceMenu error", (Object)e);
                }
            }
        }, RequestContext.get());
    }

    private static void activatePage(String pageID, IFormView view, Map<String, Object> map) {
        List<String> yzjAppList = YzjAppEnum.getAllBosAppNum();
        Object yzjAppIdObj = map.get("yzjAppId");
        String zyjAppId = "";
        if (!ObjectUtils.isEmpty((Object)yzjAppIdObj)) {
            zyjAppId = (String)yzjAppIdObj;
        }
        String menuId = pageID.split("root")[0];
        IFormView childView = view.getViewNoPlugin(pageID);
        if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
            childView = view.getView(pageID);
        }
        if (yzjAppList.contains(zyjAppId)) {
            childView = view.getView(pageID);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                HashMap customparameters = (HashMap)map.get(CUSTOMPARAMETERS);
                childView.getFormShowParameter().getCustomParams().remove(MESSAGE_ID);
                childView.getFormShowParameter().getCustomParams().remove(TAB_TYPE);
                childView.getFormShowParameter().getCustomParams().remove(OPEN_PAGE);
                childView.getFormShowParameter().getCustomParams().remove(BILL_FORM_ID);
                if (customparameters != null) {
                    if (customparameters.get(MESSAGE_ID) != null) {
                        childView.getFormShowParameter().setCustomParam(MESSAGE_ID, customparameters.get(MESSAGE_ID));
                    }
                    if (customparameters.get(TAB_TYPE) != null) {
                        childView.getFormShowParameter().setCustomParam(TAB_TYPE, customparameters.get(TAB_TYPE));
                    }
                    if (customparameters.get(OPEN_PAGE) != null) {
                        childView.getFormShowParameter().setCustomParam(OPEN_PAGE, customparameters.get(OPEN_PAGE));
                    }
                    if (customparameters.get(BILL_FORM_ID) != null) {
                        childView.getFormShowParameter().setCustomParam(BILL_FORM_ID, customparameters.get(BILL_FORM_ID));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                OpenPageUtils.newPortalSelectAppTab(childView);
                if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
                    childView.updateView();
                }
                if (yzjAppList.contains(zyjAppId)) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
                String userId = RequestContext.get().getUserId();
                String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
                String debugInfo = "the ending of click APP debug info is: ---userID:" + userId + TIME + time + "---menuId Or appId:" + menuId + "---PageID" + pageID;
                logger.debug(debugInfo);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u91cd\u65b0\u767b\u5f55\u3002", (String)"OpenPageUtils_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private static void newPortalSelectAppTab(IFormView formView) {
        Tab tab;
        RequestContext rc = RequestContext.get();
        boolean isNewPortal = NewPortalService.isPersonalSettingNewPortal((long)rc.getCurrUserId(), (String)rc.getAccountId());
        if (!isNewPortal) {
            return;
        }
        if (!WFTASK.equals(formView.getFormShowParameter().getAppId()) && (tab = (Tab)formView.getControl("_submaintab_")) != null) {
            tab.activeTab("appmiantab");
        }
    }

    private static FormShowParameter showFormParameter(String formNumber, String parameterType, Map<String, Object> parameter, Map<String, Object> map) {
        FormShowParameter sp;
        if (parameterType.equalsIgnoreCase("ListShowParameter") && Objects.nonNull(parameter)) {
            MainEntityType dt;
            String entityId;
            parameter.put("type", "list");
            String billFormId = (String)parameter.get(BILL_FORM_ID);
            if (billFormId == null && !"empty".equalsIgnoreCase(entityId = FormMetadataCache.getFormConfig((String)formNumber).getEntityTypeId()) && (dt = EntityMetadataCache.getDataEntityType((String)entityId)) instanceof BillEntityType) {
                parameter.put(BILL_FORM_ID, formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        } else {
            if (Objects.nonNull(parameter) && parameter.get("formId") == null) {
                parameter.put("formId", formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        }
        OpenPageUtils.setParameterValue(sp, parameter);
        if (Objects.isNull(parameter)) {
            return sp;
        }
        String isModal = (String)parameter.get("isModal");
        if ("1".equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.Modal);
            sp.setShowTitle(false);
        } else if ("0".equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.NewTabPage);
            sp.getOpenStyle().setTargetKey("_submaintab_");
        } else {
            Object openType = null;
            if (map != null) {
                openType = map.get("openType");
            }
            String openTypeStr = null;
            if (openType != null) {
                openTypeStr = openType.toString();
            }
            if ("Modal".equals(openTypeStr)) {
                sp.getOpenStyle().setShowType(ShowType.Modal);
            } else {
                sp.getOpenStyle().setShowType(ShowType.NewTabPage);
                sp.getOpenStyle().setTargetKey("_submaintab_");
            }
        }
        sp.setCustomParams(parameter);
        return sp;
    }

    private static void setParameterValue(FormShowParameter showParameter, Map<String, Object> params) {
        if (params != null) {
            Class<?> clazz = showParameter.getClass();
            try {
                OpenPageUtils.exeClass(showParameter, params, clazz);
            }
            catch (Exception e) {
                logger.error("setParameterValue error", (Throwable)e);
            }
        }
    }

    private static void exeClass(FormShowParameter showParameter, Map<String, Object> params, Class<?> clazz) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (clazz == Object.class) {
            return;
        }
        block0: for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            String paramName = field.getName();
            String type = field.getGenericType().getTypeName();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String pName = entry.getKey();
                if (pName.equalsIgnoreCase("status") && paramName.equalsIgnoreCase(pName)) {
                    int paramValue = Integer.parseInt((String)entry.getValue());
                    field.set(showParameter, OperationStatus.forValue((int)paramValue));
                    continue block0;
                }
                if (pName.equalsIgnoreCase("listFilterParameter") && paramName.equalsIgnoreCase(pName)) {
                    String paramValue = (String)params.get(pName);
                    ListFilterParameter filterParameter = new ListFilterParameter();
                    filterParameter.setQFilter(paramValue);
                    field.set(showParameter, filterParameter);
                    continue block0;
                }
                if (!paramName.equalsIgnoreCase(pName)) continue;
                String paramValue = "";
                if (params.get(pName) instanceof LinkedHashMap) {
                    String captionLocalName;
                    LinkedHashMap paramLinkedHashMap = (LinkedHashMap)params.get(pName);
                    LocaleString captionName = LocaleString.fromMap((Map)paramLinkedHashMap);
                    paramValue = captionLocalName = captionName.getLocaleValue();
                } else if (params.get(pName) instanceof String) {
                    paramValue = (String)params.get(pName);
                }
                if (type.endsWith("Object")) {
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("String")) {
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("int") || type.endsWith("Integer")) {
                    field.set(showParameter, Integer.parseInt(paramValue));
                    continue block0;
                }
                if (type.endsWith("double") || type.endsWith("Double")) {
                    field.set(showParameter, Double.parseDouble(paramValue));
                    continue block0;
                }
                if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                    field.set(showParameter, Boolean.parseBoolean(paramValue));
                    continue block0;
                }
                if (type.endsWith("float") || type.endsWith("Float")) {
                    field.set(showParameter, Float.valueOf(Float.parseFloat(paramValue)));
                    continue block0;
                }
                if (type.endsWith("short") || type.endsWith("Short")) {
                    field.set(showParameter, Short.parseShort(paramValue));
                    continue block0;
                }
                if (type.endsWith("long") || type.endsWith("Long")) {
                    field.set(showParameter, Long.parseLong(paramValue));
                    continue block0;
                }
                if (type.endsWith("byte") || type.endsWith("Byte")) {
                    field.set(showParameter, Byte.parseByte(paramValue));
                    continue block0;
                }
                if (!type.endsWith("Map<java.lang.String, java.lang.Object>")) continue block0;
                field.set(showParameter, SerializationUtils.fromJsonString((String)paramValue, Map.class));
                continue block0;
            }
        }
        Class<?> clazzs = clazz.getSuperclass();
        OpenPageUtils.exeClass(showParameter, params, clazzs);
    }

    public static void activeTab(String pageId, IFormView formView) {
        HashMap<String, String> tabMap = new HashMap<String, String>();
        tabMap.put("pageId", pageId);
        tabMap.put("appId", formView.getFormShowParameter().getAppId());
        String method = "activeVirtualTab";
        ArrayList<HashMap<String, String>> argList = new ArrayList<HashMap<String, String>>();
        argList.add(tabMap);
        HashMap<String, Object> realMap = new HashMap<String, Object>();
        realMap.put("args", argList);
        realMap.put("methodname", method);
        realMap.put("key", "homepagetabap");
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("InvokeControlMethod", realMap);
        IFormView parentFormView = SessionManager.getCurrent().getView(formView.getParentView().getPageId());
        method = "activeTab";
        ArrayList<String> styleList = new ArrayList<String>();
        styleList.add(pageId);
        HashMap<String, Object> lastMap = new HashMap<String, Object>();
        lastMap.put("args", styleList);
        lastMap.put("methodname", method);
        lastMap.put("key", "_submaintab_");
        ((IClientViewProxy)parentFormView.getService(IClientViewProxy.class)).addAction("InvokeControlMethod", lastMap);
        formView.sendFormAction(parentFormView);
    }
}

