/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.api.AICommandParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class OperatePageUtils {
    private static final Log logger = LogFactory.getLog(OperatePageUtils.class);
    public static final String BIZAPPID = "bizappid";
    public static final String NUMBER = "number";

    public static void executeOperation(String key, IFormView page) {
        page.invokeOperation(key);
    }

    public static void reloadData(IFormView mainPage, IFormView page, AICommandParameter cmd) {
        OperatePageUtils.reloadData(mainPage, page, cmd.getPara());
    }

    public static void reloadData(IFormView mainPage, IFormView page, Map<String, Object> cmdParameter) {
        FormShowParameter param = page.getFormShowParameter();
        param.beginInit();
        if (cmdParameter != null) {
            if (param instanceof BillShowParameter) {
                BillShowParameter billShowParameter = (BillShowParameter)param;
                Object reloadPkId = cmdParameter.get("pkId");
                billShowParameter.setPkId(reloadPkId);
                billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            }
            Object formId = param.getCustomParam("formId");
            param.setCustomParams(cmdParameter);
            param.setCustomParam("formId", formId);
        }
        param.endInit();
        page.cacheFormShowParameter();
        IFormController controller = (IFormController)page.getService(IFormController.class);
        controller.loadData();
        page.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        mainPage.sendFormAction(page);
    }

    public static void doOperation(IFormView mainPage, AICommandParameter cmd) {
    }

    public static List<Map<String, Object>> getFormInfoByName(String formName) {
        ArrayList<Map<String, Object>> formInfos = new ArrayList<Map<String, Object>>();
        QFilter[] filters = new QFilter[]{new QFilter("name", "like", (Object)("%" + formName + "%"))};
        Map cacheData = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,bizappid,name", (QFilter[])filters);
        for (Map.Entry formInfo : cacheData.entrySet()) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            DynamicObject formObj = (DynamicObject)formInfo.getValue();
            infoMap.put("id", formInfo.getKey());
            infoMap.put("name", formObj.get("name"));
            infoMap.put(BIZAPPID, formObj.get(BIZAPPID));
            infoMap.put("formid", formObj.get(NUMBER));
            String menuId = OperatePageUtils.getMenuId(formInfo.getKey().toString(), formObj.get(NUMBER).toString(), formObj.get(BIZAPPID).toString());
            if (!StringUtils.isNotBlank((CharSequence)menuId)) continue;
            infoMap.put("menuid", menuId);
            formInfos.add(infoMap);
        }
        return formInfos;
    }

    public static List<Map<String, Object>> getFormInfoByFormId(String formId) {
        return OperatePageUtils.getFormInfoByFormId(formId, true);
    }

    public static List<Map<String, Object>> getFormInfoByFormId(String formId, boolean isLoadMenuId) {
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)formId)};
        Map cacheData = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number,bizappid,name", (QFilter[])filters);
        ArrayList<Map<String, Object>> formInfos = new ArrayList<Map<String, Object>>(cacheData.size());
        for (Map.Entry formInfo : cacheData.entrySet()) {
            String menuId;
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            DynamicObject formObj = (DynamicObject)formInfo.getValue();
            infoMap.put("id", formInfo.getKey());
            infoMap.put("name", formObj.get("name"));
            infoMap.put(BIZAPPID, formObj.get(BIZAPPID));
            infoMap.put("formid", formObj.get(NUMBER));
            if (isLoadMenuId && StringUtils.isNotBlank((CharSequence)(menuId = OperatePageUtils.getMenuId(formInfo.getKey().toString(), formObj.get(NUMBER).toString(), formObj.get(BIZAPPID).toString())))) {
                infoMap.put("menuid", menuId);
            }
            formInfos.add(infoMap);
        }
        return formInfos;
    }

    private static String getMenuId(String fid, String formId, String appID) {
        String appNumber = AppMetadataCache.getAppNumberById((String)appID);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        List menus = AppMetadataCache.getAppMenusInfoByAppId((String)appNumber);
        Optional<AppMenuInfo> formMenu = menus.stream().filter(appMenu -> fid.equals(appMenu.getFormId())).findFirst();
        if (formMenu.isPresent()) {
            return formMenu.get().getId();
        }
        return null;
    }

    public static void openBill(String appID, String formId, Map<String, Object> params, IFormView mainPageView) {
        AppMetadata appMetadata = BizAppServiceHelp.getAppMetaByID((String)appID);
        String appPageID = appMetadata.getNumber() + mainPageView.getPageId();
        IFormView appPageView = mainPageView.getViewNoPlugin(appPageID);
        if (appPageView != null) {
            if (appPageView.getPageId().equalsIgnoreCase(mainPageView.getPageId())) {
                appPageView = mainPageView;
            }
            String menuPageID = formId + mainPageView.getPageId();
            FormShowParameter fsp = OperatePageUtils.showFormParameter(formId, params);
            fsp.setHasRight(true);
            fsp.setAppId(appID);
            fsp.setCustomParams(params);
            HashMap<String, String> customMap = fsp.getCustomParams();
            if (customMap == null) {
                customMap = new HashMap<String, String>();
            }
            customMap.put("appid", appID);
            fsp.setCustomParams(customMap);
            fsp.setPageId(menuPageID);
            List pluginList = ((FormViewPluginProxy)appPageView.getService(FormViewPluginProxy.class)).getPlugIns();
            if (pluginList != null && pluginList.size() > 0) {
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)pluginList.get(0), "close_menupage"));
            }
            if (mainPageView.getPageId().equals(appPageView.getPageId())) {
                mainPageView.showForm(fsp);
            } else {
                appPageView.showForm(fsp);
                mainPageView.sendFormAction(appPageView);
            }
        } else {
            mainPageView.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u5237\u65b0\u91cd\u65b0\u767b\u5f55\u3002", (String)"OperatePageUtils_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
        }
    }

    private static FormShowParameter showFormParameter(String formNumber, Map<String, Object> parameter) {
        FormShowParameter sp = FormShowParameter.createFormShowParameter(parameter);
        sp.getOpenStyle().setShowType(ShowType.NewTabPage);
        sp.getOpenStyle().setTargetKey("_submaintab_");
        HashMap map = new HashMap();
        sp.setCustomParams(map);
        return sp;
    }
}

