/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.portal.model.PersonalSchemaAppInfo;
import kd.bos.portal.model.PersonalSchemaCloudInfo;
import kd.bos.portal.model.PersonalSchemaInfo;
import kd.bos.util.CollectionUtils;

public class PersonalSchemaTemplateUtil {
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String INDUSTRY = "industry";
    private MetadataSerializer metaSerializer = new MetadataSerializer("AppModel");

    public String buildDiffXml(PersonalSchemaInfo personalSchemaInfo, PersonalSchemaInfo basePersonalSchemaInfo, boolean onlyLocaleValue) {
        String xml = this.metaSerializer.buildDiffXml((Object)personalSchemaInfo, (Object)basePersonalSchemaInfo, onlyLocaleValue, true);
        return xml;
    }

    public PersonalSchemaInfo getPersonalSchemaInfo(String diffXml, PersonalSchemaInfo basePersonalSchemaInfo) {
        PersonalSchemaInfo personalSchemaInfo = (PersonalSchemaInfo)this.metaSerializer.deserializeFromXml(diffXml, (Object)basePersonalSchemaInfo, true);
        return personalSchemaInfo;
    }

    public JSONArray changePersonalSchemaInfoToJsonArray(JSONArray runtimeApps, String personalApps) {
        JSONArray allPersonInfo = new JSONArray();
        PersonalSchemaInfo basePersonalSchemaInfo = this.getPersonalSchemaInfo(runtimeApps.toString());
        PersonalSchemaInfo personalSchemaInfo = new PersonalSchemaTemplateUtil().getPersonalSchemaInfo(personalApps, basePersonalSchemaInfo);
        List<PersonalSchemaCloudInfo> personalSchemaCloudInfoList = personalSchemaInfo.getCloudInfoList();
        personalSchemaCloudInfoList.sort(Comparator.comparingInt(PersonalSchemaCloudInfo::getSeq));
        for (PersonalSchemaCloudInfo cloudInfo : personalSchemaCloudInfoList) {
            JSONObject cloudObj = new JSONObject();
            JSONArray cloudArr = new JSONArray();
            List<PersonalSchemaAppInfo> personalSchemaAppInfo = cloudInfo.getAppInfoList();
            if (CollectionUtils.isEmpty(personalSchemaAppInfo)) continue;
            personalSchemaAppInfo.sort(Comparator.comparingInt(PersonalSchemaAppInfo::getSeq));
            String backGroundImage = cloudInfo.getBackGroundImage();
            String cloudId = cloudInfo.getCloudId();
            String cloudName = cloudInfo.getCloudName();
            String industryName = cloudInfo.getIndustryName();
            String pageImage = cloudInfo.getPgimage();
            short seq = cloudInfo.getSeq();
            LocaleString cloudNameLocale = null;
            LocaleString industryNameLocale = null;
            try {
                if (StringUtils.isNotBlank((CharSequence)cloudName)) {
                    HashMap cloudNameMap = (HashMap)JSONUtils.cast((String)cloudName, HashMap.class);
                    cloudNameLocale = LocaleString.fromMap((Map)cloudNameMap);
                }
                if (StringUtils.isNotBlank((CharSequence)industryName)) {
                    HashMap industryNameMap = (HashMap)JSONUtils.cast((String)industryName, HashMap.class);
                    industryNameLocale = LocaleString.fromMap((Map)industryNameMap);
                }
            }
            catch (IOException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u884c\u4e1a\u540d\u79f0\u6216\u63cf\u8ff0\u8f6c\u6362\u51fa\u9519\u3002", (String)"PersonalSchemaTemplateUtil_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            cloudObj.put("id", (Object)cloudId);
            cloudObj.put("name", (Object)cloudNameLocale);
            cloudObj.put("seq", (Object)seq);
            cloudObj.put("pgimage", (Object)pageImage);
            cloudObj.put("bgimage", (Object)backGroundImage);
            cloudObj.put("iscloud", (Object)true);
            cloudObj.put(INDUSTRY, (Object)industryNameLocale);
            cloudObj.put("grayValid", (Object)cloudInfo.getGrayValid());
            if (cloudId.equals("2HGKCE94QELW")) {
                cloudObj.put("thirdapp", (Object)true);
            }
            cloudArr.add((Object)cloudObj);
            for (PersonalSchemaAppInfo appInfo : personalSchemaAppInfo) {
                JSONObject appObj = new JSONObject();
                String allUserApp = appInfo.getAllUserApp();
                String bizAppId = appInfo.getBizAppId();
                String bizAppCloudId = appInfo.getCloudId();
                String image = appInfo.getImage();
                String bizAppNum = appInfo.getNumber();
                String userType = appInfo.getUserType();
                String bizAppName = appInfo.getName();
                String description = appInfo.getDescription();
                String bizAppIndustry = appInfo.getIndustry();
                Short appSeq = appInfo.getSeq();
                String homeURL = appInfo.getHomeURL();
                String mainFormType = appInfo.getMainFormType();
                String isv = appInfo.getIsv();
                String thirdApp = appInfo.getThirdApp();
                LocaleString bizAppNameLocale = null;
                LocaleString bizAppDescription = null;
                LocaleString bizAppIndustryNameLocale = null;
                try {
                    if (StringUtils.isNotBlank((CharSequence)bizAppName)) {
                        HashMap bizAppNameMap = (HashMap)JSONUtils.cast((String)bizAppName, HashMap.class);
                        bizAppNameLocale = LocaleString.fromMap((Map)bizAppNameMap);
                    }
                    if (StringUtils.isNotBlank((CharSequence)description)) {
                        HashMap descriptionMap = (HashMap)JSONUtils.cast((String)description, HashMap.class);
                        bizAppDescription = LocaleString.fromMap((Map)descriptionMap);
                    }
                    if (StringUtils.isNotBlank((CharSequence)bizAppIndustry)) {
                        HashMap bizAppIndustryMap = (HashMap)JSONUtils.cast((String)bizAppIndustry, HashMap.class);
                        bizAppIndustryNameLocale = LocaleString.fromMap((Map)bizAppIndustryMap);
                    }
                }
                catch (IOException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u540d\u79f0\u6216\u63cf\u8ff0\u8f6c\u6362\u51fa\u9519\u3002", (String)"PersonalSchemaTemplateUtil_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                }
                appObj.put("cloudid", (Object)bizAppCloudId);
                appObj.put("id", (Object)bizAppId);
                appObj.put("number", (Object)bizAppNum);
                appObj.put("seq", (Object)appSeq);
                appObj.put("image", (Object)image);
                appObj.put("name", (Object)bizAppNameLocale);
                appObj.put("alluserapp", (Object)allUserApp);
                appObj.put("usertype", (Object)userType);
                appObj.put("description", (Object)bizAppDescription);
                appObj.put(INDUSTRY, (Object)bizAppIndustryNameLocale);
                appObj.put("homeURL", (Object)homeURL);
                appObj.put("mainformtype", (Object)mainFormType);
                appObj.put("isv", (Object)isv);
                appObj.put("thirdapp", (Object)Boolean.parseBoolean(thirdApp));
                appObj.put("grayValid", (Object)appInfo.getGrayValid());
                cloudArr.add((Object)appObj);
            }
            allPersonInfo.add((Object)cloudArr);
        }
        return allPersonInfo;
    }

    public PersonalSchemaInfo getPersonalSchemaInfo(String apps) {
        JSONArray allAppsInSystem = JSONArray.parseArray((String)apps);
        Iterator iterAppsInSystem = allAppsInSystem.iterator();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        PersonalSchemaInfo personalSchemaInfo = new PersonalSchemaInfo();
        personalSchemaInfo.setUserId(userId);
        ArrayList<PersonalSchemaCloudInfo> cloudInfoList = new ArrayList<PersonalSchemaCloudInfo>();
        while (iterAppsInSystem.hasNext()) {
            PersonalSchemaCloudInfo personSchemaCloudInfo = new PersonalSchemaCloudInfo();
            ArrayList<PersonalSchemaAppInfo> appInfoList = new ArrayList<PersonalSchemaAppInfo>();
            JSONArray cloudAndApp = (JSONArray)iterAppsInSystem.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                PersonalSchemaAppInfo personalSchemaAppInfo = new PersonalSchemaAppInfo();
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (StringUtils.isNotBlank((Object)cloudOrApp.getBoolean("iscloud"))) {
                    String bgImage = cloudOrApp.getString("bgimage");
                    String bizCloudId = cloudOrApp.getString("id");
                    JSONObject industry = (JSONObject)cloudOrApp.get((Object)INDUSTRY);
                    JSONObject cloudName = (JSONObject)cloudOrApp.get((Object)"name");
                    try {
                        if (StringUtils.isNotBlank((Object)industry)) {
                            String industryStr = JSONUtils.toString((Object)industry);
                            personSchemaCloudInfo.setIndustryName(industryStr);
                        }
                        if (StringUtils.isNotBlank((Object)cloudName)) {
                            String cloudNameStr = JSONUtils.toString((Object)cloudName);
                            personSchemaCloudInfo.setCloudName(cloudNameStr);
                        }
                    }
                    catch (IOException e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u884c\u4e1a\u540d\u79f0\u6216\u63cf\u8ff0\u8f6c\u6362\u51fa\u9519\u3002", (String)"PersonalSchemaTemplateUtil_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    }
                    String pgImage = cloudOrApp.getString("pgimage");
                    Short seq = cloudOrApp.getShort("seq");
                    personSchemaCloudInfo.setBackGroundImage(bgImage);
                    personSchemaCloudInfo.setCloudId(bizCloudId);
                    personSchemaCloudInfo.setPgimage(pgImage);
                    if (StringUtils.isNotBlank((Object)seq)) {
                        personSchemaCloudInfo.setSeq(seq);
                    }
                    personSchemaCloudInfo.setGrayValid(cloudOrApp.getString("grayValid"));
                    continue;
                }
                String allUserApp = cloudOrApp.getString("alluserapp");
                String cloudId = cloudOrApp.getString("cloudid");
                String bizAppId = cloudOrApp.getString("id");
                String bizAppImage = cloudOrApp.getString("image");
                String bizAppNum = cloudOrApp.getString("number");
                String userType = cloudOrApp.getString("usertype");
                Short appSeq = cloudOrApp.getShort("seq");
                JSONObject description = (JSONObject)cloudOrApp.get((Object)"description");
                JSONObject bizAppName = (JSONObject)cloudOrApp.get((Object)"name");
                JSONObject bizAppIndustry = (JSONObject)cloudOrApp.get((Object)INDUSTRY);
                String homeNum = cloudOrApp.getString("homenum");
                String openType = cloudOrApp.getString("opentype");
                String mainFormType = cloudOrApp.getString("mainformtype");
                String homeURL = cloudOrApp.getString("homeURL");
                String isv = cloudOrApp.getString("isv");
                String thirdapp = cloudOrApp.getString("thirdapp");
                try {
                    if (StringUtils.isNotBlank((Object)description)) {
                        String descriptionStr = JSONUtils.toString((Object)description);
                        personalSchemaAppInfo.setDescription(descriptionStr);
                    }
                    if (StringUtils.isNotBlank((Object)bizAppName)) {
                        String bizAppNameStr = JSONUtils.toString((Object)bizAppName);
                        personalSchemaAppInfo.setName(bizAppNameStr);
                    }
                    if (StringUtils.isNotBlank((Object)bizAppIndustry)) {
                        String bizAppIndustryStr = JSONUtils.toString((Object)bizAppIndustry);
                        personalSchemaAppInfo.setIndustry(bizAppIndustryStr);
                    }
                }
                catch (IOException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u540d\u79f0\u6216\u63cf\u8ff0\u8f6c\u6362\u51fa\u9519\u3002", (String)"PersonalSchemaTemplateUtil_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                }
                personalSchemaAppInfo.setAllUserApp(allUserApp);
                personalSchemaAppInfo.setCloudId(cloudId);
                personalSchemaAppInfo.setBizAppId(bizAppId);
                personalSchemaAppInfo.setImage(bizAppImage);
                personalSchemaAppInfo.setNumber(bizAppNum);
                personalSchemaAppInfo.setUserType(userType);
                personalSchemaAppInfo.setHomeNum(homeNum);
                personalSchemaAppInfo.setOpenType(openType);
                personalSchemaAppInfo.setMainFormType(mainFormType);
                personalSchemaAppInfo.setHomeURL(homeURL);
                personalSchemaAppInfo.setIsv(isv);
                personalSchemaAppInfo.setThirdApp(thirdapp);
                if (StringUtils.isNotBlank((Object)appSeq)) {
                    personalSchemaAppInfo.setSeq(appSeq);
                }
                personalSchemaAppInfo.setGrayValid(cloudOrApp.getString("grayValid"));
                appInfoList.add(personalSchemaAppInfo);
            }
            personSchemaCloudInfo.setAppInfoList(appInfoList);
            cloudInfoList.add(personSchemaCloudInfo);
        }
        personalSchemaInfo.setCloudInfoList(cloudInfoList);
        return personalSchemaInfo;
    }
}

