/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class PortalAppMetaDataUtils {
    private static final Log logger = LogFactory.getLog(PortalAppMetaDataUtils.class);

    public static Map<String, AppInfo> getAppIdInfo(Set<String> appIds) {
        Map<String, AppInfo> allIdAppInfo = new HashMap<String, AppInfo>(0);
        if (CollectionUtils.isEmpty(appIds)) {
            return allIdAppInfo;
        }
        if (appIds.size() == 1) {
            String appId = new ArrayList<String>(appIds).get(0);
            try {
                AppInfo appInfo2 = AppMetadataCache.getAppInfo((String)appId);
                allIdAppInfo.put(appInfo2.getId(), appInfo2);
            }
            catch (Exception e) {
                logger.info("getAppInfo error", (Object)e);
            }
            return allIdAppInfo;
        }
        Map allAppInfo = AppMetadataCache.getAllAppInfo();
        allIdAppInfo = allAppInfo.values().stream().filter(appInfo -> appIds.contains(appInfo.getId())).collect(Collectors.toMap(AppInfo::getId, i -> i));
        return allIdAppInfo;
    }

    public static Map<String, AppInfo> getAppNumInfo(Set<String> appNums) {
        Map<String, AppInfo> allIdAppInfo = new HashMap<String, AppInfo>(0);
        if (CollectionUtils.isEmpty(appNums)) {
            return allIdAppInfo;
        }
        if (appNums.size() == 1) {
            String appNum = new ArrayList<String>(appNums).get(0);
            try {
                AppInfo appInfo2 = AppMetadataCache.getAppInfo((String)appNum);
                allIdAppInfo.put(appInfo2.getNumber(), appInfo2);
            }
            catch (Exception e) {
                logger.info("getAppInfo error", (Object)e);
            }
            return allIdAppInfo;
        }
        Map allAppInfo = AppMetadataCache.getAllAppInfo();
        allIdAppInfo = allAppInfo.values().stream().filter(appInfo -> appNums.contains(appInfo.getNumber())).collect(Collectors.toMap(AppInfo::getNumber, i -> i));
        return allIdAppInfo;
    }

    public static Map<String, List<AppMenuInfo>> getAppIdAndAllMenuByAppIds(Set<String> appIds) {
        return PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appIds, true);
    }

    public static Map<String, List<AppMenuInfo>> getAppIdAndAllMenuByAppIds(Set<String> appIds, boolean includeQingMenu) {
        return PortalAppMetaDataUtils.getAppIdAndAllMenuByAppIds(appIds, null, includeQingMenu);
    }

    public static Map<String, List<AppMenuInfo>> getAppIdAndAllMenuByAppIds(Set<String> appIds, Map<String, String> appNumAndIdMapParams, boolean includeQingMenu) {
        if (CollectionUtils.isEmpty(appIds)) {
            return new HashMap<String, List<AppMenuInfo>>(0);
        }
        Map<String, String> appNumAndIdMap = PortalAppMetaDataUtils.getAppNumAndIdMap(appIds, appNumAndIdMapParams);
        HashMap<String, List<AppMenuInfo>> result = new HashMap<String, List<AppMenuInfo>>(appNumAndIdMap.size());
        Map<String, List<AppMenuInfo>> qingMenuByAppIds = null;
        if (includeQingMenu) {
            qingMenuByAppIds = PortalAppMetaDataUtils.getQingMenuByAppIds(new ArrayList<String>(appNumAndIdMap.values()));
        }
        Map<String, List<AppMenuInfo>> allAppMenus = PortalAppMetaDataUtils.getAppMenusByAppNums(appNumAndIdMap.keySet());
        for (Map.Entry<String, String> appEntry : appNumAndIdMap.entrySet()) {
            String appNum = appEntry.getKey();
            String appId = appEntry.getValue();
            if (appIds.size() == 1) {
                if (qingMenuByAppIds != null && qingMenuByAppIds.size() > 0) {
                    result.put(appId, PortalAppMetaDataUtils.processQingAppMenuInfos(allAppMenus.get(appNum), qingMenuByAppIds.get(appNum)));
                    break;
                }
                result.put(appId, allAppMenus.get(appNum));
                break;
            }
            List<AppMenuInfo> appMenuInfos = allAppMenus.get(appNum);
            if (appMenuInfos == null) {
                appMenuInfos = new ArrayList<AppMenuInfo>();
            }
            ArrayList<AppMenuInfo> appMenuInfoList = new ArrayList<AppMenuInfo>(appMenuInfos);
            if (qingMenuByAppIds != null && qingMenuByAppIds.get(appNum) != null) {
                appMenuInfoList.addAll((Collection<AppMenuInfo>)qingMenuByAppIds.get(appNum));
            }
            result.put(appId, appMenuInfoList);
        }
        return result;
    }

    private static List<AppMenuInfo> processQingAppMenuInfos(List<AppMenuInfo> menusInfos, List<AppMenuInfo> qingMenuInfos) {
        ArrayList<AppMenuInfo> menuResult = new ArrayList<AppMenuInfo>(menusInfos);
        if (CollectionUtils.isEmpty(qingMenuInfos)) {
            return menuResult;
        }
        List helpMenuInfos = menuResult.stream().filter(menu -> menu.getId().endsWith("#hpce")).collect(Collectors.toList());
        menuResult.removeAll(helpMenuInfos);
        menuResult.addAll(qingMenuInfos);
        if (CollectionUtils.isNotEmpty(helpMenuInfos)) {
            menuResult.addAll(helpMenuInfos);
        }
        return menuResult;
    }

    private static Map<String, String> getAppNumAndIdMap(Set<String> appIds, Map<String, String> appNumAndIdMapParams) {
        if (appNumAndIdMapParams != null && !appNumAndIdMapParams.isEmpty()) {
            return appNumAndIdMapParams;
        }
        return PortalAppMetaDataUtils.getAppNumAndIdMap(appIds);
    }

    public static Map<String, String> getAppNumAndIdMap(Set<String> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return new HashMap<String, String>(0);
        }
        Map<String, String> appNumAndIdMap = new HashMap<String, String>(0);
        if (appIds.size() == 1) {
            String appId2 = new ArrayList<String>(appIds).get(0);
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId2);
                appNumAndIdMap.put(appInfo.getAppId(), appInfo.getId());
            }
            catch (Exception e) {
                logger.info("getAppInfo error", (Object)e);
            }
        } else {
            Map allAppInfo = AppMetadataCache.getAllAppInfo();
            Map<String, AppInfo> allIdAppInfo = allAppInfo.values().stream().collect(Collectors.toMap(AppInfo::getId, i -> i));
            appNumAndIdMap = appIds.stream().map(appId -> {
                AppInfo appInfo = (AppInfo)allAppInfo.get(appId);
                if (appInfo == null) {
                    appInfo = (AppInfo)allIdAppInfo.get(appId);
                }
                return appInfo;
            }).filter(Objects::nonNull).collect(Collectors.toMap(AppInfo::getNumber, AppInfo::getId));
        }
        return appNumAndIdMap;
    }

    private static Map<String, List<AppMenuInfo>> getAppMenusByAppNums(Set<String> appNums) {
        HashMap<String, List<AppMenuInfo>> appMenus = new HashMap<String, List<AppMenuInfo>>(0);
        if (CollectionUtils.isEmpty(appNums)) {
            return appMenus;
        }
        if (appNums.size() == 1) {
            String appId = new ArrayList<String>(appNums).get(0);
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
                List menusInfos = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
                appMenus.put(appInfo.getAppId(), menusInfos);
            }
            catch (Exception e) {
                logger.info("getAppInfo error", (Object)e);
            }
        } else {
            Map allAppMenus = AppMetadataCache.getAllAppMenus();
            appNums.forEach(appNum -> {
                List appMenuInfos = (List)allAppMenus.get(appNum);
                if (appMenuInfos != null) {
                    appMenus.put((String)appNum, appMenuInfos);
                }
            });
        }
        return appMenus;
    }

    public static Map<String, List<AppMenuInfo>> getQingMenuByAppIds(List<String> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return new HashMap<String, List<AppMenuInfo>>(0);
        }
        try {
            Class<?> qingAppMenuUtil = Class.forName("kd.bos.qing.plugin.appmenu.PublishedAppMenuUtil");
            List qingMenus = (List)MethodUtils.invokeStaticMethod(qingAppMenuUtil, (String)"getPublishedAppQingMenuListByAppIds", appIds);
            if (qingMenus != null) {
                logger.info("getQingMenuByAppIds:" + SerializationUtils.toJsonString(qingMenus));
                return qingMenus.stream().collect(Collectors.groupingBy(AppMenuInfo::getAppId));
            }
        }
        catch (Exception e) {
            logger.info("getQingMenuByAppIds--error", (Object)e);
        }
        return null;
    }
}

