/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.basmsg.api.MessageInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.DelTagsUtil;
import kd.bos.message.util.MsgCacheUtil;
import kd.bos.message.util.MsgSessionUtil;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.notification.IconType;
import kd.bos.notification.NotificationBody;
import kd.bos.notification.NotificationClientCache;
import kd.bos.notification.NotificationFormInfo;
import kd.bos.notification.NotificationLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.pushservice.PushMessagePublisher;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkInternal;

public class PortalMessageUtils {
    private static final String SHOW_TYPE = "showType";
    private static final String MSG_NOTICE_MODAL = "msg_notice_modal";
    private static Log logger = LogFactory.getLog(PortalMessageUtils.class);
    private static final String PORTAL_PROMOTE_MSG = "portal_promoteMsg";
    private static final Integer TIMEOUT = 5;
    private static final String CENTER = "1";
    private static final String FLOAT = "2";
    private static final String TOP = "11";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static ExecutorService execSer = ThreadPools.newCachedExecutorService((String)"promoteMsg_pool", (int)3, (int)10);

    private static Integer getTimeOut() {
        String tenantId = RequestContext.get().getTenantId();
        String timeout = SystemPropertyUtils.getProptyByTenant((String)"promotemsg.timeout", (String)tenantId);
        if (StringUtils.isNumeric((CharSequence)timeout)) {
            return Integer.valueOf(timeout);
        }
        return TIMEOUT;
    }

    private static boolean isReceiveMessage() {
        boolean isReceive = true;
        String tenantId = RequestContext.get().getTenantId();
        String isReceiveStr = SystemPropertyUtils.getProptyByTenant((String)"is_receive_operation_message", (String)tenantId);
        if (isReceiveStr != null && "false".equalsIgnoreCase(isReceiveStr.trim())) {
            isReceive = false;
        }
        return isReceive;
    }

    @SdkInternal
    public static void showActivityMessageAsync(String rootPageId, String appNum) {
        if (!PortalMessageUtils.isReceiveMessage()) {
            return;
        }
        if (rootPageId == null) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        String cacheData = MsgCacheUtil.getString((String)PortalMessageUtils.getCacheKey(userId, appNum));
        if (cacheData == null) {
            execSer.execute(() -> PortalMessageUtils.showActivityMessage(rootPageId, appNum));
        }
    }

    private static String getCacheKey(long userId, String appNum) {
        return "portal_promoteMsg_" + userId + "_" + appNum;
    }

    private static String getUrlKey(long msgId) {
        return "prompteUrl_" + msgId;
    }

    private static void showActivityMessage(String rootPageId, String appNum) {
        logger.debug(String.format("PortalMessageUtils--showActivityMessage, rootPageId:%s, appNum:%s", rootPageId, appNum));
        long userId = RequestContext.get().getCurrUserId();
        String cacheData = MsgCacheUtil.getString((String)PortalMessageUtils.getCacheKey(userId, appNum));
        if (cacheData != null) {
            return;
        }
        List activityMsgs = MessageCenterServiceHelper.getUnreadActivityMessageByAppNum((Long)userId, (String[])new String[]{appNum});
        if (!CollectionUtils.isEmpty((Collection)activityMsgs)) {
            logger.debug("PortalMessageUtils--getUnreadActivityMessageByAppNum" + SerializationUtils.toJsonString(activityMsgs));
            List<Map<String, Object>> modelMsg = activityMsgs.stream().filter(msg -> CENTER.equals(msg.get(SHOW_TYPE))).collect(Collectors.toList());
            PortalMessageUtils.showMessage(rootPageId, modelMsg, userId);
            List<Map<String, Object>> floatMsg = activityMsgs.stream().filter(msg -> FLOAT.equals(msg.get(SHOW_TYPE))).collect(Collectors.toList());
            PortalMessageUtils.showMessage(rootPageId, floatMsg, userId);
            List<Map<String, Object>> topMsg = activityMsgs.stream().filter(msg -> TOP.equals(msg.get(SHOW_TYPE))).collect(Collectors.toList());
            PortalMessageUtils.showMessage(rootPageId, topMsg, userId);
        }
        MsgCacheUtil.putCache((String)PortalMessageUtils.getCacheKey(userId, appNum), (String)"true", (int)PortalMessageUtils.getTimeOut(), (TimeUnit)TimeUnit.MINUTES);
    }

    private static void showMessage(String rootPageId, List<Map<String, Object>> msgList, Long userId) {
        String showType;
        Map<String, Object> msgMap;
        MessageInfo msgInfo;
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        if (msgList.size() > 1) {
            Collections.reverse(msgList);
        }
        if ((msgInfo = PortalMessageUtils.parseMsg(msgMap = msgList.get(0))) == null) {
            return;
        }
        switch (showType = msgInfo.getShowType()) {
            case "1": {
                PortalMessageUtils.showMessageModel(rootPageId, msgInfo, userId);
                break;
            }
            case "2": {
                PortalMessageUtils.showMessageFloat(rootPageId, msgInfo, userId);
                break;
            }
            case "11": {
                PortalMessageUtils.showMessageTop(rootPageId, msgInfo, userId);
                break;
            }
        }
        msgList.forEach(msg -> {
            Long msgId = Long.parseLong(msgMap.get("id").toString());
            MessageCenterServiceHelper.setMessagePopup((Long)msgId, Collections.singletonList(userId), (boolean)false);
        });
    }

    private static void showMessageModel(String rootPageId, MessageInfo msgInfo, Long userId) {
        long msgId = msgInfo.getId();
        String url = msgInfo.getUrl();
        FormShowParameter fsp2 = new FormShowParameter();
        fsp2.setFormId(MSG_NOTICE_MODAL);
        fsp2.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", msgInfo.getContent());
        map.put("title", msgInfo.getTitle());
        map.put("msgId", msgId);
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            map.put("url", url);
        }
        fsp2.setCustomParams(map);
        fsp2.setShowTitle(false);
        fsp2.setShowClose(false);
        Map config = FormConfigFactory.createConfig((FormShowParameter)fsp2);
        config.remove("watermark");
        String msg = MsgSessionUtil.buildWebSocketAction((String)"showForm", (Object)config);
        logger.debug(String.format("PortalMessageUtils--push userId:%s,msg:%s", userId, msg));
        PushMessage pushMessage = new PushMessage(PushMessageRange.RootPage, rootPageId, (Object)msg);
        PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
    }

    private static void showMessageFloat(String rootPageId, MessageInfo msgInfo, Long userId) {
        long msgId = msgInfo.getId();
        String title = msgInfo.getTitle();
        String content = msgInfo.getContent();
        int duration = msgInfo.getDuration();
        String url = msgInfo.getUrl();
        NotificationBody notificationBody = new NotificationBody();
        notificationBody.setAppId("bos");
        notificationBody.setTitle(title);
        notificationBody.setContent(DelTagsUtil.getTextFromHtml((String)content));
        notificationBody.setNotificationId(msgId + "");
        notificationBody.setIconType(IconType.Info.toString());
        notificationBody.setCreateTime(System.currentTimeMillis());
        notificationBody.setLevel(NotificationLevel.normal.getLevel());
        notificationBody.setClickClassName("kd.bos.message.op.MsgNoticeClick");
        NotificationBody.ButtonInfo detailButton = new NotificationBody.ButtonInfo();
        detailButton.setKey("detail");
        detailButton.setText(ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"PortalMessageUtils_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        notificationBody.addButtonInfo(detailButton);
        NotificationFormInfo notificationFormInfo = new NotificationFormInfo();
        notificationFormInfo.setNotification(notificationBody);
        notificationFormInfo.setDuration(duration);
        notificationFormInfo.setMsgType("activity");
        ArrayList<NotificationBody> msgList = new ArrayList<NotificationBody>();
        msgList.add(notificationBody);
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(16);
        data.put("notification", msgList);
        data.put("duration", Integer.valueOf(duration));
        NotificationClientCache.putNotificationFormInfo((String)(userId + ""), (String)notificationFormInfo.getNotification().getNotificationId(), (NotificationFormInfo)notificationFormInfo);
        String msg = MsgSessionUtil.buildWebSocketAction((String)"showNotification", data);
        logger.debug(String.format("PortalMessageUtils--push userId:%s,msg:%s", userId, msg));
        PushMessage pushMessage = new PushMessage(PushMessageRange.RootPage, rootPageId, (Object)msg);
        PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
        PortalMessageUtils.setUrlCache(msgId, url);
    }

    private static void showMessageTop(String rootPageId, MessageInfo msgInfo, Long userId) {
        long msgId = msgInfo.getId();
        String title = msgInfo.getTitle();
        String content = msgInfo.getContent();
        int duration = msgInfo.getDuration();
        String url = msgInfo.getUrl();
        NotificationBody notificationBody = new NotificationBody();
        notificationBody.setAppId("bos");
        notificationBody.setTitle(title);
        notificationBody.setContent(DelTagsUtil.getTextFromHtml((String)content));
        notificationBody.setNotificationId(msgId + "");
        notificationBody.setIconType(IconType.Info.toString());
        notificationBody.setLevel(NotificationLevel.important.getLevel());
        notificationBody.setDuration(duration);
        notificationBody.setClickClassName("kd.bos.message.op.MsgNoticeClick");
        NotificationBody.ButtonInfo detailButton = new NotificationBody.ButtonInfo();
        detailButton.setKey("detail");
        detailButton.setText(ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"PortalMessageUtils_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        notificationBody.addButtonInfo(detailButton);
        NotificationFormInfo notificationFormInfo = new NotificationFormInfo();
        notificationFormInfo.setNotification(notificationBody);
        ArrayList<NotificationBody> msgList = new ArrayList<NotificationBody>();
        msgList.add(notificationBody);
        HashMap<String, ArrayList<NotificationBody>> data = new HashMap<String, ArrayList<NotificationBody>>(16);
        data.put("notification", msgList);
        NotificationClientCache.putNotificationFormInfo((String)(userId + ""), (String)notificationFormInfo.getNotification().getNotificationId(), (NotificationFormInfo)notificationFormInfo);
        String msg = MsgSessionUtil.buildWebSocketAction((String)"showNotification", data);
        logger.debug(String.format("PortalMessageUtils--push userId:%s,msg:%s", userId, msg));
        PushMessage pushMessage = new PushMessage(PushMessageRange.RootPage, rootPageId, (Object)msg);
        PushMessagePublisher.sendPushMessage((PushMessage)pushMessage);
        PortalMessageUtils.setUrlCache(msgId, url);
    }

    private static MessageInfo parseMsg(Map<String, Object> msgMap) {
        logger.debug("PortalMessageUtils--parseMsg:" + SerializationUtils.toJsonString(msgMap));
        try {
            Object timeOut;
            Object url;
            Object content;
            Object title;
            Object showType;
            Object msgType;
            Object duration;
            MessageInfo msgInfo = new MessageInfo();
            Object id = msgMap.get("id");
            if (id != null) {
                msgInfo.setId(Long.parseLong(id.toString()));
            }
            if ((duration = msgMap.get("duration")) != null) {
                msgInfo.setDuration(Integer.parseInt(duration.toString()));
            }
            if ((msgType = msgMap.get("msgType")) != null) {
                msgInfo.setMsgType(msgType.toString());
            }
            if ((showType = msgMap.get(SHOW_TYPE)) != null) {
                msgInfo.setShowType(showType.toString());
            }
            if ((title = msgMap.get("title")) != null) {
                msgInfo.setTitle(title.toString());
            }
            if ((content = msgMap.get("content")) != null) {
                msgInfo.setContent(content.toString());
            }
            if ((url = msgMap.get("url")) != null) {
                msgInfo.setUrl(url.toString());
            }
            if ((timeOut = msgMap.get("timeOut")) != null) {
                msgInfo.setTimeOut(Long.parseLong(timeOut.toString()));
            }
            return msgInfo;
        }
        catch (Exception e) {
            logger.info("parseMsg error", (Object)e);
            return null;
        }
    }

    private static void setUrlCache(long msgId, String url) {
        String urlCache = MsgCacheUtil.getString((String)PortalMessageUtils.getUrlKey(msgId));
        if (urlCache == null) {
            logger.debug("PortalMessageUtils--msgId:" + msgId + "--url:" + url);
            MsgCacheUtil.putCache((String)PortalMessageUtils.getUrlKey(msgId), (String)url, (int)1, (TimeUnit)TimeUnit.DAYS);
        }
    }

    public static FormShowParameter createFormShowParameter(String title, String message) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(MSG_NOTICE_MODAL);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", message);
        map.put("title", title);
        fsp.setCustomParams(map);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(false);
        return fsp;
    }
}

