/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ShaSignUtils;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.AppPackageUtil;
import kd.bos.portal.util.AppUtils;
import kd.bos.portal.util.DevportalUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.DisCardUtil;

public class PortalSchemeExportUtils {
    private static Log logger = LogFactory.getLog(PortalSchemeExportUtils.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String LOCALPATH = System.getProperty("java.io.tmpdir") + File.separator + "KINGDEEDOWNLOAD";
    private static final String DATAMODEL = "datamodel";
    private static final String FILELIST_TXT = "filelist.txt";

    public static String exportScheme(Long[] pkKeys) {
        return PortalSchemeExportUtils.exportScheme(pkKeys, null);
    }

    public static String exportScheme(Long[] pkKeys, ExportProgress exportProgress) {
        int total = pkKeys.length;
        if (total == 0) {
            return "";
        }
        String defaultAppPackageName = "defaultAppPackage-dm";
        String defaultZipPath = LOCALPATH + File.separator + defaultAppPackageName + File.separator + ShaSignUtils.getSHA256StrJava1((String)UUID.randomUUID().toString());
        ArrayList<String> list = new ArrayList<String>(total);
        int serialNumSuffix = 1;
        for (int i = 0; i < total; ++i) {
            Long pkKey = pkKeys[i];
            String zipName = PortalSchemeExportUtils.getHomeSchemeZipName(pkKey, serialNumSuffix++);
            String defaultAppVersion = "1.5.0";
            String defaultAppPath = defaultZipPath + File.separator + DATAMODEL + File.separator + defaultAppVersion + File.separator + "main";
            list.add(zipName);
            PortalSchemeExportUtils.createZipFileToTemp(pkKey, zipName, defaultAppVersion, defaultZipPath, defaultAppPath);
            if (exportProgress == null) continue;
            exportProgress.feedbackProgress(total, i + 1);
        }
        DevportalUtil.zipFiles(list, defaultZipPath, defaultAppPackageName);
        return PortalSchemeExportUtils.createFileDownloadUrl(defaultZipPath, defaultAppPackageName);
    }

    private static String getHomeSchemeZipName(Long pKkEY, Integer serialNumSuffix) {
        String selectFields = "id,number,name,schemetype,bizapp";
        QFilter qId = new QFilter("id", "=", (Object)pKkEY);
        QFilter[] filters = new QFilter[]{qId};
        DynamicObject protalSchemaObject = BusinessDataServiceHelper.loadSingle((String)"portal_scheme", (String)selectFields, (QFilter[])filters);
        String zipName = protalSchemaObject.getString("name");
        return zipName + "_" + serialNumSuffix;
    }

    private static void createZipFileToTemp(Long pKkEY, String zipName, String defaultAppVersion, String defaultZipPath, String defaultAppPath) {
        String selectCloudNum = "cloudNum";
        String selectAppNum = "selectAppNum";
        String selectAppPath = defaultAppPath + File.separator + "package";
        ArrayList<String> sqlNameList = new ArrayList<String>();
        ArrayList<Long> listIds = new ArrayList<Long>(3);
        listIds.add(pKkEY);
        boolean hasXmlFlag = false;
        if (!listIds.isEmpty()) {
            hasXmlFlag = AppPackageUtil.exportPageScheme(listIds, selectAppPath, sqlNameList);
        }
        JSONArray dbschemaMsg = new JSONArray();
        JSONArray preinsdataMsg = new JSONArray();
        AppPackageUtil.createDataModelXML("", selectAppNum, selectCloudNum, defaultAppVersion, defaultZipPath);
        AppPackageUtil.createAppXML("", selectAppNum, selectAppPath, dbschemaMsg, preinsdataMsg, sqlNameList, hasXmlFlag);
        ArrayList<String> fileList = new ArrayList<String>();
        String datamodelPath = defaultZipPath + File.separator + DATAMODEL;
        DevportalUtil.recursiveFiles(datamodelPath, fileList);
        StringBuilder appRelPathBuilder = new StringBuilder();
        fileList.forEach(appSource -> {
            int datamodelIndex = appSource.indexOf(DATAMODEL);
            String appRelPath = appSource.substring(datamodelIndex + DATAMODEL.length());
            if (!appRelPath.endsWith(FILELIST_TXT)) {
                appRelPathBuilder.append(appRelPath).append(System.lineSeparator());
            }
        });
        String appInfoPath = datamodelPath + File.separator + FILELIST_TXT;
        AppPackageUtil.createLogInfo(defaultZipPath, appRelPathBuilder.toString(), appInfoPath);
        PortalSchemeExportUtils.createDMZip(defaultZipPath, selectAppPath, zipName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createFileDownloadUrl(String defaultZipPath, String defaultAppPackageName) {
        InputStream zipInput = null;
        InputStream input = null;
        try {
            String downloadPath = defaultZipPath + File.separator + defaultAppPackageName + ".zip";
            File downloadFile = new File(downloadPath);
            if (downloadFile.exists()) {
                input = new FileInputStream(downloadFile);
                byte[] b = new byte[input.available()];
                int len = input.read(b);
                BigDecimal zipBigDecimal = new BigDecimal(len);
                BigDecimal kbBigDecimal = new BigDecimal(1024);
                BigDecimal bigDecimal = zipBigDecimal.divide(kbBigDecimal);
            }
            zipInput = new FileInputStream(downloadPath);
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String dataFormat = sdf.format(date);
            String zipName = ResManager.loadKDString((String)"\u9996\u9875\u65b9\u6848", (String)"PortalSchemeExportTask_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(zipName + "-" + dataFormat + ".zip", zipInput, 5000);
            logger.info("createFileDownloadUrl:" + url);
            String string = url;
            return string;
        }
        catch (Exception e) {
            logger.info("createFileDownloadUrl error", (Object)e);
        }
        finally {
            if (zipInput != null) {
                try {
                    zipInput.close();
                }
                catch (IOException e) {
                    DisCardUtil.discard();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    DisCardUtil.discard();
                }
            }
            try {
                File zipFile = new File(defaultZipPath);
                if (zipFile.exists()) {
                    boolean delete;
                    AppUtils.deleteKd(zipFile);
                    String appNumberStr = LOCALPATH + File.separator + defaultAppPackageName;
                    File appNumberPath = new File(appNumberStr);
                    File[] files = appNumberPath.listFiles();
                    if ((files == null || files.length == 0) && (delete = appNumberPath.delete())) {
                        DisCardUtil.discard();
                    }
                }
            }
            catch (Exception ioExp) {
                logger.info("io error", (Object)ioExp);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDMZip(String defaultZipPath, String selectAppPath, String zipName) {
        AppPackageUtil.zipDMFile(defaultZipPath, zipName);
        String dmPath = defaultZipPath + File.separator + "dm" + File.separator + zipName + ".zip";
        InputStream appMD5Input = null;
        File selectAppFile = new File(selectAppPath);
        try {
            if (!selectAppFile.exists()) {
                selectAppFile.mkdirs();
            }
            appMD5Input = new FileInputStream(dmPath);
            if (selectAppFile.exists()) {
                AppUtils.deleteKd(selectAppFile);
            }
        }
        catch (Exception e) {
            logger.info("createDMZip error", (Object)e);
        }
        finally {
            if (appMD5Input != null) {
                try {
                    appMD5Input.close();
                }
                catch (Exception excepiton) {
                    logger.info("io error", (Object)excepiton);
                }
            }
        }
    }
}

