/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.portal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.param.CustomParam;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.model.AppSchemeType;
import kd.bos.portal.pluginnew.noCode.NoCodeAppUtils;
import kd.bos.portal.util.PersonalSchemaTemplateUtil;
import kd.bos.portal.util.TenantUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.license.LicenseGrayServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;

public class PortalUsableFuncUtil {
    private static final String USERCONFIGKEY = "appPersonalList";
    private static final String TENANTCONFIGKEY = "tenantPersonalList";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static Log logger = LogFactory.getLog(PortalUsableFuncUtil.class);
    private IFormView view = null;
    private static final String FINAL_FILTER_APP = "finalFilterApp";
    private static final String HAS_PERM_APP = "hasPermApp";
    private static final String SCHEME_APP_NUMANDNAME = "schemeAppNumAndName";

    public PortalUsableFuncUtil(Log logger) {
    }

    public PortalUsableFuncUtil(Log logger, IFormView view) {
        this(view);
    }

    public PortalUsableFuncUtil(IFormView view) {
        this.view = view;
    }

    public JSONArray getAllAppsInSystem() {
        JSONArray allAppsInSystem = BizAppServiceHelp.getAllAppInfo();
        if (this.logDebugOut()) {
            logger.info("PortalUsableFuncUtil--allApps:" + this.getAppIdsFormJsonArray(allAppsInSystem).toString());
        }
        this.addGrayValid(allAppsInSystem);
        return allAppsInSystem;
    }

    private void addGrayValid(JSONArray allApps) {
        Map allGrayCloudInfo = new HashMap();
        Map allGrayAppInfo = new HashMap();
        try {
            allGrayCloudInfo = LicenseGrayServiceHelper.getAllGrayCloudInfo();
            allGrayAppInfo = LicenseGrayServiceHelper.getAllGrayAppInfo();
        }
        catch (Exception e) {
            logger.info("getGrayInfo error", (Object)e);
            return;
        }
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            String valid;
            String cloudId;
            Map graCloudMap;
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            JSONObject cloudObj = (JSONObject)cloudAndApp.get(0);
            boolean isCloudGray = false;
            if (cloudObj != null && (graCloudMap = (Map)allGrayCloudInfo.get(cloudId = cloudObj.getString("id"))) != null && (valid = (String)graCloudMap.get("valid")) != null) {
                isCloudGray = true;
                cloudObj.put("grayValid", (Object)valid);
            }
            if (isCloudGray) continue;
            for (JSONObject cloudOrApp : cloudAndApp) {
                String valid2;
                String number;
                Map grayAppMap;
                if (cloudOrApp.get((Object)"iscloud") != null || (grayAppMap = (Map)allGrayAppInfo.get(number = cloudOrApp.getString("number"))) == null || (valid2 = (String)grayAppMap.get("valid")) == null) continue;
                cloudOrApp.put("grayValid", (Object)valid2);
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
    }

    private List<String> getAppIdsFormJsonArray(JSONArray allAppsInSystem) {
        return allAppsInSystem.stream().flatMap(x -> ((JSONArray)x).stream()).filter(a -> ((JSONObject)a).getBoolean("iscloud") == null).map(a -> ((JSONObject)a).getString("id")).collect(Collectors.toList());
    }

    private boolean logDebugOut() {
        try {
            CustomParam customParam = new CustomParam();
            customParam.getSearchKeySet().add("log_debug_out");
            Map map = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
            return map != null && map.get("log_debug_out") != null;
        }
        catch (Exception e) {
            logger.info("logDebugOut error", (Object)e);
            return true;
        }
    }

    @Deprecated
    public JSONArray getAppsAfterFilters(JSONArray allApps, boolean runtime) {
        return this.getAppsFilters(allApps, runtime, AppSchemeType.USERSCHEME);
    }

    public JSONArray getAppsFilters(boolean runtime, AppSchemeType appSchemeType) {
        JSONArray allApps = this.getAllAppsInSystem();
        return this.getAppsFilters(runtime, appSchemeType, allApps);
    }

    public JSONArray getAppsFilters(boolean runtime, AppSchemeType appSchemeType, JSONArray allApps) {
        Long userId = RequestContext.get().getCurrUserId();
        if (runtime && appSchemeType != null) {
            allApps = this.getApps(allApps, userId, appSchemeType);
        }
        allApps = this.getAppsAfterFilter(allApps, userId);
        return allApps;
    }

    public JSONArray getAppsFilters(JSONArray allApps, boolean runtime, AppSchemeType appSchemeType) {
        return this.getAppsFilters(runtime, appSchemeType, allApps);
    }

    public JSONArray getAppsAfterFilter(JSONArray allApps, Long userId) {
        this.addAppGroups(allApps, userId);
        this.filterLicenseBuyApps(allApps);
        this.filterByDisabledAppIds(allApps);
        this.filterPermApps(allApps, userId);
        this.filterAppsOther(allApps);
        return allApps;
    }

    private void filterPermApps(JSONArray allApps, Long userId) {
        Set appBlackSet;
        String userTypeInContext = RequestContext.get().getUserType();
        if (kd.bos.util.StringUtils.isEmpty((String)userTypeInContext)) {
            if (this.view != null) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u7c7b\u578b\u5931\u8d25", (String)"PortalUsableFuncUtil_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            return;
        }
        List userBizApps = PermissionServiceHelper.getUserBizApps((Long)userId);
        if (userBizApps == null || userBizApps.size() == 0) {
            if (this.view != null) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u6709\u6743\u9650\u7684\u5e94\u7528\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PortalUsableFuncUtil_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            return;
        }
        if (this.logDebugOut()) {
            logger.info("\u83b7\u53d6\u6709\u6743\u9650\u7684\u5e94\u7528\uff1a" + userBizApps.toString());
        }
        String[] userType = userTypeInContext.split(",");
        List<String> userTypeList = Stream.of(userType).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        Long cosmicUserId = 10L;
        if (PermissionServiceHelper.isAdminUser((long)userId) || userId.equals(cosmicUserId)) {
            userTypeList.add("1");
        }
        if (!CollectionUtils.isEmpty(userTypeList)) {
            logger.info("\u4eba\u5458\u7c7b\u578b\uff1a" + userTypeList.toString());
        }
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (userId.equals(cosmicUserId)) {
            isSuperAdmin = true;
        }
        if ((appBlackSet = PermissionServiceHelper.getAppBlackSet((Long)userId)) != null && appBlackSet.size() > 0) {
            logger.info("\u5168\u5458\u5e94\u7528\u9ed1\u540d\u5355\uff1a" + appBlackSet.toString());
        }
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                boolean result;
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null || !(result = this.isRemoveApp(cloudOrApp, appBlackSet, userBizApps, userTypeList, isSuperAdmin))) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
    }

    private boolean isRemoveApp(JSONObject appObject, Set<String> appBlackSet, List<String> userBizApps, List<String> userTypeList, boolean isSuperAdmin) {
        String appId = appObject.getString("id");
        if (appBlackSet != null && appBlackSet.contains(appId)) {
            return true;
        }
        String userType = appObject.getString("usertype");
        if (userType == null) {
            return true;
        }
        String allUserApp = appObject.getString("alluserapp");
        if (isSuperAdmin && Boolean.TRUE.toString().equals(allUserApp)) {
            return true;
        }
        if (!Boolean.TRUE.toString().equals(allUserApp) && userBizApps != null && !userBizApps.contains(appId)) {
            return true;
        }
        ArrayList<String> appUserTypeList = new ArrayList<String>(Arrays.asList(userType.split(",")));
        appUserTypeList.removeIf(StringUtils::isEmpty);
        userTypeList.removeIf(StringUtils::isEmpty);
        return Collections.disjoint(appUserTypeList, userTypeList);
    }

    private void addAppGroups(JSONArray allApps, Long userId) {
        List appGroups = AppGroupUtils.getAppGroups((long)userId);
        HashMap<String, Map> cloudAppMap = new HashMap<String, Map>(20);
        for (String appGroup : appGroups) {
            String cloudAppJsonStr = BizAppServiceHelp.getAppGroupAllAppInfo((String)appGroup);
            JSONArray cloudAppJson = JSONArray.parseArray((String)cloudAppJsonStr);
            for (Object appJson : cloudAppJson) {
                JSONObject jsob = (JSONObject)appJson;
                String id = jsob.getString("cloudid");
                Map appMap = cloudAppMap.computeIfAbsent(id, k -> new HashMap(20));
                appMap.put(jsob.getString("id"), jsob);
            }
        }
        if (this.logDebugOut()) {
            logger.info("PortalUsableFuncUtil--allGrayApps: " + SerializationUtils.toJsonString(cloudAppMap));
        }
        if (!cloudAppMap.isEmpty()) {
            for (JSONArray cloudAndApp : allApps) {
                Map cloudApp;
                String cloudId = "";
                for (JSONObject cloudOrApp : cloudAndApp) {
                    if (cloudOrApp.get((Object)"iscloud") != null) {
                        cloudId = cloudOrApp.getString("id");
                        continue;
                    }
                    if (cloudOrApp.get((Object)"iscloud") != null) continue;
                    String appId = cloudOrApp.getString("id");
                    String cloudid = cloudOrApp.getString("cloudid");
                    Map appMap = (Map)cloudAppMap.get(cloudid);
                    if (appMap == null) continue;
                    appMap.remove(appId);
                }
                if (!StringUtils.isNotBlank((CharSequence)cloudId) || (cloudApp = (Map)cloudAppMap.get(cloudId)) == null) continue;
                cloudAndApp.addAll(cloudApp.values());
            }
        }
    }

    private void filterByDisabledAppIds(JSONArray allApps) {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        if (CollectionUtils.isEmpty((Collection)disabledAppIds)) {
            return;
        }
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                String appId;
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null || !disabledAppIds.contains(appId = cloudOrApp.getString("id"))) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        if (this.logDebugOut()) {
            logger.info("PortalUsableFuncUtil--filterByDisabledAppIds:" + this.getAppIdsFormJsonArray(allApps).toString());
        }
    }

    public Set<String> getUserHasPerAppIds() {
        Map<String, String> appIdsWithCloud = this.getHasPerAppIdsWithCloud();
        if (appIdsWithCloud == null || appIdsWithCloud.size() == 0) {
            return null;
        }
        return appIdsWithCloud.keySet();
    }

    public Map<String, String> getHasPerAppIdsWithCloud() {
        JSONArray allApps = this.getUserHasPerAppWithCache();
        if (allApps == null || allApps.size() == 0) {
            return null;
        }
        HashMap<String, String> appMaps = new HashMap<String, String>(16);
        for (JSONArray cloudAndApp : allApps) {
            for (JSONObject cloudOrApp : cloudAndApp) {
                String id;
                if (cloudOrApp.get((Object)"iscloud") != null || !StringUtils.isNotBlank((CharSequence)(id = cloudOrApp.getString("id")))) continue;
                String cloudId = cloudOrApp.getString("cloudid");
                appMaps.put(id, cloudId);
            }
        }
        return appMaps;
    }

    public Set<String> getUserHasPerAppNumbers(JSONArray allApps) {
        if (allApps == null || allApps.size() == 0) {
            return null;
        }
        HashSet<String> appsSets = new HashSet<String>();
        for (JSONArray cloudAndApp : allApps) {
            for (JSONObject cloudOrApp : cloudAndApp) {
                String id;
                if (cloudOrApp.get((Object)"iscloud") != null || !StringUtils.isNotBlank((CharSequence)(id = cloudOrApp.getString("number")))) continue;
                appsSets.add(id);
            }
        }
        return appsSets;
    }

    public Set<String> getUserHasPerAppNumbers() {
        JSONArray allApps = this.getUserHasPerAppWithCache();
        if (allApps == null || allApps.size() == 0) {
            return null;
        }
        return this.getUserHasPerAppNumbers(allApps);
    }

    public JSONArray getUserHasPerApp() {
        JSONArray allApps = this.getAllAppsInSystem();
        Long userId = RequestContext.get().getCurrUserId();
        return this.getAppsAfterFilter(allApps, userId);
    }

    private JSONArray getApps(JSONArray allApps, Long userId, AppSchemeType appSchemeType) {
        PersonalSchemaTemplateUtil personalSchemaTemplateUtil = new PersonalSchemaTemplateUtil();
        String personalApps = UserConfigServiceHelper.getSetting((long)userId, (String)USERCONFIGKEY);
        if (StringUtils.isNotBlank((CharSequence)personalApps) && appSchemeType.getValue().equals(AppSchemeType.USERSCHEME.getValue())) {
            if (!personalApps.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
                return JSONArray.parseArray((String)personalApps);
            }
            long start = System.currentTimeMillis();
            String log = ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u65b9\u6848\u8017\u65f6 :", (String)"PortalUsableFuncUtil_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            JSONArray allPersonInfo = personalSchemaTemplateUtil.changePersonalSchemaInfoToJsonArray(allApps, personalApps);
            logger.debug(log + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
            return allPersonInfo;
        }
        String tenantApps = UserConfigServiceHelper.getSetting((long)0L, (String)TENANTCONFIGKEY);
        if ((appSchemeType.getValue().equals(AppSchemeType.USERSCHEME.getValue()) || appSchemeType.getValue().equals(AppSchemeType.DEFAULTSCHEME.getValue())) && StringUtils.isNotBlank((CharSequence)tenantApps)) {
            long start = System.currentTimeMillis();
            String log = ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848\u4e2a\u6027\u5316\u8017\u65f6 :", (String)"PortalUsableFuncUtil_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            JSONArray allPersonInfo = personalSchemaTemplateUtil.changePersonalSchemaInfoToJsonArray(allApps, tenantApps);
            logger.debug(log + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
            return allPersonInfo;
        }
        this.appSort(allApps);
        return allApps;
    }

    public void appSort(JSONArray allApps) {
        if (allApps == null) {
            return;
        }
        allApps.forEach(appsArray -> ((JSONArray)appsArray).sort((obj1, obj2) -> {
            int b;
            JSONObject o1 = (JSONObject)obj1;
            JSONObject o2 = (JSONObject)obj2;
            Boolean isCloud1 = o1.getBoolean("iscloud");
            if (isCloud1 != null && isCloud1.booleanValue()) {
                return 1;
            }
            Boolean isCloud2 = o2.getBoolean("iscloud");
            if (isCloud2 != null && isCloud2.booleanValue()) {
                return 1;
            }
            int a = o1.getInteger("seq");
            if (a > (b = o2.getInteger("seq").intValue())) {
                return 1;
            }
            if (a == b) {
                return 0;
            }
            return -1;
        }));
    }

    public JSONArray getFilterBySchemeApps(JSONArray allApps, Long userId, AppSchemeType appSchemeType) {
        return this.getApps(allApps, userId, appSchemeType);
    }

    private void filterLicenseBuyApps(JSONArray allApps) {
        boolean onlyShowBuyApp = false;
        try {
            SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            Object only_show_buy_app = systemParamService.loadPublicParameterFromCache("only_show_buy_app");
            if (only_show_buy_app != null && Boolean.parseBoolean(only_show_buy_app.toString())) {
                onlyShowBuyApp = true;
            }
        }
        catch (Exception e) {
            String errMsg = ResManager.loadKDString((String)"\u201c\u53ea\u663e\u793a\u8d2d\u4e70\u5e94\u7528\u201d\u53c2\u6570\u83b7\u53d6\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", (String)"PortalUsableFuncUtil_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            logger.info(errMsg, (Object)e);
        }
        if (!onlyShowBuyApp) {
            return;
        }
        Set apps = LicenseServiceHelper.getAvailableApps();
        if (apps == null || apps.size() == 0) {
            return;
        }
        logger.info("\u6839\u636e\u8bb8\u53ef\u83b7\u53d6\u5e94\u7528\uff1a" + apps.toString());
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                String appId;
                String isv;
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null || !"kingdee".equals(isv = cloudOrApp.getString("isv")) || apps.contains(appId = cloudOrApp.getString("id"))) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        if (this.logDebugOut()) {
            logger.info("PortalUsableFuncUtil--filterLicenseBuyApps:" + this.getAppIdsFormJsonArray(allApps).toString());
        }
    }

    private void filterAppsOther(JSONArray allApps) {
        String pubTenantType = LicenseServiceHelper.getPubTenantType();
        String env = ResManager.loadKDString((String)"\u83b7\u53d6\u73af\u5883\u662f\u516c\u6709\u4e91\u8fd8\u662f\u79c1\u6709\u4e91:", (String)"PortalUsableFuncUtil_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
        logger.debug(env + pubTenantType + ", isoemEnv:" + oemEnv);
        boolean isPublicEnv = Boolean.parseBoolean(pubTenantType);
        boolean isMaster = TenantUtils.isMasterTenant();
        boolean isTenantSystem = TenantUtils.isTenantSystem();
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        boolean isGalaxy = modelType == 2 || modelType == 4;
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONObject cloudObj;
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            if (oemEnv && (cloudObj = (JSONObject)cloudAndApp.get(0)) != null) {
                String cloudId = cloudObj.getString("id");
                String cloudICC = "0B+E5YAC2OJF";
                String cloudEIP = "TODW24AWKSU";
                String cloudDATA = "18Y35CVM2EDB";
                if (cloudICC.equalsIgnoreCase(cloudId) || cloudEIP.equalsIgnoreCase(cloudId) || cloudDATA.equalsIgnoreCase(cloudId)) {
                    iterAllApp.remove();
                    continue;
                }
            }
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null) continue;
                String number = cloudOrApp.getString("number");
                if (!isPublicEnv && "ladder".equals(number)) {
                    iterCloudAndApp.remove();
                    continue;
                }
                if (oemEnv && ("unit".equals(number) || "bal".equals(number) || "ais".equals(number) || "devgptas".equals(number))) {
                    iterCloudAndApp.remove();
                    continue;
                }
                if (isMaster || isTenantSystem || !"ctsy".equals(number)) continue;
                logger.debug("ctsy remove");
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        if (this.logDebugOut()) {
            logger.info("PortalUsableFuncUtil--filterAppsOther:" + this.getAppIdsFormJsonArray(allApps).toString());
        }
    }

    public JSONArray getAllAppsInSystem(boolean includNoCodeApp) {
        JSONArray allApps = this.getAllAppsInSystem();
        if (includNoCodeApp) {
            this.addNoCodeApps(allApps);
        }
        return allApps;
    }

    private void addNoCodeApps(JSONArray allApps) {
        if (allApps == null) {
            return;
        }
        JSONArray noCodeApps = NoCodeAppUtils.getNoCodeApps(RequestContext.get().getCurrUserId());
        if (noCodeApps != null) {
            allApps.add((Object)noCodeApps);
        }
    }

    public JSONArray getUserHasPerAppIncludNoCode() {
        JSONArray userHasPerApp = this.getUserHasPerAppWithCache();
        this.addNoCodeApps(userHasPerApp);
        return userHasPerApp;
    }

    public JSONArray getUserHasPerAppWithCache() {
        JSONArray userHasPerApp;
        String userAppCacheData = this.getFromMainViewPageCache(HAS_PERM_APP);
        if (StringUtils.isNotEmpty((CharSequence)userAppCacheData)) {
            userHasPerApp = JSONArray.parseArray((String)userAppCacheData);
        } else {
            JSONArray allApps = this.getAllAppsInSystem();
            userHasPerApp = this.getAppsAfterFilter(allApps, RequestContext.get().getCurrUserId());
            this.putMainViewPageCache(HAS_PERM_APP, userHasPerApp.toJSONString());
        }
        return userHasPerApp;
    }

    public JSONArray getFilterBySchemeAppsWithCache() {
        JSONArray filterBySchemeApps;
        JSONArray finalFilterApp;
        String myAppCache = this.getFromMainViewPageCache(FINAL_FILTER_APP);
        if (StringUtils.isNotEmpty((CharSequence)myAppCache)) {
            return JSONArray.parseArray((String)myAppCache);
        }
        JSONArray allApps = this.getAllAppsInSystem();
        if (allApps == null || allApps.size() == 0) {
            return null;
        }
        JSONArray hasPerApps = this.getUserHasPerAppWithCache();
        JSONArray noCodeApps = NoCodeAppUtils.getNoCodeApps(RequestContext.get().getCurrUserId());
        if (noCodeApps != null) {
            allApps.add((Object)noCodeApps);
            hasPerApps.add((Object)noCodeApps);
        }
        if ((finalFilterApp = this.getFilterApps(filterBySchemeApps = this.getApps(allApps, RequestContext.get().getCurrUserId(), AppSchemeType.USERSCHEME), hasPerApps)) != null) {
            this.putMainViewPageCache(FINAL_FILTER_APP, finalFilterApp.toJSONString());
        }
        return finalFilterApp;
    }

    public Map<String, Object> getSchemeAppNumAndNameMap() {
        String myAppMapCache = this.getFromMainViewPageCache(SCHEME_APP_NUMANDNAME);
        if (StringUtils.isNotEmpty((CharSequence)myAppMapCache)) {
            return (Map)SerializationUtils.fromJsonString((String)myAppMapCache, Map.class);
        }
        JSONArray schemeApps = this.getFilterBySchemeAppsWithCache();
        HashMap<String, Object> appMap = new HashMap<String, Object>(0);
        for (JSONArray cloudAndApp : schemeApps) {
            for (JSONObject cloudOrApp : cloudAndApp) {
                String number;
                if (cloudOrApp.get((Object)"iscloud") != null || (number = cloudOrApp.getString("number")) == null) continue;
                Object name = cloudOrApp.get((Object)"name");
                appMap.put(number, name);
            }
        }
        this.putMainViewPageCache(SCHEME_APP_NUMANDNAME, SerializationUtils.toJsonString(appMap));
        return appMap;
    }

    public String getAppSelfName(String appNum) {
        Map<String, Object> schemeAppNumAndNameMap = this.getSchemeAppNumAndNameMap();
        Object name = schemeAppNumAndNameMap.get(appNum);
        if (name == null) {
            return null;
        }
        String localName = JSONArray.toJSONString((Object)name);
        try {
            LocaleString localeString = (LocaleString)SerializationUtils.fromJsonString((String)localName, LocaleString.class);
            localName = localeString.getLocaleValue();
        }
        catch (Exception e) {
            return localName;
        }
        return localName;
    }

    private JSONArray getFilterApps(JSONArray filterBySchemeApps, JSONArray hasPerApps) {
        String openType;
        String id;
        if (filterBySchemeApps == null || filterBySchemeApps.size() == 0) {
            return hasPerApps;
        }
        if (hasPerApps == null || hasPerApps.size() == 0) {
            return null;
        }
        HashMap<String, String> appsMap = new HashMap<String, String>();
        for (JSONArray cloudAndApp : hasPerApps) {
            for (JSONObject cloudOrApp : cloudAndApp) {
                if (cloudOrApp.get((Object)"iscloud") != null || !StringUtils.isNotBlank((CharSequence)(id = cloudOrApp.getString("id")))) continue;
                openType = cloudOrApp.getString("opentype");
                appsMap.put(id, openType);
            }
        }
        Iterator iterAllApp = filterBySchemeApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp;
            cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                JSONObject cloudOrApp;
                cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null) continue;
                id = cloudOrApp.getString("id");
                if (StringUtils.isNotBlank((CharSequence)id) && !appsMap.containsKey(id)) {
                    iterCloudAndApp.remove();
                    continue;
                }
                openType = cloudOrApp.getString("opentype");
                if (!StringUtils.isEmpty((CharSequence)openType)) continue;
                cloudOrApp.put("opentype", appsMap.get(id));
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        return filterBySchemeApps;
    }

    public void removePageCache() {
        this.removeFromMainViewPageCache(FINAL_FILTER_APP);
        this.removeFromMainViewPageCache(SCHEME_APP_NUMANDNAME);
    }

    private String getFromMainViewPageCache(String key) {
        try {
            IPageCache pageCache = this.view.getMainView().getPageCache();
            return pageCache.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void putMainViewPageCache(String key, String value) {
        try {
            IPageCache pageCache = this.view.getMainView().getPageCache();
            pageCache.put(key, value);
        }
        catch (Exception e) {
            logger.info("putMainViewPageCache fail", (Object)e);
        }
    }

    private void removeFromMainViewPageCache(String key) {
        try {
            IPageCache pageCache = this.view.getMainView().getPageCache();
            pageCache.remove(key);
        }
        catch (Exception e) {
            logger.info("removeFromMainViewPageCache fail", (Object)e);
        }
    }
}

