/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.shortcut;

import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.operation.OperationTypeLoader;
import kd.bos.portal.util.SerializationUtils;

public class OperationTypeSelectPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String KEY_ENTRY = "entryentity";
    private static final String KEY_SEQ = "fid";
    private static final String KEY_OP_TYPE_ID = "ftype";
    private static final String KEY_NAME = "fname";
    private static final String KEY_DESC = "fcode";
    private static final String ROWNUM = "rownum";
    private static final String[] entityOpParams = new String[]{"fvalidruledes", "fservice", "fserviceplugin", "fservicedesc"};
    protected static final String OPERATION_TYPES_NAME_LANG = "operation_types_name_lang";
    protected static final String OPERATION_TYPES_DESC_LANG = "operation_types_desc_lang";
    private static final String OPERATION_TYPES_LANG = "operation_types_lang";

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("EntryEntity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        OperationTypes opTypes = OperationTypeLoader.loadAll();
        opTypes.getOpTypes().sort(new Comparator<OperationType>(){

            @Override
            public int compare(OperationType o1, OperationType o2) {
                return Long.compare(o1.getSeq(), o2.getSeq());
            }
        });
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY);
        if (rowCount < opTypes.getOpTypes().size()) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRY, opTypes.getOpTypes().size() - rowCount);
        }
        HashMap values = new HashMap(2);
        HashMap<Long, LocaleString> langNameMap = new HashMap<Long, LocaleString>(opTypes.getOpTypes().size());
        HashMap<Long, LocaleString> langDescMap = new HashMap<Long, LocaleString>(opTypes.getOpTypes().size());
        for (int i = 0; i < opTypes.getOpTypes().size(); ++i) {
            OperationType opType = (OperationType)opTypes.getOpTypes().get(i);
            this.getModel().setValue(KEY_SEQ, (Object)opType.getSeq(), i);
            this.getModel().setValue(KEY_OP_TYPE_ID, (Object)opType.getId(), i);
            this.getModel().setValue(KEY_NAME, (Object)opType.getName().toString(), i);
            this.getModel().setValue(KEY_DESC, (Object)(opType.getDesc() == null ? opType.getName().toString() : opType.getDesc().toString()), i);
            langNameMap.put(opType.getSeq(), opType.getName());
            langDescMap.put(opType.getSeq(), opType.getDesc() == null ? opType.getName() : opType.getDesc());
        }
        values.put(OPERATION_TYPES_NAME_LANG, langNameMap);
        values.put(OPERATION_TYPES_DESC_LANG, langDescMap);
        this.getPageCache().putBigObject(OPERATION_TYPES_LANG, SerializationUtils.toJsonString(values));
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map params = fsp.getCustomParams();
        if (params != null) {
            Map map = params;
            this.getModel().setValue(ROWNUM, map.get(ROWNUM));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRY);
        int rowKey = grid.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        if (rowKey >= 0) {
            HashMap<String, Object> op = new HashMap<String, Object>();
            op.put("FCode", model.getValue(KEY_DESC, rowKey));
            op.put("FName", model.getValue(KEY_NAME, rowKey));
            op.put("FType", model.getValue(KEY_OP_TYPE_ID, rowKey));
            op.put(ROWNUM, this.getModel().getValue(ROWNUM));
            this.getMultiLang(model, op);
            this.getView().returnDataToParent(op);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c", (String)"OperationTypeSelectPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    private void getMultiLang(IDataModel model, Map<String, Object> op) {
        String bigObject = this.getPageCache().getBigObject(OPERATION_TYPES_LANG);
        Map mapValue = (Map)SerializationUtils.fromJsonString(bigObject, Map.class);
        Map descMapValue = (Map)mapValue.get(OPERATION_TYPES_DESC_LANG);
        Map nameMapValue = (Map)mapValue.get(OPERATION_TYPES_NAME_LANG);
        Map descMap = (Map)descMapValue.get(model.getValue(KEY_SEQ));
        Map nameMap = (Map)nameMapValue.get(model.getValue(KEY_SEQ));
        op.put(OPERATION_TYPES_DESC_LANG, SerializationUtils.toJsonString(descMap));
        op.put(OPERATION_TYPES_NAME_LANG, SerializationUtils.toJsonString(nameMap));
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.returnDataToParent();
        this.getView().close();
    }
}

