/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.shortcut;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.portal.service.impl.PortalParamServiceImpl;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ShortcutsFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener,
CellClickListener {
    private static final String ROWNUM = "rownum";
    private static final String KEYID = "keyid";
    public static final String SELECT_OPERATE_TYPE = "selectOperateType";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        PermCommonUtil.showMesIfUserIsNotAdmin((PreOpenFormEventArgs)e);
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        TextEdit textEdit = (TextEdit)this.getView().getControl("operationtype");
        textEdit.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.fillData(this.loadDataFromDB());
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    private DynamicObject[] loadDataFromDB() {
        return this.loadDataFromDB(null);
    }

    private DynamicObject[] loadDataFromDB(QFilter[] qFilters) {
        return BusinessDataServiceHelper.load((String)"bd_shortcuts", (String)"id,operationnum,type,shortcut,defaultshortcut,opinstructions,keycode,modifier,createdate,modifydate,issystem,operationtype,defaultkeycode,mulilang_type,mulilang_des", (QFilter[])qFilters, (String)"createdate");
    }

    private void fillData(DynamicObject[] dynamicObjects) {
        IDataModel model = this.getModel();
        if (dynamicObjects.length == 0) {
            return;
        }
        for (int i = 0; i < dynamicObjects.length; ++i) {
            DynamicObject object = dynamicObjects[i];
            int newEntryRow = model.createNewEntryRow("entryentity");
            this.getModel().beginInit();
            model.setValue("operationnum", object.get("operationnum"), newEntryRow);
            model.setValue("operationtype", object.get("operationtype"), newEntryRow);
            model.setValue("type", object.get("type"), newEntryRow);
            model.setValue(KEYID, object.get("id"), newEntryRow);
            model.setValue("mulilang_type", object.get("mulilang_type"), newEntryRow);
            model.setValue("mulilang_des", object.get("mulilang_des"), newEntryRow);
            if (object.get("shortcut").equals(object.get("defaultshortcut"))) {
                model.setValue("shortcut", object.get("defaultshortcut"), newEntryRow);
            } else {
                model.setValue("shortcut", object.get("shortcut"), newEntryRow);
            }
            if (object.get("modifier") != null) {
                model.setValue("modifier", object.get("modifier"), newEntryRow);
            } else {
                model.setValue("modifier", null, newEntryRow);
            }
            if (object.get("keycode") != null) {
                model.setValue("keycode", object.get("keycode"), newEntryRow);
            }
            model.setValue("opinstructions", object.get("opinstructions"), newEntryRow);
            if (object.get("modifydate") != null) {
                model.setValue("modifydate", object.get("modifydate"), newEntryRow);
            } else {
                model.setValue("modifydate", null, newEntryRow);
            }
            model.setValue("issystem", object.get("issystem"), newEntryRow);
            if ("true".equals(object.get("issystem").toString())) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"operationnum"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"operationtype"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"type"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"opinstructions"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"mulilang_des"});
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"mulilang_type"});
            }
            this.getModel().endInit();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String itemkey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (itemkey) {
            case "btn_save": {
                this.saveData();
                this.updateShortCutSetting();
                break;
            }
            case "btn_reset": {
                this.resetTipMessage();
                break;
            }
            case "btn_close": {
                this.closeTipMessage();
                break;
            }
            case "btn_adadvance": {
                this.showAdvanceSettingForm();
                break;
            }
            case "baritemap_del": {
                break;
            }
        }
    }

    public void cellClick(CellClickEvent evt) {
        DynamicObject dynamicObject;
        Integer row = evt.getRow();
        if ("shortcut".equals(evt.getFieldKey())) {
            DynamicObject dynamicObject2 = this.getModel().getEntryRowEntity("entryentity", row.intValue());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_shortcut_quickinput");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("name", dynamicObject2.get("shortcut"));
            params.put("info", dynamicObject2.get("keycode"));
            params.put(KEYID, dynamicObject2.get(KEYID));
            params.put(ROWNUM, row);
            formShowParameter.setCustomParams(params);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bos_shortcut_quickinput"));
            this.getView().showForm(formShowParameter);
        } else if ("operationtype".equalsIgnoreCase(evt.getFieldKey()) && !ObjectUtils.isEmpty((Object)(dynamicObject = this.getModel().getEntryRowEntity("entryentity", row.intValue()))) && !"true".equals(dynamicObject.get("issystem").toString())) {
            this.selectOperateType(row);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        block8: {
            super.closedCallBack(e);
            String actionId = e.getActionId();
            Map values = (Map)e.getReturnData();
            if ("bos_shortcut_quickinput".equals(actionId)) {
                try {
                    if (values == null || ObjectUtils.isEmpty(values.get(ROWNUM))) break block8;
                    Integer row = Integer.parseInt(values.get(ROWNUM).toString());
                    this.getModel().setValue("shortcut", (Object)values.get("name").toString(), row.intValue());
                    if (!ObjectUtils.isEmpty(values.get("info"))) {
                        this.getModel().setValue("keycode", (Object)JSONUtils.toString(values.get("info")), row.intValue());
                    }
                }
                catch (IOException row) {}
            } else if (SELECT_OPERATE_TYPE.equalsIgnoreCase(actionId) && values != null) {
                Integer row = Integer.parseInt(values.get(ROWNUM).toString());
                this.getModel().setValue("operationnum", (Object)values.get("FType").toString(), row.intValue());
                this.getModel().setValue("operationtype", (Object)values.get("FType").toString(), row.intValue());
                this.getModel().setValue("opinstructions", (Object)values.get("FCode").toString(), row.intValue());
                this.getModel().setValue("type", (Object)values.get("FName").toString(), row.intValue());
                Map o = (Map)SerializationUtils.fromJsonString((String)values.get("operation_types_name_lang"), Map.class);
                LocaleString nameLocaleString = new LocaleString();
                for (Map.Entry entry : o.entrySet()) {
                    nameLocaleString.setItem((String)entry.getKey(), entry.getValue());
                }
                Map o1 = (Map)SerializationUtils.fromJsonString((String)values.get("operation_types_desc_lang"), Map.class);
                LocaleString descLocaleString = new LocaleString();
                for (Map.Entry entry : o1.entrySet()) {
                    descLocaleString.setItem((String)entry.getKey(), entry.getValue());
                }
                this.getModel().setValue("mulilang_type", (Object)nameLocaleString, row.intValue());
                this.getModel().setValue("mulilang_des", (Object)descLocaleString, row.intValue());
            }
        }
    }

    @Deprecated
    public void saveDataToDB() {
    }

    public void saveData() {
        String ids;
        Object[] data;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List insertRowsList = entryEntity.getInsertRows();
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(8);
        ArrayList<String> typeList = new ArrayList<String>(8);
        for (DynamicObject dynamicObject : insertRowsList) {
            if (StringUtils.isEmpty((String)dynamicObject.getString("operationnum"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ShortcutsFromPlugin_8", (String)"bos-portal-plugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder stringBuilder = new StringBuilder(dynamicObject.getString("operationtype")).append(dynamicObject.getString("operationnum"));
            if (typeList.contains(stringBuilder.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7c7b\u578b\u7f16\u7801\u201d\u3001\u201c\u64cd\u4f5c\u7f16\u7801\u201d\u7ec4\u5408\u503c\u4e0d\u53ef\u91cd\u590d\u3002", (String)"ShortcutsFromPlugin_10", (String)"bos-portal-plugin", (Object[])new Object[0]));
                return;
            }
            if (ObjectUtils.isEmpty((Object)dynamicObject.get(KEYID))) {
                saveData.add(dynamicObject);
            } else {
                updateData.add(dynamicObject);
            }
            typeList.add(stringBuilder.toString());
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_shortcuts");
        if (!ObjectUtils.isEmpty(saveData)) {
            data = this.wrapData(saveData, "1");
            SaveServiceHelper.save((IDataEntityType)mainEntityType, (Object[])data);
        }
        if (!ObjectUtils.isEmpty(updateData)) {
            data = this.wrapData(updateData, "2");
            SaveServiceHelper.save((DynamicObject[])data);
        }
        if (!ObjectUtils.isEmpty((Object)(ids = this.getView().getPageCache().get("shortCutId")))) {
            DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])ids.split(","));
            this.getView().getPageCache().remove("shortCutId");
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ShortcutsFromPlugin_3", (String)"bos-portal-plugin", (Object[])new Object[0]));
        this.refresh(this.loadDataFromDB());
    }

    private DynamicObject[] wrapData(List<DynamicObject> dataEntities, String optionType) {
        DynamicObject[] data = new DynamicObject[dataEntities.size()];
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(16);
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bd_shortcuts");
        if ("2".equals(optionType)) {
            DynamicObject[] col;
            ArrayList pks = new ArrayList(dataEntities.size());
            dataEntities.forEach(entity -> pks.add(entity.getLong(KEYID)));
            for (DynamicObject dynamicObject : col = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)dyn.getDynamicObjectType())) {
                map.put(dynamicObject.getPkValue(), dynamicObject);
            }
        }
        for (int i = 0; i < dataEntities.size(); ++i) {
            DynamicObject dynamicObject = dataEntities.get(i);
            dyn = "2".equals(optionType) ? (DynamicObject)map.get(dynamicObject.getLong(KEYID)) : BusinessDataServiceHelper.newDynamicObject((String)"bd_shortcuts");
            dyn.set("operationnum", dynamicObject.get("operationnum"));
            dyn.set("type", dynamicObject.get("type"));
            dyn.set("shortcut", dynamicObject.get("shortcut"));
            dyn.set("opinstructions", dynamicObject.get("opinstructions"));
            dyn.set("keycode", dynamicObject.get("keycode"));
            dyn.set("operationtype", dynamicObject.get("operationtype"));
            dyn.set("mulilang_type", dynamicObject.get("mulilang_type"));
            dyn.set("mulilang_des", dynamicObject.get("mulilang_des"));
            data[i] = dyn;
        }
        return data;
    }

    private void resetTipMessage() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u6062\u590d\u9ed8\u8ba4\u5417\uff1f", (String)"ShortcutsFromPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("continue_reset", (IFormPlugin)this));
    }

    private void closeTipMessage() {
        if (this.getModel().getDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u6539\u53d8\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"ShortcutsFromPlugin_2", (String)"bos-portal-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("continue_close", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    private void showAdvanceSettingForm() {
        FormShowParameter ShowParameter = new FormShowParameter();
        ShowParameter.setFormId("bos_advancesetting");
        ShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(ShowParameter);
    }

    private void resetDBData() {
        DynamicObject[] dynamicObjects = this.loadDataFromDB(new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        boolean flag = false;
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.get("shortcut").equals(dynamicObject.get("defaultshortcut"))) continue;
            dynamicObject.set("shortcut", dynamicObject.get("defaultshortcut"));
            dynamicObject.set("keycode", dynamicObject.get("defaultkeycode"));
            flag = true;
        }
        if (flag) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            this.refresh(this.loadDataFromDB());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6062\u590d\u9ed8\u8ba4\u6570\u636e\u6210\u529f\u3002", (String)"ShortcutsFromPlugin_4", (String)"bos-portal-plugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("continue_reset".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.resetDBData();
            this.updateShortCutSetting();
        }
        if ("continue_close".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
        if (!"continue_del".equals(callBackId) || messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            // empty if block
        }
    }

    public void registerListener(EventObject e) {
        Search searchap = (Search)this.getControl("searchap");
        searchap.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void search(SearchEnterEvent search) {
        String searchText = search.getText();
        if (searchText == null) {
            return;
        }
        QFilter qFilter = new QFilter("operationnum", "ftlike", (Object)searchText);
        QFilter qFilter1 = new QFilter("shortcut", "ftlike", (Object)searchText);
        QFilter qFilter2 = new QFilter("opinstructions", "ftlike", (Object)searchText);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_shortcuts", (String)"id,operationnum,type,shortcut,defaultshortcut,opinstructions,keycode,modifier,createdate,modifydate,issystem,operationtype,defaultkeycode,mulilang_type,mulilang_des", (QFilter[])new QFilter[]{qFilter.or(qFilter1).or(qFilter2)}, (String)"createdate");
        this.refresh(dynamicObjects);
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        return null;
    }

    public List<Object> getComPlexSearchList(SearchEnterEvent evt) {
        return null;
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("entryentity".equals(entryGrid.getKey())) {
            Integer row = evt.getRow();
            this.getView().getPageCache().put("selectRow", row.toString());
        }
    }

    private void selectOperateType(Integer row) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("bos_operationtypeselect");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_OPERATE_TYPE));
        HashMap<String, Integer> params = new HashMap<String, Integer>(8);
        params.put(ROWNUM, row);
        parameter.setCustomParams(params);
        this.getView().showForm(parameter);
    }

    private void refresh(DynamicObject[] dynamicObjects) {
        this.getModel().deleteEntryData("entryentity");
        this.fillData(dynamicObjects);
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] row = e.getRowIndexs();
        if (row == null || row.length < 1) {
            e.setCancel(false);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u5220\u9664\u7684\u6570\u636e\u3002", (String)"ShortcutsFromPlugin_7", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return;
        }
        for (int selectRow : row) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", selectRow);
            if (ObjectUtils.isEmpty((Object)dynamicObject) || ObjectUtils.isEmpty((Object)dynamicObject.get(KEYID))) continue;
            Object id = dynamicObject.get(KEYID);
            if ("true".equals(dynamicObject.getString("issystem"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8bbe\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ShortcutsFromPlugin_5", (String)"bos-portal-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            StringBuilder ids = new StringBuilder();
            if (!ObjectUtils.isEmpty((Object)this.getView().getPageCache().get("shortCutId"))) {
                ids.append(this.getView().getPageCache().get("shortCutId")).append(",").append(id);
            } else {
                ids.append(id);
            }
            this.getView().getPageCache().put("shortCutId", ids.toString());
        }
    }

    private void updateShortCutSetting() {
        PortalParamServiceImpl portalParamService = new PortalParamServiceImpl();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        JSONObject result = portalParamService.loadShortcutsBasedata();
        if (null != result) {
            proxy.addAction("updateShortCutSetting", result.get("btnSetting"));
        }
    }
}

