/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.smc.evaluation.plugin;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.IFrame;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class PortalSatisfyEvaluationPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(PortalSatisfyEvaluationPlugin.class);
    private static List<String> tabap = Stream.of("tabpageap", "appbeta", "yzjportal", "tabpagemessage").collect(Collectors.toCollection(ArrayList::new));
    private static final String COSMIC_EVALUATION_URL = "https://robert.kingdee.com/linkceo-api/evaluation-invoke?source=ProductUseCQ";
    private static final String CCS_EVALUATION_URL = "https://robert.kingdee.com/linkceo-api/evaluation-invoke?source=ProductUseXH";

    private static String getCosmicUrl() {
        String value = SystemPropertyUtils.getProptyByTenant((String)"cosmic.evaluation.url", (String)RequestContext.get().getTenantId());
        return value == null ? COSMIC_EVALUATION_URL : value;
    }

    private static String getCcsUrl() {
        String value = SystemPropertyUtils.getProptyByTenant((String)"ccs.evaluation.url", (String)RequestContext.get().getTenantId());
        return value == null ? CCS_EVALUATION_URL : value;
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, String> paramMap;
        String url;
        String formId;
        IFormView mainView = this.getView().getMainView();
        if (mainView == null) {
            String rootPageId = this.getView().getFormShowParameter().getRootPageId();
            IFormView rootView = SessionManager.getCurrent().getView(rootPageId);
            mainView = rootView.getParentView();
            if (mainView == null) {
                mainView = rootView;
            }
        }
        if ("pc_main_console".equals(formId = mainView.getFormShowParameter().getFormId()) || "home_page".equals(formId)) {
            url = PortalSatisfyEvaluationPlugin.getCcsUrl();
            paramMap = this.getParamMap(mainView);
        } else {
            url = PortalSatisfyEvaluationPlugin.getCosmicUrl();
            paramMap = this.getParamMap("", formId, this.getProdVersion("cosmic_bos"));
        }
        String urlParam = this.getUrlParamsByMap(paramMap);
        try {
            url = url + "&customize=" + URLEncoder.encode(urlParam, StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            logger.info("PortalSatisfyEvaluation url encode error", (Object)ex);
        }
        IFrame iFrame = (IFrame)this.getControl("evaluationiframe");
        iFrame.setSrc(url);
    }

    private Map<String, String> getParamMap(String appId, String formId, String version) {
        HashMap<String, String> custMap = new HashMap<String, String>();
        String uid = RequestContext.get().getUid();
        custMap.put("customerId", uid);
        custMap.put("prodInstance", this.getProdInstance());
        custMap.put("appId", appId);
        custMap.put("entityId", formId);
        custMap.put("prodVersion", version);
        return custMap;
    }

    private Map<String, String> getParamMap(IFormView mainView) {
        Tab t = (Tab)mainView.getControl("tabap");
        String currentTab = t.getCurrentTab();
        String formId = "";
        String appId = "";
        if (tabap.contains(currentTab)) {
            formId = mainView.getEntityId();
        } else {
            IFormView view = this.getView().getViewNoPlugin(currentTab);
            Tab submaintab = (Tab)view.getControl("_submaintab_");
            if (submaintab != null) {
                FormShowParameter showPara;
                String pageId = submaintab.getCurrentTab();
                appId = view.getFormShowParameter().getAppId();
                formId = "appmiantab".equals(pageId) ? view.getEntityId() : ((showPara = SessionManager.getCurrent().getFormShowParameter(pageId)) instanceof ListShowParameter ? ((ListShowParameter)showPara).getBillFormId() : showPara.getFormId());
            }
        }
        return this.getParamMap(appId, formId, this.getProdVersion("constellation_"));
    }

    private String getProdVersion(String product) {
        String prodVersion = null;
        List<Version> versions = VersionService.getVersionInfos();
        Optional<String> productVersion = versions.stream().filter(version -> version.getProductNumber().startsWith(product)).map(Version::getVersion).findFirst();
        if (productVersion.isPresent()) {
            prodVersion = "V" + productVersion.get();
        }
        return prodVersion;
    }

    private String getProdInstance() {
        Map productInfo = LicenseServiceHelper.getProductInfo();
        if (productInfo == null) {
            return null;
        }
        return (String)productInfo.get("prodInstCode");
    }

    private String getUrlParamsByMap(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = StringUtils.substringBeforeLast((String)s, (String)"&");
        }
        return s;
    }
}

