/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.smc.user.mq;

import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.mq.onlineUser.MqSessionInfo;
import kd.bos.login.mq.onlineUser.SessionHistoryDTO;
import kd.bos.login.utils.JSONUtils;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.smc.user.service.IUserService;
import kd.bos.smc.user.service.impl.UserServiceImpl;
import kd.bos.util.StringUtils;

public class OnlineMaxNumberConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(OnlineMaxNumberConsumer.class);
    public static final String ONLINE_NUM_MAX_ANY = "svc:login:onlineUserNum:any";
    public static final String ONLINE_NUM_MAX_WEB = "svc:login:onlineUserNum:web";
    public static final String ONLINE_NUM_MAX_MOBILE = "svc:login:onlineUserNum:mobile";
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion", new DistributeCacheHAPolicy(true, true));
    private static final IUserService userService = new UserServiceImpl();

    public void onMessage(Object body, String messageId, boolean b, MessageAcker acker) {
        try {
            String historyDTOStr = (String)body;
            SessionHistoryDTO historyDTO = (SessionHistoryDTO)JSONUtils.cast((String)historyDTOStr, SessionHistoryDTO.class);
            if (historyDTO.isLogin() && historyDTO.getSessionInfo() != null) {
                DynamicObject[] dynamicObjects = this.getSessionInfo(historyDTO.getSessionInfo());
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                userService.updateUserInfo(historyDTO.getSessionInfo());
            } else if (historyDTO.isLogout()) {
                String type = OnlineMaxNumberConsumer.logoutSave(historyDTO.getSessionId());
                historyDTO.setType(type);
            }
            OnlineMaxNumberConsumer.saveOnlineUser(RequestContext.get().getAccountId(), historyDTO);
            acker.ack(messageId);
        }
        catch (Exception e) {
            acker.discard(messageId);
        }
    }

    private static void saveOnlineUser(String accountId, SessionHistoryDTO historyDTO) {
        String typeKey = OnlineMaxNumberConsumer.getType(historyDTO.getType(), accountId);
        if (StringUtils.isNotEmpty((String)typeKey)) {
            if (historyDTO.isLogin()) {
                CACHE.inc(typeKey);
                CACHE.inc("svc:login:onlineUserNum:any_" + accountId);
            } else {
                CACHE.decr(typeKey);
                CACHE.decr("svc:login:onlineUserNum:any_" + accountId);
            }
        }
    }

    private static String getType(String type, String accountId) {
        if ("web".equals(type)) {
            return "svc:login:onlineUserNum:web_" + accountId;
        }
        if ("mobile".equals(type)) {
            return "svc:login:onlineUserNum:mobile_" + accountId;
        }
        return null;
    }

    private DynamicObject[] getSessionInfo(MqSessionInfo sessionInfo) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_smc_onlinesession_his");
        DynamicObject object = new DynamicObject((DynamicObjectType)mainEntityType);
        object.set("language", (Object)sessionInfo.getLanguage());
        object.set("createtime", (Object)sessionInfo.getCreateTime());
        object.set("modifytime", (Object)sessionInfo.getModifyTime());
        object.set("modifierid", (Object)sessionInfo.getModifierId());
        object.set("userid", (Object)sessionInfo.getUserid());
        object.set("username", (Object)sessionInfo.getUsername());
        object.set("useropenid", (Object)sessionInfo.getUserOpenid());
        object.set("usertype", (Object)sessionInfo.getUserType());
        object.set("orgid", (Object)sessionInfo.getOrgId());
        object.set("logintime", (Object)sessionInfo.getLoginTime());
        object.set("yzjappid", (Object)sessionInfo.getYzjAppId());
        object.set("loginip", (Object)sessionInfo.getLoginIp());
        object.set("yzjappticket", (Object)sessionInfo.getYzjAppTicket());
        object.set("loginorg", (Object)sessionInfo.getLoginOrg());
        object.set("client", (Object)sessionInfo.getClient());
        object.set("acccompanyid", (Object)sessionInfo.getAccCompanyId());
        object.set("kdcsrftoken", (Object)sessionInfo.getKdcsrfToken());
        object.set("api3rdappid", (Object)sessionInfo.getApi3rdAppId());
        object.set("api3rdappnum", (Object)sessionInfo.getApi3rdAppNum());
        object.set("bizpartnerid", (Object)sessionInfo.getBizPartnerId());
        object.set("expiredtime", (Object)sessionInfo.getExpiredTime());
        object.set("sessionid", (Object)sessionInfo.getSessionId());
        object.set("datetime", (Object)sessionInfo.getDatetime());
        return new DynamicObject[]{object};
    }

    public static String logoutSave(String sessionId) {
        String type = null;
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_smc_onlinesession_his", (QFilter[])new QFilter[]{new QFilter("sessionid", "=", (Object)sessionId)});
        if (null != objectMap && objectMap.size() > 0) {
            DynamicObject object = null;
            for (Map.Entry objectEntry : objectMap.entrySet()) {
                object = (DynamicObject)objectEntry.getValue();
            }
            if (object != null) {
                Date date = new Date();
                object.set("logouttime", (Object)date);
                type = object.getString("client");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
        }
        return type;
    }
}

