/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.smc.user.plugin;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.session.SessionInfo;
import kd.bos.session.service.SessionDBService;

public class OnlineUserPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    private static Log logger = LogFactory.getLog(OnlineUserPlugin.class);
    private static final int REFRESHTIME = 30;
    private static final String[] parameters = new String[]{"orgId", "accountId", "userId", "userName", "loginTime", "loginIP", "client", "tenantId", "language", "uid", "userOpenId", "userType", "sandboxId", "yzjAppId", "yzjAppTicket", "loginOrg"};

    public void registerListener(EventObject e) {
        ProgressBar pb = (ProgressBar)this.getView().getControl("progressbarap");
        pb.addProgressListener((ProgresssListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.renderOnlineUserData();
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("refresh")) {
            this.renderOnlineUserData();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache cache = this.getPageCache();
        if (cache.get("time") != null) {
            cache.remove("time");
        }
    }

    public void onProgress(ProgressEvent evt) {
        IPageCache cache = this.getPageCache();
        if (cache.get("time") != null) {
            int time = Integer.parseInt(cache.get("time"));
            if (time < 30) {
                cache.put("time", String.valueOf(time + 10));
            } else {
                cache.put("time", "10");
                this.renderOnlineUserData();
            }
        } else {
            cache.put("time", "20");
        }
    }

    private void renderOnlineUserData() {
        List sessionList = SessionDBService.getAllSessions();
        if (sessionList != null) {
            this.makeLabBySession(sessionList);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5728\u7ebf\u7528\u6237\u5931\u8d25\u3002", (String)"OnlineUserPlugin_0", (String)"bos-smc-plugin", (Object[])new Object[0]));
        }
    }

    private void makeLabBySession(List<SessionInfo> sessionList) {
        if (sessionList != null && sessionList.size() > 0) {
            IDataModel model = this.getModel();
            int i = 0;
            model.deleteEntryData("entryentity");
            model.batchCreateNewEntryRow("entryentity", sessionList.size());
            Date currentTime = new Date();
            for (SessionInfo sessionInfo : sessionList) {
                model.setValue("userid", (Object)sessionInfo.getUserId(), i);
                model.setValue("username", (Object)sessionInfo.getUserName(), i);
                String loginTimeInSession = sessionInfo.getLoginTime();
                if (loginTimeInSession != null && StringUtils.isNotBlank((CharSequence)loginTimeInSession)) {
                    Date loginTime = DateUtils.parseDate((Object)loginTimeInSession);
                    try {
                        int onlineTime = (int)((currentTime.getTime() - loginTime.getTime()) / 60000L);
                        model.setValue("onlinetime", (Object)String.valueOf(onlineTime), i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    model.setValue("logintime", (Object)loginTimeInSession, i);
                }
                model.setValue("org", (Object)sessionInfo.getOrgId(), i);
                model.setValue("tenant", (Object)RequestContext.get().getAccountId(), i);
                model.setValue("ip", (Object)sessionInfo.getLoginIP(), i);
                ++i;
            }
            ((Label)this.getControl("onlinenumber")).setText(String.valueOf(i));
        }
    }
}

