/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.smc.user.plugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.impl.SessionComServiceImpl;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.session.SessionInfo;
import kd.bos.smc.user.DateRange;
import kd.bos.smc.user.OnlineUserConts;
import kd.bos.smc.user.plugin.OnlineUserUtil;
import kd.bos.smc.user.service.ChartDataService;
import kd.bos.smc.user.service.DataZoom;
import kd.bos.smc.user.service.DateRangeDTO;
import kd.bos.smc.user.service.OnlineMaxChartDataService;
import kd.bos.smc.user.service.OnlineTimeChartDataService;
import kd.bos.smc.user.service.OnlineUserChartDataService;
import kd.bos.smc.user.service.OnlineUserService;
import kd.bos.smc.user.utils.DateUtil;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;

public class OnlineUserPluginNew
extends AbstractFormPlugin
implements TabSelectListener,
ClickListener,
ItemClickListener {
    public static final String LOGOUTUSER = "logoutuser";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static Log logger = LogFactory.getLog(OnlineUserPluginNew.class);
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private OnlineUserService onlineUserService;

    public void initialize() {
        this.onlineUserService = new OnlineUserService();
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        Chart onlineTimeChart = (Chart)this.getControl("chart_online_time");
        onlineTimeChart.addClickListener((ClickListener)this);
        Chart onlineDetailChart = (Chart)this.getControl("chart_online_detail");
        onlineDetailChart.addClickListener((ClickListener)this);
        Label loginLog = (Label)this.getControl("gotologinlog");
        loginLog.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IPageCache pageCache = this.getView().getPageCache();
        String fieldKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("radiogroupfield".equals(fieldKey) || "radiogroup_time".equals(fieldKey)) {
            if (null != newValue) {
                String value = (String)newValue;
                boolean radiogroupTime = "radiogroupfield".equals(fieldKey);
                this.getModel().setValue(radiogroupTime ? "daterangefield1_startdate" : "daterangefield_startdate", null);
                this.getModel().setValue(radiogroupTime ? "daterangefield1_enddate" : "daterangefield_enddate", null);
                pageCache.put(fieldKey, value);
                this.radioChange(value, radiogroupTime);
            }
        } else if ("radiogroup_num".equals(fieldKey)) {
            String value = (String)newValue;
            pageCache.put(fieldKey, value);
            this.showOnlineNum(value);
        } else if ("radiogroup_max".equals(fieldKey)) {
            if (null != newValue) {
                String value = (String)newValue;
                this.getModel().setValue("daterangefield_startdate_m", null);
                this.getModel().setValue("daterangefield_enddate_m", null);
                pageCache.put(fieldKey, value);
                this.showMaxNumByRadio(value);
            }
        } else {
            this.dateValueChange(pageCache, newValue, fieldKey);
        }
    }

    private void dateValueChange(IPageCache pageCache, Object newValue, String fieldKey) {
        Long time;
        String startDateStr;
        if ("daterangefield1_startdate".equals(fieldKey)) {
            startDateStr = this.getDateStr(newValue);
            pageCache.put("daterangefield1_startdate", startDateStr);
            this.bindBetweenDate();
        } else if ("daterangefield1_enddate".equals(fieldKey)) {
            startDateStr = this.getDateStr(newValue);
            pageCache.put("daterangefield1_enddate", startDateStr);
            this.bindBetweenDate();
        }
        if ("daterangefield_startdate".equals(fieldKey) || "daterangefield_startdate_m".equals(fieldKey)) {
            time = this.getchangeTime(newValue);
            pageCache.put(fieldKey, time == null ? null : String.valueOf(time));
            this.dateChangeQuery(fieldKey);
        } else if ("daterangefield_enddate".equals(fieldKey) || "daterangefield_enddate_m".equals(fieldKey)) {
            time = this.getchangeTime(newValue);
            pageCache.put(fieldKey, time == null ? null : String.valueOf(time));
            this.dateChangeQuery(fieldKey);
        }
    }

    private Long getchangeTime(Object newValue) {
        Long time = null;
        if (null != newValue) {
            Date date = (Date)newValue;
            time = OnlineUserUtil.getTime(date);
        }
        return time;
    }

    private String getDateStr(Object newValue) {
        String str = null;
        if (null != newValue) {
            str = DateUtil.getDateFormat(DateUtil.DEFAULT_DATE_FORMAT).format((Date)newValue);
        }
        return str;
    }

    private void showMaxNumByRadio(String value) {
        if (null == value) {
            return;
        }
        String type = "dateTypeDay";
        switch (value) {
            case "2": {
                type = "dateTypeWeek";
                break;
            }
            case "3": {
                type = "dateTypeMonth";
                break;
            }
            case "4": {
                type = "dateTypeYear";
                break;
            }
        }
        this.showMaxChart(type);
    }

    private void dateChangeQuery(String fieldKey) {
        boolean f1;
        IPageCache pageCache = this.getView().getPageCache();
        boolean f = pageCache.get("daterangefield_startdate") != null && pageCache.get("daterangefield_enddate") != null;
        boolean bl = f1 = pageCache.get("daterangefield_startdate_m") != null && pageCache.get("daterangefield_enddate_m") != null;
        if (f || f1) {
            try {
                String start = pageCache.get("daterangefield_startdate");
                String end = pageCache.get("daterangefield_enddate");
                ChartDataService chartDataService = new OnlineTimeChartDataService();
                String chart = "chart_online_time";
                if (fieldKey.endsWith("_m")) {
                    start = pageCache.get("daterangefield_startdate_m");
                    end = pageCache.get("daterangefield_enddate_m");
                    chartDataService = new OnlineMaxChartDataService();
                    chart = "chart_online_max";
                    this.getModel().setValue("radiogroup_max", null);
                } else {
                    this.getModel().setValue("radiogroup_time", null);
                }
                Date startDate = DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).parse(start);
                Date endDate = DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).parse(end);
                String key = fieldKey.endsWith("_m") ? "daterangefield_startdate_m" : "daterangefield_startdate";
                if (this.lessThenYear(startDate, endDate, key, fieldKey.endsWith("_m") ? "daterangefield_enddate_m" : "daterangefield_enddate")) {
                    pageCache.remove(fieldKey.endsWith("_m") ? "radiogroup_max" : "radiogroup_time");
                    pageCache.put(fieldKey.endsWith("_m") ? "KEY_STARTDATE_M" : "KEY_STARTDATE", "Y");
                    DateRangeDTO dateRangeDTO = new DateRangeDTO("dateTypeCustom");
                    dateRangeDTO.setDateRange(new DateRange(startDate, endDate));
                    this.setUserNumToChartInDeatil(dateRangeDTO, chartDataService, chart);
                }
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        if (pageCache.get("daterangefield_startdate_m") == null && pageCache.get("daterangefield_enddate_m") == null && pageCache.get("radiogroup_max") == null) {
            this.setRadioValue("tabpage_online_max", "2");
        }
    }

    private void radioChange(String value, boolean flag) {
        if (value == null) {
            return;
        }
        switch (value) {
            case "1": {
                this.userDailyData(flag);
                break;
            }
            case "2": {
                this.userWeekData(flag);
                break;
            }
            case "3": {
                this.userMonthData(flag);
                break;
            }
            case "4": {
                this.userYearData(flag);
                break;
            }
        }
    }

    private void userYearData(boolean flag) {
        if (flag) {
            this.bindUserDeatilData(new DateRangeDTO("dateTypeYear"), true);
        } else {
            this.showOnlineTime("dateTypeYear");
        }
    }

    private void userMonthData(boolean flag) {
        if (flag) {
            this.bindUserDeatilData(new DateRangeDTO("dateTypeMonth"), true);
        } else {
            this.showOnlineTime("dateTypeMonth");
        }
    }

    private void userWeekData(boolean flag) {
        if (flag) {
            this.bindUserDeatilData(new DateRangeDTO("dateTypeWeek"), true);
        } else {
            this.showOnlineTime("dateTypeWeek");
        }
    }

    private void userDailyData(boolean flag) {
        if (flag) {
            this.bindUserDeatilData(new DateRangeDTO("dateTypeDay"), true);
        } else {
            this.showOnlineTime("dateTypeDay");
        }
    }

    private void bindBetweenDate() {
        try {
            IPageCache pageCache = this.getView().getPageCache();
            if (pageCache.get("daterangefield1_startdate") != null && pageCache.get("daterangefield1_enddate") != null) {
                this.getModel().setValue("radiogroupfield", null);
                Date startDate = DateUtil.getDateFormat(DateUtil.DEFAULT_DATE_FORMAT).parse(pageCache.get("daterangefield1_startdate"));
                Date endDate = DateUtil.getDateFormat(DateUtil.DEFAULT_DATE_FORMAT).parse(pageCache.get("daterangefield1_enddate"));
                if (this.lessThenYear(startDate, endDate, "daterangefield1_startdate", "daterangefield1_enddate")) {
                    pageCache.remove("radiogroupfield");
                    pageCache.put("KEY_STARTDATE1", "Y");
                    this.bindUserDeatilData(new DateRangeDTO("dateTypeCustom", new DateRange(startDate, endDate)), true);
                }
            }
            if (pageCache.get("daterangefield1_startdate") == null && pageCache.get("daterangefield1_enddate") == null) {
                this.setRadioValue("tabpage_online_detail", "3");
            }
        }
        catch (ParseException e) {
            logger.info("\u5728\u7ebf\u7528\u6237\u65e5\u671f\u89e3\u6790\u5f02\u5e38:", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean lessThenYear(Date startDate, Date endDate, String keyStart, String keyEnd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.set(year + 1, month, day);
        if (endDate.getTime() > calendar.getTimeInMillis()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u4e00\u5e74\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OnlineUserPluginNew_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            this.getModel().setValue(keyStart, null);
            this.getModel().setValue(keyEnd, null);
            IPageCache pageCache = this.getPageCache();
            pageCache.remove(keyStart);
            pageCache.remove(keyEnd);
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof PointLineChart) {
            Long timeFromCache;
            PointLineChart chart = (PointLineChart)source;
            ChartClickEvent e = (ChartClickEvent)evt;
            String key = chart.getKey();
            if ("chart_online_time".equals(key) && (timeFromCache = this.getTimeFromCache(e.getName())) != null) {
                String format = DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).format(timeFromCache);
                HashMap<String, Long> hashMap = new HashMap<String, Long>(1);
                hashMap.put("end", Long.valueOf(format));
                this.getOnlineData(hashMap);
            }
            if ("chart_online_detail".equals(key)) {
                this.chartPonitClickEvent(evt);
            }
        }
        if (source instanceof Label && "gotologinlog".equals(((Label)source).getKey())) {
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.setFormId("bos_list");
            formShowParameter.setBillFormId("bos_login_log_new");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private void chartPonitClickEvent(EventObject evt) {
        ChartClickEvent e = (ChartClickEvent)evt;
        String dateKey = e.getName();
        Long timeFromCache = this.getTimeFromCache(dateKey);
        if (timeFromCache != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(timeFromCache));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            long zero = calendar.getTimeInMillis();
            long twelve = zero + 86400000L - 1L;
            DateRange dateRange = new DateRange(new Date(zero), new Date(twelve));
            this.setUserDetailBill(dateRange, true);
        }
    }

    private Long getTimeFromCache(String dateKey) {
        IPageCache pageCache = this.getPageCache();
        String timestamp = pageCache.get(dateKey);
        if (timestamp == null) {
            return null;
        }
        Long timestampLong = Long.valueOf(timestamp);
        return timestampLong;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        Tab tab = (Tab)this.getView().getControl("tabap");
        String tabKey = tab.getCurrentTab();
        if ("baritemap_reflesh".equals(evt.getItemKey())) {
            switch (tabKey) {
                case "tabpage_online_num": {
                    this.setRadioValue(tabKey, "any");
                    this.showOnlineNum("any");
                    break;
                }
                case "tabpage_noline_time": {
                    this.setRadioValue(tabKey, "1");
                    OnlineUserUtil.calculateOnlineTime();
                    this.showOnlineTime("dateTypeDay");
                    break;
                }
                case "tabpage_online_detail": {
                    this.setRadioValue(tabKey, "3");
                    this.showOnlineDetail();
                    break;
                }
                case "tabpage_online_max": {
                    this.setRadioValue(tabKey, "2");
                    this.showOnlineMax("dateTypeWeek");
                    break;
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"OnlineUserPluginNew_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (LOGOUTUSER.equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int selectRows = entryGrid.getSelectRows().length;
            if (selectRows <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OnlineUserPluginNew_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6ce8\u9500\u9009\u4e2d\u7684%s\u4e2a\u4f1a\u8bdd\uff0c\u88ab\u6ce8\u9500\u4f1a\u8bdd\u7684\u7528\u6237\u5c06\u81ea\u52a8\u9000\u51fa\u767b\u5f55\uff0c\u64cd\u4f5c\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002", (String)"OnlineUserPluginNew_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), selectRows), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("logoutUser", (IFormPlugin)this));
        }
    }

    private void setRadioValue(String currentTab, String value) {
        String radio = "radiogroup_num";
        switch (currentTab) {
            case "tabpage_noline_time": {
                radio = "radiogroup_time";
                break;
            }
            case "tabpage_online_detail": {
                radio = "radiogroupfield";
                break;
            }
            case "tabpage_online_max": {
                radio = "radiogroup_max";
                break;
            }
        }
        this.getPageCache().put(radio, value);
        this.getModel().setValue(radio, (Object)value);
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        this.changeTab(tabKey);
        this.exportButton();
    }

    private void changeTab(String tabKey) {
        IPageCache pageCache = this.getPageCache();
        switch (tabKey) {
            case "tabpage_online_num": {
                String value = pageCache.get("radiogroup_num");
                this.setRadioValue(tabKey, StringUtils.isNotEmpty((String)value) ? value : "any");
                break;
            }
            case "tabpage_noline_time": {
                String value1 = pageCache.get("radiogroup_time");
                this.setRadioValue(tabKey, StringUtils.isNotEmpty((String)value1) ? value1 : "1");
                OnlineUserUtil.calculateOnlineTime();
                break;
            }
            case "tabpage_online_detail": {
                try {
                    String value2 = pageCache.get("radiogroupfield");
                    String s = pageCache.get("KEY_STARTDATE1");
                    if (StringUtils.isEmpty((String)value2) && "Y".equals(s)) {
                        String start = pageCache.get("daterangefield1_startdate");
                        String end = pageCache.get("daterangefield1_enddate");
                        Date parse = this.DATE_FORMAT.parse(start);
                        Date parse1 = this.DATE_FORMAT.parse(end);
                        this.bindUserDeatilData(new DateRangeDTO("dateTypeCustom", new DateRange(parse, parse1)), true);
                        break;
                    }
                    this.setRadioValue(tabKey, StringUtils.isNotEmpty((String)value2) ? value2 : "3");
                }
                catch (Exception e) {
                    logger.info("bindUserDeatilData error", (Object)e);
                }
                break;
            }
            case "tabpage_online_max": {
                try {
                    String value3 = pageCache.get("radiogroup_max");
                    String s = pageCache.get("KEY_STARTDATE_M");
                    if (StringUtils.isEmpty((String)value3) && "Y".equals(s)) {
                        String start = pageCache.get("daterangefield_startdate_m");
                        String end = pageCache.get("daterangefield_enddate_m");
                        Date parse = DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).parse(start);
                        Date parse1 = DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).parse(end);
                        this.setUserNumToChartInDeatil(new DateRangeDTO("dateTypeCustom", new DateRange(parse, parse1)), new OnlineMaxChartDataService(), "chart_online_max");
                        break;
                    }
                    this.setRadioValue(tabKey, StringUtils.isNotEmpty((String)value3) ? value3 : "2");
                }
                catch (Exception e) {
                    logger.info("setUserNumToChartInDeatil error", (Object)e);
                }
                break;
            }
        }
    }

    private void showOnlineMax(String dateType) {
        this.showMaxChart(dateType);
    }

    private void showMaxChart(String dateType) {
        if (!"dateTypeDay".equals(dateType)) {
            OnlineMaxChartDataService chartDataService = new OnlineMaxChartDataService();
            this.setUserNumToChartInDeatil(new DateRangeDTO(dateType), chartDataService, "chart_online_max");
        }
    }

    private void showMaxOfDay(String dateType, String type) {
        Date now = new Date();
        Map<String, Number> maxNumFromDate = OnlineUserUtil.getMaxNumFromDate(new DateRangeDTO(dateType, new DateRange(now, now)), type);
        ArrayList<ItemValue> value = new ArrayList<ItemValue>();
        this.changeMaxTimeType(maxNumFromDate, value);
        this.showUserLineMaxChart(value, "chart_online_num", OnlineUserConts.X_NUMBER);
    }

    private void changeMaxTimeType(Map<String, Number> maxNumFromDate, List<ItemValue> value) {
        HashMap<Integer, String> date = new HashMap<Integer, String>(24);
        HashMap<Integer, Number> data = new HashMap<Integer, Number>(24);
        for (Map.Entry<String, Number> entry : maxNumFromDate.entrySet()) {
            int h = Integer.parseInt(entry.getKey()) / 60;
            int m = Integer.parseInt(entry.getKey()) - 60 * h;
            String mi = "00";
            if (m > 0 && m < 10) {
                mi = "0" + m;
            }
            if (m >= 10) {
                mi = m + "";
            }
            date.put(h, h + ":" + mi);
            data.put(h, entry.getValue());
        }
        int hour = 24;
        for (int i = 0; i < hour; ++i) {
            Number v = null;
            String dateStr = "";
            if (StringUtils.isEmpty((String)((String)date.get(i)))) {
                dateStr = i + ":00";
                if (Calendar.getInstance().get(11) > i) {
                    v = 0;
                }
            } else {
                dateStr = (String)date.get(i);
                v = (Number)data.get(i);
            }
            value.add(new ItemValue(dateStr, v));
        }
    }

    public void createNewData(BizDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpage_noline_time"});
        this.showOnlineNum("any");
        this.setRadioValue("tabpage_online_num", "any");
        this.exportButton();
    }

    private void exportButton() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String button = null;
        String disableButton = null;
        String disableButton1 = null;
        switch (currentTab) {
            case "tabpage_online_num": {
                button = "baritemap_exp_num";
                disableButton = "baritemap_exp_time";
                disableButton1 = "baritemap_exp_detail";
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap_logoutuser"});
                break;
            }
            case "tabpage_noline_time": {
                button = "baritemap_exp_time";
                disableButton = "baritemap_exp_num";
                disableButton1 = "baritemap_exp_detail";
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap_logoutuser"});
                break;
            }
            case "tabpage_online_detail": {
                disableButton = "baritemap_exp_num";
                disableButton1 = "baritemap_exp_time";
                button = "baritemap_exp_detail";
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap_logoutuser"});
                break;
            }
            case "tabpage_online_max": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap_exp_num", "baritemap_exp_time", "baritemap_exp_detail"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap_logoutuser"});
                return;
            }
        }
        if (null != button) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{button});
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{disableButton, disableButton1});
    }

    private void showOnlineDetail() {
        DateRangeDTO dateRangeDTO = new DateRangeDTO("dateTypeMonth");
        this.bindUserDeatilData(dateRangeDTO, true);
    }

    private void bindUserDeatilData(DateRangeDTO dateRangeDTO, boolean showBill) {
        OnlineUserChartDataService chartDataService = new OnlineUserChartDataService();
        this.setUserNumToChartInDeatil(dateRangeDTO, chartDataService, "chart_online_detail");
        if (showBill) {
            this.setUserDetailBill(dateRangeDTO.getDateRange(), true);
        }
    }

    private void setUserNumToChartInDeatil(DateRangeDTO dateRangeDTO, ChartDataService chartDataService, String chartName) {
        ArrayList<Date> dateList = new ArrayList();
        try {
            dateList = OnlineUserUtil.getDateListByType(dateRangeDTO.getDateType(), dateRangeDTO.getCrueentDay(), dateRangeDTO.getDateRange());
        }
        catch (ParseException e) {
            logger.info("\u5728\u7ebf\u7528\u6237\u65e5\u671f\u89e3\u6790\u5f02\u5e38:", (Object)e);
        }
        Map<String, Integer> dateRangMap = this.setDateRange(dateRangeDTO, dateList);
        Map<String, Number> userNumMap = chartDataService.getYdata(dateRangeDTO);
        List<Integer> dateNumList = this.bindDateNum(dateRangMap, userNumMap);
        List<String> dateStrList = OnlineUserUtil.getDateListForFormat(dateList, "MM-dd");
        if ("chart_online_max".equals(chartName)) {
            List<ItemValue> values = this.setValueToItem(dateNumList, dateStrList);
            this.showUserLineMaxChart(values, chartName, dateStrList);
        } else {
            this.setDateStrMap(dateStrList, dateList);
            this.showUserLineChart(dateNumList, chartName, dateStrList);
        }
    }

    private List<ItemValue> setValueToItem(List<Integer> dateNumList, List<String> dateStrList) {
        ArrayList<ItemValue> itemValues = new ArrayList<ItemValue>(32);
        for (int i = 0; i < dateNumList.size(); ++i) {
            itemValues.add(new ItemValue(dateStrList.get(i), (Number)dateNumList.get(i)));
        }
        return itemValues;
    }

    private void showUserLineMaxChart(List<ItemValue> dateNumList, String echartsName, Object propValue) {
        PointLineChart control = (PointLineChart)this.getView().getControl(echartsName);
        control.clearData();
        ArrayList<DataZoom> dataZooms = new ArrayList<DataZoom>();
        dataZooms.add(new DataZoom());
        control.addProperty("dataZoom", dataZooms);
        LineSeries series = control.createSeries("");
        ItemValue[] itemValues = dateNumList.toArray(new ItemValue[dateNumList.size()]);
        series.setData(itemValues);
        series.setPropValue("type", (Object)"line");
        series.setPropValue("showBackground", (Object)true);
        Axis xAxis = control.createXAxis("", AxisType.category);
        xAxis.setPropValue("data", propValue);
        control.createYAxis("", AxisType.value);
        this.setToolTipFormat(control);
        control.refresh();
    }

    private void setToolTipFormat(PointLineChart barchart) {
        barchart.setShowTooltip(true);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        String maxNum = ResManager.loadKDString((String)"\u5cf0\u503c", (String)"OnlineUserPluginNew_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        String time = ResManager.loadKDString((String)"\u65f6\u95f4", (String)"OnlineUserPluginNew_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        String formatter = "function(params){return `\n\t\t\t" + time + "\uff1a${params[0].data.name} </br> \n\t\t\t" + maxNum + "\uff1a${params[0].data.value!=null?params[0].data.value:''}\n\t\t\t`;}";
        barchart.addTooltip("formatter", (Object)formatter);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        barchart.addFuncPath(toolTipFuncPath);
    }

    private void showUserLineChart(List<Integer> dateNumList, String echartsName, Object propValue) {
        PointLineChart control = (PointLineChart)this.getView().getControl(echartsName);
        control.clearData();
        ArrayList<DataZoom> dataZooms = new ArrayList<DataZoom>();
        dataZooms.add(new DataZoom());
        control.addProperty("dataZoom", dataZooms);
        LineSeries series = control.createSeries("");
        series.setPropValue("data", dateNumList);
        series.setPropValue("type", (Object)"line");
        series.setPropValue("showBackground", (Object)true);
        Axis xAxis = control.createXAxis("", AxisType.category);
        xAxis.setPropValue("data", propValue);
        control.createYAxis("", AxisType.value);
        control.setShowTooltip(true);
        control.refresh();
    }

    private void setDateStrMap(List<String> dateStrList, List<Date> dateList) {
        IPageCache pageCache = this.getView().getPageCache();
        int size = dateList.size();
        if (size != dateList.size()) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            pageCache.put(dateStrList.get(i), String.valueOf(dateList.get(i).getTime()));
        }
    }

    private List<Integer> bindDateNum(Map<String, Integer> dateRangMap, Map<String, Number> userNumMap) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Iterator<Map.Entry<String, Number>> userNumMapIterator = userNumMap.entrySet().iterator();
        String now = DateUtil.getDateFormat(DateUtil.DEFAULT_DATE_FORMAT).format(new Date());
        while (userNumMapIterator.hasNext()) {
            Map.Entry<String, Number> entry = userNumMapIterator.next();
            dateRangMap.put(entry.getKey(), (Integer)entry.getValue());
        }
        Iterator<Map.Entry<String, Integer>> dateRangMapIterator = dateRangMap.entrySet().iterator();
        boolean isLessThanNow = true;
        while (dateRangMapIterator.hasNext()) {
            Map.Entry<String, Integer> entry = dateRangMapIterator.next();
            if (isLessThanNow) {
                list.add(entry.getValue());
            }
            if (!now.equals(entry.getKey())) continue;
            isLessThanNow = false;
        }
        return list;
    }

    private Map<String, Integer> setDateRange(DateRangeDTO dateRangeDTO, List<Date> dateList) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(dateList.size());
        if (dateRangeDTO.getDateRange() == null) {
            dateRangeDTO.setDateRange(new DateRange(dateList.get(0), dateList.get(dateList.size() - 1)));
        }
        for (Date date : dateList) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = format.format(date);
            map.put(dateStr, 0);
        }
        return map;
    }

    private void showOnlineTime(String type) {
        OnlineTimeChartDataService chartDataService = new OnlineTimeChartDataService();
        this.setUserNumToChartInDeatil(new DateRangeDTO(type), chartDataService, "chart_online_time");
        this.getOnlineTime();
        this.showOnlineTimeData(type);
    }

    private void showOnlineTimeData(String type) {
        Map<String, Long> days = this.getOnlineDays(type);
        this.getOnlineData(days);
    }

    private void getOnlineData(Map<String, Long> days) {
        Long start = days.get("start") == null ? days.get("end") : days.get("start");
        Long end = days.get("end");
        IDataModel model = this.getModel();
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_smc_onlinetime", (String)"userid,logintimes,onlinetime,datetime", (QFilter[])new QFilter[]{new QFilter("datetime", ">=", (Object)start), new QFilter("datetime", "<=", (Object)end)});
        Map<String, List<DynamicObject>> userList = objectMap.keySet().stream().map(v -> (DynamicObject)objectMap.get(v)).collect(Collectors.groupingBy(v -> v.getString("userid.id")));
        model.deleteEntryData("entryentity1");
        int size = userList.size();
        model.batchCreateNewEntryRow("entryentity1", size > 0 ? size : 1);
        int i = 0;
        for (Map.Entry<String, List<DynamicObject>> listEntry : userList.entrySet()) {
            List<DynamicObject> objects = listEntry.getValue();
            Integer logintimes = objects.stream().map(v -> v.getInt("logintimes")).reduce(0, (x, y) -> x + y);
            BigDecimal onlinetime = objects.stream().map(v -> v.getBigDecimal("onlinetime")).reduce(BigDecimal.ZERO, (x, y) -> x.add((BigDecimal)y)).setScale(2, 4);
            model.setValue("userid_time", (Object)listEntry.getKey(), i);
            model.setValue("username_time", objects.get(0).get("userid.name"), i);
            model.setValue("online_day", (Object)objects.size(), i);
            model.setValue("onlinetime_count", (Object)onlinetime, i);
            model.setValue("onlinetime_avg", (Object)onlinetime.divide(new BigDecimal(objects.size()), 2, 4), i);
            model.setValue("logintimes", (Object)logintimes, i);
            ++i;
        }
    }

    private Map<String, Long> getOnlineDays(String type) {
        HashMap<String, Long> days = new HashMap<String, Long>(2);
        Calendar instance = Calendar.getInstance();
        Long time = OnlineUserUtil.getTime(6);
        days.put("end", time);
        switch (type) {
            case "dateTypeWeek": {
                int count = instance.get(7) - 1 == 0 ? 7 : instance.get(7) - 1;
                Long start = time + 1L - (long)count;
                days.put("start", start);
                break;
            }
            case "dateTypeMonth": {
                int count1 = instance.get(5);
                Long start1 = time + 1L - (long)count1;
                days.put("start", start1);
                break;
            }
            case "dateTypeYear": {
                int year = instance.get(1);
                Long startYear = Long.valueOf(year + "0101");
                days.put("start", startYear);
                days.put("end", Long.valueOf(DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).format(new Date())));
                break;
            }
        }
        return days;
    }

    private void getOnlineTime() {
        String count = OnlineUserUtil.getOnlineTime();
        ((Label)this.getControl("online_time")).setText(count);
    }

    private void showOnlineNum(String type) {
        this.showMaxOfDay("dateTypeDay", type);
        this.getOnlineCount(type);
        this.getEntryData(type);
    }

    private void getEntryData(String type) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_smc_onlinesession_his", (String)"userid,username,loginip,client,logintime,sessionid", (QFilter[])new QFilter[]{new QFilter("logouttime", "is null", null)}, (String)"logintime desc", (int)10000);
        List<DynamicObject> collect = this.filterData(load, type);
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (collect.size() > 0) {
            int[] index = model.batchCreateNewEntryRow("entryentity", collect.size() > 0 ? collect.size() : 1);
            Date currentTime = new Date();
            for (int i = 0; i < collect.size(); ++i) {
                DynamicObject dynamicObject = collect.get(i);
                model.setValue("userid", dynamicObject.get("userid"), index[i]);
                model.setValue("username", dynamicObject.get("username"), index[i]);
                model.setValue("ip", dynamicObject.get("loginip"), index[i]);
                model.setValue("clienttype", (Object)dynamicObject.getString("client"), index[i]);
                Date logintime = dynamicObject.getDate("logintime");
                if (logintime != null) {
                    String format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(logintime);
                    model.setValue("newlogintime", (Object)format, index[i]);
                    BigDecimal time = new BigDecimal(currentTime.getTime() - logintime.getTime());
                    BigDecimal onlinetime = time.divide(new BigDecimal(3600000), 2, 4);
                    model.setValue("onlinetime", (Object)String.valueOf(onlinetime), index[i]);
                }
                model.setValue("sessionid", (Object)dynamicObject.getString("sessionid"), index[i]);
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private List<DynamicObject> filterData(DynamicObject[] load, String type) {
        List<DynamicObject> collect = Arrays.stream(load).filter(v -> {
            if ("any".equals(type)) {
                return "web".equals(v.getString("client")) || "mobile".equals(v.getString("client"));
            }
            if ("web".equals(type)) {
                return "web".equals(v.getString("client"));
            }
            if ("mobile".equals(type)) {
                return "mobile".equals(v.getString("client"));
            }
            return false;
        }).sorted(Comparator.comparing(v -> v.getDate("logintime"), Comparator.reverseOrder())).collect(Collectors.toList());
        return collect;
    }

    private String getClientName(String client) {
        String clientName = null;
        if ("web".equals(client)) {
            clientName = ResManager.loadKDString((String)"\u7f51\u9875\u7aef", (String)"OnlineUserPluginNew_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        if ("mobile".equals(client)) {
            clientName = ResManager.loadKDString((String)"\u79fb\u52a8\u7aef", (String)"OnlineUserPluginNew_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        }
        return clientName;
    }

    private void getOnlineCount(String type) {
        Map<String, Integer> countFromDB = OnlineUserUtil.getMaxCountFromDB();
        Integer count = countFromDB.get(type);
        ((Label)this.getControl("online_num")).setText(String.valueOf(ObjectUtils.isEmpty((Object)count) ? "0" : count));
    }

    private void setUserDetailBill(DateRange dateRange, boolean delete) {
        List<DynamicObject> dynamicObjects = this.onlineUserService.getUserDeatilByDaily(dateRange);
        this.setUserDetailHistoryData(dynamicObjects, delete);
    }

    private void setUserDetailHistoryData(List<DynamicObject> detailHistoryData, boolean delete) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity11");
        if (detailHistoryData.size() > 0) {
            model.batchCreateNewEntryRow("entryentity11", detailHistoryData.size() > 0 ? detailHistoryData.size() : 1);
            for (int i = 0; i < detailHistoryData.size(); ++i) {
                DynamicObject dynamicObject = detailHistoryData.get(i);
                model.setValue("userid_detail", dynamicObject.get("userid"), i);
                model.setValue("username_detail", dynamicObject.get("username"), i);
                model.setValue("ip_detail", dynamicObject.get("loginip"), i);
                String client = this.getClientName(dynamicObject.getString("client"));
                model.setValue("clienttype_detail", (Object)client, i);
                Date logintime = dynamicObject.getDate("logintime");
                Date logouttime = dynamicObject.getDate("logouttime");
                Date date = null == logouttime ? new Date() : logouttime;
                model.setValue("newlogintime_detail", (Object)logintime, i);
                model.setValue("newlogouttime_detail", (Object)logouttime, i);
                BigDecimal time = new BigDecimal(date.getTime() - logintime.getTime());
                BigDecimal onlinetime = time.divide(new BigDecimal(3600000), 2, 4);
                model.setValue("onlinetime_detail", (Object)String.valueOf(onlinetime), i);
            }
        }
        if (delete && detailHistoryData.size() > 0) {
            EntryGrid control = (EntryGrid)this.getView().getControl("entryentity11");
            control.setPageIndex(1);
        }
        model.endInit();
        this.getView().updateView("entryentity11");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("logoutUser".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.logoutUser();
            this.setRadioValue("tabpage_online_num", "any");
            this.showOnlineNum("any");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ce8\u9500\u6210\u529f\u3002", (String)"OnlineUserPluginNew_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void logoutUser() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        if (selectRows != null && selectRows.length > 0) {
            ArrayList<SessionInfo> sessionInfoList = new ArrayList<SessionInfo>(8);
            ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(8);
            for (int selectRow : selectRows) {
                DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
                String sessionId = dynamicObject.getString("sessionid");
                if (!StringUtils.isNotEmpty((String)sessionId)) continue;
                SessionInfo sessionInfo = new SessionInfo();
                sessionInfo.setGloableSessionId(Encrypters.decode((String)sessionId));
                sessionInfo.setUserId(dynamicObject.getString("userId"));
                sessionInfoList.add(sessionInfo);
                appLogInfoList.add(this.wrapAppLogInfo(sessionId));
            }
            SessionComServiceImpl sessionComService = new SessionComServiceImpl();
            sessionComService.removeSessionBySessionId(sessionInfoList, String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u4e8e%s\u88ab\u7ba1\u7406\u5458\u6ce8\u9500\u4f1a\u8bdd\uff0c\u5c06\u81ea\u52a8\u9000\u51fa\u767b\u5f55\u3002\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnlineUserPluginNew_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), DateUtils.getDateTime()));
            if (appLogInfoList.size() > 0) {
                LogServiceHelper.addBatchLog(appLogInfoList);
            }
        }
    }

    private AppLogInfo wrapAppLogInfo(String sessionId) {
        try {
            DynamicObject[] array = BusinessDataServiceHelper.load((String)"bos_smc_onlinesession_his", (String)"language,userid,loginip,orgid,client", (QFilter[])new QFilter[]{new QFilter("sessionid", "=", (Object)sessionId)});
            if (array == null || array.length <= 0) {
                return null;
            }
            DynamicObject data = array[0];
            AppLogInfo logInfo = new AppLogInfo();
            logInfo.setUserID(Long.valueOf(data.getLong("userid")));
            logInfo.setOrgID(Long.valueOf(data.getLong("orgid")));
            logInfo.setBizAppID("83bfebc8000037ac");
            logInfo.setBizObjID("bos_user");
            logInfo.setOpTime(new Date());
            logInfo.setClientType(data.getString("client"));
            logInfo.setClientIP(data.getString("loginip"));
            logInfo.setOpName(ResManager.loadKDString((String)"\u9000\u51fa", (String)"OnlineUserPluginNew_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            logInfo.setOpDescription(ResManager.loadKDString((String)"\u6ce8\u9500\u9000\u51fa\u6210\u529f\u3002", (String)"OnlineUserPluginNew_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            logInfo.setAccountId(RequestContext.get().getAccountId());
            logInfo.setTenantId(RequestContext.get().getTenantId());
            logInfo.setClientName(data.getString("client"));
            logInfo.setLogType(1);
            return logInfo;
        }
        catch (Exception e) {
            DisCardUtil.discard();
            return null;
        }
    }
}

