/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.smc.user.plugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.smc.user.DateRange;
import kd.bos.smc.user.service.DateRangeDTO;
import kd.bos.smc.user.utils.DateUtil;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineUserUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineUserUtil.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion", new DistributeCacheHAPolicy(true, true));
    public static final String[] client = new String[]{"web", "mobile"};
    private static LoginCacheService loginCacheService = new LoginCacheService("customRegion");

    private OnlineUserUtil() {
    }

    public static void setOnlineNum() {
        Map<String, Integer> countFromDB = OnlineUserUtil.getHisCountFromDB();
        if (countFromDB != null && countFromDB.size() > 0) {
            OnlineUserUtil.saveData(countFromDB);
        }
    }

    public static void countOnlineUser() {
        int count = OnlineUserUtil.getOnlineUser();
        OnlineUserUtil.setDailyOnlineNum(count);
    }

    private static void setDailyOnlineNum(int count) {
        Date date = OnlineUserUtil.getDate(OnlineUserUtil.getTime(new Date()));
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_smc_onlineuser_numday", (String)"onlinenumber", (QFilter[])new QFilter[]{new QFilter("datetime", "=", (Object)date)});
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_smc_onlineuser_numday");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        if (objectMap != null && objectMap.size() > 0) {
            List collect = objectMap.keySet().stream().map(v -> (DynamicObject)objectMap.get(v)).collect(Collectors.toList());
            dynamicObject = (DynamicObject)collect.get(0);
        } else {
            dynamicObject.set("datetype", (Object)"day");
            dynamicObject.set("datetime", (Object)date);
        }
        dynamicObject.set("onlinenumber", (Object)count);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static int getOnlineUser() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        String sql = "select count(1) from t_bas_session_history where flogouttime is null or flogouttime between ? and ?";
        int query = (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{calendar.getTime(), new Date()}, v -> {
            int count = 0;
            while (v.next()) {
                count = v.getInt(1);
            }
            return count;
        });
        return query;
    }

    private static void saveData(Map<String, Integer> dataCount) {
        Long day = OnlineUserUtil.getTime(6);
        Long hour = OnlineUserUtil.getTime(11);
        Long minute = hour * 60L;
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_smc_onlineuser_number", (String)"client,online_user_num,modifytime", (QFilter[])new QFilter[]{new QFilter("time", "=", (Object)day), new QFilter("minute", "=", (Object)minute)});
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>();
        if (objectMap != null && objectMap.size() > 0) {
            Map<String, List<DynamicObject>> listMap = objectMap.keySet().stream().map(v -> (DynamicObject)objectMap.get(v)).collect(Collectors.groupingBy(v -> v.getString("client")));
            for (Map.Entry<String, List<DynamicObject>> listEntry : listMap.entrySet()) {
                Integer count = dataCount.get(listEntry.getKey());
                DynamicObject object = listEntry.getValue().get(0);
                int userNum = object.getInt("online_user_num");
                if (userNum >= count) continue;
                object.set("online_user_num", (Object)count);
                object.set("modifytime", (Object)new Date());
                saveDataList.add(object);
            }
            DynamicObject[] dynamicObjects = saveDataList.toArray(new DynamicObject[saveDataList.size()]);
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        } else {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_smc_onlineuser_number");
            DynamicObject[] saveData = new DynamicObject[3];
            int size = 0;
            for (Map.Entry<String, Integer> entry : dataCount.entrySet()) {
                Integer o = entry.getValue();
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainEntityType);
                dynamicObject.set("time", (Object)day);
                dynamicObject.set("minute", (Object)minute);
                dynamicObject.set("online_user_num", (Object)o);
                dynamicObject.set("client", (Object)entry.getKey());
                dynamicObject.set("modifytime", (Object)new Date());
                saveData[size] = dynamicObject;
                ++size;
            }
            SaveServiceHelper.save((DynamicObject[])saveData);
        }
    }

    public static Map<String, Integer> getMaxCountFromDB() {
        String countSql = "select count(fuserid) as count,fclient from t_bas_session_history where flogouttime is null  group by fclient;";
        Object[] params = new Object[]{};
        return OnlineUserUtil.queryFromDB(countSql, params);
    }

    public static Map<String, Integer> getHisCountFromDB() {
        String sql = "select count(fuserid)  as count,fclient from t_bas_session_history where flogouttime is null or flogouttime between ? and ?  group by fclient;";
        Calendar instance = Calendar.getInstance();
        Date startTime = OnlineUserUtil.getNowDateOfHour(instance, 0);
        Date endTime = OnlineUserUtil.getNowDateOfHour(instance, 1);
        Object[] objects = new Object[]{startTime, endTime};
        return OnlineUserUtil.queryFromDB(sql, objects);
    }

    private static Date getNowDateOfHour(Calendar instance, int i) {
        instance.set(instance.get(1), instance.get(2), instance.get(5), instance.get(11) + i, 0, 0);
        return instance.getTime();
    }

    public static Map<String, Integer> queryFromDB(String sql, Object[] params) {
        HashMap<String, Integer> data = new HashMap<String, Integer>(3);
        OnlineUserUtil.getDataFromDB(sql, params, data);
        for (String s : client) {
            Integer count = (Integer)data.get(s);
            if (count != null) continue;
            data.put(s, 0);
        }
        data.put("any", (Integer)data.get("mobile") + (Integer)data.get("web"));
        LOGGER.info(((Object)data).toString());
        return data;
    }

    private static void getDataFromDB(String sql, Object[] params, Map<String, Integer> data) {
        DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, resultSet -> {
            while (resultSet.next()) {
                data.put(resultSet.getString("fclient"), resultSet.getInt("count"));
            }
            return true;
        });
    }

    public static Long getTime(int type) {
        Calendar calendar = Calendar.getInstance();
        Long time = 0L;
        switch (type) {
            case 12: {
                int h = calendar.get(11);
                int m = calendar.get(12);
                time = h * 60 + m;
                break;
            }
            case 6: {
                Date date = calendar.getTime();
                time = Long.valueOf(DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).format(date));
                break;
            }
            case 11: {
                time = calendar.get(type);
                break;
            }
            case 2: {
                Date now = calendar.getTime();
                SimpleDateFormat formatMonth = new SimpleDateFormat("yyyyMM");
                time = Long.valueOf(formatMonth.format(now));
                break;
            }
        }
        return time;
    }

    public static Map<Integer, Long> getDataFromDB(String type) {
        Long time = OnlineUserUtil.getTime(6);
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>(24);
        String sql = "select fminute,fonlineusernum from t_bas_daily_onlinenumber where ftime = ? and fclient = ?";
        Object[] params = new Object[]{time, type};
        DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, v -> {
            while (v.next()) {
                int fminute = v.getInt("fminute");
                if (fminute % 60 != 0) continue;
                long fonlineusernum = v.getLong("fonlineusernum");
                hashMap.put(fminute / 60, fonlineusernum);
            }
            return null;
        });
        return OnlineUserUtil.initNumData(hashMap);
    }

    private static Map<Integer, Long> initNumData(HashMap<Integer, Long> hashMap) {
        Calendar instance = Calendar.getInstance();
        int hour = instance.get(11);
        for (int i = 0; i < hour; ++i) {
            if (hashMap.get(i) != null) continue;
            hashMap.put(i, 0L);
        }
        return hashMap;
    }

    public static Map<String, Number> getOnlineTime(String type, HashMap<String, Long> map) {
        String sql = "";
        Object[] params = null;
        Long end = map.get("end");
        Long start = map.get("start");
        if (type.equals("dateTypeDay")) {
            sql = "select sum(fonlinetime) as onlinetime ,fdatetime from t_bas_daily_logintime where fdatetime = ? group by fdatetime";
            params = new Object[]{OnlineUserUtil.getTime(6)};
        }
        if (type.equals("dateTypeWeek") || type.equals("dateTypeMonth")) {
            sql = "select sum(fonlinetime) as onlinetime,fdatetime from t_bas_daily_logintime where fdatetype = 'day' and (fdatetime between  ? and ?) group by fdatetime order by fdatetime ";
            params = new Object[]{start, end};
        }
        if (type.equals("dateTypeYear")) {
            sql = "select sum(fonlinetime) as onlinetime,fdatetime from t_bas_daily_logintime where (fdatetime between  ? and ?) group by fdatetime order by fdatetime ";
            params = new Object[]{start, end};
        }
        if (type.equals("dateTypeCustom")) {
            sql = "select sum(fonlinetime) as onlinetime,fdatetime from t_bas_daily_logintime where fdatetype = 'day' and (fdatetime between  ? and ?) group by fdatetime order by fdatetime";
            params = new Object[]{start, end};
        }
        HashMap<String, Number> dataMap = new HashMap<String, Number>(16);
        DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, v -> {
            while (v.next()) {
                long time = v.getLong("fdatetime");
                Date date = OnlineUserUtil.getDate(time);
                dataMap.put(DateUtil.getDateFormat(DateUtil.DEFAULT_DATE_FORMAT).format(date), v.getBigDecimal("onlinetime"));
            }
            return null;
        });
        return dataMap;
    }

    public static String getMonth(int month) {
        String monthStr = String.valueOf(month).length() < 2 ? "0" + month : String.valueOf(month);
        return monthStr;
    }

    public static void calculateOnlineTime() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_smc_onlinetime", (String)"id,onlinetime,userid,calculationstart,calculationend,compensatetime", (QFilter[])new QFilter[]{new QFilter("islogout", "=", (Object)"0"), new QFilter("datetime", "=", (Object)OnlineUserUtil.getTime(6))});
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>();
        for (DynamicObject onlineInfo : load) {
            List<DynamicObject> onlineTime = OnlineUserUtil.getOnlineTime(onlineInfo);
            if (onlineTime.size() <= 0) continue;
            saveData.addAll(onlineTime);
        }
        DynamicObject[] save = OnlineUserUtil.toArray(saveData);
        SaveServiceHelper.save((DynamicObject[])load);
        SaveServiceHelper.save((DynamicObject[])save);
    }

    private static DynamicObject[] toArray(List<DynamicObject> saveData) {
        DynamicObject[] save = new DynamicObject[saveData.size()];
        for (int i = 0; i < save.length; ++i) {
            save[i] = saveData.get(i);
        }
        return save;
    }

    private static List<DynamicObject> getOnlineTime(DynamicObject onlineInfo) {
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_smc_onlinesession_his", (QFilter[])new QFilter[]{new QFilter("userid", "=", onlineInfo.get("userid.id")), new QFilter("datetime", "=", (Object)OnlineUserUtil.getTime(6)), new QFilter("iscalculation", "=", (Object)"0")});
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>();
        Long calculationend = onlineInfo.getLong("calculationend");
        Long calculationstart = onlineInfo.getLong("calculationstart");
        Long compensatetime = 0L;
        HashMap<String, Long> hashMap = null;
        for (Map.Entry objectEntry : objectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)objectEntry.getValue();
            long logintime = dynamicObject.getDate("logintime").getTime();
            Date logoutDate = dynamicObject.getDate("logouttime");
            long logouttime = 0L;
            if (logoutDate == null) {
                logouttime = Calendar.getInstance().getTimeInMillis();
            } else {
                logouttime = logoutDate.getTime();
                dynamicObject.set("iscalculation", (Object)"1");
                saveData.add(dynamicObject);
            }
            if (OnlineUserUtil.calculationNull(calculationstart, calculationend)) {
                hashMap = OnlineUserUtil.toCaculateTime(calculationstart, calculationend, logintime, logouttime, compensatetime);
                calculationstart = hashMap.get("calculationstart");
                calculationend = hashMap.get("calculationend");
                compensatetime = hashMap.get("compensatetime");
                continue;
            }
            calculationstart = logintime;
            calculationend = logouttime;
        }
        OnlineUserUtil.setCaculateTime(calculationstart, calculationend, compensatetime, onlineInfo);
        return saveData;
    }

    private static boolean calculationNull(Long calculationstart, Long calculationend) {
        return calculationstart != null && calculationstart != 0L && calculationend != null && calculationend != 0L;
    }

    private static HashMap<String, Long> toCaculateTime(Long calculationstart, Long calculationend, Long logintime, Long logouttime, Long compensatetime) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(3);
        if (logintime.compareTo(calculationstart) < 0) {
            calculationstart = logintime;
            if (logouttime.compareTo(calculationstart) < 0) {
                compensatetime = calculationstart - logouttime;
            }
            if (logouttime.compareTo(calculationend) > 0) {
                calculationend = logouttime;
                compensatetime = 0L;
            }
        }
        if (logintime.compareTo(calculationstart) >= 0 && logintime.compareTo(calculationend) < 0 && logouttime.compareTo(calculationend) > 0) {
            calculationend = logouttime;
        }
        if (logintime.compareTo(calculationend) >= 0) {
            compensatetime = logintime - calculationend;
            calculationend = logouttime;
        }
        hashMap.put("calculationstart", calculationstart);
        hashMap.put("calculationend", calculationend);
        hashMap.put("compensatetime", compensatetime);
        return hashMap;
    }

    private static void setCaculateTime(Long calculationstart, Long calculationend, Long compensatetime, DynamicObject onlineInfo) {
        onlineInfo.set("calculationend", (Object)calculationend);
        onlineInfo.set("calculationstart", (Object)calculationstart);
        Long aLong = onlineInfo.getLong("compensatetime");
        onlineInfo.set("compensatetime", (Object)(null == aLong ? compensatetime : aLong + compensatetime));
        BigDecimal onlineTime = new BigDecimal(calculationend - calculationstart - compensatetime).divide(new BigDecimal(3600000), 2, 4);
        onlineInfo.set("onlinetime", (Object)onlineTime);
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat;
    }

    public static String getOnlineTime() {
        String sql = "select sum(fonlinetime) as onlinetime,count(1) onlinenum  from t_bas_daily_logintime  where fdatetime = ?";
        BigDecimal query = (BigDecimal)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{OnlineUserUtil.getTime(6)}, res -> {
            BigDecimal bigDecimal = new BigDecimal(0);
            while (res.next()) {
                BigDecimal onlinetime = res.getBigDecimal("onlinetime");
                BigDecimal onlinenum = res.getBigDecimal("onlinenum");
                if (onlinetime == null || !(onlinenum != null & onlinenum.compareTo(BigDecimal.ZERO) != 0)) continue;
                bigDecimal = onlinetime.divide(onlinenum, 2, 4);
            }
            return bigDecimal;
        });
        return query.toString();
    }

    public static List<Date> getDateListByType(String dateType, Date crueentDay, DateRange dateRange) throws ParseException {
        switch (dateType) {
            case "dateTypeDay": {
                ArrayList<Date> dateList = new ArrayList<Date>(1);
                dateList.add(crueentDay);
                return dateList;
            }
            case "dateTypeWeek": {
                return OnlineUserUtil.getWeekDay();
            }
            case "dateTypeMonth": {
                Calendar thisMonthFirstDateCal = Calendar.getInstance();
                thisMonthFirstDateCal.set(5, 1);
                Calendar thisMonthEndDateCal = Calendar.getInstance();
                thisMonthEndDateCal.add(2, 1);
                thisMonthEndDateCal.set(5, 0);
                return OnlineUserUtil.getBetweenDays(thisMonthFirstDateCal.getTime(), thisMonthEndDateCal.getTime());
            }
            case "dateTypeYear": {
                return OnlineUserUtil.getBetweenDays(DateUtil.getCurrYearFirst(), DateUtil.getCurrYearLast());
            }
            case "dateTypeCustom": {
                return OnlineUserUtil.getBetweenDays(dateRange.getStartDate(), dateRange.getEndDate());
            }
        }
        return null;
    }

    public static List<Date> getWeekDay() {
        ArrayList<Date> dateList = new ArrayList<Date>(7);
        Calendar calendar = Calendar.getInstance();
        while (calendar.get(7) != 2) {
            calendar.add(7, -1);
        }
        for (int i = 0; i < 7; ++i) {
            dateList.add(calendar.getTime());
            calendar.add(5, 1);
        }
        return dateList;
    }

    public static List<String> getDateListForFormat(List<Date> dateList, String formatString) {
        ArrayList<String> dateStrList = new ArrayList<String>();
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        Date start = dateList.get(0);
        Date end = dateList.get(dateList.size() - 1);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        int stratYear = calendar.get(1);
        calendar.setTime(end);
        int endYear = calendar.get(1);
        if (stratYear == endYear) {
            for (Date date : dateList) {
                String dateStr = format.format(date);
                dateStrList.add(dateStr);
            }
        } else {
            OnlineUserUtil.setDayOtherYear(dateList, dateStrList, stratYear);
        }
        return dateStrList;
    }

    private static void setDayOtherYear(List<Date> dateList, List<String> dateStrList, int stratYear) {
        boolean startFlag = true;
        boolean endFlag = true;
        for (Date date : dateList) {
            String dateStr = OnlineUserUtil.getDateFormat().format(date);
            if (dateStr.startsWith(String.valueOf(stratYear))) {
                if (startFlag) {
                    startFlag = false;
                } else {
                    dateStr = dateStr.substring(5, dateStr.length());
                }
            } else if (endFlag) {
                endFlag = false;
            } else {
                dateStr = dateStr.substring(5, dateStr.length());
            }
            dateStrList.add(dateStr);
        }
    }

    public static Date addAndSubtractDaysByGetTime(Date dateTime, int n) {
        return new Date(dateTime.getTime() + (long)(n * 24 * 60 * 60) * 1000L);
    }

    public static List<Date> getBetweenDays(Date start, Date end) throws ParseException {
        ArrayList<Date> result = new ArrayList<Date>(32);
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(6, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        result.add(start);
        while (tempStart.before(tempEnd) || tempStart.equals(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public static Long getTime(Date date) {
        if (date != null) {
            return Long.valueOf(DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).format(date));
        }
        return null;
    }

    public static Date getDate(Long time) {
        if (time != null) {
            try {
                return DateUtil.getDateFormat(DateUtil.TIME_DATE_FORMAT).parse(String.valueOf(time));
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return null;
    }

    public static Integer getMinuteOfDay(Date time) {
        if (time != null) {
            Calendar instance = Calendar.getInstance();
            instance.setTime(time);
            return instance.get(12) + instance.get(11) * 60;
        }
        return null;
    }

    public static void setOnlineUserMax() {
        RequestContext rc = RequestContext.get();
        String accountId = rc.getAccountId();
        OnlineUserUtil.saveMaxData(rc.getAccountId());
        String any = (String)CACHE.get("svc:login:onlineUserNum:any_" + accountId);
        String web = (String)CACHE.get("svc:login:onlineUserNum:web_" + accountId);
        String mobile = (String)CACHE.get("svc:login:onlineUserNum:mobile_" + accountId);
        HashMap<String, String> countFromCache = new HashMap<String, String>(3);
        countFromCache.put("any", StringUtils.isNotEmpty((String)any) ? any : "0");
        countFromCache.put("web", StringUtils.isNotEmpty((String)web) ? web : "0");
        countFromCache.put("mobile", StringUtils.isNotEmpty((String)mobile) ? mobile : "0");
        OnlineUserUtil.saveOnlineUserMax(countFromCache);
    }

    private static void saveMaxData(String accountId) {
        Map<String, Integer> countFromDB = OnlineUserUtil.getMaxCountFromDB();
        Integer web = 0;
        Integer any = 0;
        Integer mobile = 0;
        if (!countFromDB.isEmpty()) {
            web = countFromDB.get("web");
            any = countFromDB.get("any");
            mobile = countFromDB.get("mobile");
        }
        CACHE.put("svc:login:onlineUserNum:any_" + accountId, (Object)String.valueOf(any));
        CACHE.put("svc:login:onlineUserNum:web_" + accountId, (Object)String.valueOf(web));
        CACHE.put("svc:login:onlineUserNum:mobile_" + accountId, (Object)String.valueOf(mobile));
    }

    private static void saveOnlineUserMax(Map<String, String> countFromCache) {
        String any = countFromCache.get("any");
        String web = countFromCache.get("web");
        String mobile = countFromCache.get("mobile");
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        int start = hour * 60;
        int end = hour * 60 + 59;
        Object[] load = BusinessDataServiceHelper.load((String)"bos_smc_onlineuser_max", (String)"id,time,minute,online_user_num,client", (QFilter[])new QFilter[]{new QFilter("time", "=", (Object)OnlineUserUtil.getTime(new Date())), new QFilter("minute", "<=", (Object)end).and(new QFilter("minute", ">=", (Object)start))});
        LOGGER.info("onlineMaxQuery::" + Arrays.toString(load));
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_smc_onlineuser_max");
        List<Object> anys = new ArrayList();
        List<Object> webs = new ArrayList();
        List<Object> mobiles = new ArrayList();
        if (null != load && load.length > 0) {
            Map<String, List<DynamicObject>> clientMap = Arrays.stream(load).collect(Collectors.groupingBy(v -> v.getString("client")));
            if (null != clientMap.get("any")) {
                anys = clientMap.get("any");
            }
            if (null != clientMap.get("web")) {
                webs = clientMap.get("web");
            }
            if (null != clientMap.get("mobile")) {
                mobiles = clientMap.get("mobile");
            }
        }
        HashMap<String, DynamicObject> dy = new HashMap<String, DynamicObject>(3);
        dy.put("mobile", mobiles.size() > 0 ? (DynamicObject)mobiles.get(0) : new DynamicObject((DynamicObjectType)mainEntityType));
        dy.put("web", webs.size() > 0 ? (DynamicObject)webs.get(0) : new DynamicObject((DynamicObjectType)mainEntityType));
        dy.put("any", anys.size() > 0 ? (DynamicObject)anys.get(0) : new DynamicObject((DynamicObjectType)mainEntityType));
        OnlineUserUtil.saveOnlineUserMaxDB(any, web, mobile, dy);
    }

    private static Integer cacheValueParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static void saveOnlineUserMaxDB(String any, String web, String mobile, Map<String, DynamicObject> dy) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        Long minute = OnlineUserUtil.getTime(12);
        for (Map.Entry<String, DynamicObject> objectEntry : dy.entrySet()) {
            DynamicObject dynamicObject = objectEntry.getValue();
            String s = objectEntry.getKey();
            int num = dynamicObject.getInt("online_user_num");
            switch (s) {
                case "any": {
                    Integer anyInt = OnlineUserUtil.cacheValueParseInt(any);
                    if (anyInt <= num) break;
                    OnlineUserUtil.getSaveData(s, anyInt, minute, dynamicObject, dynamicObjects);
                    break;
                }
                case "web": {
                    Integer webInt = OnlineUserUtil.cacheValueParseInt(web);
                    if (webInt <= num) break;
                    OnlineUserUtil.getSaveData(s, webInt, minute, dynamicObject, dynamicObjects);
                    break;
                }
                case "mobile": {
                    Integer mobileInt = OnlineUserUtil.cacheValueParseInt(mobile);
                    if (mobileInt <= num) break;
                    OnlineUserUtil.getSaveData(s, mobileInt, minute, dynamicObject, dynamicObjects);
                    break;
                }
            }
        }
        LOGGER.info("saveOnlineMax" + dynamicObjects.size());
        if (dynamicObjects.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
    }

    private static void getSaveData(String key, Integer value, Long minute, DynamicObject dynamicObject, List<DynamicObject> dynamicObjects) {
        dynamicObject.set("online_user_num", (Object)value);
        dynamicObject.set("time", (Object)OnlineUserUtil.getTime(new Date()));
        dynamicObject.set("minute", (Object)minute);
        dynamicObject.set("client", (Object)key);
        dynamicObjects.add(dynamicObject);
    }

    public static Integer getMaxNum() {
        String sql = "select max(fonlineusernum) from t_bas_daily_onlinemax where ftime = ?";
        Integer query = (Integer)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{OnlineUserUtil.getTime(new Date())}, v -> {
            Integer value = 0;
            while (v.next()) {
                value = v.getInt(1);
            }
            return value;
        });
        return query;
    }

    public static Map<String, Number> getMaxNumFromDate(DateRangeDTO dateRangeDTO, String type) {
        String sql;
        Long start = OnlineUserUtil.getTime(dateRangeDTO.getDateRange().getStartDate());
        Long end = OnlineUserUtil.getTime(dateRangeDTO.getDateRange().getEndDate());
        HashMap map = new HashMap(16);
        if ("dateTypeDay".equals(dateRangeDTO.getDateType())) {
            sql = "select fonlineusernum, fminute from t_bas_daily_onlinemax where ftime = ? and fclient = ? order by fminute";
            Object[] params = new Object[]{start, type};
            DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, v -> {
                while (v.next()) {
                    map.put(v.getString("fminute"), v.getInt("fonlineusernum"));
                }
                return true;
            });
        } else {
            sql = "select max(fonlineusernum) as fonlineusernum, ftime from t_bas_daily_onlinemax where fclient = ? and (ftime between ? and ?) group by ftime order by ftime";
            Object[] params = new Object[]{"any", start, end};
            DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, v -> {
                while (v.next()) {
                    long time = v.getLong("ftime");
                    Date date = OnlineUserUtil.getDate(time);
                    map.put(DateUtil.getDateFormat(DateUtil.DEFAULT_DATE_FORMAT).format(date), v.getInt("fonlineusernum"));
                }
                return true;
            });
        }
        TreeMap<String, Number> sortMap = new TreeMap<String, Number>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }

    public static void sessionTimeOut() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_smc_onlinesession_his", (String)"id,sessionid", (QFilter[])new QFilter[]{new QFilter("logouttime", "is null", null)}, (String)"logintime desc", (int)30000);
        ArrayList<String> sessionIdHis = new ArrayList<String>();
        if (load != null && load.length > 0) {
            for (DynamicObject object : load) {
                String sessionid = Encrypters.decode((String)object.getString("sessionid"));
                SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionid);
                if (!StringUtils.isEmpty((String)sessionDAO.getAttribute("loginTime"))) continue;
                sessionIdHis.add(object.getString("id"));
            }
        }
        int pageSize = 500;
        if (sessionIdHis.size() > 0 && sessionIdHis.size() < pageSize) {
            OnlineUserUtil.updateSessionHis(sessionIdHis);
        }
        if (sessionIdHis.size() >= pageSize) {
            List<List<String>> lists = OnlineUserUtil.averageAssign(sessionIdHis, (int)Math.ceil((double)sessionIdHis.size() / (double)pageSize));
            for (List<String> list : lists) {
                OnlineUserUtil.updateSessionHis(list);
            }
        }
    }

    private static void updateSessionHis(List<String> sessionIdHis) {
        String updateSql = "update t_bas_session_history set flogouttime = ? where fid in %s";
        String inParams = OnlineUserUtil.getInParams(sessionIdHis);
        String format = String.format(updateSql, inParams);
        DB.execute((DBRoute)DBRoute.base, (String)format, (Object[])new Object[]{new Date()});
    }

    private static String getInParams(List<String> sessionIdHis) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < sessionIdHis.size(); ++i) {
            if (i == sessionIdHis.size() - 1) {
                sb.append("'").append(sessionIdHis.get(i)).append("'").append(")");
                continue;
            }
            sb.append("'").append(sessionIdHis.get(i)).append("'").append(",");
        }
        return sb.toString();
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(64);
        int number = source.size() / n;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            value = i == n - 1 ? source.subList(i * number, source.size()) : source.subList(i * number, (i + 1) * number);
            result.add(value);
        }
        return result;
    }

    public static void removeDataForOneYear() {
        MainEntityType smcOnlineSessionHis = EntityMetadataCache.getDataEntityType((String)"bos_smc_onlinesession_his");
        Map<Integer, List<Long>> deletePks = OnlineUserUtil.getDeletePks();
        for (Map.Entry<Integer, List<Long>> entry : deletePks.entrySet()) {
            if (entry.getValue() == null) continue;
            DeleteServiceHelper.delete((IDataEntityType)smcOnlineSessionHis, (Object[])entry.getValue().toArray());
        }
    }

    private static Map<Integer, List<Long>> getDeletePks() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -12);
        Date lastYearDate = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String format = simpleDateFormat.format(lastYearDate);
        QFilter qFilter = new QFilter("datetime", "<=", (Object)Long.parseLong(format));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_smc_onlinesession_his", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"logintime", (int)5000000);
        if (query == null || query.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        return OnlineUserUtil.listToBatchMap(query, 2000);
    }

    private static Map<Integer, List<Long>> listToBatchMap(DynamicObjectCollection query, int batchSize) {
        HashMap<Integer, List<Long>> hashMap = new HashMap<Integer, List<Long>>(32);
        Integer index = 0;
        ArrayList<Long> pks = new ArrayList<Long>(batchSize);
        for (int i = 0; i < query.size(); ++i) {
            if (i >= batchSize && i % batchSize == 0) {
                hashMap.put(index, pks);
                index = i;
                pks = new ArrayList(batchSize);
            }
            if (i == query.size() - 1) {
                hashMap.put(index, pks);
            }
            pks.add(((DynamicObject)query.get(i)).getLong("id"));
        }
        return hashMap;
    }
}

