/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.smc.user.service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.smc.user.DateRange;
import kd.bos.smc.user.plugin.OnlineUserUtil;
import kd.bos.smc.user.service.DateRangeDTO;

public class OnlineUserService {
    public Map<Object, DynamicObject> getUserNumByRange(DateRangeDTO dateRangeDTO) {
        Date start = this.getDateTime(dateRangeDTO.getDateRange().getStartDate());
        Date end = this.getDateTime(dateRangeDTO.getDateRange().getEndDate());
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_smc_onlineuser_numday", (String)"onlinenumber,datetime", (QFilter[])new QFilter[]{new QFilter("datetime", ">=", (Object)start).and(new QFilter("datetime", "<=", (Object)end))}, (String)"datetime");
        return loadFromCache;
    }

    private Date getDateTime(Date date) {
        Long time = OnlineUserUtil.getTime(date);
        return OnlineUserUtil.getDate(time);
    }

    public List<DynamicObject> getUserDeatilByDaily(DateRange dateRange) {
        Date start = this.getDateTime(dateRange.getStartDate());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_smc_onlinesession_his", (String)"userid,username,loginip,client,logintime,logouttime", (QFilter[])new QFilter[]{new QFilter("logintime", "<=", (Object)start).and(new QFilter("logouttime", ">=", (Object)dateRange.getEndDate()).or("logouttime", "is null", null)).or(new QFilter("logintime", "<=", (Object)start).and(new QFilter("logouttime", "<=", (Object)dateRange.getEndDate()).and(new QFilter("logouttime", ">=", (Object)start)))).or(new QFilter("logintime", ">=", (Object)start).and("logouttime", "<=", (Object)dateRange.getEndDate())).or(new QFilter("logintime", ">=", (Object)start).and("logintime", "<=", (Object)dateRange.getEndDate()).and(new QFilter("logouttime", ">=", (Object)dateRange.getEndDate()).or("logouttime", "is null", null)))}, (String)"logintime desc", (int)10000);
        return this.filterData(load, "any");
    }

    private List<DynamicObject> filterData(DynamicObject[] load, String type) {
        return Arrays.stream(load).filter(v -> {
            if ("any".equals(type)) {
                return "web".equals(v.getString("client")) || "mobile".equals(v.getString("client"));
            }
            if ("web".equals(type)) {
                return "web".equals(v.getString("client"));
            }
            if ("mobile".equals(type)) {
                return "mobile".equals(v.getString("client"));
            }
            return false;
        }).collect(Collectors.toList());
    }
}

