/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.cache;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;

public class PortalAppFeaturesCacheMrg {
    private static final String APP_FEATURES = "APP_FEATURES";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("APP_FEATURES", new DistributeCacheHAPolicy(true, true));
    private static final String ALL_APP_FEATURES = "ALL_APP_FEATURES";
    private static final String USER_APP_FEATURES = "USER_APP_FEATURES";
    public static final String DATA_LOADED = "DATA_LOADED";

    private PortalAppFeaturesCacheMrg() {
    }

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e3a\u7a7a\u3002", (String)"PortalAppFeaturesCacheMrg_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static String getType4AllAppFeatures() {
        return "ALL_APP_FEATURES_" + PortalAppFeaturesCacheMrg.getAcctId();
    }

    public static String getType4UserAppFeatures() {
        return "USER_APP_FEATURES_" + PortalAppFeaturesCacheMrg.getAcctId();
    }

    public static void clearAllCache() {
    }

    public static void clearCache(String type) {
        type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId();
        cache.removeType(type);
    }

    public static void clearCache(String type, String key) {
        type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId();
        cache.remove(type, key);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        List<String> keys;
        Map kvs = cache.getAll(type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId());
        if (kvs != null && kvs.size() > 0 && (keys = kvs.keySet().stream().filter(key -> key.startsWith(keyPrefix)).collect(Collectors.toList())).size() > 0) {
            cache.remove(type, keys.toArray(new String[0]));
        }
    }

    public static String getCache(String type, String key) {
        type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId();
        return (String)cache.get(type, key);
    }

    public static void putCache(String type, String key, String value) {
        type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId();
        cache.put(type, key, (Object)value);
    }

    public static void putCache(String type, Map<String, String> values) {
        type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId();
        cache.put(type, values);
    }

    public static Map<String, String> getCache(String type) {
        type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId();
        return cache.getAll(type);
    }

    public static void loaded(String type, String key) {
        type = type + "_" + PortalAppFeaturesCacheMrg.getAcctId();
        cache.put(type, key, (Object)DATA_LOADED);
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.equals(DATA_LOADED);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }
}

