/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.ext.form.control.AppStarted;
import kd.bos.ext.form.control.events.AppStartedListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.sysint.servicehelper.KnowledgeServiceHelper;
import kd.bos.sysint.servicehelper.constant.LocationConst;
import kd.bos.sysint.servicehelper.dto.KnowledgeSearchParams;

public class AppStartedFormPlugin
extends AbstractFormPlugin
implements AppStartedListener {
    private static Log logger = LogFactory.getLog(AppStartedFormPlugin.class);
    static String CUSTOMPARAMETERS = "customparameters";
    private static final String APPINTRODUCTION = "AppIntroduction";
    private static final String OPERATINGGUIDE = "OperatingGuide";
    private static final String HOTISSUES = "HotIssues";
    private static final String ADVANCEDSKILLS = "AdvancedSkills";
    private static final String NEWFEATURES = "NewFeatures";
    private static final String BOS_SYSINTEG_FORMPLUGIN = "bos-sysinteg-formplugin";
    private static final String ERRCODE = "errcode";
    private static final String ARTICLE = "Article";
    private static final String DESCRIPTION = "description";
    private static final String CONTENT = "content";
    private static final String ISRECOMMEND = "isRecommend";

    public void initialize() {
        super.initialize();
        AppStarted appstarted = (AppStarted)this.getControl("appstartedap");
        appstarted.addGetMoreListener((AppStartedListener)this);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (APPINTRODUCTION.equals(e.getName())) {
            this.getHelpInfo(APPINTRODUCTION);
        } else if (OPERATINGGUIDE.equals(e.getName())) {
            this.getHelpInfo(OPERATINGGUIDE);
        } else if (HOTISSUES.equals(e.getName())) {
            this.getHelpInfo(HOTISSUES);
        } else if (ADVANCEDSKILLS.equals(e.getName())) {
            this.getHelpInfo(ADVANCEDSKILLS);
        } else if (NEWFEATURES.equals(e.getName())) {
            this.getHelpInfo(NEWFEATURES);
        }
    }

    public void afterBindData(EventObject e) {
        boolean langFlag;
        Lang lang = RequestContext.get().getLang();
        boolean bl = langFlag = lang == Lang.zh_CN || lang == Lang.zh_TW;
        if (!langFlag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tipspanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"helppanel"});
            return;
        }
        super.afterBindData(e);
        boolean isContinue = this.getHelpInfo("AppIntroCourse");
        if (isContinue) {
            this.getView().addClientCallBack(APPINTRODUCTION, Integer.valueOf(100));
            this.getView().addClientCallBack(OPERATINGGUIDE, Integer.valueOf(200));
            this.getView().addClientCallBack(HOTISSUES, Integer.valueOf(300));
            this.getView().addClientCallBack(ADVANCEDSKILLS, Integer.valueOf(400));
            this.getView().addClientCallBack(NEWFEATURES, Integer.valueOf(500));
        }
    }

    private boolean getHelpInfo(String title) {
        IFormView view = this.getView();
        ArrayList<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        String startedLabel = "GettingStarted";
        String type = "Article,Question,Course";
        String module = view.getFormShowParameter().getAppId();
        String domain = AppMetadataCache.getAppInfo((String)module).getCloudNum();
        String bizentity = "";
        String label = APPINTRODUCTION;
        String labelName = ResManager.loadKDString((String)"\u5e94\u7528\u4ecb\u7ecd", (String)"AppStartedFormPlugin_0", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]);
        String restrictIn = "domain,module,label";
        String content = "";
        String authcode = "";
        String searchScope = "knowledge";
        int page = 1;
        int pageSize = 5;
        Boolean allowHtml = false;
        boolean isContinue = true;
        KnowledgeSearchParams searchParams = new KnowledgeSearchParams(type, domain, module, bizentity, label + "," + startedLabel, restrictIn, content, authcode, page, pageSize, allowHtml, searchScope);
        searchParams.setLocation(LocationConst.APP_HELP.code());
        if ("AppIntroCourse".equals(title)) {
            searchParams.setType("Course");
            String appIntResponse = KnowledgeServiceHelper.knowledgeSearch(searchParams);
            Map<String, Object> appIntJason = this.parse(label, labelName, appIntResponse, module);
            if ("1".equals(appIntJason.get(ERRCODE)) || "2".equals(appIntJason.get(ERRCODE))) {
                isContinue = false;
            }
            response.add(appIntJason);
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            userMap.put("code", "user");
            userMap.put("name", user.get("name"));
            response.add(userMap);
            HashMap<String, String> appMap = new HashMap<String, String>();
            appMap.put("code", "appname");
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)module);
            appMap.put("name", (String)appInfo.getName());
            response.add(appMap);
        } else if (APPINTRODUCTION.equals(title)) {
            label = APPINTRODUCTION;
            searchParams.setType(ARTICLE);
            searchParams.setLabel(label + "," + startedLabel);
            String appArticleResponse = KnowledgeServiceHelper.knowledgeSearch(searchParams);
            Map<String, Object> appArticleJason = this.parse("AppArticle", ResManager.loadKDString((String)"\u5e94\u7528\u6587\u7ae0", (String)"AppStartedFormPlugin_1", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]), appArticleResponse, module);
            response.add(appArticleJason);
        } else if (OPERATINGGUIDE.equals(title)) {
            label = OPERATINGGUIDE;
            labelName = ResManager.loadKDString((String)"\u64cd\u4f5c\u6307\u5f15", (String)"AppStartedFormPlugin_2", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]);
            searchParams.setLabel(label + "," + startedLabel);
            String opInstResponse = KnowledgeServiceHelper.knowledgeSearch(searchParams);
            Map<String, Object> opInstJason = this.parse(label, labelName, opInstResponse, module);
            response.add(opInstJason);
        } else if (HOTISSUES.equals(title)) {
            label = HOTISSUES;
            labelName = ResManager.loadKDString((String)"\u70ed\u95e8\u95ee\u9898", (String)"AppStartedFormPlugin_3", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]);
            searchParams.setLabel(label + "," + startedLabel);
            String hotIssuesResponse = KnowledgeServiceHelper.knowledgeSearch(searchParams);
            Map<String, Object> hotIssuesJason = this.parse(label, labelName, hotIssuesResponse, module);
            response.add(hotIssuesJason);
        } else if (ADVANCEDSKILLS.equals(title)) {
            label = ADVANCEDSKILLS;
            labelName = ResManager.loadKDString((String)"\u9ad8\u7ea7\u6280\u5de7", (String)"AppStartedFormPlugin_4", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]);
            searchParams.setLabel(label + "," + startedLabel);
            String advancedSkillsResponse = KnowledgeServiceHelper.knowledgeSearch(searchParams);
            Map<String, Object> advancedSkillsJason = this.parse(label, labelName, advancedSkillsResponse, module);
            response.add(advancedSkillsJason);
        } else if (NEWFEATURES.equals(title)) {
            label = NEWFEATURES;
            labelName = ResManager.loadKDString((String)"\u65b0\u7279\u6027", (String)"AppStartedFormPlugin_5", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]);
            searchParams.setLabel(label + "," + startedLabel);
            searchParams.setType(ARTICLE);
            String newFeaturesResponse = KnowledgeServiceHelper.knowledgeSearch(searchParams);
            Map<String, Object> newFeaturesJason = this.parse(label, labelName, newFeaturesResponse, module);
            response.add(newFeaturesJason);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("appstartedap", "setHelpCenterData", new Object[]{response});
        return isContinue;
    }

    private Map<String, Object> parse(String label, String labelName, String source, String moudle) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put(ERRCODE, "0");
        response.put(DESCRIPTION, "");
        response.put("category", labelName);
        response.put("code", label);
        String cloudNumber = AppMetadataCache.getAppInfo((String)moudle).getCloudNum();
        ArrayList contentList = new ArrayList();
        HashMap<String, Object> content = null;
        try {
            JSONObject jason = (JSONObject)JSON.parse((String)source);
            String errcode = jason.getString(ERRCODE);
            String description = jason.getString(DESCRIPTION);
            Object moreUrl = jason.get((Object)"moreUrl");
            if ("1".equals(errcode) || "2".equals(errcode)) {
                response.put(ERRCODE, errcode);
                response.put(DESCRIPTION, description);
                return response;
            }
            JSONArray contentJason = (JSONArray)jason.get((Object)CONTENT);
            JSONObject eachContentJason = null;
            String title = null;
            String contentTxt = null;
            String type = null;
            String publishTime = null;
            Integer views = null;
            Integer like = null;
            Integer comments = null;
            String url = null;
            Integer isKnowledge = null;
            Boolean isRecommend = null;
            String picPath = null;
            for (Object eachContent : contentJason.toArray()) {
                eachContentJason = (JSONObject)eachContent;
                title = (String)eachContentJason.get((Object)"title");
                contentTxt = (String)eachContentJason.get((Object)CONTENT);
                type = (String)eachContentJason.get((Object)"entity-type");
                if (eachContentJason.get((Object)"createdAt") != null) {
                    publishTime = eachContentJason.get((Object)"createdAt").toString();
                }
                views = (Integer)eachContentJason.get((Object)"views");
                like = (Integer)eachContentJason.get((Object)"supports");
                if (like == null) {
                    like = 0;
                }
                comments = (Integer)eachContentJason.get((Object)"comments");
                url = (String)eachContentJason.get((Object)"entityUrl");
                isKnowledge = (Integer)eachContentJason.get((Object)"isKnowledge");
                isRecommend = eachContentJason.getBoolean(ISRECOMMEND);
                picPath = (String)eachContentJason.get((Object)"picPath");
                content = new HashMap<String, Object>();
                content.put("title", title);
                if (contentTxt == null) {
                    contentTxt = "";
                }
                content.put(CONTENT, contentTxt);
                content.put("publishTime", publishTime);
                content.put("like", like);
                content.put("views", views);
                content.put("comments", comments);
                content.put("picPath", picPath);
                content.put("type", type);
                switch (type) {
                    case "Question": {
                        content.put("typeName", ResManager.loadKDString((String)"\u95ee\u7b54", (String)"AppStartedFormPlugin_6", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
                        break;
                    }
                    case "Article": {
                        content.put("typeName", ResManager.loadKDString((String)"\u6587\u7ae0", (String)"AppStartedFormPlugin_7", (String)BOS_SYSINTEG_FORMPLUGIN, (Object[])new Object[0]));
                        break;
                    }
                }
                if (isRecommend != null && isRecommend.booleanValue()) {
                    content.put(ISRECOMMEND, 1);
                } else {
                    content.put(ISRECOMMEND, 0);
                }
                content.put("isKnowledge", isKnowledge);
                content.put("url", url);
                contentList.add(content);
            }
            if (moreUrl != null && StringUtils.isNotEmpty((CharSequence)moreUrl.toString())) {
                int produceId = KnowledgeServiceHelper.getProductId();
                StringBuilder sb = new StringBuilder();
                sb.append(moreUrl).append(this.getAppendSign(moreUrl.toString())).append("productId=").append(produceId).append("&domain=").append(cloudNumber).append("&module=").append(moudle).append("&labels=").append(label);
                response.put("url", sb.toString());
            }
            response.put(CONTENT, contentList);
        }
        catch (Exception e) {
            logger.info("parse", (Object)e);
            response.put(ERRCODE, "1");
            response.put(DESCRIPTION, e.getMessage());
            return response;
        }
        return response;
    }

    private String getAppendSign(String url) {
        String sign = url.contains("?") ? "&" : "?";
        return sign;
    }
}

