/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.servicehelper.ElectronicContractHelper;

public class ECSealAddPlugin
extends AbstractFormPlugin {
    private static final String IS_SEAL_UPDATA = "isSealUpdata";
    private static final String SEAL_SET_DEFAULT = "seal_setDefault";
    private static final String ISDEFAULT_UPDATA = "isdefaultUpdata";
    private static final String SUBJECTID = "subjectid";
    private static final String SUBJECTTYPE = "subjecttype";
    private static final String COMPANYSEAL = "companyseal";
    private static final String ISDEFAULT = "isdefault";
    private static final String BOS_EC_SEAL = "bos_ec_seal";
    private static final String SIGNATUREID = "signatureid";
    private static Log logger = LogFactory.getLog(ECSealAddPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterBindData(EventObject e) {
        Map data = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)data)) {
            return;
        }
        try {
            Long sealPkid = this.getSealPkid();
            if (sealPkid == null) {
                Object entityName = data.get("entityName");
                Object subjectid = data.get(SUBJECTID);
                this.getModel().setValue(SUBJECTID, subjectid);
                if (entityName != null) {
                    this.getModel().setValue(SUBJECTTYPE, (Object)this.getSubjectType(entityName.toString()));
                }
                this.getModel().setDataChanged(false);
            }
        }
        catch (Exception ex) {
            logger.info(ex.getMessage(), (Object)ex);
        }
    }

    private Integer getSubjectType(String entityName) {
        if ("contractsubject".equals(entityName)) {
            return 1;
        }
        if ("companyauth".equals(entityName)) {
            return 2;
        }
        return null;
    }

    private Long getSealPkid() {
        Map data = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)data)) {
            return null;
        }
        Object objId = data.get("sealPkid");
        if (objId == null) {
            return null;
        }
        return Long.valueOf(objId.toString());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (COMPANYSEAL.equals(name)) {
            this.getPageCache().put(IS_SEAL_UPDATA, "true");
        }
        if (ISDEFAULT.equals(name)) {
            this.getPageCache().put(ISDEFAULT_UPDATA, "true");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            Object companyseal = this.getModel().getValue(COMPANYSEAL);
            String isSealUpdata = this.getPageCache().get(IS_SEAL_UPDATA);
            if (StringUtils.isNotEmpty((CharSequence)isSealUpdata)) {
                boolean reuslt = this.uploadSeal(companyseal.toString());
                if (reuslt) {
                    this.getPageCache().remove(IS_SEAL_UPDATA);
                } else {
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object companyseal = this.getModel().getValue(COMPANYSEAL);
        if (StringUtils.isBlank((Object)companyseal)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u7ae0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ECSealAddPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (this.checkUniqueIndex()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u4e3b\u4f53\u5df2\u5b58\u5728\u540c\u7c7b\u578b\u7684\u7b7e\u7ae0\u3002", (String)"ECSealAddPlugin_2", (String)"bos-portal-plugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String isdefaultUpdata = this.getPageCache().get(ISDEFAULT_UPDATA);
        Object isdefault = this.getModel().getValue(ISDEFAULT);
        if (StringUtils.isNotEmpty((CharSequence)isdefaultUpdata) && isdefault != null && Boolean.parseBoolean(isdefault.toString())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5df2\u5c06\u5f53\u524d\u7b7e\u7ae0\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u7b7e\u7ae0\uff0c\u5982\u4e3b\u4f53\u5df2\u5b58\u5728\u9ed8\u8ba4\u7b7e\u7ae0\u5c06\u88ab\u66ff\u6362\u4e3a\u5f53\u524d\u7b7e\u7ae0\uff0c\u786e\u5b9a\u662f\u5426\u66ff\u6362\uff1f", (String)"ECSealAddPlugin_1", (String)"bos-portal-plugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(SEAL_SET_DEFAULT, (IFormPlugin)this));
            evt.setCancel(true);
        } else {
            String isSealUpdata = this.getPageCache().get(IS_SEAL_UPDATA);
            if (StringUtils.isNotEmpty((CharSequence)isSealUpdata)) {
                boolean reuslt = this.uploadSeal(companyseal.toString());
                if (reuslt) {
                    this.getPageCache().remove(IS_SEAL_UPDATA);
                } else {
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    private boolean checkUniqueIndex() {
        Object subjecttype = this.getModel().getValue(SUBJECTTYPE);
        Object subjectid = this.getModel().getValue(SUBJECTID);
        QFilter filter = new QFilter(SUBJECTTYPE, "=", subjecttype).and(new QFilter(SUBJECTID, "=", subjectid));
        DynamicObject dyObj = (DynamicObject)this.getModel().getValue("sealtype");
        Long sealtype = dyObj != null ? Long.valueOf(dyObj.getLong("id")) : Long.valueOf(0L);
        filter.and(new QFilter("sealtype", "=", (Object)sealtype));
        Object id = this.getModel().getValue("id");
        if (id != null && !Long.valueOf(id.toString()).equals(0L)) {
            filter.and(new QFilter("id", "!=", id));
        }
        return QueryServiceHelper.exists((String)BOS_EC_SEAL, (QFilter[])new QFilter[]{filter});
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (SEAL_SET_DEFAULT.equals(callBackId) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getView().invokeOperation("save");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        if ("save".equals(key) && args.getOperationResult().isSuccess()) {
            Object id = this.getModel().getValue("id");
            Object companyseal = this.getModel().getValue(COMPANYSEAL);
            HashMap<String, Object> retData = new HashMap<String, Object>();
            Object isdefault = this.getModel().getValue(ISDEFAULT);
            if (isdefault != null && Boolean.parseBoolean(isdefault.toString())) {
                Object subjectid = this.getModel().getValue(SUBJECTID);
                QFilter qfilter = new QFilter(SUBJECTID, "=", subjectid);
                QFilter idFilter = new QFilter("id", "!=", id);
                QFilter defaultFilter = new QFilter(ISDEFAULT, "=", (Object)Boolean.TRUE);
                DynamicObject[] datas = BusinessDataServiceHelper.load((String)BOS_EC_SEAL, (String)"id, isdefault", (QFilter[])new QFilter[]{qfilter, idFilter, defaultFilter});
                for (int i = 0; i < datas.length; ++i) {
                    DynamicObject data = datas[i];
                    data.set(ISDEFAULT, (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])datas);
            }
            retData.put(ISDEFAULT, isdefault);
            Object signatureid = this.getModel().getValue(SIGNATUREID);
            retData.put(SIGNATUREID, signatureid);
            retData.put(COMPANYSEAL, companyseal);
            this.getView().returnDataToParent(retData);
        }
    }

    private boolean uploadSeal(String companysealPath) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams)) {
            return false;
        }
        try {
            String response;
            JSONObject json;
            String code;
            String kdappid = customParams.get("kdappid").toString();
            String key = customParams.get("key").toString();
            String userId = customParams.get("userId").toString();
            Object signatureid = customParams.get(SIGNATUREID);
            if (StringUtils.isEmpty((CharSequence)companysealPath)) {
                companysealPath = customParams.get("companysealPath").toString();
            }
            HashMap<String, String> data = new HashMap<String, String>(16);
            data.put("userId", userId);
            if (StringUtils.isNotBlank(signatureid)) {
                data.put(SIGNATUREID, signatureid.toString());
            }
            if (!"0".equals(code = (json = (JSONObject)JSON.parse((String)(response = ElectronicContractHelper.uploadSeal(kdappid, key, data, companysealPath)))).get((Object)"code").toString())) {
                String msg = json.get((Object)"msg").toString();
                if ("1044".equals(code)) {
                    String respData = json.get((Object)"data").toString();
                    msg = msg + "\uff0c" + respData;
                }
                this.getView().showTipNotification(msg);
                return false;
            }
            JSONObject contentJson = (JSONObject)json.get((Object)"data");
            String signatureId = contentJson.get((Object)"signatureId").toString();
            this.getModel().setValue(SIGNATUREID, (Object)signatureId);
            this.getModel().setDataChanged(false);
        }
        catch (Exception e) {
            logger.info("ECUploadSealPlugin--uploadSeal", (Object)e);
            this.getView().showTipNotification(e.getMessage());
            return false;
        }
        return true;
    }
}

