/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.formplugin.enums.SealProviderType;

public class ECSealManagerPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String REFRESH_ENTRY_DATA = "refreshEntryData";
    private static Log logger = LogFactory.getLog(ECSealManagerPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        if (entryentity != null) {
            entryentity.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return;
        }
        try {
            String orgName = customParams.get("name").toString();
            String icCode = customParams.get("icCode").toString();
            String signprovider = customParams.get("signprovider").toString();
            String subjectidStr = customParams.get("subjectid").toString();
            this.getModel().setValue("subjectinfo", (Object)orgName);
            this.getModel().setValue("uniformsocialcreditcode", (Object)icCode);
            this.getModel().setValue("signprovider", (Object)SealProviderType.getNameByType(signprovider));
            String entityName = customParams.get("entityName").toString();
            this.initEntityData();
            this.getPageCache().put("entityName", entityName);
            this.getPageCache().put("subjectid", subjectidStr);
            if ("companyauth".equals(entityName)) {
                LocaleString caption = ResManager.getLocaleString((String)"\u7b7e\u7ea6\u4e3b\u4f53", (String)"ECSealManagerPlugin_0", (String)BOS_PORTAL_PLUGIN);
                HashMap<String, LocaleString> controlMetadata = new HashMap<String, LocaleString>();
                controlMetadata.put("text", caption);
                this.getView().updateControlMetadata("contractpanel", controlMetadata);
                HashMap<String, LocaleString> contractinfo = new HashMap<String, LocaleString>();
                contractinfo.put("caption", caption);
                this.getView().updateControlMetadata("subjectinfo", contractinfo);
            }
        }
        catch (Exception ex) {
            logger.info("loadData error", (Object)ex);
        }
    }

    private void initEntityData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String idStr = customParams.get("subjectid").toString();
        Long id = Long.valueOf(idStr);
        this.buildSealEntryData(id);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btn_new": {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                this.showAddSeal(customParams);
                break;
            }
            case "btn_refresh": {
                this.initEntityData();
                this.getView().updateView();
                break;
            }
        }
    }

    private void showAddSeal(Map<String, Object> customParams) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("bos_ec_seal");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Object sealPkid = customParams.get("sealPkid");
        if (sealPkid != null) {
            parameter.setPkId(sealPkid);
        }
        parameter.setCustomParams(customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFRESH_ENTRY_DATA));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        String actionId = event.getActionId();
        if (REFRESH_ENTRY_DATA.equals(actionId) && (returnData = event.getReturnData()) instanceof Map) {
            Map map = (Map)returnData;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String entityName = customParams.get("entityName").toString();
            Object subjectPkid = customParams.get("subjectid");
            Object isdefault = map.get("isdefault");
            if (isdefault != null && StringUtil.isNotBlank((CharSequence)isdefault.toString()) && Boolean.parseBoolean(isdefault.toString())) {
                String signatureId = map.get("signatureid").toString();
                String companyseal = map.get("companyseal").toString();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(subjectPkid, (String)entityName);
                dynamicObject.set("signatureid", (Object)signatureId);
                dynamicObject.set("companyseal", (Object)companyseal);
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
            this.initEntityData();
        }
    }

    private void buildSealEntryData(Long constractId) {
        DynamicObjectCollection contractSealRelCol = QueryServiceHelper.query((String)"bos_ec_seal", (String)"id, signatureid, sealtype.name, isdefault, remark, companyseal", (QFilter[])new QFilter[]{new QFilter("subjectid", "=", (Object)constractId)}, (String)"id desc");
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        int count = contractSealRelCol.size();
        if (count > 0) {
            int[] index = model.batchCreateNewEntryRow("entryentity", count);
            for (int i = 0; i < count; ++i) {
                DynamicObject dynamicObject = (DynamicObject)contractSealRelCol.get(i);
                model.setValue("pkid", dynamicObject.get("id"), index[i]);
                model.setValue("signatureid", dynamicObject.get("signatureid"), index[i]);
                model.setValue("companyseal", dynamicObject.get("companyseal"), index[i]);
                model.setValue("sealtype", dynamicObject.get("sealtype.name"), index[i]);
                model.setValue("isdefault", dynamicObject.get("isdefault"), index[i]);
                model.setValue("remark", dynamicObject.get("remark"), index[i]);
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
        model.setDataChanged(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", evt.getRowIndex());
        if (dynamicObject != null) {
            Long sealPkid = dynamicObject.getLong("pkid");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("sealPkid", sealPkid);
            String signatureid = dynamicObject.getString("signatureid");
            String companysealPath = dynamicObject.getString("companyseal");
            customParams.put("signatureid", signatureid);
            customParams.put("companysealPath", companysealPath);
            this.showAddSeal(customParams);
        }
    }
}

