/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sysint.servicehelper.ElectronicContractHelper;

public class ECSendMessagePlugin
extends AbstractFormPlugin {
    private static final String PHONE = "phone";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static Log logger = LogFactory.getLog(ECSendMessagePlugin.class);
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String CACHE_KEY = "ec_message";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map data = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString((Object)data));
        Object phone = data.get(PHONE);
        if (phone != null) {
            this.getModel().setValue(PHONE, phone);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.sendMessage();
        } else {
            this.getView().close();
        }
    }

    private void sendMessage() {
        String data = this.getPageCache().get(CACHE_KEY);
        String phone = this.getModel().getValue(PHONE).toString();
        if (StringUtils.isBlank((CharSequence)phone)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ECSendMessagePlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Pattern p = Pattern.compile("^1[0-9]{10}$");
        Matcher m = p.matcher(phone);
        boolean isMatch = m.matches();
        if (!isMatch) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\u3002", (String)"ECSendMessagePlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        String kdappid = map.get("kdappid").toString();
        String key = map.get("key").toString();
        String authurl = map.get("authurl").toString();
        String userId = map.get("userId").toString();
        try {
            this.doSendMessage(kdappid, key, authurl, userId, phone);
            this.getView().close();
        }
        catch (Exception e) {
            logger.info("ECSendMessagePlugin--sendMessage", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void doSendMessage(String kdappid, String key, String authurl, String userId, String phone) {
        HashMap<String, String> data = new HashMap<String, String>(16);
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            data.put("mobile", phone);
        } else {
            data.put("userId", userId);
        }
        data.put("url", authurl);
        data.put("message", ResManager.loadKDString((String)"\u60a8\u7684\u4f01\u4e1a\u4fe1\u606f\u5f85\u8ba4\u8bc1\uff0c\u8bf7\u70b9\u51fb\u94fe\u63a5\u8fdb\u884c\u8ba4\u8bc1\u3002", (String)"ECSendMessagePlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        String response = ElectronicContractHelper.sendMessage(kdappid, key, data);
        JSONObject json = (JSONObject)JSON.parse((String)response);
        Integer code = json.getInteger("code");
        HashMap<String, Object> retData = new HashMap<String, Object>();
        retData.put("code", code);
        String message = code != 0 ? json.getString("msg") : ResManager.loadKDString((String)"\u94fe\u63a5\u53d1\u9001\u6210\u529f\u3002", (String)"ECSendMessagePlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
        retData.put("message", message);
        this.getView().returnDataToParent(retData);
    }
}

