/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.sysint.servicehelper.ElectronicContractHelper;

public class ECUploadSealPlugin
extends AbstractFormPlugin {
    private static final String COMPANYSEAL = "companyseal";
    private static Log logger = LogFactory.getLog(ECUploadSealPlugin.class);
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_CANCEL = "btn_cancel";
    private static final String CACHE_KEY = "ec_uploadseal";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CANCEL, BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map data = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString((Object)data));
        Object companyseal = data.get("companysealPath");
        if (companyseal != null) {
            this.getModel().setValue(COMPANYSEAL, companyseal);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.uploadSeal();
        } else {
            this.getView().close();
        }
    }

    private void uploadSeal() {
        String data = this.getPageCache().get(CACHE_KEY);
        Object companyseal = this.getModel().getValue(COMPANYSEAL);
        if (StringUtils.isBlank((Object)companyseal)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5b50\u5370\u7ae0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ECUploadSealPlugin_0", (String)"bos-portal-plugin", (Object[])new Object[0]));
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        String kdappid = map.get("kdappid").toString();
        String key = map.get("key").toString();
        String userId = map.get("userId").toString();
        String signatureid = map.get("signatureid").toString();
        try {
            this.doUploadSeal(kdappid, key, userId, signatureid, companyseal.toString());
        }
        catch (Exception e) {
            logger.info("ECUploadSealPlugin--uploadSeal", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void doUploadSeal(String kdappid, String key, String userId, String signatureid, String companyseal) {
        String response;
        JSONObject json;
        String code;
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("userId", userId);
        if (StringUtils.isNotBlank((CharSequence)signatureid)) {
            data.put("signatureid", signatureid);
        }
        if (!"0".equals(code = (json = (JSONObject)JSON.parse((String)(response = ElectronicContractHelper.uploadSeal(kdappid, key, data, companyseal)))).get((Object)"code").toString())) {
            String msg = json.get((Object)"msg").toString();
            if ("1044".equals(code)) {
                String respData = json.get((Object)"data").toString();
                msg = msg + "\uff0c" + respData;
            }
            this.getView().showTipNotification(msg);
            return;
        }
        JSONObject contentJson = (JSONObject)json.get((Object)"data");
        String signatureId = contentJson.get((Object)"signatureId").toString();
        HashMap<String, String> retData = new HashMap<String, String>();
        retData.put("signatureId", signatureId);
        retData.put(COMPANYSEAL, companyseal);
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }
}

