/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.servicehelper.ElectronicContractHelper;

public class ElectronicContractPlugin
extends AbstractListPlugin {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String KDAPPID = "kdappid";
    private static final String PHONE = "phone";
    private static final String ISAUTHED = "isauthed";
    private static final String AUTHURL = "authurl";
    private static final String USER_ID = "userId";
    private static final String CONTRACTSUB = "contractsub";
    private static final String COMPANYID = "companyid";
    private static final String UUID = "uuid";
    private static final String COMPANYSEAL = "companyseal";
    private static final String SIGNATUREID = "signatureid";
    private static final String SYS_BASE_SELECT_ONE_ROW_ERROR = "sys.base.selectOneRowError";
    private static Log logger = LogFactory.getLog(ElectronicContractPlugin.class);
    private static final String VERIFY_NOTIFY_URI = "kapi/app/base/verifyNotify";
    private static final String UPLOAD_SEAL = "uploadSeal";
    private static final String SEND_MESSAGE = "sendMessage";

    private String getDescription() {
        return ResManager.loadKDString((String)"Kdappid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u6267\u884c\u5546\u6237\u7533\u8bf7\u64cd\u4f5c\u3002", (String)"ElectronicContractPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        OperationResult opResult = evt.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        switch (opKey) {
            case "applykdappid": {
                this.applyKdappid();
                break;
            }
            case "companyregister": {
                this.companyRegister();
                break;
            }
            case "companyauth": {
                this.companyAuth();
                break;
            }
            case "uploadseal": {
                this.sealManager("contractsubject");
                break;
            }
            case "bizpartnerregister": {
                this.bizpartnerRegister();
                break;
            }
            case "bizuploadseal": {
                this.sealManager("companyauth");
                break;
            }
            case "sendsms": {
                this.sendMessage();
                break;
            }
            case "bizsendsms": {
                this.bizSendMessage();
                break;
            }
        }
    }

    private void applyKdappid() {
        try {
            DynamicObject data = this.selectOneRow();
            DynamicObject fiorg = data.getDynamicObject("fiorg");
            String name = fiorg.getString("ffirmname");
            if (StringUtils.isBlank((CharSequence)name)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElectronicContractPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String kdAppid = data.getString(KDAPPID);
            if (StringUtils.isNotEmpty((CharSequence)kdAppid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u6237\u7533\u8bf7\u5df2\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"ElectronicContractPlugin_18", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String response = ElectronicContractHelper.applyKdappid(name);
            JSONObject json = (JSONObject)JSON.parse((String)response);
            String code = json.get((Object)"code").toString();
            if (!"0".equals(code)) {
                String msg = json.get((Object)"msg").toString();
                if ("103".equals(code)) {
                    msg = ResManager.loadKDString((String)"\u540d\u79f0\u5df2\u88ab\u5360\u7528", (String)"ElectronicContractPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5546\u6237\u7533\u8bf7\u5931\u8d25\uff0c%s\u3002", (String)"ElectronicContractPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), msg));
                return;
            }
            JSONObject contentJson = (JSONObject)json.get((Object)"data");
            String kdappid = contentJson.get((Object)"kdAppId").toString();
            String uuid = contentJson.get((Object)UUID).toString();
            data.set(KDAPPID, (Object)kdappid);
            data.set(UUID, (Object)uuid);
            SaveServiceHelper.update((DynamicObject)data);
            ((IListView)this.getView()).refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5546\u6237\u7533\u8bf7\u6210\u529f\u3002", (String)"ElectronicContractPlugin_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--applyKdappid", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void companyRegister() {
        try {
            DynamicObject dyObj = this.selectOneRow();
            String isauthed = dyObj.getString(ISAUTHED);
            if ("1".equals(isauthed)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u5df2\u6ce8\u518c\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ElectronicContractPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String kdappid = dyObj.get(KDAPPID).toString();
            String key = dyObj.getString(UUID);
            String appid = dyObj.getString("appid");
            String phone = dyObj.getString(PHONE);
            DynamicObject fiorg = dyObj.getDynamicObject("fiorg");
            String name = fiorg.getString("ffirmname");
            String icCode = fiorg.getString("uniformsocialcreditcode");
            this.doRegister(dyObj, name, appid, icCode, kdappid, key, phone);
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--companyRegister", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void bizpartnerRegister() {
        try {
            DynamicObject dyObj = this.selectOneRow();
            String isauthed = dyObj.getString(ISAUTHED);
            if ("1".equals(isauthed)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u5df2\u6ce8\u518c\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ElectronicContractPlugin_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String phone = dyObj.getString(PHONE);
            DynamicObject contractSubject = dyObj.getDynamicObject(CONTRACTSUB);
            String kdappid = contractSubject.getString(KDAPPID);
            String key = contractSubject.getString(UUID);
            String appid = contractSubject.getString("appid");
            DynamicObject bizPartner = dyObj.getDynamicObject("bizpartner");
            String name = bizPartner.getString("name");
            String icCode = bizPartner.getString("societycreditcode");
            this.doRegister(dyObj, name, appid, icCode, kdappid, key, phone);
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--bizpartnerRegister", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void doRegister(DynamicObject dyObj, String name, String appid, String icCode, String kdappid, String key, String phone) {
        if (StringUtils.isBlank((CharSequence)kdappid)) {
            this.getView().showTipNotification(this.getDescription());
            return;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElectronicContractPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)icCode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ElectronicContractPlugin_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("name", name);
        data.put("isKdApp", "true");
        data.put("appId", appid);
        data.put("icCode", icCode);
        data.put("orgCode", icCode);
        data.put("taxCode", icCode);
        data.put("pageModify", "1");
        data.put("verifyedWay", "0");
        data.put("mobile", phone);
        RequestContext context = RequestContext.get();
        String url = context.getClientFullContextPath();
        if (!url.endsWith("/")) {
            url = url + url + "/";
        }
        data.put("verifyNotifyUrl", url + VERIFY_NOTIFY_URI + "?accountId=" + context.getAccountId() + "&");
        logger.info(String.format("ElectronicContractPlugin--kdappid:%s,--verifyNotifyUrl:%s", kdappid, data.get("verifyNotifyUrl")));
        String response = ElectronicContractHelper.companyRegister(kdappid, key, data);
        JSONObject json = (JSONObject)JSON.parse((String)response);
        String code = json.get((Object)"code").toString();
        if (!"0".equals(code)) {
            String msg = "101".equals(code) ? ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5appid\u662f\u5426\u6b63\u786e", (String)"ElectronicContractPlugin_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ("124".equals(code) ? ResManager.loadKDString((String)"\u5546\u6237\u4e0d\u5b58\u5728", (String)"ElectronicContractPlugin_22", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : json.get((Object)"msg").toString());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u6ce8\u518c\u5931\u8d25\uff0c%s\u3002", (String)"ElectronicContractPlugin_8", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), msg));
            return;
        }
        JSONObject contentJson = (JSONObject)json.get((Object)"data");
        String userId = contentJson.get((Object)USER_ID).toString();
        String authurl = contentJson.get((Object)"url").toString();
        dyObj.set(AUTHURL, (Object)authurl);
        dyObj.set(COMPANYID, (Object)userId);
        dyObj.set(ISAUTHED, (Object)1);
        SaveServiceHelper.update((DynamicObject)dyObj);
        ((IListView)this.getView()).refresh();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u6ce8\u518c\u6210\u529f\u3002", (String)"ElectronicContractPlugin_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
    }

    private void companyAuth() {
        try {
            DynamicObject dyObj = this.selectOneRow();
            String isauthed = dyObj.getString(ISAUTHED);
            if (!"1".equals(isauthed)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6ce8\u518c\u72b6\u6001\u4e3a\u201c\u5df2\u6ce8\u518c\u201d\u7684\u4f01\u4e1a\uff0c\u624d\u80fd\u8fdb\u884c\u8ba4\u8bc1\u3002", (String)"ElectronicContractPlugin_10", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String resultcode = dyObj.getString("resultcode");
            if ("1".equals(resultcode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u5df2\u8ba4\u8bc1\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ElectronicContractPlugin_11", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String authUrl = dyObj.getString(AUTHURL);
            this.getView().openUrl(authUrl);
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--companyAuth", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void sealManager(String subjectType) {
        switch (subjectType) {
            case "contractsubject": {
                this.showContractSubject();
                break;
            }
            case "companyauth": {
                this.showCompanyAuth();
                break;
            }
        }
    }

    private void showContractSubject() {
        try {
            DynamicObject dyObj = this.selectOneRow();
            DynamicObject fiorg = dyObj.getDynamicObject("fiorg");
            String name = fiorg.getString("ffirmname");
            String icCode = fiorg.getString("uniformsocialcreditcode");
            String signprovider = dyObj.getString("signprovider");
            Long subjectid = dyObj.getLong("id");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("name", name);
            customParams.put("icCode", icCode);
            customParams.put("signprovider", signprovider);
            customParams.put("subjectid", subjectid);
            String kdappid = dyObj.get(KDAPPID).toString();
            String key = dyObj.getString(UUID);
            String userId = dyObj.getString(COMPANYID);
            customParams.put(KDAPPID, kdappid);
            customParams.put("key", key);
            customParams.put(USER_ID, userId);
            if (StringUtils.isBlank((CharSequence)kdappid)) {
                this.getView().showTipNotification(this.getDescription());
                return;
            }
            String resultcode = dyObj.getString("resultcode");
            if (!"1".equals(resultcode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u8ba4\u8bc1\uff0c\u8bf7\u5148\u8ba4\u8bc1\u3002", (String)"ElectronicContractPlugin_19", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.showSealMananger(customParams);
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--bizUploadSeal", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void showCompanyAuth() {
        try {
            DynamicObject dyObj = this.selectOneRow();
            DynamicObject contractSubject = dyObj.getDynamicObject(CONTRACTSUB);
            String kdappid = contractSubject.getString(KDAPPID);
            String key = contractSubject.getString(UUID);
            DynamicObject bizPartner = dyObj.getDynamicObject("bizpartner");
            String name = bizPartner.getString("name");
            String icCode = bizPartner.getString("societycreditcode");
            String signprovider = dyObj.getString("signprovider");
            Long subjectid = dyObj.getLong("id");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("name", name);
            customParams.put("icCode", icCode);
            customParams.put("signprovider", signprovider);
            customParams.put("subjectid", subjectid);
            String userId = dyObj.getString(COMPANYID);
            customParams.put(KDAPPID, kdappid);
            customParams.put("key", key);
            customParams.put(USER_ID, userId);
            if (StringUtils.isBlank((CharSequence)kdappid)) {
                this.getView().showTipNotification(this.getDescription());
                return;
            }
            String resultcode = dyObj.getString("resultcode");
            if (!"1".equals(resultcode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u8ba4\u8bc1\uff0c\u8bf7\u5148\u8ba4\u8bc1\u3002", (String)"ElectronicContractPlugin_19", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            this.showSealMananger(customParams);
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--bizUploadSeal", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void showSealMananger(Map<String, Object> customParams) {
        String formId = "bos_sealmanager";
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        String entityName = this.getPageCache().get("entityName");
        customParams.put("entityName", entityName);
        if ("contractsubject".equals(entityName)) {
            fsp.setCaption(ResManager.loadKDString((String)"\u5408\u540c\u4e3b\u4f53\u7b7e\u7ae0", (String)"ElectronicContractPlugin_20", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        } else if ("companyauth".equals(entityName)) {
            fsp.setCaption(ResManager.loadKDString((String)"\u7b7e\u7ea6\u4e3b\u4f53\u7b7e\u7ae0", (String)"ElectronicContractPlugin_21", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        fsp.setCustomParams(customParams);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm(fsp);
    }

    private void sendMessage() {
        try {
            DynamicObject dyObj = this.selectOneRow();
            String userId = dyObj.getString(COMPANYID);
            String authurl = dyObj.getString(AUTHURL);
            String kdappid = dyObj.getString(KDAPPID);
            String key = dyObj.getString(UUID);
            String phone = dyObj.getString(PHONE);
            this.doSendMessage(kdappid, key, authurl, userId, phone);
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--sendMessage", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void doSendMessage(String kdappid, String key, String authurl, String userId, String phone) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f01\u4e1a\u672a\u6ce8\u518c\uff0c\u8bf7\u5148\u6ce8\u518c\u3002", (String)"ElectronicContractPlugin_12", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)kdappid)) {
            this.getView().showTipNotification(this.getDescription());
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(USER_ID, userId);
        map.put(AUTHURL, authurl);
        map.put(KDAPPID, kdappid);
        map.put("key", key);
        map.put(PHONE, phone);
        this.showForm("sendmessagepage", map, SEND_MESSAGE);
    }

    private void showForm(String formId, Map<String, Object> customParams, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(formId);
        fsp.setCustomParams(customParams);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map result;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (SEND_MESSAGE.equals(actionId)) {
            Map result2 = (Map)evt.getReturnData();
            if (result2 != null) {
                Object code = result2.get("code");
                String msg = result2.get("message").toString();
                if (code != null && code.equals(0)) {
                    this.getView().showSuccessNotification(msg);
                } else {
                    this.getView().showTipNotification(msg);
                }
            }
        } else if (UPLOAD_SEAL.equals(actionId) && (result = (Map)evt.getReturnData()) != null) {
            String signatureId = result.get("signatureId").toString();
            String companyseal = result.get(COMPANYSEAL).toString();
            String pkid = this.getPageCache().get("pkid");
            String entityName = this.getPageCache().get("entityName");
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(pkid), (String)entityName);
            data.set(SIGNATUREID, (Object)signatureId);
            data.set(COMPANYSEAL, (Object)companyseal);
            SaveServiceHelper.update((DynamicObject)data);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u7b7e\u7ae0\u6210\u529f\u3002", (String)"ElectronicContractPlugin_13", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void bizSendMessage() {
        try {
            DynamicObject dyObj = this.selectOneRow();
            String userId = dyObj.getString(COMPANYID);
            String phone = dyObj.getString(PHONE);
            String authurl = dyObj.getString(AUTHURL);
            DynamicObject contractSubject = dyObj.getDynamicObject(CONTRACTSUB);
            String kdappid = contractSubject.getString(KDAPPID);
            String key = contractSubject.getString(UUID);
            this.doSendMessage(kdappid, key, authurl, userId, phone);
        }
        catch (Exception e) {
            logger.info("ElectronicContractPlugin--bizSendMessage", (Object)e);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private DynamicObject selectOneRow() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows.size() != 1) {
            String message = rows.size() > 1 ? ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ElectronicContractPlugin_14", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ElectronicContractPlugin_15", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]);
            throw new KDException(new ErrorCode(SYS_BASE_SELECT_ONE_ROW_ERROR, message), new Object[0]);
        }
        ListSelectedRow row = rows.get(0);
        long id = (Long)row.getPrimaryKeyValue();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = listShowParameter.getBillFormId();
        String entityName = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        String status = data.getString("status");
        if (!"C".equals(status)) {
            throw new KDException(new ErrorCode(SYS_BASE_SELECT_ONE_ROW_ERROR, ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u9700\u8981\u4e3a\u5df2\u5ba1\u6838\u3002", (String)"ElectronicContractPlugin_16", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        String enable = data.getString("enable");
        if ("0".equals(enable)) {
            throw new KDException(new ErrorCode(SYS_BASE_SELECT_ONE_ROW_ERROR, ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u9700\u8981\u4e3a\u542f\u7528\u3002", (String)"ElectronicContractPlugin_17", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        this.getPageCache().put("pkid", id + "");
        this.getPageCache().put("entityName", entityName);
        return data;
    }
}

