/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import java.io.InputStream;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.license.NextCloud;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.sysint.servicehelper.ECAesCryptUtil;
import kd.bos.sysint.servicehelper.HashHmacCrypto;
import kd.bos.sysint.servicehelper.MultipartUtility;
import kd.bos.util.HttpClientUtils;
import kd.sdk.annotation.SdkInternal;

public class ElectronicContractHelper {
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String RESPONSE = "response: ";
    private static final String KD_APP_ID = "?kdAppId=";
    private static Log logger = LogFactory.getLog(ElectronicContractHelper.class);
    private static final String PRODUCT = "cosmic";
    private static final String HOST = "https://api.kingdee.com";
    private static final String EC_URL_KEY = "ec_url";
    private static final String EC_URL_DEFAULT = "https://pay.kingdee.com/kdcontract/";
    private static final String KDAPPID_URI_KEY = "kdappid_uri";
    private static final String KDAPPID_URI_DEFAULT = "/emerchant/merchant/add";
    private static final String COMPANY_AUTH_URL = "api/contract/companyAuthUrl";
    private static final String UPLOAD_URL = "api/contract/uploadSignatureImage";
    private static final String SMS_URL = "api/contract/sms";

    private static String getCloudClientId() {
        String cloudId = System.getProperty("clientId");
        if (StringUtils.isEmpty((CharSequence)cloudId)) {
            cloudId = NextCloud.CLIENT_ID;
        }
        return cloudId;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (StringUtils.isEmpty((CharSequence)clientSecret)) {
            clientSecret = NextCloud.CLIENT_SECRET;
        }
        return clientSecret;
    }

    public static String getEcParamOrDefault(String key, String defaultValue) {
        Map paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        if (paramMap == null || StringUtils.isBlank(paramMap.get(key))) {
            return defaultValue;
        }
        return paramMap.get(key).toString();
    }

    public static String applyKdappid(String kdAppDesc) {
        String response;
        try {
            String kdappidUri = ElectronicContractHelper.getEcParamOrDefault(KDAPPID_URI_KEY, KDAPPID_URI_DEFAULT);
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("product", PRODUCT);
            params.put("kdAppDesc", URLEncoder.encode(kdAppDesc, "UTF-8"));
            String url = ElectronicContractHelper.getKingDeeUrl(kdappidUri, params);
            Map<String, String> header = ElectronicContractHelper.getHeader(params, ElectronicContractHelper.splitUri(kdappidUri));
            response = HttpClientUtils.post((String)url, header, null);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("sys.base.applyKdappidError", ResManager.loadKDString((String)"\u5546\u6237\u7533\u8bf7\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicContractHelper_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)response)) {
            throw new KDException(new ErrorCode("sys.base.applyKdappidError", ResManager.loadKDString((String)"\u5546\u6237\u7533\u8bf7\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicContractHelper_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        logger.info(RESPONSE + response);
        return response;
    }

    private static String splitUri(String kdappidUri) {
        String[] split = kdappidUri.split("\\?");
        String uri = kdappidUri;
        if (split.length > 1) {
            uri = split[0];
        }
        return uri;
    }

    private static String getKingDeeUrl(String kdappidUri, TreeMap<String, String> params) {
        String kingdeeHost = ElectronicContractHelper.getKingDeeHost();
        StringBuilder builder = new StringBuilder(kingdeeHost);
        builder.append(kdappidUri).append(kdappidUri.contains("?") ? "&" : "?").append(ElectronicContractHelper.getUrlParamsByMap(params));
        return builder.toString();
    }

    private static String getKingDeeHost() {
        String kingdeeHost = DefaultParameterService.getDefaultValueByKey((String)"ELECTRONIC_SIGNATURE_HOST", (String)"1");
        if (StringUtils.isEmpty((CharSequence)kingdeeHost)) {
            kingdeeHost = HOST;
        }
        return kingdeeHost;
    }

    private static String getUrlParamsByMap(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            sb.append('&');
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = StringUtils.substringBeforeLast((String)s, (String)"&");
        }
        return s;
    }

    private static Map<String, String> getHeader(TreeMap<String, String> body, String kdappidUri) {
        String clientId = ElectronicContractHelper.getCloudClientId();
        String clientSecret = ElectronicContractHelper.getClientSecret();
        logger.info(String.format("ElectronicContractHelper---getHeader---clientId:%s", clientId));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json;charset=UTF-8");
        header.put("X-Api-ClientID", clientId);
        header.put("X-Api-Auth-Version", "2.0");
        long time = System.currentTimeMillis() / 1000L;
        header.put("X-Api-TimeStamp", time + "");
        SecureRandom random = new SecureRandom();
        long nonce = (long)((random.nextDouble() * 9.0 + 1.0) * 1.0E9);
        header.put("X-Api-Nonce", nonce + "");
        header.put("X-Api-Signheaders", "X-Api-TimeStamp,X-Api-Nonce");
        String[] signHeaders = ((String)header.get("X-Api-Signheaders")).split(",");
        TreeMap signHeaderMap = new TreeMap();
        for (String signHeader : signHeaders) {
            signHeaderMap.put(signHeader, header.get(signHeader));
        }
        String signStr = null;
        try {
            signStr = HashHmacCrypto.sign((String)"POST", (String)kdappidUri, body, signHeaderMap, (String)clientSecret);
        }
        catch (Exception e) {
            logger.info("HashHmacCrypto sign error", (Object)e);
        }
        header.put("X-Api-Signature", ElectronicContractHelper.replaceBlank(signStr));
        return header;
    }

    private static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\t|\\r|\\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    @SdkInternal
    public static String companyRegister(String kdAppId, String key, Map<String, String> data) {
        String response;
        String nonce = UUID.randomUUID().toString().replace("-", "");
        StringBuilder sb = new StringBuilder(ElectronicContractHelper.getEcParamOrDefault(EC_URL_KEY, EC_URL_DEFAULT));
        sb.append(COMPANY_AUTH_URL);
        sb.append(KD_APP_ID).append(kdAppId).append("&nonce=").append(nonce).append("&signType=AES");
        logger.info(String.format("ElectronicContractHelper---companyRegister--key:%s, nonce:%s, data:%s", key, nonce, SerializationUtils.toJsonString(data)));
        String sign = ECAesCryptUtil.encryptData(key, nonce, data);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("sign", sign);
        logger.info(String.format("ElectronicContractHelper---companyRegister(postappjson)---url:%s,signvalue:%s", sb.toString(), sign));
        try {
            response = HttpClientUtils.postAppJson((String)sb.toString(), null, body);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("sys.base.companyRegisterError", ResManager.loadKDString((String)"\u4f01\u4e1a\u6ce8\u518c\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicContractHelper_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)response)) {
            throw new KDException(new ErrorCode("sys.base.companyRegisterError", ResManager.loadKDString((String)"\u4f01\u4e1a\u6ce8\u518c\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicContractHelper_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        logger.info(RESPONSE + response);
        return response;
    }

    public static String uploadSeal(String kdAppId, String key, Map<String, String> data, String companysealPath) {
        String templateName;
        if (companysealPath.contains("?v")) {
            companysealPath = companysealPath.substring(0, companysealPath.indexOf("?v"));
        } else if (companysealPath.contains("&v")) {
            companysealPath = companysealPath.substring(0, companysealPath.indexOf("&v"));
        }
        String subName = companysealPath.substring(companysealPath.lastIndexOf(47) + 1);
        if (subName.contains(".jpg")) {
            templateName = subName.substring(0, subName.lastIndexOf(".jpg") + 4);
        } else if (subName.contains(".png")) {
            templateName = subName.substring(0, subName.lastIndexOf(".png") + 4);
        } else {
            throw new KDException(new ErrorCode("ElectronicContractHelper---bizUploadSeal error", ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u6587\u4ef6\u683c\u5f0f\u4e3ajpg\u6216png\u3002", (String)"ElectronicContractHelper_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        if (templateName.split("\\.").length != 2) {
            throw new KDException(new ErrorCode("ElectronicContractHelper---bizUploadSeal error", ResManager.loadKDString((String)"\u670d\u52a1\u5668\u6587\u4ef6\u8def\u5f84\u89e3\u6790\u51fa\u9519\u3002", (String)"ElectronicContractHelper_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        StringBuilder uploadResponse = new StringBuilder();
        StringBuilder sb = new StringBuilder(ElectronicContractHelper.getEcParamOrDefault(EC_URL_KEY, EC_URL_DEFAULT));
        sb.append(UPLOAD_URL);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        sb.append(KD_APP_ID).append(kdAppId).append("&nonce=").append(nonce).append("&signType=AES");
        String sign = ECAesCryptUtil.encryptData(key, nonce, data);
        String realpath = FileServiceExtFactory.getImageFileServiceExt().getRealPath(companysealPath);
        try (InputStream is = FileServiceFactory.getImageFileService().getInputStream(realpath);){
            MultipartUtility multipart = new MultipartUtility(sb.toString(), "UTF-8");
            multipart.addHeaderField("User-Agent", "CodeJava");
            multipart.addHeaderField("Test-Header", "Header-Value");
            multipart.addFormField("description", "Cool Pictures");
            multipart.addFormField("keywords", "Java,upload,Spring");
            multipart.addFilePart("file", is, templateName);
            multipart.addFormField("sign", sign);
            List<String> response = multipart.finish();
            for (String line : response) {
                uploadResponse.append(line);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("sys.base.uploadSealError", ResManager.loadKDString((String)"\u4e0a\u4f20\u7b7e\u7ae0\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicContractHelper_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)uploadResponse.toString())) {
            throw new KDException(new ErrorCode("sys.base.uploadSeal Error", ResManager.loadKDString((String)"\u4e0a\u4f20\u7b7e\u7ae0\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicContractHelper_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        logger.info(RESPONSE + uploadResponse);
        return uploadResponse.toString();
    }

    public static String sendMessage(String kdAppId, String key, Map<String, String> data) {
        String response;
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String sign = ECAesCryptUtil.encryptData(key, nonce, data);
        StringBuilder sb = new StringBuilder(ElectronicContractHelper.getEcParamOrDefault(EC_URL_KEY, EC_URL_DEFAULT));
        sb.append(SMS_URL);
        sb.append(KD_APP_ID).append(kdAppId).append("&nonce=").append(nonce).append("&signType=AES");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("sign", sign);
        logger.info(String.format("ElectronicContractHelper---sendMessage(postappjson)---url:%s,signvalue:%s", sb.toString(), sign));
        try {
            response = HttpClientUtils.postAppJson((String)sb.toString(), null, body);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("sys.base.sendMessageError", ResManager.loadKDString((String)"\u77ed\u4fe1\u63a8\u9001\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicContractHelper_5", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0])), new Object[0]);
        }
        logger.info(RESPONSE + response);
        return response;
    }
}

