/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.license.NextCloud;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.sysint.cache.PortalAppFeaturesCache;
import kd.bos.sysint.servicehelper.constant.LocationConst;
import kd.bos.sysint.servicehelper.dto.KnowledgeSearchParams;
import kd.bos.util.HttpClientUtils;

public class KnowledgeServiceHelper {
    private static final String ID = "id";
    private static Log logger = LogFactory.getLog(KnowledgeServiceHelper.class);
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static final String ERRCODE = "errcode";
    private static final String DESCRIPTION = "description";
    private static final String KNOWLEDGE_URL_KEY = "knowledage.search.url";
    private static final String KNOWLEDGE_SPECIAL_URL_KEY = "knowledagespecail.search.url";
    private static final String DOMAIN = "domain";
    private static final String MODULE = "module";
    private static final String BIZENTITY = "bizentity";
    private static final String LABEL = "label";
    private static final String RESTRICTIN = "restrictIn";
    private static final String AUTHCODE = "authcode";
    private static final String PAGESIZE = "pageSize";
    private static final String ALLOWHTML = "allowHtml";
    private static final int STANDARD_PRODUCT = 68;
    private static final int GALAXY_PRODUCT = 93;
    private static final int CONSTELLATION_PRODUCT = 3;
    private static final String KNOWLEDGE_API_URL = "https://knowledge.kingdee.com/";
    private static final String UPDATE_TIME = "updateTime";
    private static final String TITLE = "title";
    private static final String URL = "url";
    private static final String APPNUMBER = "appNumber";
    private static final String CONTENTS = "contents";
    private static final String ENTITYURL = "entityUrl";
    private static final String CLASSIFIES = "classifies";
    private static final String KNOWLEDGEUPDATEDAT = "knowledgeUpdatedAt";
    private static final String KNOWLEDGE_SPECIAL_URL = "https://bj1-api.kingdee.com/knowledgeapi/";

    private static String getKnowledgeUrl() {
        String value = SystemPropertyUtils.getProptyByTenant((String)KNOWLEDGE_URL_KEY, (String)RequestContext.get().getTenantId());
        return value == null ? KNOWLEDGE_API_URL : value;
    }

    private static String getKnowledgeSpecialUrl() {
        String value = SystemPropertyUtils.getProptyByTenant((String)KNOWLEDGE_SPECIAL_URL_KEY, (String)RequestContext.get().getTenantId());
        return value == null ? KNOWLEDGE_SPECIAL_URL : value;
    }

    public static String knowledgeSearch(String type, String domain, String module, String bizentity, String label, String restrictIn, String content, String authcode, int page, int pageSize, Boolean allowHtml, String searchScope) {
        KnowledgeSearchParams searchParams = new KnowledgeSearchParams();
        searchParams.setType(type);
        searchParams.setDomain(domain);
        searchParams.setModule(module);
        searchParams.setBizentity(bizentity);
        searchParams.setLabel(label);
        searchParams.setRestrictIn(restrictIn);
        searchParams.setContent(content);
        searchParams.setAuthcode(authcode);
        searchParams.setPage(page);
        searchParams.setPageSize(pageSize);
        searchParams.setAllowHtml(allowHtml);
        searchParams.setSearchScope(searchScope);
        return KnowledgeServiceHelper.knowledgeSearch(searchParams);
    }

    public static String knowledgeSearch(KnowledgeSearchParams searchParams) {
        String response;
        String location;
        Object isSearch = BaseAppParameterServiceHelper.getParameterFromCache((String)"knowledge_search");
        if (isSearch != null && !Boolean.parseBoolean(isSearch.toString())) {
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, ResManager.loadKDString((String)"\u672a\u5f00\u542f\u201c\u641c\u7d22\u4e91\u793e\u533a\u77e5\u8bc6\u201d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u7cfb\u7edf\u53c2\u6570\u4e2d\u5f00\u542f\u3002", (String)"KnowledgeServiceHelper_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return JSON.toJSONString(errResponse);
        }
        Long userId = RequestContext.get().getCurrUserId();
        Lang lang = RequestContext.get().getLang();
        boolean langFlag = lang == Lang.zh_CN || lang == Lang.zh_TW;
        String url = KnowledgeServiceHelper.getKnowledgeUrl() + "product/" + KnowledgeServiceHelper.getProductId() + "/search";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uid", userId);
        param.put("types", searchParams.getType());
        param.put(DOMAIN, searchParams.getDomain());
        param.put(MODULE, searchParams.getModule());
        param.put(BIZENTITY, searchParams.getBizentity());
        param.put(LABEL, searchParams.getLabel());
        param.put(RESTRICTIN, searchParams.getRestrictIn());
        param.put("text", searchParams.getContent());
        param.put(AUTHCODE, searchParams.getAuthcode());
        param.put("page", searchParams.getPage());
        param.put(PAGESIZE, searchParams.getPageSize());
        param.put("searchScope", searchParams.getSearchScope());
        if (!langFlag) {
            param.put("lang", "en-US");
        }
        param.put("location", (location = searchParams.getLocation()) == null ? "" : location);
        Boolean allowHtml = searchParams.getAllowHtml();
        if (allowHtml.booleanValue()) {
            param.put(ALLOWHTML, true);
        }
        logger.info(String.format("knowledgeSearch url:%s, params:%s", url, ((Object)param).toString()));
        try {
            response = HttpClientUtils.get((String)url, KnowledgeServiceHelper.getHttpRequestHeader(), param);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Object)e);
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, e.getMessage());
            return JSON.toJSONString(errResponse);
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, ResManager.loadKDString((String)"\u83b7\u53d6\u793e\u533a\u4e91\u4fe1\u606f\u5f02\u5e38\u3002", (String)"KnowledgeServiceHelper_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return JSON.toJSONString(errResponse);
        }
        return response;
    }

    private static Map<String, String> getHttpRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }

    public static int getProductId() {
        boolean oemEnv = DevVerifyServiceHelper.isOEMEnv();
        if (oemEnv) {
            return 87;
        }
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        int productId = modelType == 1 ? 68 : (modelType == 2 || modelType == 4 ? 93 : 3);
        return productId;
    }

    public static void updateAllAppFeatures() {
        String allAppFeatures = KnowledgeServiceHelper.getAllAppFeatures();
        HashMap<String, String> appFeatrueMap = new HashMap<String, String>();
        JSONArray allAppFeaturesArr = JSONArray.parseArray((String)allAppFeatures);
        for (Object appFeatureObj : allAppFeaturesArr) {
            JSONObject appFeature = (JSONObject)appFeatureObj;
            String appNumber = appFeature.getString(APPNUMBER);
            JSONArray contents = appFeature.getJSONArray(CONTENTS);
            if (contents.size() <= 0) continue;
            int index = KnowledgeServiceHelper.getIndexOfMaxUpateTime(contents);
            JSONObject content = (JSONObject)contents.get(index);
            String id = content.getString(ID);
            String title = content.getString(TITLE);
            String updateTime = content.getString(UPDATE_TIME);
            String url = content.getString(URL);
            appFeatrueMap.put(APPNUMBER, appNumber);
            appFeatrueMap.put(ID, id);
            appFeatrueMap.put(TITLE, title);
            appFeatrueMap.put(UPDATE_TIME, updateTime);
            appFeatrueMap.put(URL, url);
            KnowledgeServiceHelper.addOrUpdateFeature(appFeatrueMap, appNumber, updateTime);
        }
    }

    private static int getIndexOfMaxUpateTime(JSONArray contents) {
        int index = 0;
        String updateTimeStr = ((JSONObject)contents.get(0)).getString(UPDATE_TIME);
        long maxUpdateTime = Long.parseLong(updateTimeStr);
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject content = (JSONObject)contents.get(i);
            long updateTime = Long.parseLong(content.getString(UPDATE_TIME));
            if (updateTime <= maxUpdateTime) continue;
            index = i;
        }
        return index;
    }

    private static void addOrUpdateFeature(Map<String, String> appFeatrueMap, String appNumber, String updateTime) {
        PortalAppFeaturesCache portalAppFeaturesCache = new PortalAppFeaturesCache();
        Map<String, String> oldFeature = portalAppFeaturesCache.getAppFeatrue(appNumber);
        if (null != oldFeature) {
            long oldTime = Long.parseLong(oldFeature.get(UPDATE_TIME));
            if (Long.parseLong(updateTime) < oldTime) {
                appFeatrueMap = oldFeature;
            }
        }
        logger.info("addOrUpdateFeature:" + SerializationUtils.toJsonString(appFeatrueMap));
        portalAppFeaturesCache.updateAppFeature(appNumber, appFeatrueMap);
    }

    public static String getAllAppFeatures() {
        String response;
        boolean langFlag;
        ArrayList<Map<String, Object>> allAppFeatures = new ArrayList<Map<String, Object>>();
        int page = 1;
        int pageSize = 1000;
        Calendar now = Calendar.getInstance();
        now.add(5, -30);
        long createdAtEnd = System.currentTimeMillis();
        long createdAtStart = now.getTimeInMillis();
        StringBuilder url = new StringBuilder();
        url.append(KnowledgeServiceHelper.getKnowledgeUrl()).append("product/").append(KnowledgeServiceHelper.getProductId()).append("/search?label=NewFeatures&restrictIn=label");
        url.append("&page=").append(page).append("&pageSize=").append(pageSize);
        url.append("&updatedAtStart=").append(createdAtStart);
        url.append("&updatedAtEnd=").append(createdAtEnd);
        url.append("&location=").append(LocationConst.NEW_FEATURES_HELP.code());
        Lang lang = RequestContext.get().getLang();
        boolean bl = langFlag = lang == Lang.zh_CN || lang == Lang.zh_TW;
        if (!langFlag) {
            url.append("&lang=en-US");
        }
        String urlStr = url.toString();
        logger.info("getAllAppFeatures url:" + urlStr);
        try {
            response = HttpClientUtils.get((String)urlStr, KnowledgeServiceHelper.getHttpRequestHeader(), null);
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u793e\u533a\u4e91\u65b0\u7279\u6027\u4fe1\u606f\u5f02\u5e38:", (Object)e);
            return JSON.toJSONString(allAppFeatures);
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            return JSON.toJSONString(allAppFeatures);
        }
        JSONObject responseObj = (JSONObject)JSON.parse((String)response);
        String contentStr = responseObj.get((Object)"content").toString();
        JSONArray conents = (JSONArray)JSONArray.parse((String)contentStr);
        for (Object contentObj : conents) {
            String classifiesStr;
            String knowledgeUpdatedAt;
            JSONObject contentJsonObj = (JSONObject)JSON.parse((String)contentObj.toString());
            String id = contentJsonObj.get((Object)ID).toString();
            String title = contentJsonObj.get((Object)TITLE).toString();
            String entityUrl = contentJsonObj.get((Object)ENTITYURL).toString();
            if ("Question".equals(contentJsonObj.get((Object)"entity-type").toString())) {
                JSONObject answer;
                if (null == contentJsonObj.get((Object)TITLE) || null == contentJsonObj.get((Object)ENTITYURL) || null == contentJsonObj.get((Object)"answer") || null == (answer = (JSONObject)JSON.parse((String)contentJsonObj.get((Object)"answer").toString())).get((Object)CLASSIFIES) || null == answer.get((Object)KNOWLEDGEUPDATEDAT)) continue;
                knowledgeUpdatedAt = answer.get((Object)KNOWLEDGEUPDATEDAT).toString();
                classifiesStr = answer.get((Object)CLASSIFIES).toString();
            } else {
                if (null == contentJsonObj.get((Object)TITLE) || null == contentJsonObj.get((Object)ENTITYURL) || null == contentJsonObj.get((Object)KNOWLEDGEUPDATEDAT) || null == contentJsonObj.get((Object)CLASSIFIES)) continue;
                knowledgeUpdatedAt = contentJsonObj.get((Object)KNOWLEDGEUPDATEDAT).toString();
                classifiesStr = contentJsonObj.get((Object)CLASSIFIES).toString();
            }
            KnowledgeServiceHelper.putXmlDataIntoMap(allAppFeatures, title, entityUrl, classifiesStr, knowledgeUpdatedAt, id);
        }
        return JSON.toJSONString(allAppFeatures);
    }

    private static void putXmlDataIntoMap(List<Map<String, Object>> allAppFeatures, String title, String entityUrl, String classifiesStr, String knowledgeUpdatedAt, String id) {
        JSONArray classifies = (JSONArray)JSONArray.parse((String)classifiesStr);
        for (Object classifyObj : classifies) {
            Object moduleObj;
            JSONObject product = (JSONObject)JSON.parse((String)classifyObj.toString());
            Object domainObj = product.get((Object)"child");
            if (null == domainObj || null == (moduleObj = ((JSONObject)domainObj).get((Object)"child"))) continue;
            String appnumber = ((JSONObject)moduleObj).get((Object)"code").toString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList contents = new ArrayList();
            HashMap<String, String> content = new HashMap<String, String>();
            map.put(APPNUMBER, appnumber);
            map.put(CONTENTS, contents);
            content.put(ID, id);
            content.put(TITLE, title);
            content.put(UPDATE_TIME, knowledgeUpdatedAt);
            content.put(URL, entityUrl);
            contents.add(content);
            allAppFeatures.add(map);
        }
    }

    public static String getKnowledgeSpecial(KnowledgeSearchParams searchParams) {
        String location;
        boolean langFlag;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(AUTHCODE, "");
        param.put("series_code", KnowledgeServiceHelper.getSeriesCode());
        param.put(DOMAIN, searchParams.getDomain());
        param.put(MODULE, searchParams.getModule());
        param.put(BIZENTITY, searchParams.getBizentity());
        param.put(RESTRICTIN, searchParams.getRestrictIn());
        Long userId = RequestContext.get().getCurrUserId();
        param.put("uid", userId);
        Lang lang = RequestContext.get().getLang();
        boolean bl = langFlag = lang == Lang.zh_CN || lang == Lang.zh_TW;
        if (!langFlag) {
            param.put("lang", "en-US");
        }
        param.put("location", (location = searchParams.getLocation()) == null ? "" : location);
        String url = KnowledgeServiceHelper.getKnowledgeSpecialUrl() + "product/knowledge/specials";
        logger.info(String.format("getHelpDocInfo url:%s, params:%s", url, ((Object)param).toString()));
        String response = null;
        try {
            response = HttpClientUtils.get((String)url, KnowledgeServiceHelper.getRequestHeader(), param);
        }
        catch (Exception e) {
            logger.info("KnowledgeServiceHelper--getHelpDocInfo error", (Object)e);
        }
        if (StringUtils.isEmpty((CharSequence)response)) {
            HashMap<String, String> errResponse = new HashMap<String, String>();
            errResponse.put(ERRCODE, "1");
            errResponse.put(DESCRIPTION, ResManager.loadKDString((String)"\u83b7\u53d6\u5e2e\u52a9\u6587\u6863\u5f02\u5e38\u3002", (String)"KnowledgeServiceHelper_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return JSON.toJSONString(errResponse);
        }
        logger.info("getKnowledgeSpecial response:" + response);
        return response;
    }

    private static String getSeriesCode() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        String seriesCode = modelType == 2 || modelType == 4 ? "S0361" : "S039";
        return seriesCode;
    }

    private static Map<String, String> getRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json");
        header.put("X-Api-ClientID", KnowledgeServiceHelper.getClientId());
        header.put("X-Api-ClientSecret", KnowledgeServiceHelper.getClientSecret());
        return header;
    }

    private static String getClientId() {
        String cloudId = System.getProperty("clientId");
        if (StringUtils.isEmpty((CharSequence)cloudId)) {
            cloudId = NextCloud.CLIENT_ID;
        }
        return cloudId;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (StringUtils.isEmpty((CharSequence)clientSecret)) {
            clientSecret = NextCloud.CLIENT_SECRET;
        }
        return clientSecret;
    }
}

