/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.DisCardUtil;

public class MultipartUtility {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream outputStream;
    private PrintWriter writer;
    private static Log logger = LogFactory.getLog(MultipartUtility.class);

    public MultipartUtility(String requestURL, String charset) throws IOException {
        this.charset = charset;
        this.boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setConnectTimeout(1000);
        this.httpConn.setReadTimeout(180000);
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("User-Agent", "CodeJava Agent");
        this.httpConn.setRequestProperty("Test", "Bonjour");
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, InputStream is, String fileName) throws IOException {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = is.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
        }
        this.outputStream.flush();
        is.close();
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String name, String value) {
        this.writer.append(name + ": " + value).append(LINE_FEED);
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> finish() throws IOException {
        ArrayList<String> response;
        block5: {
            int status;
            block6: {
                response = new ArrayList<String>();
                this.writer.append(LINE_FEED).flush();
                this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
                this.writer.close();
                status = this.httpConn.getResponseCode();
                if (status != 200) break block6;
                InputStreamReader isr = null;
                try {
                    isr = new InputStreamReader(this.httpConn.getInputStream());
                    BufferedReader reader = new BufferedReader(isr);
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        response.add(line);
                    }
                    reader.close();
                    this.httpConn.disconnect();
                }
                catch (IOException e) {
                    try {
                        logger.info(e.getMessage(), (Object)e);
                    }
                    catch (Throwable throwable) {
                        MultipartUtility.safeClose(isr);
                        throw throwable;
                    }
                    MultipartUtility.safeClose(isr);
                    break block5;
                }
                MultipartUtility.safeClose(isr);
                break block5;
            }
            throw new IOException("Server returned non-OK status: " + status);
        }
        return response;
    }

    private static void safeClose(InputStreamReader isr) {
        if (isr != null) {
            try {
                isr.close();
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
    }
}

