/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cloudplatform.model.CloudPlatformConfigInfo;
import kd.bos.login.cloudplatform.model.CloudPlatformResult;
import kd.bos.login.cloudplatform.utils.CloudPlatformUtils;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.SHAUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.servicehelper.SalesChatUtil;
import kd.bos.sysint.servicehelper.service.impl.CloudUserRelationServiceImpl;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class PortalPreSalesChatWebApiPlugin
implements IBillWebApiPlugin {
    private static final String APP = "app";
    private static final String APP_STR = "app_str";
    private static Log logger = LogFactory.getLog(PortalPreSalesChatWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            RequestContext requestContext = RequestContext.get();
            Map paramMap = LicenseServiceHelper.getProductInfo();
            String prodInstCode = "";
            if (paramMap != null) {
                prodInstCode = (String)paramMap.get("prodInstCode");
            }
            logger.info(String.format("requestUserCenter.getprodInstCode:%s", prodInstCode));
            CloudUserRelationServiceImpl cloudUserRelationService = new CloudUserRelationServiceImpl();
            DynamicObject[] array = cloudUserRelationService.getCloudUserRelation(RequestContext.get().getCurrUserId());
            if (array == null || array.length < 1) {
                return ApiResult.fail((String)"cloud user is null");
            }
            String config = DefaultParameterService.getDefaultValueByKey((String)"cloud_customer_service_config");
            if (StringUtils.isBlank((CharSequence)config)) {
                return ApiResult.fail((String)"cloud_customer_service_config is null");
            }
            Map configData = (Map)JSONUtils.cast((String)config, HashMap.class);
            CloudPlatformConfigInfo cloudPlatformConfigInfo = new CloudPlatformConfigInfo();
            cloudPlatformConfigInfo.setServiceUrl((String)configData.get("serviceUrl"));
            cloudPlatformConfigInfo.setTargetId((String)configData.get("targetId"));
            ArrayList<Map<String, String>> productInfoList = new ArrayList<Map<String, String>>(8);
            if (!configData.containsKey(APP) || !configData.containsKey(APP_STR)) {
                cloudPlatformConfigInfo.setUrl(DefaultParameterService.getDefaultValueByKey((String)"cloud_platform_mcapi_url"));
                cloudPlatformConfigInfo = this.createAppSecretByCloudPlatform(cloudPlatformConfigInfo, productInfoList);
            } else {
                cloudPlatformConfigInfo.setAppId((String)configData.get(APP));
                cloudPlatformConfigInfo.setAppStr((String)configData.get(APP_STR));
                if (!prodInstCode.equals(configData.get("prodInstCode"))) {
                    return ApiResult.fail((String)"prodInstCode is update ");
                }
            }
            DynamicObject cloudUserRelation = array[0];
            String identity = cloudUserRelation.getString("identity");
            HashMap<String, Object> body = new HashMap<String, Object>(8);
            body.put("identity", identity);
            body.put("targetId", cloudPlatformConfigInfo.getTargetId());
            CloudPlatformResult cloudPlatformResult = CloudPlatformUtils.identity2codeByCloudPlatform(cloudPlatformConfigInfo, body);
            Object responseData = cloudPlatformResult.getData();
            if (!cloudPlatformResult.isSuccess()) {
                if ("50061".equals(cloudPlatformResult.getErrCode())) {
                    cloudPlatformResult = CloudPlatformUtils.refreshIdentityByCloudPlatform(cloudPlatformConfigInfo, body);
                    responseData = cloudPlatformResult.getData();
                    if (responseData != null) {
                        Map data = (Map)JSONUtils.cast((String)responseData.toString(), HashMap.class);
                        identity = (String)data.get("refreshIdentity");
                        cloudUserRelation.set("identity", (Object)identity);
                        SaveServiceHelper.update((DynamicObject)cloudUserRelation);
                    }
                    body = new HashMap(8);
                    body.put("identity", identity);
                    body.put("targetId", cloudPlatformConfigInfo.getTargetId());
                    cloudPlatformResult = CloudPlatformUtils.identity2codeByCloudPlatform(cloudPlatformConfigInfo, body);
                }
                if (!cloudPlatformResult.isSuccess()) {
                    return ApiResult.fail((String)cloudPlatformResult.getMessage());
                }
            }
            responseData = cloudPlatformResult.getData();
            String code = "";
            if (responseData != null) {
                Map data = (Map)JSONUtils.cast((String)responseData.toString(), HashMap.class);
                code = (String)data.get("code");
            }
            Map<String, String> imInfo = PortalPreSalesChatWebApiPlugin.getPreSalesChatURL(cloudPlatformConfigInfo.getServiceUrl() + "/sso/login", code);
            return ApiResult.success(imInfo);
        }
        catch (Exception var15) {
            logger.info("PreSalesChatURLWebApiPlugin", (Object)var15);
            return ApiResult.ex((Throwable)var15);
        }
    }

    private CloudPlatformConfigInfo createAppSecretByCloudPlatform(CloudPlatformConfigInfo cloudPlatformConfigInfo, List<Map<String, String>> productInfoList) {
        return cloudPlatformConfigInfo;
    }

    private static Map<String, String> getPreSalesChatURL(String url, String code) {
        HashMap<String, String> preSalesChatURLInfo = new HashMap<String, String>(8);
        String redirectUrl = "https://support.kingdee.com/osp2016/chat/pc/index.php";
        String urlData = DefaultParameterService.getDefaultValueByKey((String)"preSaleChatUrl", (String)"1");
        if (urlData != null) {
            redirectUrl = urlData;
        }
        StringBuilder sb = new StringBuilder(redirectUrl);
        String timestamp = String.valueOf(System.currentTimeMillis());
        RequestContext requestContext = RequestContext.get();
        try {
            HashMap<String, String> param = new HashMap<String, String>(8);
            ArrayList<Object> paramVal = new ArrayList<Object>(8);
            param.put("kduid", requestContext.getUid());
            param.put("vendorID", "8");
            param.put("type", "Sales");
            param.put("source", "Kdcloud");
            param.put("serviceType", "1");
            param.put("nonce", timestamp);
            param.put("timestamp", timestamp);
            Map<String, String> product = SalesChatUtil.getProductLicense();
            param.put("prodCategoryCode", product.get("prodCategoryCode"));
            param.put("prodSN", product.get("prodSN"));
            sb.append("?vendorID=8");
            for (Map.Entry stringEntry : param.entrySet()) {
                if (!"vendorID".equals(stringEntry.getKey())) {
                    sb.append("&").append((String)stringEntry.getKey()).append("=").append((String)stringEntry.getValue());
                }
                paramVal.add(stringEntry.getValue());
            }
            paramVal.add("LTAIKzJqfjQ70Jiw");
            Collections.sort(paramVal);
            String paramValStr = StringUtils.join(paramVal, (String)"");
            String signature = SHAUtils.sha((String[])new String[]{paramValStr});
            String preSalesChatURL = sb + "&signature=" + signature;
            preSalesChatURLInfo.put("preSalesChatURL", sb.toString());
            preSalesChatURLInfo.put("preSalesChatSignatureURL", url + "?auth_code=" + code + "&redirect_url=" + URLEncoder.encode(preSalesChatURL, "UTF-8"));
            return preSalesChatURLInfo;
        }
        catch (Exception var11) {
            logger.info("sha error", (Object)var11);
            preSalesChatURLInfo.put("error", var11.getMessage());
            return preSalesChatURLInfo;
        }
    }
}

