/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.sysint.servicehelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URLDecoder;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sysint.servicehelper.ECAesCryptUtil;

public class VerifyNotifyWebApiPlugin
implements IBillWebApiPlugin {
    private static final String CONTRACTSUBJECT = "contractsubject";
    private static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    private static Log logger = LogFactory.getLog(VerifyNotifyWebApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info(String.format("CompanyRegister---VerifyNotify---time:%s, params:%s", System.currentTimeMillis(), JSON.toJSONString(params)));
        if (CollectionUtils.isEmpty(params)) {
            return this.fail(ResManager.loadKDString((String)"\u5f02\u6b65\u901a\u77e5\u5185\u5bb9\u4e3a\u7a7a", (String)"VerifyNotifyWebApiPlugin_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
        try {
            String sign;
            String kdappid = params.get("kdAppId").toString().trim();
            QFilter kdappidFilter = new QFilter("kdappid", "=", (Object)kdappid);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)CONTRACTSUBJECT, (String)"id,uuid,resultcode,resultdesc", (QFilter[])new QFilter[]{kdappidFilter});
            if (object == null) {
                logger.info("CompanyRegister--accountId:" + RequestContext.get().getAccountId());
                return this.fail(String.format(ResManager.loadKDString((String)"\u5408\u540c\u4e3b\u4f53kdappid\u4e0d\u5339\u914d%s", (String)"VerifyNotifyWebApiPlugin_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]), kdappid));
            }
            String uuid = object.getString("uuid");
            String decryptSign = ECAesCryptUtil.decrypt(uuid, sign = params.get("sign").toString());
            if (StringUtils.isBlank((CharSequence)decryptSign)) {
                decryptSign = ECAesCryptUtil.decrypt(uuid, URLDecoder.decode(sign, "utf-8"));
            }
            if (StringUtils.isBlank((CharSequence)decryptSign)) {
                return this.fail(ResManager.loadKDString((String)"\u7b7e\u540d\u65e0\u6cd5\u89e3\u5bc6", (String)"VerifyNotifyWebApiPlugin_2", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            JSONObject jsonObject = (JSONObject)JSON.parse((String)decryptSign);
            JSONObject data = (JSONObject)jsonObject.get((Object)"data");
            String userId = data.get((Object)"userId").toString();
            QFilter filter = new QFilter("companyid", "=", (Object)userId);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)CONTRACTSUBJECT, (String)"id,resultcode,resultdesc", (QFilter[])new QFilter[]{filter});
            if (!(dynamicObjects != null && dynamicObjects.length != 0 || (dynamicObjects = BusinessDataServiceHelper.load((String)"companyauth", (String)"id,resultcode,resultdesc", (QFilter[])new QFilter[]{filter})) != null && dynamicObjects.length != 0)) {
                return this.fail(ResManager.loadKDString((String)"\u7528\u6237\u5b9e\u4f53\u4e0d\u5b58\u5728", (String)"VerifyNotifyWebApiPlugin_3", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            DynamicObject dynamicObject = dynamicObjects[0];
            dynamicObject.set("resultcode", data.get((Object)"resultCode"));
            dynamicObject.set("resultdesc", data.get((Object)"resultDesc"));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        }
        catch (Exception e) {
            logger.info("CompanyRegister--error", (Object)e);
            return this.fail(e.getMessage());
        }
        return ApiResult.success(null);
    }

    private ApiResult fail(String msg) {
        int httpStatusCode = 500;
        ApiResult result = ApiResult.fail((String)msg, (String)(httpStatusCode + ""));
        result.setHttpStatus(Integer.valueOf(httpStatusCode));
        return result;
    }
}

