/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;

public class ECSealUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ECSealUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            boolean isSuccess = this.executeInsertSql();
            result.setSuccess(isSuccess);
            result.setLog("executeInsertSql isSuccess:" + isSuccess);
        }
        catch (Exception e) {
            logger.info("beforeExecuteSqlWithResult error", (Object)e);
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private boolean executeInsertSql() {
        try (TXHandle txHandle = TX.required();){
            try {
                List<Object[]> batchInsertSqlParams2;
                String insertSql = "INSERT INTO t_bos_ec_seal(fid, fsealtypeid, fsignatureid, fisdefault, fremark, fsubjecttype, fsubjectid, fcompanyseal, fmodifierid, fcreatetime, fmodifytime, fcreatorid)VALUES(?, 0, ?, '1', ' ', ?, ?, ?, 0, {ts'2023-03-9  00:00:00'}, {ts'2023-03-9  00:00:00'}, 0);";
                List<Object[]> batchInsertSqlParams1 = this.getBatchInsertSqlParams("t_ec_contractsubject");
                if (CollectionUtils.isNotEmpty(batchInsertSqlParams1)) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, batchInsertSqlParams1);
                }
                if (CollectionUtils.isNotEmpty(batchInsertSqlParams2 = this.getBatchInsertSqlParams("t_ec_companyauth"))) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, batchInsertSqlParams2);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.info("ECSealUpgradeService execute error", (Object)e);
                boolean bl = false;
                if (txHandle != null) {
                    if (var2_2 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private List<Object[]> getBatchInsertSqlParams(String tableName) {
        boolean existTable = DB.exitsTable((DBRoute)DBRoute.basedata, (String)"t_bos_ec_seal");
        if (!existTable) {
            logger.info("t_bos_ec_seal table is not exist");
            return null;
        }
        String subjectType = "";
        if ("t_ec_contractsubject".equals(tableName)) {
            subjectType = "1";
        } else if ("t_ec_companyauth".equals(tableName)) {
            subjectType = "2";
        }
        String sealSql = String.format("select t.fsubjectid from t_bos_ec_seal t where t.fsealtypeid = 0 and t.fsubjecttype = '%s'", subjectType);
        String sealAlgoKey = this.getClass().getName() + ".query_t_bos_ec_seal";
        ArrayList<String> subjectidList = new ArrayList<String>(10);
        try (DataSet sealDataSet = DB.queryDataSet((String)sealAlgoKey, (DBRoute)DBRoute.basedata, (String)sealSql);){
            while (sealDataSet.hasNext()) {
                Row row = sealDataSet.next();
                String subjectid = row.getString(0);
                subjectidList.add(String.format("'%s'", subjectid));
            }
        }
        String sql = String.format("select t.fid, t.fcompanyseal, t.fsignatureid from %s t where t.fsignatureid is not null", tableName);
        if (CollectionUtils.isNotEmpty(subjectidList)) {
            String subjectidStr = String.join((CharSequence)",", subjectidList);
            logger.info("history data:" + subjectidStr);
            sql = sql + " and t.fid not in " + String.format("(%s)", subjectidStr);
        }
        String algoKey = this.getClass().getName() + ".query_" + tableName;
        ArrayList<Object[]> sqlParamsList = new ArrayList<Object[]>(10);
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long subjectId = row.getLong(0);
                String companyseal = row.getString(1);
                String signatureid = row.getString(2);
                long pkid = ID.genLongId();
                Object[] params = new Object[]{pkid, signatureid, subjectType, subjectId, companyseal};
                sqlParamsList.add(params);
            }
        }
        return sqlParamsList;
    }
}

