/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgradeservice;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.constant.PermApiConst;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.req.upgrade.PermUpgradePreProcessFile;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PortalPermItemUpgradeServiceOne
implements IUpgradeService {
    private static Long[] adminEntryIds = new Long[]{PermApiConst.THREE_STRATEGY_1_ADMIN_ENTRYID};

    public void upgradePreProcess() {
        try {
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            ArrayList<PermUpgradePreProcessFile> fileList = new ArrayList<PermUpgradePreProcessFile>();
            String content = this.getDataFromResFile("permupgrade_20240717.perm");
            PermUpgradePreProcessFile ff = new PermUpgradePreProcessFile();
            ff.setFileName("permupgrade_20240717.perm");
            ff.setContent(content);
            fileList.add(ff);
            permissionService.upgradePreProcess(fileList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getDataFromResFile(String resFile) {
        StringBuilder returnStr = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String str;
            bufferedReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(resFile))));
            while ((str = bufferedReader.readLine()) != null) {
                returnStr.append(str);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            return returnStr.toString();
        }
        return returnStr.toString();
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            StringBuilder pProcessInfo = new StringBuilder();
            PermResult permResult = PermissionServiceHelper.appendPermItemAuthUpgrade(this.buildData(), (StringBuilder)pProcessInfo);
            if (permResult.isOk()) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(String.format("appendPermItemAuthUpgrade info:%s", pProcessInfo.toString()));
            }
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
            throw new KDException((Throwable)e, new ErrorCode("fail", "PortalPermItemUpgradeService error"), new Object[0]);
        }
        return result;
    }

    private List<Object[]> buildData() {
        String savePermItem = "0=KX5+QVF5+R";
        String imForm = "bas_immapping";
        Object[] imSaveItem = new Object[]{imForm, "47150e89000000ac", imForm, savePermItem, adminEntryIds};
        String themeForm = "bas_uitheme";
        Object[] themeEnableItem = new Object[]{themeForm, "47150e89000000ac", themeForm, "4730fc5d000000ac", adminEntryIds};
        Object[] themeDisableItem = new Object[]{themeForm, "47150e89000000ac", themeForm, "47160c2b000000ac", adminEntryIds};
        String logopForm = "bos_log_operation_web";
        String logsetPermItem = "3GLK44OTB2EU";
        Object[] logsetItem = new Object[]{logopForm, "47150e89000000ac", logopForm, logsetPermItem, adminEntryIds};
        String bizForm = "companyauth";
        Object[] bizSaveItem = new Object[]{bizForm, "47150e89000000ac", bizForm, savePermItem, adminEntryIds};
        String contractForm = "contractsubject";
        Object[] contractsaveItem = new Object[]{contractForm, "47150e89000000ac", contractForm, savePermItem, adminEntryIds};
        String thirdscheForm = "third_app_route_schemes";
        Object[] thirdscheSaveItem = new Object[]{thirdscheForm, "47150e89000000ac", thirdscheForm, savePermItem, adminEntryIds};
        String privacystatementForm = "privacystatement";
        String importtplPermItem = "498DO=I04/OS";
        String checkPermItem = "498DTJLOHETS";
        Object[] psImportItem = new Object[]{privacystatementForm, "47150e89000000ac", privacystatementForm, importtplPermItem, adminEntryIds};
        Object[] psCheckItem = new Object[]{privacystatementForm, "47150e89000000ac", privacystatementForm, checkPermItem, adminEntryIds};
        String wxqyFormNew = "bos_wxqy_config";
        String wxqyFormOld = "cts_wxqyh";
        Object[] wxqyViewItem = new Object[]{wxqyFormOld, "47150e89000000ac", wxqyFormNew, "47150e89000000ac", adminEntryIds};
        Object[] wxqyEditItem = new Object[]{wxqyFormOld, "4715a0df000000ac", wxqyFormNew, "4715a0df000000ac", adminEntryIds};
        Object[] wxqyNewItem = new Object[]{wxqyFormOld, "47156aff000000ac", wxqyFormNew, "47156aff000000ac", adminEntryIds};
        Object[] wxqyDeleteItem = new Object[]{wxqyFormOld, "4715e1f1000000ac", wxqyFormNew, "4715e1f1000000ac", adminEntryIds};
        Object[] wxqySaveItem = new Object[]{wxqyFormOld, savePermItem, wxqyFormNew, savePermItem, adminEntryIds};
        Object[] wxqyDisableItem = new Object[]{wxqyFormOld, "47150e89000000ac", wxqyFormNew, "47160c2b000000ac", adminEntryIds};
        Object[] wxqyEnableItem = new Object[]{wxqyFormOld, "47150e89000000ac", wxqyFormNew, "4730fc5d000000ac", adminEntryIds};
        String ddFormNew = "bos_dingding_config";
        String ddFormOld = "cts_dingding";
        Object[] ddViewItem = new Object[]{ddFormOld, "47150e89000000ac", ddFormNew, "47150e89000000ac", adminEntryIds};
        Object[] ddEditItem = new Object[]{ddFormOld, "4715a0df000000ac", ddFormNew, "4715a0df000000ac", adminEntryIds};
        Object[] ddNewItem = new Object[]{ddFormOld, "47156aff000000ac", ddFormNew, "47156aff000000ac", adminEntryIds};
        Object[] ddDeleteItem = new Object[]{ddFormOld, "4715e1f1000000ac", ddFormNew, "4715e1f1000000ac", adminEntryIds};
        Object[] ddSaveItem = new Object[]{ddFormOld, savePermItem, ddFormNew, savePermItem, adminEntryIds};
        Object[] ddDisableItem = new Object[]{ddFormOld, "47150e89000000ac", ddFormNew, "47160c2b000000ac", adminEntryIds};
        Object[] ddEnableItem = new Object[]{ddFormOld, "47150e89000000ac", ddFormNew, "4730fc5d000000ac", adminEntryIds};
        String fbFormNew = "bos_fly_book_config";
        String fbFormOld = "cts_fly_book";
        Object[] fbViewItem = new Object[]{fbFormOld, "47150e89000000ac", fbFormNew, "47150e89000000ac", adminEntryIds};
        Object[] fbEditItem = new Object[]{fbFormOld, "4715a0df000000ac", fbFormNew, "4715a0df000000ac", adminEntryIds};
        Object[] fbNewItem = new Object[]{fbFormOld, "47156aff000000ac", fbFormNew, "47156aff000000ac", adminEntryIds};
        Object[] fbDeleteItem = new Object[]{fbFormOld, "4715e1f1000000ac", fbFormNew, "4715e1f1000000ac", adminEntryIds};
        Object[] fbSaveItem = new Object[]{fbFormOld, savePermItem, fbFormNew, savePermItem, adminEntryIds};
        Object[] fbDisableItem = new Object[]{fbFormOld, "47150e89000000ac", fbFormNew, "47160c2b000000ac", adminEntryIds};
        Object[] fbEnableItem = new Object[]{fbFormOld, "47150e89000000ac", fbFormNew, "4730fc5d000000ac", adminEntryIds};
        String weLinkFormNew = "bos_welink_config";
        String weLinkFormOld = "cts_welink";
        Object[] weLinkViewItem = new Object[]{weLinkFormOld, "47150e89000000ac", weLinkFormNew, "47150e89000000ac", adminEntryIds};
        Object[] weLinkEditItem = new Object[]{weLinkFormOld, "4715a0df000000ac", weLinkFormNew, "4715a0df000000ac", adminEntryIds};
        Object[] weLinkNewItem = new Object[]{weLinkFormOld, "47156aff000000ac", weLinkFormNew, "47156aff000000ac", adminEntryIds};
        Object[] weLinkDeleteItem = new Object[]{weLinkFormOld, "4715e1f1000000ac", weLinkFormNew, "4715e1f1000000ac", adminEntryIds};
        Object[] weLinkSaveItem = new Object[]{weLinkFormOld, savePermItem, weLinkFormNew, savePermItem, adminEntryIds};
        Object[] weLinkDisableItem = new Object[]{weLinkFormOld, "47150e89000000ac", weLinkFormNew, "47160c2b000000ac", adminEntryIds};
        Object[] weLinkEnableItem = new Object[]{weLinkFormOld, "47150e89000000ac", weLinkFormNew, "4730fc5d000000ac", adminEntryIds};
        List<Object[]> data = Arrays.asList(imSaveItem, themeEnableItem, themeDisableItem, logsetItem, bizSaveItem, thirdscheSaveItem, contractsaveItem, psImportItem, psCheckItem, wxqyViewItem, wxqyEditItem, wxqyNewItem, wxqyDeleteItem, wxqySaveItem, wxqyDisableItem, wxqyEnableItem, ddViewItem, ddEditItem, ddNewItem, ddDeleteItem, ddSaveItem, ddDisableItem, ddEnableItem, fbViewItem, fbEditItem, fbNewItem, fbDeleteItem, fbSaveItem, fbDisableItem, fbEnableItem, weLinkViewItem, weLinkEditItem, weLinkNewItem, weLinkDeleteItem, weLinkSaveItem, weLinkDisableItem, weLinkEnableItem);
        return data;
    }
}

