/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgradeservice;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.upgradeservice.UpgradeFileUtils;
import kd.bos.util.StringUtils;

public class PortalSchemeUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PortalSchemeUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String id;
        UpgradeResult result;
        block19: {
            result = new UpgradeResult();
            id = null;
            try {
                String tableName = "t_bas_new_build_flag";
                boolean existTable = DB.exitsTable((DBRoute)DBRoute.basedata, (String)tableName);
                if (!existTable) break block19;
                String sql = "SELECT t.fid from t_bas_new_build_flag t where t.fflag='portalscheme'";
                String algoKey = this.getClass().getName() + ".query_t_bas_new_build_flag";
                try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql);){
                    if (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        id = row.getString(0);
                    }
                }
            }
            catch (Exception e) {
                logger.info("beforeExecuteSqlWithResult select t_bas_new_build_flag error", (Object)e);
            }
        }
        try {
            String msg;
            boolean isSuccess = true;
            if (StringUtils.isNotEmpty(id)) {
                isSuccess = this.executePresetSql();
                msg = "PortalSchemeUpgradeService data update success";
            } else {
                msg = "PortalSchemeUpgradeService no data execute";
            }
            result.setSuccess(isSuccess);
            result.setLog(msg);
        }
        catch (Exception e) {
            logger.info("beforeExecuteSqlWithResult error", (Object)e);
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private boolean executePresetSql() {
        try (TXHandle txHandle = TX.required();){
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)this.getSchemeSql("SysSchemeSql.txt"));
                DB.execute((DBRoute)DBRoute.basedata, (String)this.getSchemeSql("CtsSchemeSql.txt"));
                DB.execute((DBRoute)DBRoute.basedata, (String)this.getSchemeSql("BaseDataSchemeSql.txt"));
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.info("PortalSchemeUpgradeService execute error" + e.getMessage());
                boolean bl = false;
                if (txHandle != null) {
                    if (var2_2 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private String getSchemeSql(String fileName) {
        List<String> dataFromResFile = UpgradeFileUtils.getDataFromResFile(fileName);
        if (dataFromResFile.size() == 0) {
            return "";
        }
        return String.join((CharSequence)"\n", dataFromResFile);
    }
}

