/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.upgradeservice.UpgradeFileUtils;

public class ProverbsUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ProverbsUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ArrayList<Long> updateIds;
        Throwable throwable;
        TXHandle txHandle;
        UpgradeResult result;
        block37: {
            DataSet dataSet;
            block38: {
                block39: {
                    Map<String, String> proverbsDatas;
                    block33: {
                        UpgradeResult upgradeResult;
                        block34: {
                            block35: {
                                result = new UpgradeResult();
                                result.setSuccess(true);
                                txHandle = TX.required();
                                throwable = null;
                                proverbsDatas = this.getProverbsDatas();
                                if (!proverbsDatas.isEmpty()) break block33;
                                result.setLog("ProverbsUpgradeService data empty");
                                upgradeResult = result;
                                if (txHandle == null) break block34;
                                if (throwable == null) break block35;
                                try {
                                    txHandle.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block34;
                            }
                            txHandle.close();
                        }
                        return upgradeResult;
                    }
                    Collection<String> values = proverbsDatas.values();
                    String algoKey = this.getClass().getName() + ".query_t_bas_proverbs";
                    String numParams = String.join((CharSequence)",", proverbsDatas.keySet());
                    String sql = "select t.fid, t.fnumber, tl.fdescription from t_bas_proverbs t left join t_bas_proverbs_l tl on t.fid=tl.fid where tl.flocaleid = 'zh_CN' and t.fnumber in " + String.format("(%s)", numParams);
                    updateIds = new ArrayList<Long>();
                    dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql);
                    Throwable throwable3 = null;
                    try {
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            String fdescription = row.getString(2);
                            if (!values.contains(fdescription.trim())) continue;
                            Long fid = row.getLong(0);
                            updateIds.add(fid);
                        }
                    }
                    catch (Throwable row) {
                        throwable3 = row;
                        throw row;
                    }
                    finally {
                        if (dataSet != null) {
                            if (throwable3 != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable row) {
                                    throwable3.addSuppressed(row);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                    }
                    if (!updateIds.isEmpty()) break block37;
                    dataSet = result;
                    if (txHandle == null) break block38;
                    if (throwable == null) break block39;
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block38;
                }
                txHandle.close();
            }
            return dataSet;
        }
        try {
            try {
                String delSql = "delete from t_bas_proverbs where fid = ?;";
                String delLangSql = "delete from t_bas_proverbs_l where fid = ?";
                List<Object[]> numbers = this.getSqlParams(updateIds);
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)delLangSql, numbers);
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)delSql, numbers);
                result.setLog("ProverbsUpgradeService data update success, size:" + updateIds.size());
            }
            catch (Exception e) {
                txHandle.markRollback();
                logger.info("ProverbsUpgradeService data update error", (Object)e);
                result.setErrorInfo(e.getMessage());
                result.setLog(e.getMessage());
                result.setSuccess(false);
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        catch (Throwable throwable6) {
            throw throwable6;
        }
        finally {
            if (txHandle != null) {
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        return result;
    }

    private Map<String, String> getProverbsDatas() {
        List<String> dataList = UpgradeFileUtils.getDataFromResFile("DeleteProverbsData.txt");
        HashMap<String, String> proverbsMap = new HashMap<String, String>();
        dataList.forEach(dataStr -> {
            String[] datas = dataStr.split("\\|");
            if (datas.length == 2) {
                String number = String.format("'%s'", datas[0]);
                String desc = datas[1];
                proverbsMap.put(number, desc);
            }
        });
        return proverbsMap;
    }

    private List<Object[]> getSqlParams(List<Long> ids) {
        ArrayList<Object[]> idParams = new ArrayList<Object[]>();
        for (Long id : ids) {
            Object[] param = new Object[]{id};
            idParams.add(param);
        }
        return idParams;
    }
}

