/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.upgradeservice.UpgradeFileUtils;

public class ShortcutsUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ShortcutsUpgradeService.class);

    private void defaultDataSql() {
        List<String> dataList = UpgradeFileUtils.getDataFromResFile("ShortcutsUpgradeData.txt");
        if (dataList.isEmpty()) {
            return;
        }
        dataList.forEach(dataStr -> {
            String[] datas = dataStr.split(",");
            if (datas.length == 5) {
                String nameCh = datas[0];
                String descCh = datas[1];
                String nameUs = datas[2];
                String descUs = datas[3];
                long id = Long.parseLong(datas[4]);
                this.executeShortcutsSql(nameCh, descCh, nameUs, descUs, id);
            }
        });
    }

    private void executeShortcutsSql(String nameCh, String descCh, String nameUs, String descUs, long id) {
        String insertSql = "insert into t_bas_shortcuts_l(fpkid,fid,flocaleid,fmulilang_type,fmulilang_des) values(?,?,?,?,?);";
        DB.execute((DBRoute)DBRoute.base, (String)insertSql, (Object[])new Object[]{ID.genStringId(), id, "zh_CN", nameCh, descCh});
        DB.execute((DBRoute)DBRoute.base, (String)insertSql, (Object[])new Object[]{ID.genStringId(), id, "en_US", nameUs, descUs});
    }

    private void executeAddData() {
        ArrayList sqlList = new ArrayList(16);
        DB.query((DBRoute)DBRoute.base, (String)"select fid, ftype,fopinstructions from t_bas_shortcuts where fissystem = '0'", rs -> {
            while (rs.next()) {
                String sql = "insert into t_bas_shortcuts_l(fpkid,fid,flocaleid,fmulilang_type,fmulilang_des) values(%1s,%2s,%3s,%4s,%5s);";
                sqlList.add(String.format(sql, "'" + ID.genStringId() + "'", rs.getString(1), "'zh_CN'", "'" + rs.getString(2) + "'", "'" + rs.getString(3) + "'"));
            }
            return true;
        });
        for (String s : sqlList) {
            DB.execute((DBRoute)DBRoute.base, (String)s);
        }
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.defaultDataSql();
            this.executeAddData();
            result.setLog("ShortcutsUpgradeService data update success");
            result.setSuccess(true);
        }
        catch (Exception e) {
            logger.info("ExecuteSql error", (Object)e);
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }
}

