/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nlp.plugin;

import java.util.EventObject;
import kd.bos.dataentity.TypesContainer;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datasync.DtsAccountPower;

public class NLPSearchingPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(NLPSearchingPlugin.class);
    private IFormPlugin newNLPPlugin = null;

    public void setView(IFormView formView) {
        super.setView(formView);
        this.addNewNLPPlugin(formView);
        this.addWebChatbotPlugin(formView);
        this.addAiPortalListenerPlugin(formView);
    }

    private void addNewNLPPlugin(IFormView formView) {
        this.getPageCache().put("has_nlp_searching_plugin", "true");
        this.newNLPPlugin = null;
        String enable = System.getProperty("portal.search.enable", "false");
        if ("true".equals(enable) && DtsAccountPower.isAccountDtsEnable()) {
            try {
                this.newNLPPlugin = (IFormPlugin)TypesContainer.createInstance((String)"kd.bos.ais.plugin.NLPSearchingPlugin");
                formView.addPlugin(this.newNLPPlugin);
            }
            catch (Exception e) {
                log.error("init NLPSearchingPlugin error!", (Throwable)e);
                this.newNLPPlugin = null;
            }
        }
    }

    private void addWebChatbotPlugin(IFormView formView) {
        try {
            IFormPlugin webChatbotPlugin = (IFormPlugin)TypesContainer.createInstance((String)"kd.bos.ais.plugin.WebChatbotPlugin");
            formView.addPlugin(webChatbotPlugin);
        }
        catch (Exception e) {
            log.error("init WebChatbotPlugin error!" + e.getMessage(), (Throwable)e);
        }
    }

    private void addAiPortalListenerPlugin(IFormView formView) {
        try {
            IFormPlugin aiPortalListenerPlugin = (IFormPlugin)TypesContainer.createInstance((String)"kd.ai.gai.plugin.portal.PortalListenerPlugin");
            formView.addPlugin(aiPortalListenerPlugin);
        }
        catch (Exception e) {
            log.info("init PortalListenerPlugin fail!" + e.getMessage());
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        if (this.newNLPPlugin == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nlp_searching_ctrl"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"searchap"});
        }
    }

    public void customEvent(CustomEventArgs e) {
    }
}

